/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Structure.CoordInfo;
import com.sun.j3d.utils.geometry.Sphere;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class MonitorNode {
    private BranchGroup pickedGroup;
    private TransformGroup rotateTG;
    private Point3f point1;
    private Point3f point2;
    private Point3f point3;
    private int pointCount = 0;
    private TransformGroup pickedTfg = null;
    private Vector pointVector = new Vector();
    private static Appearance sphereAppearance;
    private static Appearance lineAppearance;
    private static Appearance triAppearance;
    private static Color3f pickedColor;
    private static Font3D pickedFont;

    MonitorNode(BranchGroup branchGroup, TransformGroup transformGroup) {
        this.pickedGroup = branchGroup;
        this.rotateTG = transformGroup;
    }

    public void addPickedNode(int n, CoordInfo coordInfo, float f, float f2, float f3, float f4, int n2) {
        float f5 = n == 3 || n == 5 ? 0.37f : (n == 4 ? 0.25f : (n == 1 ? 0.1f : 0.2f));
        Sphere sphere = new Sphere(f5, 1, 8, sphereAppearance);
        sphere.setPickable(false);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(f -= coordInfo.xcenter, f2 -= coordInfo.ycenter, f3 -= coordInfo.zcenter));
        this.pickedGroup.detach();
        if (n2 == 0) {
            this.pointCount = 0;
        }
        if (this.pointCount == 0) {
            this.pickedTfg = new TransformGroup();
        }
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)sphere);
        this.pickedTfg.addChild((Node)transformGroup);
        if (this.pointCount == 0) {
            this.point1 = new Point3f(f, f2, f3);
            this.pickedGroup.addChild((Node)this.pickedTfg);
        } else if (this.pointCount == 1) {
            this.point2 = new Point3f(f, f2, f3);
        } else if (this.pointCount == 2) {
            this.point3 = new Point3f(f, f2, f3);
        }
        ++this.pointCount;
        if (n2 == 2 || n2 == 3 || n2 == 4) {
            Shape3D shape3D;
            Object object;
            Point3f point3f = new Point3f(f, f2, f3);
            Vector<Point3f> vector = new Vector<Point3f>();
            vector.add(this.point1);
            if (n2 == 2) {
                if (this.checkPickedNode(this.point1, point3f)) {
                    return;
                }
            } else if (n2 == 3) {
                if (this.checkPickedNode(this.point1, this.point2, point3f)) {
                    return;
                }
                vector.add(this.point2);
            } else if (n2 == 4) {
                if (this.checkPickedNode(this.point1, this.point2, this.point3, point3f)) {
                    return;
                }
                vector.add(this.point2);
                vector.add(this.point3);
            }
            vector.add(new Point3f(point3f));
            this.pointVector.add(vector);
            if (n2 == 2 || n2 == 3) {
                object = new LineArray(2, 5);
                object.setCoordinate(0, this.point1);
                object.setCoordinate(1, point3f);
                object.setColor(0, pickedColor);
                object.setColor(1, pickedColor);
                shape3D = new Shape3D((Geometry)object);
                shape3D.setAppearance(lineAppearance);
                shape3D.setPickable(false);
                this.pickedTfg.addChild((Node)shape3D);
            } else {
                object = new TriangleArray(6, 5);
                object.setCoordinate(0, this.point1);
                object.setCoordinate(1, this.point2);
                object.setCoordinate(2, this.point3);
                object.setCoordinate(3, this.point2);
                object.setCoordinate(4, this.point3);
                object.setCoordinate(5, point3f);
                object.setColor(0, pickedColor);
                object.setColor(1, pickedColor);
                object.setColor(2, pickedColor);
                object.setColor(3, pickedColor);
                object.setColor(4, pickedColor);
                object.setColor(5, pickedColor);
                shape3D = new Shape3D((Geometry)object, triAppearance);
                shape3D.setPickable(false);
                this.pickedTfg.addChild((Node)shape3D);
            }
            object = new DecimalFormat("0.000");
            shape3D = new Transform3D();
            float f6 = 0.5f;
            shape3D.setScale((double)f6);
            point3f.interpolate((Tuple3f)this.point1, 0.5f);
            point3f.scale(1.0f / f6);
            TransformGroup transformGroup2 = new TransformGroup((Transform3D)shape3D);
            Text3D text3D = new Text3D(pickedFont, ((NumberFormat)object).format(f4), point3f, 0, 1);
            OrientedShape3D orientedShape3D = new OrientedShape3D((Geometry)text3D, sphereAppearance, 1, point3f);
            orientedShape3D.setPickable(false);
            transformGroup2.addChild((Node)orientedShape3D);
            this.pickedTfg.addChild((Node)transformGroup2);
            this.pointCount = 0;
        }
        this.rotateTG.addChild((Node)this.pickedGroup);
    }

    private boolean checkPickedNode(Point3f point3f, Point3f point3f2) {
        for (int i = 0; i < this.pointVector.size(); ++i) {
            Vector vector = (Vector)this.pointVector.get(i);
            if (vector.size() != 2) continue;
            Point3f point3f3 = (Point3f)vector.get(0);
            Point3f point3f4 = (Point3f)vector.get(1);
            if ((!point3f3.equals((Tuple3f)point3f) || !point3f4.equals((Tuple3f)point3f2)) && (!point3f4.equals((Tuple3f)point3f) || !point3f3.equals((Tuple3f)point3f2))) continue;
            this.removePickedNode(i);
            return true;
        }
        return false;
    }

    private boolean checkPickedNode(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        for (int i = 0; i < this.pointVector.size(); ++i) {
            Vector vector = (Vector)this.pointVector.get(i);
            if (vector.size() != 3) continue;
            Point3f point3f4 = (Point3f)vector.get(0);
            Point3f point3f5 = (Point3f)vector.get(1);
            Point3f point3f6 = (Point3f)vector.get(2);
            if ((!point3f4.equals((Tuple3f)point3f) || !point3f5.equals((Tuple3f)point3f2) || !point3f6.equals((Tuple3f)point3f3)) && (!point3f4.equals((Tuple3f)point3f3) || !point3f5.equals((Tuple3f)point3f2) || !point3f6.equals((Tuple3f)point3f))) continue;
            this.removePickedNode(i);
            return true;
        }
        return false;
    }

    private boolean checkPickedNode(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        for (int i = 0; i < this.pointVector.size(); ++i) {
            Vector vector = (Vector)this.pointVector.get(i);
            if (vector.size() != 4) continue;
            Point3f point3f5 = (Point3f)vector.get(0);
            Point3f point3f6 = (Point3f)vector.get(1);
            Point3f point3f7 = (Point3f)vector.get(2);
            Point3f point3f8 = (Point3f)vector.get(3);
            if ((!point3f5.equals((Tuple3f)point3f) || !point3f6.equals((Tuple3f)point3f2) || !point3f7.equals((Tuple3f)point3f3) || !point3f8.equals((Tuple3f)point3f4)) && (!point3f5.equals((Tuple3f)point3f4) || !point3f6.equals((Tuple3f)point3f3) || !point3f7.equals((Tuple3f)point3f2) || !point3f8.equals((Tuple3f)point3f))) continue;
            this.removePickedNode(i);
            return true;
        }
        return false;
    }

    private void removePickedNode(int n) {
        this.pickedGroup.removeChild(n);
        this.pickedGroup.removeChild(this.pickedGroup.numChildren() - 1);
        this.pointVector.remove(n);
        this.rotateTG.addChild((Node)this.pickedGroup);
    }

    public void clearPickedNode() {
        this.pickedGroup.detach();
        int n = this.pickedGroup.numChildren();
        for (int i = 0; i < n; ++i) {
            this.pickedGroup.removeChild(0);
        }
        this.rotateTG.addChild((Node)this.pickedGroup);
        this.pointVector.removeAllElements();
    }

    static {
        pickedFont = new Font3D(new Font("Century Gothic", 0, 1), new FontExtrusion());
        pickedColor = new Color3f(1.0f, 0.0f, 1.0f);
        sphereAppearance = new Appearance();
        sphereAppearance.setMaterial(new Material(pickedColor, pickedColor, pickedColor, pickedColor, 100.0f));
        LineAttributes lineAttributes = new LineAttributes(2.0f, 1, true);
        lineAppearance = new Appearance();
        lineAppearance.setLineAttributes(lineAttributes);
        triAppearance = new Appearance();
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setTransparency(0.7f);
        transparencyAttributes.setTransparencyMode(3);
        triAppearance.setTransparencyAttributes(transparencyAttributes);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCullFace(0);
        triAppearance.setPolygonAttributes(polygonAttributes);
    }
}

