/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.util;

public class BoundingBox2D {
    private float[] mCenter = new float[2];
    private float[] mSize = new float[2];

    public BoundingBox2D() {
        this.clear();
    }

    public void clear() {
        int n = 0;
        while (n < 2) {
            this.mCenter[n] = 0.0f;
            this.mSize[n] = -1.0f;
            ++n;
        }
    }

    public void setCenter(float[] center) {
        int n = 0;
        while (n < 2) {
            this.mCenter[n] = center[n];
            ++n;
        }
    }

    public void setCenter(float x, float y) {
        this.mCenter[0] = x;
        this.mCenter[1] = y;
    }

    public void getCenter(float[] center) {
        int n = 0;
        while (n < 2) {
            center[n] = this.mCenter[n];
            ++n;
        }
    }

    public float[] getCenter() {
        float[] center = new float[2];
        this.getCenter(center);
        return center;
    }

    public void setSize(float[] size) {
        int n = 0;
        while (n < 2) {
            this.mSize[n] = size[n];
            ++n;
        }
    }

    public void setSize(float x, float y) {
        this.mSize[0] = x;
        this.mSize[1] = y;
    }

    public void getSize(float[] size) {
        int n = 0;
        while (n < 2) {
            size[n] = this.mSize[n];
            ++n;
        }
    }

    public float[] getSize() {
        float[] size = new float[2];
        this.getSize(size);
        return size;
    }

    public void set(float[] minPos, float[] maxPos) {
        int n = 0;
        while (n < 2) {
            this.mCenter[n] = (minPos[n] + maxPos[n]) / 2.0f;
            this.mSize[n] = Math.abs(maxPos[n] - this.mCenter[n]);
            ++n;
        }
    }

    public void getMaxPosition(float[] pos) {
        if (this.mSize[0] <= 0.0f && this.mSize[1] <= 0.0f) {
            int n = 0;
            while (n < 2) {
                pos[n] = Float.MIN_VALUE;
                ++n;
            }
        } else {
            int n = 0;
            while (n < 2) {
                pos[n] = this.mCenter[n] + this.mSize[n];
                ++n;
            }
        }
    }

    public void getMinPosition(float[] pos) {
        if (this.mSize[0] <= 0.0f && this.mSize[1] <= 0.0f) {
            int n = 0;
            while (n < 2) {
                pos[n] = Float.MAX_VALUE;
                ++n;
            }
        } else {
            int n = 0;
            while (n < 2) {
                pos[n] = this.mCenter[n] - this.mSize[n];
                ++n;
            }
        }
    }

    public void addPoint(float[] pos) {
        float[] minPos = new float[2];
        float[] maxPos = new float[2];
        this.getMinPosition(minPos);
        this.getMaxPosition(maxPos);
        int n = 0;
        while (n < 2) {
            if (pos[n] < minPos[n]) {
                minPos[n] = pos[n];
            }
            if (maxPos[n] < pos[n]) {
                maxPos[n] = pos[n];
            }
            ++n;
        }
        this.set(minPos, maxPos);
    }

    public void addPoint(float x, float y, float z) {
        float[] pos = new float[]{x, y};
        pos[2] = z;
        this.addPoint(pos);
    }
}

