/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.parser.vrml97;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import org.cybergarage.x3d.parser.vrml97.VRML97Proto;
import org.cybergarage.x3d.parser.vrml97.VRML97ProtoParameter;
import org.cybergarage.x3d.parser.vrml97.VRML97ProtoParameterList;
import org.cybergarage.x3d.parser.vrml97.VRML97ProtoTokenizer;
import org.cybergarage.x3d.util.Debug;
import org.cybergarage.x3d.util.LinkedList;

public class VRML97Preprocessor {
    private LinkedList mVRML97ProtoList = new LinkedList();
    private boolean mOK = false;
    private static final DecimalFormat number2StringDecimalFormat = new DecimalFormat("#############################0.0#############################");
    public InputStream mInputStream = null;

    public VRML97Preprocessor() {
        this.setOkFlag(false);
    }

    public VRML97Preprocessor(File file) throws FileNotFoundException, IOException {
        this.open(file);
    }

    public VRML97Preprocessor(String file) throws FileNotFoundException, IOException {
        this.open(file);
    }

    public void addVRML97Proto(VRML97Proto proto) {
        this.mVRML97ProtoList.addNode(proto);
    }

    public VRML97Proto getVRML97Protos() {
        return (VRML97Proto)this.mVRML97ProtoList.getNodes();
    }

    public VRML97Proto getVRML97Proto(String name) {
        VRML97Proto proto = this.getVRML97Protos();
        while (proto != null) {
            String protoName = proto.getName();
            if (protoName.compareTo(name) == 0) {
                return proto;
            }
            proto = proto.next();
        }
        return null;
    }

    public void setOkFlag(boolean flag) {
        this.mOK = flag;
    }

    public boolean isOk() {
        return this.mOK;
    }

    public String getTempFilename() {
        return "__temp__filename__";
    }

    private static final boolean isIntegerValue(double value) {
        return value % 1.0 == 0.0;
    }

    public static final String number2String(double value) {
        String str = null;
        if (VRML97Preprocessor.isIntegerValue(value)) {
            int ivalue = (int)value;
            str = Integer.toString(ivalue);
        } else {
            str = number2StringDecimalFormat.format(value);
        }
        return str;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if (this.isOk()) {
            this.mInputStream = new FileInputStream(this.getTempFilename());
            return this.mInputStream;
        }
        throw new FileNotFoundException(this.getTempFilename());
    }

    public void close() throws IOException {
        if (this.mInputStream == null) {
            throw new IOException(this.getTempFilename());
        }
        this.mInputStream.close();
    }

    public boolean delete() throws IOException {
        this.close();
        File file = new File(this.getTempFilename());
        return file.delete();
    }

    public InputStream open(File file) throws FileNotFoundException, IOException {
        this.setOkFlag(false);
        this.replace(file);
        return this.getInputStream();
    }

    public InputStream open(String file) throws FileNotFoundException, IOException {
        this.setOkFlag(false);
        this.replace(file);
        return this.getInputStream();
    }

    public void replace(File file) throws FileNotFoundException, IOException {
        FileInputStream inputStream = new FileInputStream(file);
        BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
        VRML97ProtoTokenizer st = new VRML97ProtoTokenizer(r);
        this.replace(st);
        ((InputStream)inputStream).close();
    }

    public void replace(String file) throws FileNotFoundException, IOException {
        FileInputStream inputStream = new FileInputStream(file);
        BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
        VRML97ProtoTokenizer st = new VRML97ProtoTokenizer(r);
        this.replace(st);
        ((InputStream)inputStream).close();
    }

    private boolean isMField(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        String beginTwoChars = new String(fieldName.getBytes(), 0, 2);
        if (beginTwoChars == null) {
            return false;
        }
        return beginTwoChars.equals("MF");
    }

    public String getParameterValue(String fieldName, VRML97ProtoTokenizer stream) throws IOException {
        if (fieldName.compareTo("SFBool") == 0) {
            stream.nextToken();
            String value = stream.sval;
            return value;
        }
        if (fieldName.compareTo("SFFloat") == 0) {
            stream.nextToken();
            Double value = new Double(stream.nval);
            return value.toString();
        }
        if (fieldName.compareTo("SFColor") == 0) {
            stream.nextToken();
            double r = stream.nval;
            stream.nextToken();
            double g = stream.nval;
            stream.nextToken();
            double b = stream.nval;
            return String.valueOf(r) + " " + g + " " + b;
        }
        if (fieldName.compareTo("SFImage") == 0) {
            System.out.println("PROTO SFImage is not suppoted !!");
            return null;
        }
        if (fieldName.compareTo("SFInt32") == 0) {
            stream.nextToken();
            Integer value = new Integer((int)stream.nval);
            return value.toString();
        }
        if (fieldName.compareTo("SFString") == 0) {
            stream.nextToken();
            String value = stream.sval;
            return value;
        }
        if (fieldName.compareTo("SFTime") == 0) {
            stream.nextToken();
            Double value = new Double(stream.nval);
            return value.toString();
        }
        if (fieldName.compareTo("SFVec2f") == 0) {
            stream.nextToken();
            double x = stream.nval;
            stream.nextToken();
            double y = stream.nval;
            return String.valueOf(x) + " " + y;
        }
        if (fieldName.compareTo("SFVec3f") == 0) {
            stream.nextToken();
            double x = stream.nval;
            stream.nextToken();
            double y = stream.nval;
            stream.nextToken();
            double z = stream.nval;
            return String.valueOf(x) + " " + y + " " + z;
        }
        if (fieldName.compareTo("SFRotation") == 0) {
            stream.nextToken();
            double x = stream.nval;
            stream.nextToken();
            double y = stream.nval;
            stream.nextToken();
            double z = stream.nval;
            stream.nextToken();
            double r = stream.nval;
            return String.valueOf(x) + " " + y + " " + z + " " + r;
        }
        if (fieldName.compareTo("SFNode") == 0) {
            stream.nextToken();
            String value = stream.sval;
            return value;
        }
        if (this.isMField(fieldName)) {
            int bigBracket = 0;
            int smallBracket = 0;
            StringBuffer value = new StringBuffer();
            stream.nextToken();
            while (stream.ttype != -1) {
                if (stream.ttype == 10) {
                    if (bigBracket == 0 && smallBracket == 0) {
                        String appendedStr = value.toString();
                        if (appendedStr.length() > 0) {
                            return appendedStr;
                        }
                        return "[]";
                    }
                    value.append("\n");
                }
                if (stream.ttype == -3) {
                    String str = stream.sval;
                    if (str.compareTo("[]") == 0) {
                        return new String("[]");
                    }
                    if (str.compareTo("[") == 0) {
                        ++bigBracket;
                        value.append("[ ");
                        stream.nextToken();
                        break;
                    }
                    if (str.compareTo("{") == 0) {
                        ++smallBracket;
                        value.append("{ ");
                        stream.nextToken();
                        break;
                    }
                    value.append(String.valueOf(str) + " ");
                }
                stream.nextToken();
            }
            while (stream.ttype != -1) {
                if (stream.ttype == -3) {
                    String str = stream.sval;
                    if (str.compareTo("]") == 0 && --bigBracket == 0 && smallBracket == 0) {
                        value.append("]");
                        break;
                    }
                    if (str.compareTo("}") == 0 && --smallBracket == 0 && bigBracket == 0) {
                        value.append("}");
                        break;
                    }
                    if (str.compareTo("[") == 0) {
                        ++bigBracket;
                    }
                    if (str.compareTo("{") == 0) {
                        ++smallBracket;
                    }
                    value.append(String.valueOf(str) + " ");
                }
                if (stream.ttype == -2) {
                    double dvalue = stream.nval;
                    String str = VRML97Preprocessor.number2String(dvalue);
                    value.append(String.valueOf(str) + " ");
                }
                if (stream.ttype == 10) {
                    value.append("\n");
                }
                stream.nextToken();
            }
            return value.toString();
        }
        return null;
    }

    public boolean addProtoParameter(VRML97ProtoParameterList paramList, VRML97ProtoTokenizer stream) throws IOException {
        stream.nextToken();
        if (stream.ttype != -3) {
            return false;
        }
        String fieldName = stream.sval;
        stream.nextToken();
        if (stream.ttype != -3) {
            return false;
        }
        String name = stream.sval;
        String value = this.getParameterValue(fieldName, stream);
        if (name != null && value != null) {
            paramList.addParameter(fieldName, name, value);
            return true;
        }
        return false;
    }

    private boolean isFieldName(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        if (fieldName.compareTo("field") == 0) {
            return true;
        }
        if (fieldName.compareTo("exposedField") == 0) {
            return true;
        }
        if (fieldName.compareTo("eventIn") == 0) {
            return true;
        }
        return fieldName.compareTo("eventOut") == 0;
    }

    public boolean addProtoParameters(VRML97ProtoParameterList paramList, VRML97ProtoTokenizer stream) throws IOException {
        stream.nextToken();
        while (stream.ttype != -1) {
            if (stream.ttype == -3 && stream.sval.compareTo("[") == 0) break;
            stream.nextToken();
        }
        if (stream.ttype == -1) {
            return false;
        }
        stream.nextToken();
        while (stream.ttype != -1) {
            if (stream.ttype == -3) {
                String str = stream.sval;
                if (str.compareTo("]") == 0) {
                    return true;
                }
                if (this.isFieldName(str) && !this.addProtoParameter(paramList, stream)) {
                    return false;
                }
            }
            stream.nextToken();
        }
        return false;
    }

    public VRML97Proto createProto(VRML97ProtoTokenizer stream) throws IOException {
        stream.nextToken();
        String protoName = stream.sval;
        Debug.message("PROTO");
        Debug.message("  name = " + protoName);
        VRML97Proto proto = new VRML97Proto(protoName);
        if (!this.addProtoParameters(proto.getParameterList(), stream)) {
            return null;
        }
        int nest = 0;
        stream.nextToken();
        while (stream.ttype != -1) {
            if (stream.ttype == -3 && stream.sval.compareTo("{") == 0) {
                ++nest;
                break;
            }
            stream.nextToken();
        }
        stream.nextToken();
        while (stream.ttype != -1 && nest > 0) {
            switch (stream.ttype) {
                case -2: {
                    double dvalue = stream.nval;
                    String valStr = VRML97Preprocessor.number2String(dvalue);
                    proto.addToken(valStr);
                    break;
                }
                case -3: {
                    if (stream.sval.compareTo("{") == 0) {
                        ++nest;
                    }
                    if (stream.sval.compareTo("}") == 0) {
                        --nest;
                    }
                    if (nest <= 0) break;
                    proto.addToken(stream.sval);
                    break;
                }
                case 10: {
                    proto.addToken("\n");
                }
            }
            stream.nextToken();
        }
        return proto;
    }

    public boolean hasProto(VRML97Proto proto, String value) throws IOException {
        StringReader strReader = new StringReader(value);
        VRML97ProtoTokenizer stream = new VRML97ProtoTokenizer(strReader);
        stream.nextToken();
        while (stream.ttype != -1) {
            String token;
            if (stream.ttype == -3 && proto.hasParameter(token = stream.sval)) {
                return true;
            }
            stream.nextToken();
        }
        return false;
    }

    public String getVRML97ProtoString(VRML97Proto proto, VRML97ProtoTokenizer stream) throws IOException {
        VRML97ProtoParameterList paramList = new VRML97ProtoParameterList();
        int indent = 0;
        stream.nextToken();
        while (stream.ttype != -1) {
            if (stream.ttype == -3 && stream.sval.compareTo("{") == 0) {
                ++indent;
                break;
            }
            stream.nextToken();
        }
        if (stream.ttype == -1) {
            return null;
        }
        stream.nextToken();
        while (stream.ttype != -1) {
            switch (stream.ttype) {
                case -3: {
                    String strToken = stream.sval;
                    if (strToken.compareTo("{") == 0) {
                        ++indent;
                        break;
                    }
                    if (strToken.compareTo("}") == 0) {
                        if (--indent != 0) break;
                        return proto.getString(paramList);
                    }
                    String name = strToken;
                    VRML97ProtoParameter protoParam = proto.getParameter(name);
                    if (protoParam == null) break;
                    String fieldTypeName = protoParam.getType();
                    String value = this.getParameterValue(fieldTypeName, stream);
                    if (this.hasProto(proto, value)) {
                        Debug.message("==== value ==== ");
                        Debug.message(value);
                        StringWriter strWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(strWriter);
                        StringReader strReader = new StringReader(value);
                        VRML97ProtoTokenizer valueStream = new VRML97ProtoTokenizer(strReader);
                        try {
                            this.replace(valueStream, printWriter);
                            strWriter.flush();
                            strWriter.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        value = strWriter.toString();
                        Debug.message("==== New value ==== ");
                        Debug.message(value);
                    }
                    paramList.addParameter(fieldTypeName, name, value);
                    break;
                }
            }
            stream.nextToken();
        }
        return null;
    }

    public void replace(VRML97ProtoTokenizer stream, PrintWriter printStream) throws IOException {
        int nToken = 0;
        block5: while (stream.nextToken() != -1) {
            switch (stream.ttype) {
                case -2: {
                    String strToken;
                    double numValue = stream.nval;
                    printStream.print(VRML97Preprocessor.number2String(numValue));
                    boolean isNextTokenFloatWorld = false;
                    stream.nextToken();
                    if (stream.ttype == -3 && (strToken = stream.sval) != null && (strToken.startsWith("E") || strToken.startsWith("e"))) {
                        if (VRML97Preprocessor.isIntegerValue(numValue)) {
                            printStream.print(".0");
                        }
                        printStream.print(strToken);
                        isNextTokenFloatWorld = true;
                    }
                    if (!isNextTokenFloatWorld) {
                        stream.pushBack();
                    }
                    printStream.print(" ");
                    ++nToken;
                    break;
                }
                case -3: {
                    VRML97Proto proto;
                    String strToken = stream.sval;
                    if (strToken.compareTo("PROTO") == 0) {
                        proto = this.createProto(stream);
                        if (proto == null) break;
                        this.addVRML97Proto(proto);
                        String protoString = proto.getString(null);
                        if (protoString == null) break;
                        printStream.println(protoString);
                        break;
                    }
                    if (strToken.compareTo("DEF") == 0) {
                        String nodeName = null;
                        stream.nextToken();
                        if (stream.ttype == -3) {
                            nodeName = stream.sval;
                        }
                        if (nodeName == null || nodeName.length() <= 0) continue block5;
                        printStream.print("DEF " + nodeName + " ");
                        break;
                    }
                    proto = this.getVRML97Proto(strToken);
                    if (proto != null) {
                        String protoString = this.getVRML97ProtoString(proto, stream);
                        if (protoString == null) break;
                        Debug.message(protoString);
                        printStream.println(protoString);
                        break;
                    }
                    printStream.print(String.valueOf(strToken) + " ");
                    ++nToken;
                    break;
                }
                case 10: {
                    if (nToken > 0) {
                        printStream.println("");
                    }
                    nToken = 0;
                }
            }
        }
        if (printStream != null) {
            printStream.flush();
            printStream.close();
        }
    }

    public void replace(VRML97ProtoTokenizer stream) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(this.getTempFilename());
            PrintWriter printStream = new PrintWriter(outputStream);
            this.replace(stream, printStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            System.out.println("Couldn't replace a file(" + this.getTempFilename() + ") !!");
        }
        this.setOkFlag(true);
    }
}

