/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.parser.threedsystems;

import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.IndexedFaceSetNode;
import org.cybergarage.x3d.node.NormalNode;
import org.cybergarage.x3d.node.RootNode;
import org.cybergarage.x3d.node.ShapeNode;
import org.cybergarage.x3d.parser.threedsystems.ParseException;
import org.cybergarage.x3d.parser.threedsystems.STLAsciiParserConstants;
import org.cybergarage.x3d.parser.threedsystems.STLAsciiParserTokenManager;
import org.cybergarage.x3d.parser.threedsystems.SimpleCharStream;
import org.cybergarage.x3d.parser.threedsystems.Token;

public class STLAsciiParser
implements STLAsciiParserConstants {
    private RootNode mRootNode;
    private ShapeNode mCurrentShapeNode;
    private boolean mHasFaceColor;
    private float[] mPrevFaceColor = new float[3];
    private int mSolidFaceCount;
    public STLAsciiParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[6];
    private final int[] jj_la1_0 = new int[]{163840, 32, 65536, 4224, 4096, 16384};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public STLAsciiParser() {
    }

    public void initialize() {
        this.mRootNode = new RootNode();
        this.setCurrentShapeNode(null);
        this.setPrevFaceColor(1.0f, 1.0f, 1.0f);
    }

    public ShapeNode createShapeNode() {
        ShapeNode shape = new ShapeNode();
        IndexedFaceSetNode idxFaceSetNode = new IndexedFaceSetNode();
        shape.addChildNode(idxFaceSetNode);
        idxFaceSetNode.addChildNode(new CoordinateNode());
        idxFaceSetNode.addChildNode(new ColorNode());
        idxFaceSetNode.addChildNode(new NormalNode());
        idxFaceSetNode.setColorPerVertex(false);
        idxFaceSetNode.setNormalPerVertex(true);
        return shape;
    }

    public int getNShapeNodes() {
        return this.mRootNode.getNChildNodes();
    }

    public ShapeNode getShapeNodes() {
        return this.mRootNode.getShapeNodes();
    }

    public void addShapeNode(ShapeNode node) {
        this.mRootNode.addChildNode(node);
    }

    public void setSolidFaceCount(int n) {
        this.mSolidFaceCount = n;
    }

    public int getSolidFaceCount() {
        return this.mSolidFaceCount;
    }

    public void setPrevFaceColor(float r, float g, float b) {
        this.mPrevFaceColor[0] = r;
        this.mPrevFaceColor[1] = g;
        this.mPrevFaceColor[2] = b;
    }

    public void getPrevFaceColor(float[] color) {
        color[0] = this.mPrevFaceColor[0];
        color[1] = this.mPrevFaceColor[1];
        color[2] = this.mPrevFaceColor[2];
    }

    public boolean hasFaceColor() {
        return this.mHasFaceColor;
    }

    public void setFaceColorFlag(boolean flag) {
        this.mHasFaceColor = flag;
    }

    public void setCurrentShapeNode(ShapeNode node) {
        this.mCurrentShapeNode = node;
    }

    public ShapeNode getCurrentShapeNode() {
        return this.mCurrentShapeNode;
    }

    private IndexedFaceSetNode getCurrentIndexedFaceSetNode() {
        return this.getCurrentShapeNode().getIndexedFaceSetNodes();
    }

    private CoordinateNode getCurrentCoordinateNode() {
        return this.getCurrentIndexedFaceSetNode().getCoordinateNodes();
    }

    private ColorNode getCurrentColorNode() {
        return this.getCurrentIndexedFaceSetNode().getColorNodes();
    }

    private NormalNode getCurrentNormalNode() {
        return this.getCurrentIndexedFaceSetNode().getNormalNodes();
    }

    private void addCoodinate(float x, float y, float z) {
        this.getCurrentCoordinateNode().addPoint(x, y, z);
    }

    private int getNCoodinates() {
        return this.getCurrentCoordinateNode().getNPoints();
    }

    private void addColor(float r, float g, float b) {
        this.getCurrentColorNode().addColor(r, g, b);
    }

    private int getNColors() {
        return this.getCurrentColorNode().getNColors();
    }

    private void addNormal(float x, float y, float z) {
        this.getCurrentNormalNode().addVector(x, y, z);
    }

    private int getNNormals() {
        return this.getCurrentNormalNode().getNVectors();
    }

    private void addCoordIndex(int index) {
        this.getCurrentIndexedFaceSetNode().addCoordIndex(index);
    }

    public int getNCoordIndices() {
        return this.getCurrentIndexedFaceSetNode().getNCoordIndices();
    }

    public int getCoordIndex(int n) {
        return this.getCurrentIndexedFaceSetNode().getCoordIndex(n);
    }

    private void addNormalIndex(int index) {
        this.getCurrentIndexedFaceSetNode().addNormalIndex(index);
    }

    public int getNNormalIndices() {
        return this.getCurrentIndexedFaceSetNode().getNNormalIndices();
    }

    public int getNormalIndex(int n) {
        return this.getCurrentIndexedFaceSetNode().getNormalIndex(n);
    }

    private void addTexCoordIndex(int index) {
        this.getCurrentIndexedFaceSetNode().addTexCoordIndex(index);
    }

    public int getNTexCoordIndices() {
        return this.getCurrentIndexedFaceSetNode().getNTexCoordIndices();
    }

    public int getTexCoordIndex(int n) {
        return this.getCurrentIndexedFaceSetNode().getTexCoordIndex(n);
    }

    public final float ValueToken() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                Token t = this.jj_consume_token(15);
                Integer intObj = new Integer(t.image);
                return intObj.intValue();
            }
            case 17: {
                Token t = this.jj_consume_token(17);
                Float floatObj = new Float(t.image);
                return floatObj.floatValue();
            }
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String NameToken() throws ParseException {
        Token t = this.jj_consume_token(16);
        return t.image;
    }

    public final void STLAscii() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.Solid();
        }
    }

    public final void SolidBegin() throws ParseException {
        this.jj_consume_token(5);
        String name = this.NameToken();
        ShapeNode shape = this.createShapeNode();
        shape.setName(name);
        this.addShapeNode(shape);
        this.setCurrentShapeNode(shape);
        this.setSolidFaceCount(0);
    }

    public final void SolidEnd() throws ParseException {
        this.jj_consume_token(6);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            String string = this.NameToken();
        }
    }

    public final void Solid() throws ParseException {
        this.SolidBegin();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block6;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    this.Color();
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                }
            }
            this.Face();
        }
        this.SolidEnd();
    }

    public final void Facet() throws ParseException {
        this.jj_consume_token(7);
        this.setFaceColorFlag(false);
    }

    public final void EndFacet() throws ParseException {
        int nNormals;
        float[] color = new float[3];
        float[] vector = new float[3];
        this.jj_consume_token(8);
        int faceCount = this.getSolidFaceCount();
        if (!this.hasFaceColor()) {
            this.getPrevFaceColor(color);
            this.addColor(color[0], color[1], color[2]);
        }
        if ((nNormals = this.getNNormals()) == 1) {
            NormalNode normalNode = this.getCurrentNormalNode();
            normalNode.getVector(0, vector);
            this.addNormal(vector[0], vector[1], vector[2]);
            this.addNormal(vector[0], vector[1], vector[2]);
        }
        int n = 0;
        while (n < 3) {
            this.addCoordIndex(faceCount * 3 + n);
            ++n;
        }
        this.addCoordIndex(-1);
        this.setSolidFaceCount(faceCount + 1);
    }

    public final void Face() throws ParseException {
        this.Facet();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.Normal();
        }
        this.jj_consume_token(9);
        this.jj_consume_token(10);
        this.Vertex();
        this.Vertex();
        this.Vertex();
        this.jj_consume_token(11);
        this.EndFacet();
    }

    public final void Color() throws ParseException {
        this.jj_consume_token(12);
        float r = this.ValueToken();
        float g = this.ValueToken();
        float b = this.ValueToken();
        this.addColor(r, g, b);
        this.setFaceColorFlag(true);
        this.setPrevFaceColor(r, g, b);
    }

    public final void Vertex() throws ParseException {
        this.jj_consume_token(13);
        float x = this.ValueToken();
        float y = this.ValueToken();
        float z = this.ValueToken();
        this.addCoodinate(x, y, z);
    }

    public final void Normal() throws ParseException {
        this.jj_consume_token(14);
        float x = this.ValueToken();
        float y = this.ValueToken();
        float z = this.ValueToken();
        this.addNormal(x, y, z);
    }

    public final void Input() throws ParseException {
        this.STLAscii();
        this.jj_consume_token(0);
    }

    public STLAsciiParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new STLAsciiParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public STLAsciiParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new STLAsciiParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public STLAsciiParser(STLAsciiParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(STLAsciiParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[19];
        int i = 0;
        while (i < 19) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 6) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 19) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

