/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFVec2f;
import org.cybergarage.x3d.node.GeometricPropertyNode;
import org.cybergarage.x3d.node.Node;

public class TextureCoordinateNode
extends GeometricPropertyNode {
    private static final String pointFieldName = "point";
    private MFVec2f pointField;

    public TextureCoordinateNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.TEXTURECOORD);
        this.pointField = new MFVec2f();
        this.pointField.setName(pointFieldName);
        this.addExposedField(this.pointField);
    }

    public TextureCoordinateNode(TextureCoordinateNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFVec2f getPointField() {
        if (!this.isInstanceNode()) {
            return this.pointField;
        }
        return (MFVec2f)this.getExposedField(pointFieldName);
    }

    public void addPoint(float[] point) {
        this.getPointField().addValue(point);
    }

    public void addPoint(float x, float y) {
        this.getPointField().addValue(x, y);
    }

    public int getNPoints() {
        return this.getPointField().getSize();
    }

    public void setPoint(int index, float[] point) {
        this.getPointField().set1Value(index, point);
    }

    public void setPoint(int index, float x, float y) {
        this.getPointField().set1Value(index, x, y);
    }

    public void setPoints(String point) {
        this.getPointField().setValues(point);
    }

    public void setPoints(String[] point) {
        this.getPointField().setValues(point);
    }

    public void getPoint(int index, float[] point) {
        this.getPointField().get1Value(index, point);
    }

    public float[] getPoint(int index) {
        float[] value = new float[2];
        this.getPoint(index, value);
        return value;
    }

    public void removePoint(int index) {
        this.getPointField().removeValue(index);
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        float[] point = new float[2];
        printStream.println(String.valueOf(indentString) + "\tpoint [");
        int n = 0;
        while (n < this.getNPoints()) {
            this.getPoint(n, point);
            if (n < this.getNPoints() - 1) {
                printStream.println(String.valueOf(indentString) + "\t\t" + point[0] + " " + point[1] + ",");
            } else {
                printStream.println(String.valueOf(indentString) + "\t\t" + point[0] + " " + point[1]);
            }
            ++n;
        }
        printStream.println(String.valueOf(indentString) + "\t]");
    }
}

