/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.Node;

public class SphereNode
extends Geometry3DNode {
    private static final String radiusFieldName = "radius";
    private SFFloat radiusField;

    public SphereNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.SPHERE);
        this.radiusField = new SFFloat(1.0f);
        this.addExposedField(radiusFieldName, this.radiusField);
    }

    public SphereNode(SphereNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFFloat getRadiusField() {
        if (!this.isInstanceNode()) {
            return this.radiusField;
        }
        return (SFFloat)this.getExposedField(radiusFieldName);
    }

    public void setRadius(float value) {
        this.getRadiusField().setValue(value);
    }

    public void setRadius(String value) {
        this.getRadiusField().setValue(value);
    }

    public float getRadius() {
        return this.getRadiusField().getValue();
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateBoundingBox();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
    }

    @Override
    public void updateBoundingBox() {
        this.setBoundingBoxCenter(0.0f, 0.0f, 0.0f);
        this.setBoundingBoxSize(this.getRadius(), this.getRadius(), this.getRadius());
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        printStream.println(String.valueOf(indentString) + "\t" + "radius " + this.getRadius());
    }
}

