/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import java.util.Date;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFRotation;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.EnvironmentalSensorNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.ViewpointNode;

public class ProximitySensorNode
extends EnvironmentalSensorNode {
    private static final String positionEventOutName = "position";
    private static final String orientationEventOutName = "orientation";
    private SFVec3f positionField;
    private SFRotation orientationField;
    private float[] vpos = new float[3];
    private float[] center = new float[3];
    private float[] size = new float[3];

    public ProximitySensorNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.PROXIMITYSENSOR);
        this.setRunnable(true);
        this.positionField = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.addEventOut(positionEventOutName, this.positionField);
        this.orientationField = new SFRotation(0.0f, 0.0f, 1.0f, 0.0f);
        this.addEventOut(orientationEventOutName, this.orientationField);
    }

    public ProximitySensorNode(ProximitySensorNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFVec3f getPositionChangedField() {
        if (!this.isInstanceNode()) {
            return this.positionField;
        }
        return (SFVec3f)this.getEventOut(positionEventOutName);
    }

    public void setPositionChanged(float[] value) {
        this.getPositionChangedField().setValue(value);
    }

    public void setPositionChanged(float x, float y, float z) {
        this.getPositionChangedField().setValue(x, y, z);
    }

    public void setPositionChanged(String value) {
        this.getPositionChangedField().setValue(value);
    }

    public void getPositionChanged(float[] value) {
        this.getPositionChangedField().getValue(value);
    }

    public SFVec3f getPositionField() {
        return this.getPositionChangedField();
    }

    public void setPosition(float[] value) {
        this.setPositionChanged(value);
    }

    public void setPosition(float x, float y, float z) {
        this.setPositionChanged(x, y, z);
    }

    public void setPosition(String value) {
        this.setPositionChanged(value);
    }

    public void getPosition(float[] value) {
        this.getPositionChanged(value);
    }

    public SFRotation getOrientationChangedField() {
        if (!this.isInstanceNode()) {
            return this.orientationField;
        }
        return (SFRotation)this.getEventOut(orientationEventOutName);
    }

    public void setOrientationChanged(float[] value) {
        this.getOrientationChangedField().setValue(value);
    }

    public void setOrientationChanged(float x, float y, float z, float rot) {
        this.getOrientationChangedField().setValue(x, y, z, rot);
    }

    public void setOrientationChanged(String value) {
        this.getOrientationChangedField().setValue(value);
    }

    public void getOrientationChanged(float[] value) {
        SFRotation orientation = (SFRotation)this.getEventOut(orientationEventOutName);
        orientation.getValue(value);
    }

    public SFRotation getOrientationField() {
        return this.getOrientationChangedField();
    }

    public void setOrientation(float[] value) {
        this.setOrientationChanged(value);
    }

    public void setOrientation(float x, float y, float z, float rot) {
        this.setOrientationChanged(x, y, z, rot);
    }

    public void setOrientation(String value) {
        this.setOrientationChanged(value);
    }

    public void getOrientation(float[] value) {
        this.getOrientationChanged(value);
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setInRegion(false);
        this.setRunnableIntervalTime(250);
    }

    @Override
    public void uninitialize() {
    }

    public double getCurrentSystemTime() {
        Date date = new Date();
        return (double)date.getTime() / 1000.0;
    }

    @Override
    public void update() {
        if (!this.isEnabled()) {
            return;
        }
        SceneGraph sg = this.getSceneGraph();
        if (sg == null) {
            return;
        }
        ViewpointNode view = sg.getViewpointNode();
        if (view == null) {
            view = sg.getDefaultViewpointNode();
        }
        view.getPosition(this.vpos);
        this.getCenter(this.center);
        this.getSize(this.size);
        if (!this.inRegion()) {
            if (this.isRegion(this.vpos, this.center, this.size)) {
                this.setInRegion(true);
                double time = this.getCurrentSystemTime();
                this.setEnterTime(time);
                this.sendEvent(this.getEnterTimeField());
                this.setIsActive(true);
                this.sendEvent(this.getIsActiveField());
            }
        } else if (!this.isRegion(this.vpos, this.center, this.size)) {
            this.setInRegion(false);
            double time = this.getCurrentSystemTime();
            this.setExitTime(time);
            this.sendEvent(this.getExitTimeField());
            this.setIsActive(false);
            this.sendEvent(this.getIsActiveField());
        }
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        SFBool enabled = this.getEnabledField();
        SFVec3f center = this.getCenterField();
        SFVec3f size = this.getSizeField();
        printStream.println(String.valueOf(indentString) + "\t" + "enabled " + enabled);
        printStream.println(String.valueOf(indentString) + "\t" + "center " + center);
        printStream.println(String.valueOf(indentString) + "\t" + "size " + size);
    }
}

