/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFVec2f;
import org.cybergarage.x3d.field.SFVec2f;
import org.cybergarage.x3d.node.InterpolatorNode;
import org.cybergarage.x3d.node.Node;

public class PositionInterpolator2DNode
extends InterpolatorNode {
    private String keyValueFieldName = "keyValue";
    private MFVec2f keyValueField;
    private SFVec2f valueField;

    public PositionInterpolator2DNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.POSITIONINTERPOLATOR2D);
        this.keyValueField = new MFVec2f();
        this.addExposedField(this.keyValueFieldName, this.keyValueField);
        this.valueField = new SFVec2f(0.0f, 0.0f);
        this.addEventOut("value", this.valueField);
    }

    public PositionInterpolator2DNode(PositionInterpolator2DNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFVec2f getKeyValueField() {
        if (!this.isInstanceNode()) {
            return this.keyValueField;
        }
        return (MFVec2f)this.getExposedField(this.keyValueFieldName);
    }

    public void addKeyValue(float[] vector) {
        this.getKeyValueField().addValue(vector);
    }

    public void addKeyValue(float x, float y) {
        this.getKeyValueField().addValue(x, y);
    }

    public int getNKeyValues() {
        return this.getKeyValueField().getSize();
    }

    public void setKeyValue(int index, float[] vector) {
        this.getKeyValueField().set1Value(index, vector);
    }

    public void setKeyValue(int index, float x, float y) {
        this.getKeyValueField().set1Value(index, x, y);
    }

    public void setKeyValues(String value) {
        this.getKeyValueField().setValues(value);
    }

    public void setKeyValues(String[] value) {
        this.getKeyValueField().setValues(value);
    }

    public void getKeyValue(int index, float[] vector) {
        this.getKeyValueField().get1Value(index, vector);
    }

    public float[] getKeyValue(int index) {
        float[] value = new float[2];
        this.getKeyValue(index, value);
        return value;
    }

    public void removeKeyValue(int index) {
        this.getKeyValueField().removeValue(index);
    }

    public SFVec2f getValueField() {
        if (!this.isInstanceNode()) {
            return this.valueField;
        }
        return (SFVec2f)this.getEventOut("value");
    }

    public void setValue(float[] vector) {
        this.getValueField().setValue(vector);
    }

    public void setValue(String vector) {
        this.getValueField().setValue(vector);
    }

    public void getValue(float[] vector) {
        this.getValueField().getValue(vector);
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
        float fraction = this.getFraction();
        int index = -1;
        int n = 0;
        while (n < this.getNKeys() - 1) {
            if (this.getKey(n) <= fraction && fraction <= this.getKey(n + 1)) {
                index = n;
                break;
            }
            ++n;
        }
        if (index == -1) {
            return;
        }
        float scale = (fraction - this.getKey(index)) / (this.getKey(index + 1) - this.getKey(index));
        float[] vector1 = new float[2];
        float[] vector2 = new float[2];
        float[] vectorOut = new float[2];
        this.getKeyValue(index, vector1);
        this.getKeyValue(index + 1, vector2);
        int n2 = 0;
        while (n2 < 2) {
            vectorOut[n2] = vector1[n2] + (vector2[n2] - vector1[n2]) * scale;
            ++n2;
        }
        this.setValue(vectorOut);
        this.sendEvent(this.getValueField());
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
    }
}

