/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFInt32;
import org.cybergarage.x3d.field.SFInt32;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.SequencerNode;

public class IntegerSequencerNode
extends SequencerNode {
    private String keyValueFieldName = "keyValue";
    private MFInt32 keyValueField;
    private SFInt32 valueField;

    public IntegerSequencerNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.INTEGERSEQUENCER);
        this.keyValueField = new MFInt32();
        this.addExposedField(this.keyValueFieldName, this.keyValueField);
        this.valueField = new SFInt32();
        this.addEventOut("value", this.valueField);
    }

    public IntegerSequencerNode(IntegerSequencerNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFInt32 getKeyValueField() {
        if (!this.isInstanceNode()) {
            return this.keyValueField;
        }
        return (MFInt32)this.getExposedField(this.keyValueFieldName);
    }

    public void addKeyValue(int value) {
        this.getKeyValueField().addValue(value);
    }

    public int getNKeyValues() {
        return this.getKeyValueField().getSize();
    }

    public void setKeyValue(int index, int value) {
        this.getKeyValueField().set1Value(index, value);
    }

    public void setKeyValues(String value) {
        this.getKeyValueField().setValues(value);
    }

    public void setKeyValues(String[] value) {
        this.getKeyValueField().setValues(value);
    }

    public int getKeyValue(int index) {
        return this.getKeyValueField().get1Value(index);
    }

    public void removeKeyValue(int index) {
        this.getKeyValueField().removeValue(index);
    }

    public SFInt32 getValueField() {
        if (!this.isInstanceNode()) {
            return this.valueField;
        }
        return (SFInt32)this.getEventOut("value");
    }

    public void setValue(int value) {
        this.getValueField().setValue(value);
    }

    public void setValue(String value) {
        this.getValueField().setValue(value);
    }

    public int getValue() {
        return this.getValueField().getValue();
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
        float fraction = this.getFraction();
        int index = -1;
        int n = 0;
        while (n < this.getNKeys() - 1) {
            if (this.getKey(n) <= fraction && fraction <= this.getKey(n + 1)) {
                index = n;
                break;
            }
            ++n;
        }
        if (index == -1) {
            return;
        }
        float scale = (fraction - this.getKey(index)) / (this.getKey(index + 1) - this.getKey(index));
        float value1 = this.getKeyValue(index);
        float value2 = this.getKeyValue(index + 1);
        float valueOut = value1 + (value2 - value1) * scale;
        this.setValue((int)valueOut);
        this.sendEvent(this.getValueField());
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
    }
}

