/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.field.MFString;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.node.BoundedNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.util.Debug;

public class InlineNode
extends BoundedNode {
    private static final String urlFieldName = "url";
    private MFString urlField;
    private static final String loadFieldName = "load";
    private SFBool loadField;

    public InlineNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.INLINE);
        this.urlField = new MFString();
        this.addExposedField(urlFieldName, this.urlField);
        this.loadField = new SFBool();
        this.addExposedField(loadFieldName, this.loadField);
    }

    public InlineNode(InlineNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFString getURLField() {
        if (!this.isInstanceNode()) {
            return this.urlField;
        }
        return (MFString)this.getExposedField(urlFieldName);
    }

    public void addURL(String value) {
        this.getURLField().addValue(value);
    }

    public int getNURLs() {
        return this.getURLField().getSize();
    }

    public void setURL(int index, String value) {
        this.getURLField().set1Value(index, value);
    }

    public void setURLs(String value) {
        this.getURLField().setValues(value);
    }

    public void setURLs(String[] value) {
        this.getURLField().setValues(value);
    }

    public String getURL(int index) {
        return this.getURLField().get1Value(index);
    }

    public void removeURL(int index) {
        this.getURLField().removeValue(index);
    }

    public SFBool getLoadField() {
        if (!this.isInstanceNode()) {
            return this.loadField;
        }
        return (SFBool)this.getExposedField(loadFieldName);
    }

    public void setLoad(boolean value) {
        this.getLoadField().setValue(value);
    }

    public boolean getLoad() {
        return this.getLoadField().getValue();
    }

    public boolean isLoad() {
        return this.getLoad();
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
    }

    public boolean loadURL() {
        Debug.message("InlineNode::loadURL");
        this.removeChildNodes();
        if (this.getNURLs() <= 0) {
            return false;
        }
        String urlName = this.getURL(0);
        if (urlName == null) {
            return true;
        }
        SceneGraph sgLoad = new SceneGraph();
        if (!sgLoad.load(urlName)) {
            SceneGraph sg = this.getSceneGraph();
            if (sg == null) {
                return false;
            }
            URL baseURL = sg.getBaseURL();
            if (baseURL != null) {
                try {
                    if (!sgLoad.load(new URL(String.valueOf(baseURL.toString()) + urlName))) {
                        Debug.message("\tLoading is Failed !!");
                        return false;
                    }
                }
                catch (MalformedURLException mue) {
                    return false;
                }
            }
        }
        Debug.message("\tLoading is OK !!");
        sgLoad.initialize();
        Node sgNode = sgLoad.getNodes();
        while (sgNode != null) {
            sgNode.remove();
            this.addChildNode(sgNode);
            sgNode = sgLoad.getNodes();
        }
        return true;
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        MFString url = this.getURLField();
        printStream.println(String.valueOf(indentString) + "\t" + "url [");
        url.outputContext(printStream, String.valueOf(indentString) + "\t\t");
        printStream.println(String.valueOf(indentString) + "\t" + "]");
    }
}

