/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.ImageComponent2D;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.node.ImageTextureNode;
import org.cybergarage.x3d.util.Debug;

public class ImageTextureLoader {
    private ImageComponent2D mImageComponent = null;

    public ImageTextureLoader(ImageTextureNode imgTex, Component comp) {
        this.loadImageComponent(imgTex, comp);
    }

    public boolean hasComponent() {
        return this.mImageComponent != null;
    }

    private Image getImage(Component comp, String filename) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(filename);
        MediaTracker mt = new MediaTracker(comp);
        mt.addImage(image, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            Debug.warning("ImageTextureLoader::getImage = " + e.getMessage());
            return null;
        }
        if (mt.isErrorAny()) {
            return null;
        }
        return image;
    }

    private Image getImage(Component comp, URL urlFilename) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(urlFilename);
        MediaTracker mt = new MediaTracker(comp);
        mt.addImage(image, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            Debug.warning("ImageTextureLoader::getImage = " + e.getMessage());
            return null;
        }
        if (mt.isErrorAny()) {
            return null;
        }
        return image;
    }

    private void loadImageComponent(ImageTextureNode imgTex, Component comp) {
        SceneGraph sg;
        String url = imgTex.getURL(0);
        Image image = null;
        Debug.message("Image URL = " + url);
        if (image == null && (sg = imgTex.getSceneGraph()) != null) {
            URL baseURL = sg.getBaseURL();
            Debug.message("Base URL = " + baseURL);
            if (baseURL != null) {
                try {
                    URL imgURL = new URL(String.valueOf(baseURL.toString()) + url);
                    Debug.message("Loading Texture (" + imgURL + ") .....");
                    image = this.getImage(comp, imgURL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (image == null) {
            this.mImageComponent = null;
            Debug.warning("Texture (" + url + ") is not found");
            return;
        }
        int width = image.getWidth(comp);
        int height = image.getHeight(comp);
        this.mImageComponent = this.createImageComponent(this.createBufferedImage(image, comp));
    }

    private ImageComponent2D createImageComponent(BufferedImage bufferedImage) {
        ImageComponent2D imgComp = new ImageComponent2D(2, bufferedImage);
        imgComp.setCapability(1);
        imgComp.setCapability(2);
        imgComp.setCapability(0);
        return imgComp;
    }

    private static int getClosestPowerOf2(int value) {
        if (value < 1) {
            return value;
        }
        int powerValue = 1;
        while (value >= (powerValue *= 2)) {
        }
        int minBound = powerValue / 2;
        if (powerValue - value > value - minBound) {
            return minBound;
        }
        return powerValue;
    }

    private BufferedImage getScaledImage(BufferedImage origImage, float xScale, float yScale) {
        if (xScale == 1.0f && yScale == 1.0f) {
            return origImage;
        }
        AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
        AffineTransformOp atop = new AffineTransformOp(at, 2);
        BufferedImage scaledImage = atop.filter(origImage, null);
        return scaledImage;
    }

    private BufferedImage createBufferedImage(Image image, Component observer) {
        observer.prepareImage(image, null);
        while (true) {
            int status;
            if (((status = observer.checkImage(image, null)) & 0x40) != 0) {
                Debug.warning("Couldn't load a image in ImageTextureLoader::createBufferedImage");
                return null;
            }
            if ((status & 0x20) != 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int width = image.getWidth(observer);
        int height = image.getHeight(observer);
        BufferedImage bImage = new BufferedImage(width, height, 2);
        int[] intPixels = ((DataBufferInt)bImage.getRaster().getDataBuffer()).getData();
        PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, intPixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        float xScale = (float)ImageTextureLoader.getClosestPowerOf2(width) / (float)width;
        float yScale = (float)ImageTextureLoader.getClosestPowerOf2(height) / (float)height;
        bImage = this.getScaledImage(bImage, xScale, yScale);
        return bImage;
    }

    public ImageComponent2D getImageComponent() {
        return this.mImageComponent;
    }

    public int getWidth() {
        if (this.mImageComponent == null) {
            return 0;
        }
        return this.mImageComponent.getWidth();
    }

    public int getHeight() {
        if (this.mImageComponent == null) {
            return 0;
        }
        return this.mImageComponent.getHeight();
    }
}

