/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.field;

import java.io.IOException;
import java.util.Vector;
import org.cybergarage.x3d.field.FieldTokenizer;

public class StringFieldTokenizer {
    public static final String[] getTokens(String value, String whitespaceChars, String wordChars) {
        FieldTokenizer stream = new FieldTokenizer(value, whitespaceChars, wordChars);
        Vector<String> tokenBuffer = new Vector<String>();
        try {
            stream.nextToken();
            while (stream.ttype != -1) {
                switch (stream.ttype) {
                    case -3: {
                        tokenBuffer.addElement(new String(stream.sval));
                        break;
                    }
                    case -2: {
                        if (stream.nval % 1.0 == 0.0) {
                            tokenBuffer.addElement(Integer.toString((int)stream.nval));
                            break;
                        }
                        tokenBuffer.addElement(Double.toString(stream.nval));
                    }
                }
                stream.nextToken();
            }
        }
        catch (IOException e) {
            return null;
        }
        String[] tokens = new String[tokenBuffer.size()];
        int n = 0;
        while (n < tokenBuffer.size()) {
            tokens[n] = (String)tokenBuffer.elementAt(n);
            ++n;
        }
        return tokens;
    }

    public static final String[] getTokens(String value) {
        return StringFieldTokenizer.getTokens(value, ", ", "%");
    }
}

