/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.field;

import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.FieldType;
import org.cybergarage.x3d.field.Vec2fValue;

public class SFVec2f
extends Field {
    private Vec2fValue mVector = new Vec2fValue();

    public SFVec2f() {
        this.setType(FieldType.SFVEC2F);
        this.setValue(0.0f, 0.0f);
    }

    public SFVec2f(SFVec2f vector) {
        this();
        this.setValue(vector);
    }

    public SFVec2f(float x, float y) {
        this();
        this.setValue(x, y);
    }

    public SFVec2f(float[] value) {
        this();
        this.setValue(value);
    }

    public SFVec2f(String value) {
        this();
        this.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(Object object) {
        Vec2fValue vec2fValue = this.mVector;
        synchronized (vec2fValue) {
            this.mVector = (Vec2fValue)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject() {
        Vec2fValue object;
        Vec2fValue vec2fValue = this.mVector;
        synchronized (vec2fValue) {
            object = this.mVector;
        }
        return object;
    }

    public void getValue(float[] value) {
        this.mVector.getValue(value);
    }

    public float[] getValue() {
        return this.mVector.getValue();
    }

    public float getX() {
        return this.mVector.getX();
    }

    public float getY() {
        return this.mVector.getY();
    }

    @Override
    public int getValueCount() {
        return 2;
    }

    public void setValue(float x, float y, boolean doShare) {
        this.mVector.setValue(x, y);
        if (doShare) {
            this.postShareField(this);
        }
    }

    public void setValue(float x, float y) {
        this.setValue(x, y, true);
    }

    public void setValue(float[] value) {
        if (value.length < 2) {
            return;
        }
        this.setValue(value[0], value[1]);
    }

    public void setValue(SFVec2f vector, boolean doShare) {
        this.setValue(vector.getX(), vector.getY(), doShare);
    }

    public void setValue(SFVec2f vector) {
        this.setValue(vector, true);
    }

    @Override
    public void setValue(String string) {
        this.mVector.setValue(string);
    }

    @Override
    public void setValue(Field field, boolean doShare) {
        if (field instanceof SFVec2f) {
            this.setValue((SFVec2f)field, doShare);
        }
    }

    @Override
    public void setValue(Field field) {
        this.setValue(field, true);
    }

    public void setX(float x) {
        this.setValue(x, this.getY());
    }

    public void setY(float y) {
        this.setValue(this.getX(), y);
    }

    public void add(float x, float y) {
        this.mVector.add(x, y);
    }

    public void add(float[] value) {
        this.mVector.add(value);
    }

    public void add(SFVec2f value) {
        this.add(value.getValue());
    }

    public void sub(float x, float y) {
        this.mVector.sub(x, y);
    }

    public void sub(float[] value) {
        this.mVector.sub(value);
    }

    public void sub(SFVec2f value) {
        this.sub(value.getValue());
    }

    public void scale(float scale) {
        this.mVector.scale(scale);
    }

    public void invert() {
        this.mVector.invert();
    }

    public float getScalar() {
        return this.mVector.getScalar();
    }

    public void normalize() {
        this.mVector.normalize();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getX()) + " " + this.getY();
    }
}

