/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.cybergarage.x3d.Constants;
import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.Scene;
import org.cybergarage.x3d.SceneGraphObject;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFMatrix;
import org.cybergarage.x3d.field.SFTime;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.BackgroundNode;
import org.cybergarage.x3d.node.BindableNode;
import org.cybergarage.x3d.node.FogNode;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.GroupNode;
import org.cybergarage.x3d.node.InlineNode;
import org.cybergarage.x3d.node.NavigationInfoNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.PlaneSensorNode;
import org.cybergarage.x3d.node.SceneNode;
import org.cybergarage.x3d.node.ShapeNode;
import org.cybergarage.x3d.node.TouchSensorNode;
import org.cybergarage.x3d.node.TransformNode;
import org.cybergarage.x3d.node.ViewpointNode;
import org.cybergarage.x3d.parser.ParserResult;
import org.cybergarage.x3d.parser.autodesk.Parser3DS;
import org.cybergarage.x3d.parser.autodesk.ParserDXF;
import org.cybergarage.x3d.parser.autodesk.ParserDXFException;
import org.cybergarage.x3d.parser.sense8.NFFParser;
import org.cybergarage.x3d.parser.threedsystems.ParseException;
import org.cybergarage.x3d.parser.threedsystems.STLAsciiParser;
import org.cybergarage.x3d.parser.vrml97.VRML97Parser;
import org.cybergarage.x3d.parser.vrml97.VRML97Preprocessor;
import org.cybergarage.x3d.parser.wavefront.OBJParser;
import org.cybergarage.x3d.parser.wavefront.TokenMgrError;
import org.cybergarage.x3d.parser.x3d.X3DParser;
import org.cybergarage.x3d.route.Route;
import org.cybergarage.x3d.share.ShareObject;
import org.cybergarage.x3d.share.ShareWorld;
import org.cybergarage.x3d.share.ShareWorldClient;
import org.cybergarage.x3d.share.object.ShareNodeAdd;
import org.cybergarage.x3d.share.object.ShareNodeRemove;
import org.cybergarage.x3d.util.BoundingBox;
import org.cybergarage.x3d.util.Debug;

public class SceneGraph
extends Scene
implements Constants,
Runnable {
    public static final int USE_PREPROCESSOR = 1;
    public static final int NORMAL_GENERATION = 2;
    public static final int TEXTURE_GENERATION = 4;
    private boolean mIsSimulationRunning = false;
    private ParserResult parserResult = new ParserResult();
    public static final int FILE_FORMAT_NONE = 0;
    public static final int FILE_FORMAT_WRL = 1;
    public static final int FILE_FORMAT_OBJ = 2;
    public static final int FILE_FORMAT_3DS = 3;
    public static final int FILE_FORMAT_NFF = 4;
    public static final int FILE_FORMAT_LWO = 5;
    public static final int FILE_FORMAT_LWS = 6;
    public static final int FILE_FORMAT_STLA = 7;
    public static final int FILE_FORMAT_DXF = 8;
    public static final int FILE_FORMAT_X3D = 9;
    private Vector mBackgroundVector = new Vector();
    private Vector mFogVector = new Vector();
    private Vector mNavigationInfoVector = new Vector();
    private Vector mViewpointVector = new Vector();
    private BackgroundNode mDefaultBackgroundNode = new BackgroundNode();
    private FogNode mDefaultFogNode = new FogNode();
    private NavigationInfoNode mDefaultNavigationInfoNode = new NavigationInfoNode();
    private ViewpointNode mDefaultViewpointNode = new ViewpointNode();
    private SceneGraphObject mObject = null;
    private int mOption = 0;
    private float[] mBoundingBoxCenter = new float[3];
    private float[] mBoundingBoxSize = new float[3];
    private Thread mThreadObject = null;
    private URL mBaseURL = null;
    private int mRenderingMode = 1;
    private float[] mStartViewPosition = new float[3];
    private float[] mStartViewOrientation = new float[4];
    private static final int XZ_PLANE = 0;
    private static final int XY_PLANE = 1;
    private static final int YZ_PLANE = 2;
    private static final float VIEWPOS_OFFSET_SCALE = 3.0f;
    private ShareWorldClient mShareWolrdClient = null;

    public void initializeMember() {
        this.setHeaderFlag(false);
        this.setSceneGraph(this);
        this.setOption(0);
        this.setViewpointStartPosition(0.0f, 0.0f, 0.0f);
        this.setViewpointStartOrientation(0.0f, 0.0f, 1.0f, 0.0f);
    }

    public SceneGraph() {
        this.initializeMember();
    }

    public SceneGraph(int option) {
        this.initializeMember();
        this.setOption(option);
    }

    public SceneGraph(String filename) {
        this.initializeMember();
        this.load(filename);
    }

    public SceneGraph(File file) {
        this.initializeMember();
        this.load(file);
    }

    public void initialize() {
        this.stop();
        Debug.message("Node::initialize nodes .....");
        Node node = this.getNodes();
        while (node != null) {
            node.setSceneGraph(this);
            node.initialize();
            node = node.nextTraversal();
        }
        Debug.message("Node::initialize nodes ..... done");
        this.setBackgroundNode(this.findBackgroundNode(), true);
        this.setFogNode(this.findFogNode(), true);
        this.setNavigationInfoNode(this.findNavigationInfoNode(), true);
        this.setViewpointNode(this.findViewpointNode(), true);
        this.updateBoundingBox();
        Debug.message("Node::initialize object .....");
        this.initializeObject();
        Debug.message("Node::initialize object ..... done");
        node = this.getNodes();
        while (node != null) {
            if (node.isRunnable() && node.getRunnableType() == 1) {
                node.start();
            }
            node = node.nextTraversal();
        }
        this.start();
    }

    public void uninitialize() {
        this.stop();
        Node node = this.getNodes();
        while (node != null) {
            if (node.isRunnable() && node.getRunnableType() == 1) {
                node.stop();
            }
            node = node.nextTraversal();
        }
        node = this.getNodes();
        while (node != null) {
            node.uninitialize();
            node = node.nextTraversal();
        }
    }

    public void loadInlineNodeURLs() {
        InlineNode node = this.findInlineNode();
        while (node != null) {
            node.loadURL();
            node = (InlineNode)node.nextTraversalSameType();
        }
    }

    public void updateSimulation() {
        Node node = this.getNodes();
        while (node != null) {
            if (node.isTimeSensorNode()) {
                node.update();
            }
            node = node.nextTraversal();
        }
        this.updateObject();
    }

    public void updateRoute(Node eventOutNode, Field eventOutField) {
        if (eventOutNode == null || eventOutField == null) {
            return;
        }
        Route route = this.getRoutes();
        while (route != null) {
            if (route.getEventOutNode() == eventOutNode && route.getEventOutField() == eventOutField) {
                Node eventInNode = route.getEventInNode();
                Field eventInField = route.getEventInField();
                if (eventInNode != null && eventInField != null) {
                    route.update();
                    eventInNode.update();
                    this.updateRoute(eventInNode, eventInField);
                }
            }
            route = route.next();
        }
    }

    public void startSimulation() {
        if (!this.isSimulationRunning()) {
            Node node = this.getNodes();
            while (node != null) {
                if (node.isRunnable() && node.getRunnableType() != 1) {
                    node.start();
                }
                node = node.nextTraversal();
            }
            this.setSimulationRunningFlag(true);
        }
    }

    public void stopSimulation() {
        if (this.isSimulationRunning()) {
            Node node = this.getNodes();
            while (node != null) {
                if (node.isRunnable() && node.getRunnableType() != 1) {
                    node.stop();
                }
                node = node.nextTraversal();
            }
            this.setSimulationRunningFlag(false);
        }
    }

    public boolean isSimulationRunning() {
        return this.mIsSimulationRunning;
    }

    public void setSimulationRunningFlag(boolean flag) {
        this.mIsSimulationRunning = flag;
    }

    public URL toURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = String.valueOf(path) + "/";
        }
        return new URL("file", "", path);
    }

    public void moveSceneNodes(Scene scene) {
        Node node = scene.getNodes();
        if (node.isXMLNode()) {
            SceneNode sceneNode = scene.findSceneNode();
            node = sceneNode != null ? sceneNode.getChildNodes() : null;
        }
        while (node != null) {
            Node nextNode = node.next();
            this.moveNode(node);
            node.setSceneGraph(this);
            node = nextNode;
        }
    }

    public void moveSceneRoutes(Scene scene) {
        Route route = scene.getRoutes();
        while (route != null) {
            Route nextRoute = route.next();
            route.remove();
            this.addRoute(route);
            route = nextRoute;
        }
    }

    public void moveScene(Scene scene) {
        this.moveSceneNodes(scene);
        this.moveSceneRoutes(scene);
    }

    public boolean addVRML97(Reader reader) {
        this.stop();
        VRML97Parser parser = new VRML97Parser(reader);
        ParserResult parserResult = this.getParserResultObject();
        parser.setResult(parserResult);
        if (!parser.parse(reader)) {
            this.start();
            return false;
        }
        this.moveScene(parser);
        this.initialize();
        this.saveViewpointStartPositionAndOrientation();
        this.start();
        return true;
    }

    public boolean addVRML97(InputStream inputStream) {
        return this.addVRML97(new InputStreamReader(inputStream));
    }

    public boolean addVRML97(URL url) {
        this.setBaseURL(url.toString());
        Debug.message("SceneGraph::add = Loading a url file (" + url + ") ..... ");
        try {
            InputStream inputStream = url.openStream();
            this.addVRML97(inputStream);
        }
        catch (IOException ioe) {
            Debug.warning("Loading Error (IOException) = " + url);
            System.out.println(ioe.getMessage());
        }
        return this.isLoadingOK();
    }

    public boolean addVRML97(File file) {
        block11: {
            try {
                this.setBaseURL(this.toURL(file).toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            VRML97Preprocessor prepro = null;
            try {
                File inputFile = null;
                FileInputStream inputStream = null;
                boolean isPreprocessorOn = this.getOption(1);
                Debug.message("\tPreprocessor = " + isPreprocessorOn);
                if (isPreprocessorOn) {
                    prepro = new VRML97Preprocessor(file);
                    inputFile = new File(prepro.getTempFilename());
                    inputStream = new FileInputStream(inputFile);
                } else {
                    inputFile = file;
                    inputStream = new FileInputStream(file);
                }
                this.addVRML97(inputStream);
            }
            catch (MalformedURLException mue) {
                Debug.warning("Loading Error (MalformedURLException) = " + file);
                System.out.println(mue.getMessage());
                this.getOption(1);
                break block11;
            }
            catch (IOException ioe) {
                try {
                    Debug.warning("Loading Error (IOException) = " + file);
                    System.out.println(ioe.getMessage());
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.getOption(1);
                }
            }
            this.getOption(1);
        }
        return this.isLoadingOK();
    }

    public boolean addX3D(Reader reader) {
        this.stop();
        X3DParser parser = new X3DParser();
        ParserResult parserResult = this.getParserResultObject();
        parser.setResult(parserResult);
        if (!parser.parse(reader)) {
            this.start();
            return false;
        }
        this.moveScene(parser);
        this.initialize();
        this.saveViewpointStartPositionAndOrientation();
        this.start();
        return true;
    }

    public boolean addX3D(InputStream inputStream) {
        return this.addX3D(new InputStreamReader(inputStream));
    }

    public boolean addX3D(URL url) {
        this.setBaseURL(url.toString());
        Debug.message("SceneGraph::add = Loading a url file (" + url + ") ..... ");
        try {
            InputStream inputStream = url.openStream();
            this.addX3D(inputStream);
        }
        catch (IOException ioe) {
            Debug.warning("Loading Error (IOException) = " + url);
            System.out.println(ioe.getMessage());
        }
        return this.isLoadingOK();
    }

    public boolean addX3D(File file) {
        try {
            this.setBaseURL(this.toURL(file).toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            this.addX3D(inputStream);
        }
        catch (IOException ioe) {
            Debug.warning("Loading Error (IOException) = " + file);
            System.out.println(ioe.getMessage());
        }
        return this.isLoadingOK();
    }

    public boolean addOBJ(Reader reader) {
        this.stop();
        try {
            try {
                this.setLoadingResult(false);
                this.setParserErrorMessage("");
                Debug.message("\tReader = " + reader);
                Debug.message("\tStart parsering .....");
                OBJParser objParser = new OBJParser(reader);
                objParser.initialize();
                objParser.Input();
                ShapeNode shapeNode = objParser.getShapeNode();
                if (shapeNode != null) {
                    this.addNode(shapeNode);
                }
                this.initialize();
                reader.close();
                this.setLoadingResult(true);
            }
            catch (org.cybergarage.x3d.parser.wavefront.ParseException e) {
                Debug.warning("Loading Error (ParseException) = " + reader);
                System.out.println(e.getMessage());
                this.setParserErrorMessage(e.getMessage());
            }
            catch (TokenMgrError e) {
                Debug.warning("Loading Error (TokenMgrError) = " + reader);
                System.out.println(e.getMessage());
                this.setParserErrorMessage(e.getMessage());
            }
            catch (IOException e) {
                Debug.warning("Loading Error (IOException) = " + reader);
                System.out.println(e.getMessage());
                this.setParserErrorMessage(e.getMessage());
            }
            catch (Exception e) {
                Debug.warning("Loading Error (Exception) = " + reader);
                e.printStackTrace();
                this.setParserErrorMessage(e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        if (this.getLoadingResult()) {
            Debug.message("\tLoading is OK !!");
        } else {
            Debug.message("\tLoading is failed !!");
        }
        this.start();
        return this.isLoadingOK();
    }

    public boolean addOBJ(InputStream inputStream) {
        return this.addOBJ(new InputStreamReader(inputStream));
    }

    public boolean addOBJ(URL url) {
        Debug.message("SceneGraph::add = Loading a url file (" + url + ") ..... ");
        try {
            InputStream inputStream = url.openStream();
            this.addOBJ(inputStream);
        }
        catch (IOException ioe) {
            Debug.warning("Loading Error (IOException) = " + url);
            System.out.println(ioe.getMessage());
        }
        return this.isLoadingOK();
    }

    public boolean addOBJ(File file) {
        try {
            URL urlFile = this.toURL(file);
            this.addOBJ(urlFile);
        }
        catch (MalformedURLException mue) {
            Debug.warning("Loading Error (MalformedURLException) = " + file);
            System.out.println(mue.getMessage());
        }
        return this.isLoadingOK();
    }

    public boolean addNFF(Reader reader) {
        this.stop();
        try {
            try {
                this.setLoadingResult(false);
                this.setParserErrorMessage("");
                Debug.message("\tReader = " + reader);
                Debug.message("\tStart parsering .....");
                NFFParser nffParser = new NFFParser(reader);
                nffParser.initialize();
                nffParser.Input();
                ShapeNode shapeNode = nffParser.getShapeNode();
                if (shapeNode != null) {
                    TransformNode transNode = new TransformNode();
                    transNode.setRotation(1.0f, 0.0f, 0.0f, (float)Math.PI);
                    transNode.addChildNode(shapeNode);
                    this.addNode(transNode);
                }
                this.initialize();
                reader.close();
                this.setLoadingResult(true);
            }
            catch (org.cybergarage.x3d.parser.sense8.ParseException e) {
                Debug.warning("Loading Error (ParseException) = " + reader);
                System.out.println(e.getMessage());
                this.setParserErrorMessage(e.getMessage());
            }
            catch (org.cybergarage.x3d.parser.sense8.TokenMgrError e) {
                Debug.warning("Loading Error (TokenMgrError) = " + reader);
                System.out.println(e.getMessage());
                this.setParserErrorMessage(e.getMessage());
            }
            catch (IOException e) {
                Debug.warning("Loading Error (IOException) = " + reader);
                System.out.println(e.getMessage());
                this.setParserErrorMessage(e.getMessage());
            }
            catch (Exception e) {
                Debug.warning("Loading Error (Exception) = " + reader);
                e.printStackTrace();
                this.setParserErrorMessage(e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        if (this.getLoadingResult()) {
            Debug.message("\tLoading is OK !!");
        } else {
            Debug.message("\tLoading is failed !!");
        }
        this.start();
        return this.isLoadingOK();
    }

    public boolean addNFF(InputStream inputStream) {
        return this.addNFF(new InputStreamReader(inputStream));
    }

    public boolean addNFF(URL url) {
        Debug.message("SceneGraph::add = Loading a url file (" + url + ") ..... ");
        try {
            InputStream inputStream = url.openStream();
            this.addNFF(inputStream);
        }
        catch (IOException ioe) {
            Debug.warning("Loading Error (IOException) = " + url);
            System.out.println(ioe.getMessage());
        }
        return this.isLoadingOK();
    }

    public boolean addNFF(File file) {
        try {
            URL urlFile = this.toURL(file);
            this.addNFF(urlFile);
        }
        catch (MalformedURLException mue) {
            Debug.warning("Loading Error (MalformedURLException) = " + file);
            System.out.println(mue.getMessage());
        }
        return this.isLoadingOK();
    }

    public boolean add3DS(InputStream inputStream) {
        this.stop();
        Debug.message("\tReader = " + inputStream);
        Debug.message("\tStart parsering .....");
        this.setParserErrorMessage("");
        Parser3DS parser3DS = new Parser3DS();
        boolean isLodingOK = parser3DS.load(inputStream);
        this.setLoadingResult(isLodingOK);
        if (isLodingOK) {
            GroupNode gnode = parser3DS.getRootGroupNode();
            this.addNode(gnode);
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.initialize();
        this.start();
        return isLodingOK;
    }

    public boolean add3DS(URL url) {
        Debug.message("SceneGraph::add = Loading a url file (" + url + ") ..... ");
        try {
            InputStream inputStream = url.openStream();
            this.add3DS(inputStream);
        }
        catch (IOException ioe) {
            Debug.warning("Loading Error (IOException) = " + url);
            System.out.println(ioe.getMessage());
        }
        return this.isLoadingOK();
    }

    public boolean add3DS(File file) {
        try {
            URL urlFile = this.toURL(file);
            this.add3DS(urlFile);
        }
        catch (MalformedURLException mue) {
            Debug.warning("Loading Error (MalformedURLException) = " + file);
            System.out.println(mue.getMessage());
        }
        return this.isLoadingOK();
    }

    public boolean addDXF(Reader reader) {
        this.stop();
        try {
            try {
                this.setLoadingResult(false);
                this.setParserErrorMessage("");
                Debug.message("\tReader = " + reader);
                Debug.message("\tStart parsering .....");
                ParserDXF dxfParser = new ParserDXF();
                dxfParser.initialize();
                dxfParser.input(reader);
                reader.close();
                this.setLoadingResult(true);
                ShapeNode shapeNode = dxfParser.getShapeNodes();
                while (shapeNode != null) {
                    TransformNode transNode = new TransformNode();
                    transNode.addChildNode(shapeNode);
                    this.addNode(transNode);
                    shapeNode = dxfParser.getShapeNodes();
                }
                this.initialize();
            }
            catch (ParserDXFException e) {
                Debug.warning("Loading Error (IOException) = " + reader);
                System.out.println(e.getMessage());
                this.setParserErrorMessage(e.getMessage());
            }
            catch (IOException e) {
                Debug.warning("Loading Error (IOException) = " + reader);
                System.out.println(e.getMessage());
                this.setParserErrorMessage(e.getMessage());
            }
            catch (Exception e) {
                Debug.warning("Loading Error (Exception) = " + reader);
                e.printStackTrace();
                this.setParserErrorMessage(e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        if (this.getLoadingResult()) {
            Debug.message("\tLoading is OK !!");
        } else {
            Debug.message("\tLoading is failed !!");
        }
        this.start();
        return this.isLoadingOK();
    }

    public boolean addDXF(InputStream inputStream) {
        return this.addDXF(new InputStreamReader(inputStream));
    }

    public boolean addDXF(URL url) {
        Debug.message("SceneGraph::add = Loading a url file (" + url + ") ..... ");
        try {
            InputStream inputStream = url.openStream();
            this.addDXF(inputStream);
        }
        catch (IOException ioe) {
            Debug.warning("Loading Error (IOException) = " + url);
            System.out.println(ioe.getMessage());
        }
        return this.isLoadingOK();
    }

    public boolean addDXF(File file) {
        try {
            URL urlFile = this.toURL(file);
            this.addDXF(urlFile);
        }
        catch (MalformedURLException mue) {
            Debug.warning("Loading Error (MalformedURLException) = " + file);
            System.out.println(mue.getMessage());
        }
        return this.isLoadingOK();
    }

    public boolean addSTLAscii(Reader reader) {
        this.stop();
        try {
            try {
                this.setLoadingResult(false);
                this.setParserErrorMessage("");
                Debug.message("\tReader = " + reader);
                Debug.message("\tStart parsering .....");
                STLAsciiParser stlAsciiParser = new STLAsciiParser(reader);
                stlAsciiParser.initialize();
                stlAsciiParser.Input();
                reader.close();
                this.setLoadingResult(true);
                ShapeNode shapeNode = stlAsciiParser.getShapeNodes();
                while (shapeNode != null) {
                    TransformNode transNode = new TransformNode();
                    transNode.addChildNode(shapeNode);
                    this.addNode(transNode);
                    shapeNode = stlAsciiParser.getShapeNodes();
                }
                this.initialize();
            }
            catch (ParseException e) {
                Debug.warning("Loading Error (ParseException) = " + reader);
                System.out.println(e.getMessage());
                this.setParserErrorMessage(e.getMessage());
            }
            catch (org.cybergarage.x3d.parser.threedsystems.TokenMgrError e) {
                Debug.warning("Loading Error (TokenMgrError) = " + reader);
                System.out.println(e.getMessage());
                this.setParserErrorMessage(e.getMessage());
            }
            catch (IOException e) {
                Debug.warning("Loading Error (IOException) = " + reader);
                System.out.println(e.getMessage());
                this.setParserErrorMessage(e.getMessage());
            }
            catch (Exception e) {
                Debug.warning("Loading Error (Exception) = " + reader);
                e.printStackTrace();
                this.setParserErrorMessage(e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        if (this.getLoadingResult()) {
            Debug.message("\tLoading is OK !!");
        } else {
            Debug.message("\tLoading is failed !!");
        }
        this.start();
        return this.isLoadingOK();
    }

    public boolean addSTLAscii(InputStream inputStream) {
        return this.addSTLAscii(new InputStreamReader(inputStream));
    }

    public boolean addSTLAscii(URL url) {
        Debug.message("SceneGraph::add = Loading a url file (" + url + ") ..... ");
        try {
            InputStream inputStream = url.openStream();
            this.addSTLAscii(inputStream);
        }
        catch (IOException ioe) {
            Debug.warning("Loading Error (IOException) = " + url);
            System.out.println(ioe.getMessage());
        }
        return this.isLoadingOK();
    }

    public boolean addSTLAscii(File file) {
        try {
            URL urlFile = this.toURL(file);
            this.addSTLAscii(urlFile);
        }
        catch (MalformedURLException mue) {
            Debug.warning("Loading Error (MalformedURLException) = " + file);
            System.out.println(mue.getMessage());
        }
        return this.isLoadingOK();
    }

    private ParserResult getParserResultObject() {
        return this.parserResult;
    }

    private void setLoadingResult(boolean flag) {
        this.parserResult.setResult(flag);
    }

    public boolean getLoadingResult() {
        return this.parserResult.getResult();
    }

    public boolean isLoadingOK() {
        return this.parserResult.getResult();
    }

    public boolean getParserResult() {
        return this.parserResult.getResult();
    }

    public void setParserErrorMessage(String msg) {
        this.parserResult.setErrorMessage(msg);
    }

    public String getParserErrorMessage() {
        return this.parserResult.getErrorMessage();
    }

    public static int getFileFormat(String fileName) {
        if (fileName == null) {
            return 0;
        }
        int idx = fileName.lastIndexOf(46);
        if (idx < 0) {
            return 0;
        }
        String ext = new String(fileName.getBytes(), idx + 1, fileName.length() - (idx + 1));
        int formatType = 0;
        if (ext.equalsIgnoreCase("WRL")) {
            formatType = 1;
        }
        if (ext.equalsIgnoreCase("OBJ")) {
            formatType = 2;
        }
        if (ext.equalsIgnoreCase("3DS")) {
            formatType = 3;
        }
        if (ext.equalsIgnoreCase("NFF")) {
            formatType = 4;
        }
        if (ext.equalsIgnoreCase("LWO")) {
            formatType = 5;
        }
        if (ext.equalsIgnoreCase("LWS")) {
            formatType = 6;
        }
        if (ext.equalsIgnoreCase("SLP")) {
            formatType = 7;
        }
        if (ext.equalsIgnoreCase("STL")) {
            formatType = 7;
        }
        if (ext.equalsIgnoreCase("DXF")) {
            formatType = 8;
        }
        if (ext.equalsIgnoreCase("X3D")) {
            formatType = 9;
        }
        if (ext.equalsIgnoreCase("XML")) {
            formatType = 9;
        }
        Debug.message("File format = " + formatType);
        return formatType;
    }

    public boolean add(URL url) {
        switch (SceneGraph.getFileFormat(url.toString())) {
            case 1: {
                return this.addVRML97(url);
            }
            case 2: {
                return this.addOBJ(url);
            }
            case 3: {
                return this.add3DS(url);
            }
            case 4: {
                return this.addNFF(url);
            }
            case 7: {
                return this.addSTLAscii(url);
            }
            case 8: {
                return this.addDXF(url);
            }
            case 9: {
                return this.addX3D(url);
            }
        }
        return false;
    }

    public boolean add(File file) {
        switch (SceneGraph.getFileFormat(file.toString())) {
            case 1: {
                return this.addVRML97(file);
            }
            case 2: {
                return this.addOBJ(file);
            }
            case 3: {
                return this.add3DS(file);
            }
            case 4: {
                return this.addNFF(file);
            }
            case 7: {
                return this.addSTLAscii(file);
            }
            case 8: {
                return this.addDXF(file);
            }
            case 9: {
                return this.addX3D(file);
            }
        }
        return false;
    }

    public boolean add(String filename) {
        try {
            File file = new File(filename);
            if (file.exists()) {
                return this.add(file);
            }
            try {
                URL url = new URL(filename);
                return this.add(url);
            }
            catch (MalformedURLException mue) {
                Debug.message("File not found (" + filename + ")");
            }
        }
        catch (NullPointerException npe) {
            Debug.message("File not found (" + filename + ")");
        }
        return false;
    }

    public boolean load(String filename) {
        this.clear();
        return this.add(filename);
    }

    public boolean load(URL urlFilename) {
        this.clear();
        return this.add(urlFilename);
    }

    public boolean load(File file) {
        this.clear();
        return this.add(file);
    }

    public boolean save(OutputStream outputStream) {
        this.uninitialize();
        PrintWriter printStream = new PrintWriter(outputStream);
        printStream.println("#VRML V2.0 utf8");
        Node node = this.getNodes();
        while (node != null) {
            node.output(printStream, 0);
            node = node.next();
        }
        Route route = this.getRoutes();
        while (route != null) {
            route.output(printStream);
            route = route.next();
        }
        printStream.flush();
        if (!outputStream.equals(System.out)) {
            printStream.close();
        }
        this.initialize();
        return true;
    }

    public boolean save(File file) {
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            this.save(outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            Debug.warning("Couldn't open the file (" + file + ")");
            return false;
        }
        return true;
    }

    public boolean save(String filename) {
        try {
            FileOutputStream outputStream = new FileOutputStream(filename);
            this.save(outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            Debug.warning("Couldn't open the file (" + filename + ")");
            return false;
        }
        return true;
    }

    public boolean saveVRML(OutputStream outputStream) {
        return this.save(outputStream);
    }

    public boolean saveVRML(File file) {
        return this.save(file);
    }

    public boolean saveVRML(String filename) {
        return this.save(filename);
    }

    public boolean saveXML(OutputStream outputStream) {
        this.uninitialize();
        PrintWriter printStream = new PrintWriter(outputStream);
        printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printStream.println("<X3D>");
        printStream.println("\t<Scene>");
        Node node = this.getNodes();
        while (node != null) {
            node.outputXML(printStream, 2);
            node = node.next();
        }
        Route route = this.getRoutes();
        while (route != null) {
            route.outputXML(printStream, 2);
            route = route.next();
        }
        printStream.println("\t</Scene>");
        printStream.println("</X3D>");
        printStream.flush();
        if (!outputStream.equals(System.out)) {
            printStream.close();
        }
        this.initialize();
        return true;
    }

    public boolean saveXML(File file) {
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            this.saveXML(outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            Debug.warning("Couldn't open the file (" + file + ")");
            return false;
        }
        return true;
    }

    public boolean saveXML(String filename) {
        try {
            FileOutputStream outputStream = new FileOutputStream(filename);
            this.saveXML(outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            Debug.warning("Couldn't open the file (" + filename + ")");
            return false;
        }
        return true;
    }

    public void print() {
        this.save(System.out);
    }

    public void printXML() {
        this.saveXML(System.out);
    }

    public void clear() {
        this.clearNodes();
    }

    public BindableNode bindableGetTopNode(Vector vector) {
        BindableNode topNode;
        try {
            topNode = (BindableNode)vector.lastElement();
        }
        catch (NoSuchElementException e) {
            topNode = null;
        }
        return topNode;
    }

    public void setBindableNode(Vector nodeVector, BindableNode node, boolean bind) {
        if (node == null) {
            return;
        }
        BindableNode topNode = this.bindableGetTopNode(nodeVector);
        if (bind) {
            if (topNode != node) {
                if (topNode != null) {
                    topNode.setIsBound(false);
                    topNode.sendEvent(topNode.getIsBoundField());
                }
                nodeVector.removeElement(node);
                nodeVector.addElement(node);
                node.setIsBound(true);
                node.sendEvent(node.getIsBoundField());
            }
        } else if (topNode == node) {
            node.setIsBound(false);
            node.sendEvent(node.getIsBoundField());
            nodeVector.removeElement(node);
            BindableNode newTopNode = this.bindableGetTopNode(nodeVector);
            if (newTopNode != null) {
                newTopNode.setIsBound(true);
                newTopNode.sendEvent(newTopNode.getIsBoundField());
            }
        } else {
            nodeVector.removeElement(node);
        }
    }

    public void setBindableNode(BindableNode node, boolean bind) {
        if (node.isBackgroundNode()) {
            this.setBackgroundNode((BackgroundNode)node, bind);
        }
        if (node.isFogNode()) {
            this.setFogNode((FogNode)node, bind);
        }
        if (node.isNavigationInfoNode()) {
            this.setNavigationInfoNode((NavigationInfoNode)node, bind);
        }
        if (node.isViewpointNode()) {
            this.setViewpointNode((ViewpointNode)node, bind);
        }
    }

    public void setBackgroundNode(BackgroundNode bg, boolean bind) {
        this.setBindableNode(this.mBackgroundVector, bg, bind);
    }

    public void setFogNode(FogNode fog, boolean bind) {
        this.setBindableNode(this.mFogVector, fog, bind);
    }

    public void setNavigationInfoNode(NavigationInfoNode navInfo, boolean bind) {
        this.setBindableNode(this.mNavigationInfoVector, navInfo, bind);
    }

    public void setViewpointNode(ViewpointNode view, boolean bind) {
        this.setBindableNode(this.mViewpointVector, view, bind);
    }

    public BackgroundNode getBackgroundNode() {
        return (BackgroundNode)this.bindableGetTopNode(this.mBackgroundVector);
    }

    public FogNode getFogNode() {
        return (FogNode)this.bindableGetTopNode(this.mFogVector);
    }

    public NavigationInfoNode getNavigationInfoNode() {
        return (NavigationInfoNode)this.bindableGetTopNode(this.mNavigationInfoVector);
    }

    public ViewpointNode getViewpointNode() {
        return (ViewpointNode)this.bindableGetTopNode(this.mViewpointVector);
    }

    public BackgroundNode getDefaultBackgroundNode() {
        return this.mDefaultBackgroundNode;
    }

    public FogNode getDefaultFogNode() {
        return this.mDefaultFogNode;
    }

    public NavigationInfoNode getDefaultNavigationInfoNode() {
        return this.mDefaultNavigationInfoNode;
    }

    public ViewpointNode getDefaultViewpointNode() {
        return this.mDefaultViewpointNode;
    }

    public void setObject(SceneGraphObject object) {
        this.mObject = object;
    }

    public SceneGraphObject getObject() {
        return this.mObject;
    }

    public boolean hasObject() {
        return this.mObject != null;
    }

    public boolean initializeObject() {
        if (this.hasObject()) {
            return this.mObject.initialize(this);
        }
        return false;
    }

    public boolean uninitializeObject() {
        if (this.hasObject()) {
            return this.mObject.uninitialize(this);
        }
        return false;
    }

    public boolean addNodeObject(Node node) {
        if (this.hasObject()) {
            return this.mObject.addNode(this, node);
        }
        return false;
    }

    public boolean removeNodeObject(Node node) {
        if (this.hasObject()) {
            return this.mObject.removeNode(this, node);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateObject() {
        if (this.hasObject()) {
            boolean ret;
            SceneGraphObject sceneGraphObject = this.mObject;
            synchronized (sceneGraphObject) {
                ret = this.mObject.update(this);
            }
            return ret;
        }
        return false;
    }

    public boolean removeObject() {
        if (this.hasObject()) {
            return this.mObject.remove(this);
        }
        return false;
    }

    public NodeObject createNodeObject(Node node) {
        if (!this.hasObject()) {
            return null;
        }
        return this.getObject().createNodeObject(this, node);
    }

    public void setOption(int option) {
        this.mOption = option;
    }

    public int getOption() {
        return this.mOption;
    }

    public boolean getOption(int option) {
        return (this.mOption & option) == option;
    }

    @Override
    public void setBoundingBoxCenter(float[] center) {
        int n = 0;
        while (n < 3) {
            this.mBoundingBoxCenter[n] = center[n];
            ++n;
        }
    }

    @Override
    public void setBoundingBoxCenter(float x, float y, float z) {
        this.mBoundingBoxCenter[0] = x;
        this.mBoundingBoxCenter[1] = y;
        this.mBoundingBoxCenter[2] = z;
    }

    @Override
    public void getBoundingBoxCenter(float[] center) {
        int n = 0;
        while (n < 3) {
            center[n] = this.mBoundingBoxCenter[n];
            ++n;
        }
    }

    @Override
    public float[] getBoundingBoxCenter() {
        float[] center = new float[3];
        this.getBoundingBoxCenter(center);
        return center;
    }

    @Override
    public void setBoundingBoxSize(float[] size) {
        int n = 0;
        while (n < 3) {
            this.mBoundingBoxSize[n] = size[n];
            ++n;
        }
    }

    @Override
    public void setBoundingBoxSize(float x, float y, float z) {
        this.mBoundingBoxSize[0] = x;
        this.mBoundingBoxSize[1] = y;
        this.mBoundingBoxSize[2] = z;
    }

    @Override
    public void getBoundingBoxSize(float[] size) {
        int n = 0;
        while (n < 3) {
            size[n] = this.mBoundingBoxSize[n];
            ++n;
        }
    }

    @Override
    public float[] getBoundingBoxSize() {
        float[] size = new float[3];
        this.getBoundingBoxSize(size);
        return size;
    }

    @Override
    public void updateBoundingBox(Node node, BoundingBox bbox) {
        if (node.isGeometry3DNode()) {
            Geometry3DNode gnode = (Geometry3DNode)node;
            float[] bboxCenter = new float[3];
            float[] bboxSize = new float[3];
            float[] point = new float[3];
            gnode.getBoundingBoxCenter(bboxCenter);
            gnode.getBoundingBoxSize(bboxSize);
            if (bboxSize[0] >= 0.0f && bboxSize[1] >= 0.0f && bboxSize[2] >= 0.0f) {
                SFMatrix nodemx = node.getTransformMatrix();
                int n = 0;
                while (n < 8) {
                    point[0] = n < 4 ? bboxCenter[0] - bboxSize[0] : bboxCenter[0] + bboxSize[0];
                    point[1] = n % 2 != 0 ? bboxCenter[1] - bboxSize[1] : bboxCenter[1] + bboxSize[1];
                    point[2] = n % 4 < 2 ? bboxCenter[2] - bboxSize[2] : bboxCenter[2] + bboxSize[2];
                    nodemx.multi(point);
                    bbox.addPoint(point);
                    ++n;
                }
            }
        }
        Node cnode = node.getChildNodes();
        while (cnode != null) {
            this.updateBoundingBox(cnode, bbox);
            cnode = cnode.next();
        }
    }

    @Override
    public void updateBoundingBox() {
        BoundingBox bbox = new BoundingBox();
        Node node = this.getNodes();
        while (node != null) {
            this.updateBoundingBox(node, bbox);
            node = node.next();
        }
        this.setBoundingBoxCenter(bbox.getCenter());
        this.setBoundingBoxSize(bbox.getSize());
    }

    @Override
    public float getRadius() {
        SFVec3f bboxSize = new SFVec3f(this.getBoundingBoxSize());
        return bboxSize.getScalar();
    }

    public void setThreadObject(Thread obj) {
        this.mThreadObject = obj;
    }

    public Thread getThreadObject() {
        return this.mThreadObject;
    }

    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        while (thisThread == this.getThreadObject()) {
            this.updateSimulation();
            Thread threadObject = this.getThreadObject();
            if (threadObject == null) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void start() {
        Thread threadObject = this.getThreadObject();
        if (threadObject == null) {
            threadObject = new Thread(this);
            this.setThreadObject(threadObject);
            threadObject.start();
        }
    }

    public void stop() {
        Thread threadObject = this.getThreadObject();
        if (threadObject != null) {
            this.setThreadObject(null);
        }
    }

    public void setBaseURL(URL url) {
        this.mBaseURL = url;
    }

    public void setBaseURL(String urlString) {
        int index = urlString.lastIndexOf(47);
        if (index >= 0) {
            try {
                URL baseURL = new URL(new String(urlString.getBytes(), 0, index + 1));
                this.setBaseURL(baseURL);
            }
            catch (MalformedURLException mue) {
                this.setBaseURL((URL)null);
            }
        } else {
            this.setBaseURL((URL)null);
        }
    }

    public URL getBaseURL() {
        return this.mBaseURL;
    }

    public boolean setRenderingMode(int mode) {
        this.mRenderingMode = mode;
        if (!this.hasObject()) {
            return false;
        }
        return this.mObject.setRenderingMode(this, mode);
    }

    public int getRenderingMode() {
        return this.mRenderingMode;
    }

    public void setHeadlightState(boolean state) {
        NavigationInfoNode navInfo = this.getNavigationInfoNode();
        if (navInfo == null) {
            navInfo = this.getDefaultNavigationInfoNode();
        }
        navInfo.setHeadlight(state);
    }

    public boolean isHeadlightOn() {
        NavigationInfoNode navInfo = this.getNavigationInfoNode();
        if (navInfo == null) {
            navInfo = this.getDefaultNavigationInfoNode();
        }
        return navInfo.getHeadlight();
    }

    public void setNavigationSpeed(float speed) {
        NavigationInfoNode navInfo = this.getNavigationInfoNode();
        if (navInfo == null) {
            navInfo = this.getDefaultNavigationInfoNode();
        }
        navInfo.setSpeed(speed);
    }

    public float getNavigationSpeed() {
        NavigationInfoNode navInfo = this.getNavigationInfoNode();
        if (navInfo == null) {
            navInfo = this.getDefaultNavigationInfoNode();
        }
        return navInfo.getSpeed();
    }

    public double getCurrentTime() {
        Date date = new Date();
        return (double)date.getTime() / 1000.0;
    }

    public void shapePressed(ShapeNode shapeNode, int mx, int my) {
        Node node = this.getNodes();
        while (node != null) {
            PlaneSensorNode planeSensor;
            SFBool isActive;
            Node parentNode;
            if (node.isTouchSensorNode()) {
                Debug.message(node + " is active !!");
                TouchSensorNode touchSensor = (TouchSensorNode)node;
                parentNode = touchSensor.getParentNode();
                if (shapeNode.isAncestorNode(parentNode)) {
                    isActive = touchSensor.getIsActiveField();
                    isActive.setValue(true);
                    touchSensor.sendEvent(isActive);
                    SFTime touchTime = touchSensor.getTouchTimeField();
                    touchTime.setValue(this.getCurrentTime());
                    touchSensor.sendEvent(touchTime);
                }
            } else if (node.isPlaneSensorNode() && shapeNode.isAncestorNode(parentNode = (planeSensor = (PlaneSensorNode)node).getParentNode())) {
                Debug.message(node + " is active !!");
                isActive = planeSensor.getIsActiveField();
                isActive.setValue(true);
                planeSensor.sendEvent(isActive);
            }
            node = node.nextTraversal();
        }
    }

    public void shapeReleased(ShapeNode shapeNode, int mx, int my) {
        Node node = this.getNodes();
        while (node != null) {
            PlaneSensorNode planeSensor;
            SFBool isActive;
            Node parentNode;
            if (node.isTouchSensorNode()) {
                Debug.message(node + " is inactive !!");
                TouchSensorNode touchSensor = (TouchSensorNode)node;
                parentNode = touchSensor.getParentNode();
                if (shapeNode.isAncestorNode(parentNode)) {
                    isActive = touchSensor.getIsActiveField();
                    isActive.setValue(false);
                    touchSensor.sendEvent(isActive);
                }
            } else if (node.isPlaneSensorNode() && shapeNode.isAncestorNode(parentNode = (planeSensor = (PlaneSensorNode)node).getParentNode())) {
                Debug.message(node + " is inactive !!");
                isActive = planeSensor.getIsActiveField();
                isActive.setValue(false);
                planeSensor.sendEvent(isActive);
            }
            node = node.nextTraversal();
        }
    }

    public void shapeDragged(ShapeNode shapeNode, int mx, int my) {
    }

    public void setViewpointStartPosition(float[] pos) {
        this.mStartViewPosition[0] = pos[0];
        this.mStartViewPosition[1] = pos[1];
        this.mStartViewPosition[2] = pos[2];
    }

    public void setViewpointStartPosition(float x, float y, float z) {
        this.mStartViewPosition[0] = x;
        this.mStartViewPosition[1] = y;
        this.mStartViewPosition[2] = z;
    }

    public void getViewpointStartPosition(float[] pos) {
        pos[0] = this.mStartViewPosition[0];
        pos[1] = this.mStartViewPosition[1];
        pos[2] = this.mStartViewPosition[2];
    }

    public void setViewpointStartOrientation(float x, float y, float z, float angle) {
        this.mStartViewOrientation[0] = x;
        this.mStartViewOrientation[1] = y;
        this.mStartViewOrientation[2] = z;
        this.mStartViewOrientation[3] = angle;
    }

    public void setViewpointStartOrientation(float[] ori) {
        this.mStartViewOrientation[0] = ori[0];
        this.mStartViewOrientation[1] = ori[1];
        this.mStartViewOrientation[2] = ori[2];
        this.mStartViewOrientation[3] = ori[3];
    }

    public void getViewpointStartOrientation(float[] ori) {
        ori[0] = this.mStartViewOrientation[0];
        ori[1] = this.mStartViewOrientation[1];
        ori[2] = this.mStartViewOrientation[2];
        ori[3] = this.mStartViewOrientation[3];
    }

    public void saveViewpointStartPositionAndOrientation() {
        ViewpointNode view = this.getViewpointNode();
        Debug.message("Start Viewpoint = " + view);
        if (view != null) {
            float[] viewPos = new float[3];
            float[] viewOri = new float[4];
            view.getPosition(viewPos);
            view.getOrientation(viewOri);
            Debug.message("\tPosition    = " + viewPos[0] + ", " + viewPos[1] + ", " + viewPos[2]);
            Debug.message("\tOrientation = " + viewOri[0] + ", " + viewOri[1] + ", " + viewOri[2] + ", " + viewOri[3]);
            this.setViewpointStartPosition(viewPos);
            this.setViewpointStartOrientation(viewOri);
        }
    }

    private void resetViewpointAlongXAxis(float[] bboxCenter, float[] bboxSize, ViewpointNode view, float fov) {
        float offset1 = bboxSize[1] / (float)Math.tan(fov);
        float offset2 = bboxSize[2] / (float)Math.tan(fov);
        float offset = Math.max(Math.max(offset1, offset2), bboxSize[0]) * 3.0f;
        view.setPosition(bboxCenter[0] + offset, bboxCenter[1], bboxCenter[2]);
        view.setOrientation(0.0f, 1.0f, 0.0f, 1.5707964f);
    }

    private void resetViewpointAlongYAxis(float[] bboxCenter, float[] bboxSize, ViewpointNode view, float fov) {
        float offset1 = bboxSize[0] / (float)Math.tan(fov);
        float offset2 = bboxSize[2] / (float)Math.tan(fov);
        float offset = Math.max(Math.max(offset1, offset2), bboxSize[1]) * 3.0f;
        view.setPosition(bboxCenter[0], bboxCenter[1] + offset, bboxCenter[2]);
        view.setOrientation(1.0f, 0.0f, 0.0f, -1.5707964f);
    }

    private void resetViewpointAlongZAxis(float[] bboxCenter, float[] bboxSize, ViewpointNode view, float fov) {
        float offset1 = bboxSize[0] / (float)Math.tan(fov);
        float offset2 = bboxSize[1] / (float)Math.tan(fov);
        float offset = Math.max(Math.max(offset1, offset2), bboxSize[2]) * 3.0f;
        view.setPosition(bboxCenter[0], bboxCenter[1], bboxCenter[2] + offset);
        view.setOrientation(0.0f, 0.0f, 1.0f, 0.0f);
    }

    public void resetViewpoint() {
        float[] viewPos = new float[3];
        float[] viewOri = new float[4];
        this.getViewpointStartPosition(viewPos);
        this.getViewpointStartOrientation(viewOri);
        ViewpointNode view = this.getViewpointNode();
        if (view == null) {
            view = this.getDefaultViewpointNode();
        }
        Debug.message("Reset Viewpoint = " + view);
        Debug.message("\tPosition    = " + viewPos[0] + ", " + viewPos[1] + ", " + viewPos[2]);
        Debug.message("\tOrientation = " + viewOri[0] + ", " + viewOri[1] + ", " + viewOri[2] + ", " + viewOri[3]);
        view.setPosition(viewPos);
        view.setOrientation(viewOri);
    }

    public void resetViewpoint(int plane) {
        ViewpointNode view = this.getViewpointNode();
        if (view == null) {
            view = this.getDefaultViewpointNode();
        }
        this.updateBoundingBox();
        float[] bboxCenter = this.getBoundingBoxCenter();
        float[] bboxSize = this.getBoundingBoxSize();
        float fov = view.getFieldOfView();
        Debug.message("Reset Viewpoint bboxCenter = " + bboxCenter[0] + ", " + bboxCenter[1] + ", " + bboxCenter[2]);
        Debug.message("                bboxSize   = " + bboxSize[0] + ", " + bboxSize[1] + ", " + bboxSize[2]);
        Debug.message("                fov        = " + fov);
        switch (plane) {
            case 1: {
                this.resetViewpointAlongZAxis(bboxCenter, bboxSize, view, fov);
                break;
            }
            case 0: {
                this.resetViewpointAlongYAxis(bboxCenter, bboxSize, view, fov);
                break;
            }
            case 2: {
                this.resetViewpointAlongXAxis(bboxCenter, bboxSize, view, fov);
            }
        }
    }

    public void resetViewpointAlongXAxis() {
        this.resetViewpoint(2);
    }

    public void resetViewpointAlongYAxis() {
        this.resetViewpoint(0);
    }

    public void resetViewpointAlongZAxis() {
        this.resetViewpoint(1);
    }

    private void setShareWorldClient(ShareWorldClient client) {
        this.mShareWolrdClient = client;
    }

    public ShareWorldClient getShareWorldClient() {
        return this.mShareWolrdClient;
    }

    public boolean connectShareWorld(String hostName, int port) {
        ShareWorldClient client = new ShareWorldClient(hostName, port);
        if (!client.isConnected()) {
            this.setShareWorldClient(null);
            return false;
        }
        client.setSceneGraph(this);
        this.setShareWorldClient(client);
        client.executeThread();
        return true;
    }

    public boolean connectShareWorld(String hostName) {
        return this.connectShareWorld(hostName, ShareWorld.getDefaultSeverSocketPort());
    }

    public boolean isConnectedShareWorld() {
        return this.mShareWolrdClient != null;
    }

    public void postShareObject(ShareObject shareObject) {
        if (!this.isConnectedShareWorld()) {
            return;
        }
        this.getShareWorldClient().postShreObject(shareObject);
    }

    public boolean postShareNodeRemoveEvent(Node node) {
        if (!node.hasName()) {
            return false;
        }
        ShareNodeRemove removeNodeEvent = new ShareNodeRemove(node);
        this.postShareObject(removeNodeEvent);
        return true;
    }

    public boolean postShareNodeAddEvent(Node node) {
        Debug.message("postShareNodeAddEvent");
        Node parentNode = node.getParentNode();
        Debug.message("  parentNode = " + parentNode);
        Debug.message("  node = " + node);
        ShareNodeAdd addNodeEvent = new ShareNodeAdd(node);
        this.postShareObject(addNodeEvent);
        return true;
    }
}

