/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.terminal;

import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.ssh.SshClient;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.terminal.TermPanel;
import ciss.phase_viewer.ssh.terminal.TerminalListener;
import ciss.phase_viewer.ssh.terminal.TerminalMenuBar;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.apache.log4j.Logger;

public class Terminal
extends InternalFrameChase
implements SshClient {
    private static Logger logger = Logger.getLogger((String)Terminal.class.getName());
    private HostInfo hostinfo;
    private TermPanel termpanel;
    private int origw;
    private int origh;
    private String initCommand;

    public Terminal() {
        super("ssh client", false, true, false, true, new Dimension(600, 400));
        this.init();
    }

    public Terminal(HostInfo hostinfo) {
        super("ssh client", false, true, false, true, new Dimension(600, 400));
        this.hostinfo = hostinfo;
        this.init();
        if (hostinfo != null) {
            this.connect(hostinfo);
        }
    }

    public Terminal(HostInfo hostinfo, String initCommand) {
        super("ssh client", false, true, false, true, new Dimension(600, 400));
        this.hostinfo = hostinfo;
        this.initCommand = initCommand;
        this.init();
        if (hostinfo != null) {
            this.connect(hostinfo);
        }
    }

    private void init() {
        this.origw = this.getSize().width;
        this.origh = this.getSize().height;
        JPanel p = this.createPanelAndButtons();
        this.getContentPane().add(p);
        this.addComponentListener(new TerminalListener(this));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                Terminal.this.disconnect();
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
            }
        });
        super.setJMenuBar(new TerminalMenuBar(this));
        this.pack();
    }

    protected void resized() {
        double wnow = this.getSize().width;
        double hnow = this.getSize().height;
        double wscale = wnow / (double)this.origw;
        double hscale = hnow / (double)this.origh;
        this.termpanel.parentResized(wscale, hscale);
    }

    @Override
    public void setHostInfo(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
    }

    @Override
    public void connect(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
        logger.debug((Object)"connecting ...");
        if (hostinfo != null) {
            this.termpanel.connect(hostinfo);
        }
    }

    @Override
    public void disconnect() {
        if (this.termpanel != null) {
            this.termpanel.disconnect();
        }
        this.termpanel = null;
    }

    @Override
    public HostInfo getHostInfo() {
        return this.hostinfo;
    }

    private JPanel createPanelAndButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.termpanel = new TermPanel(this.initCommand, this);
        JScrollPane pane = new JScrollPane(this.termpanel);
        p.add(pane);
        p.add(this.createButtons());
        return p;
    }

    private JPanel createButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton close = new JButton("close");
        p.add(close);
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Terminal.this.dispose();
            }
        });
        return p;
    }
}

