/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.sftp;

import ciss.phase_viewer.mainpanel.ChaseProgressMonitor;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.mainpanel.ProgressInfo;
import ciss.phase_viewer.settings.PropertiesManager;
import com.jcraft.jsch.SftpProgressMonitor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class MyProgressMonitor
extends InternalFrameChase
implements SftpProgressMonitor,
ActionListener,
ProgressInfo {
    private static Logger logger = Logger.getLogger((String)MyProgressMonitor.class.getName());
    private JProgressBar progress;
    private long count = 0L;
    private long max = 0L;
    private JPanel p;
    private boolean isCanceled = false;
    private TitledBorder title = new TitledBorder("transfering file ...");
    private String src;
    private Timer timer;
    private int time = 1000;
    private String name;
    private boolean isDone = false;

    public MyProgressMonitor(String name) {
        super("progress", true, true, true, true, new Dimension(500, 110), false);
        this.name = name;
        String time_ = PropertiesManager.getGlobalProperties(0).getProperty("sftp_progmon_delay");
        if (time_ != null) {
            try {
                this.time = Integer.parseInt(time_);
            }
            catch (NumberFormatException nfe) {
                this.time = 1000;
            }
        }
        ChaseProgressMonitor monitor = ChaseProgressMonitor.getMonitor();
        monitor.setProgress(this);
    }

    public void init(int op, String src, String dest, long max) {
        this.timer = new Timer(this.time, this);
        this.timer.start();
        this.max = max;
        this.src = src;
        String mode = "getting file: ";
        if (op == 0) {
            mode = "putting file: ";
        }
        mode = String.valueOf(mode) + src;
        this.setTitle(mode);
        this.progress = new JProgressBar(0, (int)max);
        this.progress.setValue(0);
        this.progress.setStringPainted(true);
        JButton cancel = new JButton("cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyProgressMonitor.this.isCanceled = true;
            }
        });
        this.p = new JPanel();
        this.p.setLayout(new BoxLayout(this.p, 1));
        this.progress.setBorder(this.title);
        this.p.add(this.progress);
        JPanel pbtn = new JPanel();
        pbtn.add(cancel);
        this.p.add(pbtn);
        this.getContentPane().add(this.p);
        this.count = 0L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)"long transfer");
        this.setVisible(true);
        this.timer.stop();
    }

    public boolean count(long count) {
        this.count += count;
        this.progress.setValue((int)this.count);
        this.title.setTitle("Completed " + this.count + " out of " + this.max + ".");
        if (count == this.max || this.isCanceled) {
            this.isDone = true;
        }
        return !this.isCanceled;
    }

    public void end() {
        this.isDone = true;
        this.dispose();
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public int getLength() {
        return (int)this.max;
    }

    @Override
    public String getCurrentMessage() {
        return null;
    }

    @Override
    public int getCurrent() {
        return (int)this.count;
    }

    @Override
    public String getNameOfProgress() {
        return this.name;
    }

    @Override
    public void done() {
    }
}

