/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.remotehostexecuter;

import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.sftp.Sftp;
import ciss.phase_viewer.ssh.sftp.SftpEvent;
import ciss.phase_viewer.ssh.sftp.SftpListener;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BatchFileTransferer
implements SftpListener,
Serializable {
    private static Logger logger = Logger.getLogger((String)BatchFileTransferer.class.getName());
    private HostInfo hostinfo;
    private String targetdir;
    private String localdir;
    private Sftp sftp;
    private ChannelSftp c;
    private Vector regfiles = new Vector();
    private Vector listeners = new Vector();
    private ProjectInfo projectInfo;
    private ChaseFile[] chaseFiles;

    public BatchFileTransferer(ProjectInfo projectInfo, HostInfo hostinfo) {
        this.localdir = projectInfo.getProjectDirectory();
        this.projectInfo = projectInfo;
        this.hostinfo = hostinfo;
        this.init();
    }

    public void disconnect() {
        if (this.sftp != null) {
            this.sftp.disconnect();
        }
    }

    public void registerFiles(String path) {
        this.regfiles.add(path);
    }

    @Override
    public void uploadFinished(SftpEvent se) {
        logger.info((Object)"finished upload.");
        int i = 0;
        while (i < this.listeners.size()) {
            ((SftpListener)this.listeners.elementAt(i)).uploadFinished(se);
            ++i;
        }
        this.sftp.disconnect();
    }

    @Override
    public void downloadFinished(SftpEvent se) {
        logger.info((Object)"finished download.");
        this.sftp.disconnect();
    }

    public void addSftpListener(SftpListener list) {
        this.listeners.addElement(list);
    }

    private void init() {
        logger.debug((Object)"initializing....");
        this.targetdir = this.projectInfo.getTargetDirectory();
        ChaseFileManager cfmanager = this.projectInfo.getChaseFileManager();
        if (cfmanager == null) {
            logger.error((Object)"invalid ChaseFileManager.");
            return;
        }
        this.chaseFiles = cfmanager.getFiles();
        logger.debug((Object)"initialization finished...");
    }

    public String getTargetDir() {
        return this.targetdir;
    }

    public Session getSession() {
        if (this.sftp != null) {
            return this.sftp.getSession();
        }
        return null;
    }

    public boolean upload(File file) {
        RemoteFile[] rfs = new RemoteFile[]{new RemoteFile(file.getAbsolutePath())};
        this.sftp = new Sftp(this.hostinfo);
        this.sftp.addSftpListener(this);
        this.sftp.connect();
        this.c = this.sftp.getChannelSftp();
        this.sftp.upload(rfs, new RemoteFile(this.targetdir, this.c), this.projectInfo.getProjectDirectory());
        return true;
    }

    public boolean upload() {
        logger.debug((Object)("uploading .... host: " + this.hostinfo.getName()));
        if (this.hostinfo == null) {
            logger.error((Object)"invalid hostinfo.");
            return false;
        }
        if (this.targetdir == null || this.targetdir.trim().length() == 0) {
            this.targetdir = "";
        }
        if (this.targetdir.startsWith("$HOME/")) {
            this.targetdir = this.targetdir.substring(6, this.targetdir.length());
        }
        logger.debug((Object)("uploading file to " + this.hostinfo.getName() + ", target dir: " + this.targetdir));
        RemoteFile[] rfs = this.chaseFile2RemoteFile("upload");
        if (rfs == null) {
            logger.debug((Object)"found no valid files...");
            return false;
        }
        int i = 0;
        while (i < rfs.length) {
            logger.debug((Object)("file no. " + i + ": " + rfs[i].toString()));
            ++i;
        }
        this.sftp.upload(rfs, new RemoteFile(this.targetdir, this.c), this.projectInfo.getProjectDirectory());
        return true;
    }

    public boolean download() {
        if (this.hostinfo == null) {
            return false;
        }
        if (this.targetdir == null || this.targetdir.trim().length() == 0) {
            this.targetdir = "";
        }
        if (this.targetdir.startsWith("$HOME/")) {
            this.targetdir = this.targetdir.substring(6, this.targetdir.length());
        }
        logger.debug((Object)("downloading file to " + this.hostinfo.getName() + ", target dir: " + this.targetdir));
        RemoteFile[] rfs = this.chaseFile2RemoteFile("download");
        if (rfs == null) {
            return false;
        }
        this.sftp.download(rfs, new RemoteFile(this.projectInfo.getProjectDirectory()), false);
        return true;
    }

    private String replaceHOME(String dir) {
        if (dir.startsWith("$HOME/")) {
            return dir.substring(6, dir.length());
        }
        return dir;
    }

    private RemoteFile[] chaseFile2RemoteFile(String mode) {
        if (this.chaseFiles == null) {
            logger.debug((Object)"invalid chaseFiles");
            return null;
        }
        int numfiles = this.chaseFiles.length;
        logger.debug((Object)("at chaseFile2RemoteFile, mode: " + mode + ", num. files: " + numfiles));
        this.sftp = new Sftp(this.hostinfo);
        this.sftp.addSftpListener(this);
        this.sftp.connect();
        this.c = this.sftp.getChannelSftp();
        if (this.c == null) {
            return null;
        }
        Vector filevector = new Vector();
        ChannelSftp ctmp = null;
        if (mode.equals("download")) {
            ctmp = this.c;
        }
        Vector<RemoteFile> remfiles = new Vector<RemoteFile>();
        int i = 0;
        while (i < numfiles) {
            ChaseFile file = this.chaseFiles[i];
            logger.debug((Object)("processing file: " + file));
            if (file.upload_or_download(mode)) {
                if (file == null) {
                    logger.error((Object)"element is null!");
                    return null;
                }
                String directory = "";
                String filesep = System.getProperty("file.separator");
                if (mode.equals("upload")) {
                    directory = this.replaceHOME(this.projectInfo.getProjectDirectory());
                    if (!directory.endsWith(System.getProperty("file.separator"))) {
                        directory = String.valueOf(directory) + System.getProperty("file.separator");
                    }
                } else if (mode.equals("download")) {
                    filesep = "/";
                    directory = this.replaceHOME(this.projectInfo.getTargetDirectory());
                    if (!directory.endsWith(filesep)) {
                        directory = String.valueOf(directory) + filesep;
                    }
                }
                String transfer = file.getTransfer();
                Vector fnamevec = new Vector();
                logger.debug((Object)("directory, transfer: " + directory + ", " + transfer));
                if (!file.getDefaultName().hasRegExp()) {
                    fnamevec.add(file.getFileName());
                } else if (transfer.equals(ChaseFile.ALL)) {
                    String rname = file.getDefaultName().getValue();
                    fnamevec = this.getFileNamesFromRegExpEntry(directory, rname, ctmp);
                } else {
                    String rname = file.getDefaultName().getValue();
                    String foo = this.getFileNameFromRegExpEntry(directory, rname, ctmp);
                    fnamevec.addElement(foo);
                }
                if (fnamevec.size() != 0) {
                    int j = 0;
                    while (j < fnamevec.size()) {
                        String filepath = String.valueOf(directory) + file.getRelativePath() + filesep + (String)fnamevec.get(j);
                        RemoteFile rf = new RemoteFile(filepath, ctmp);
                        if (rf.exists()) {
                            rf.setChaseFile(file);
                            if (file.getDuplicateFile().equals(ChaseFile.OVERWRITE)) {
                                rf.overwrite(true);
                            } else {
                                rf.overwrite(false);
                            }
                            remfiles.addElement(rf);
                        }
                        ++j;
                    }
                    logger.debug((Object)("ok done with " + file.getFileName()));
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.regfiles.size()) {
            remfiles.add(new RemoteFile((String)this.regfiles.elementAt(i), ctmp));
            ++i;
        }
        if (remfiles.size() == 0) {
            return null;
        }
        Object[] ret = new RemoteFile[remfiles.size()];
        remfiles.copyInto(ret);
        return ret;
    }

    private String getFileNameFromRegExpEntry(String target, String name, ChannelSftp c) {
        String ret = "";
        logger.debug((Object)("targetdir: " + target));
        RemoteFile rf = new RemoteFile(target, c);
        RemoteFile[] rfs = (RemoteFile[])rf.listFiles();
        if (rfs == null || rfs.length == 0) {
            logger.debug((Object)"remote file list was null.");
            return ret;
        }
        long newest = 0L;
        boolean inew = false;
        int i = 0;
        while (i < rfs.length) {
            if (rfs[i].getName().matches(name)) {
                logger.debug((Object)("caught: " + rfs[i].getName()));
                long last = rfs[i].lastModified();
                if (last > newest) {
                    ret = rfs[i].getName();
                }
            } else {
                logger.debug((Object)(String.valueOf(rfs[i].getName()) + " does not match " + name + "."));
            }
            ++i;
        }
        logger.debug((Object)("newest file: " + ret));
        return ret;
    }

    private Vector getFileNamesFromRegExpEntry(String target, String name, ChannelSftp c) {
        logger.debug((Object)("targetdir: " + target));
        Vector<String> ret = new Vector<String>();
        RemoteFile rf = new RemoteFile(target, c);
        RemoteFile[] rfs = (RemoteFile[])rf.listFiles();
        if (rfs == null || rfs.length == 0) {
            logger.debug((Object)"remote file list was null.");
            return ret;
        }
        int i = 0;
        while (i < rfs.length) {
            if (rfs[i].getName().matches(name)) {
                logger.debug((Object)("caught: " + rfs[i].getName()));
                ret.addElement(rfs[i].getName());
            } else {
                logger.debug((Object)(String.valueOf(rfs[i].getName()) + " does not match " + name + "."));
            }
            ++i;
        }
        return ret;
    }
}

