/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting.scriptmanipulator;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.Resources;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jobcontrol.DefaultScriptCreator;
import ciss.phase_viewer.jobcontrol.JobController;
import ciss.phase_viewer.jobcontrol.JobControllerElement;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.scripting.ScriptUtils;
import ciss.phase_viewer.scripting.ScriptWrapper;
import ciss.phase_viewer.scripting.scriptmanipulator.ScriptBrowser;
import ciss.phase_viewer.scripting.scriptmanipulator.ScriptList;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostSelector;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class ScriptManipulator
extends JPanel
implements JobControllerElement,
ActionListener {
    private Logger logger;
    private Properties props;
    private Document document;
    private ProjectInfo projectInfo;
    private final String script = "script";
    private final String init_script = "init_script";
    private final String script_type = "script_type";
    private final String exec = "exec";
    private final String bsh = "bsh";
    private final String sh = "sh";
    private final String script_exec_script = "script_exec_script";
    private final String exec_script = "exec_script";
    private final String script_path = "script_path";
    private ScriptList scriptList;
    private ScriptBrowser scriptBrowser;
    private JComboBox scriptType;
    private JButton bedit;
    private JButton bbootChooser;
    private JButton bdelete;
    private JButton bup;
    private JButton bdown;
    private JButton bclose;
    private String scriptName;

    public ScriptManipulator(ProjectInfo projectInfo) {
        block11: {
            this.logger = Logger.getLogger((String)ScriptManipulator.class.getName());
            this.script = "script";
            this.init_script = "init_script";
            this.script_type = "script_type";
            this.exec = "exec";
            this.bsh = "bsh";
            this.sh = "sh";
            this.script_exec_script = "script_exec_script";
            this.exec_script = "exec_script";
            this.script_path = "script_path";
            this.scriptName = "file_transfer.bsh";
            this.projectInfo = projectInfo;
            this.props = new Properties();
            InputStream inp = null;
            try {
                try {
                    inp = ScriptManipulator.class.getResourceAsStream("/ciss/phase_viewer/scripting/script.properties");
                    this.props.load(inp);
                }
                catch (IOException ioe) {
                    this.logger.error((Object)"failed to load property file...");
                    try {
                        inp.close();
                    }
                    catch (IOException ioe2) {
                        ioe2.printStackTrace();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    inp.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                throw throwable;
            }
            try {
                inp.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.setLayout(new GridLayout());
        this.createGUI();
        this.logger.debug((Object)("finished init of: " + ScriptManipulator.class.getName()));
        this.document = JobController.getJobControlDocument(projectInfo, this);
    }

    public void adjust() {
        this.logger.debug((Object)"adjusting....");
        this.scriptList.adjust();
        this.scriptBrowser.adjust();
    }

    private JPanel createButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.scriptType = new JComboBox<String>(ScriptWrapper.REGISTERED_SCRIPT_TYPE);
        JPanel ptype = new JPanel();
        ptype.setBorder(new TitledBorder("script type"));
        ptype.add(this.scriptType);
        this.bedit = new JButton("edit input");
        JButton beditor = new JButton("boot editor");
        this.bbootChooser = new JButton("boot chooser");
        this.bdelete = new JButton("delete");
        this.bup = new JButton("up");
        this.bdown = new JButton("down");
        this.bclose = new JButton("close");
        p.add(ptype);
        p.add(this.bedit);
        p.add(beditor);
        p.add(this.bbootChooser);
        p.add(this.bdelete);
        p.add(this.bup);
        p.add(this.bdown);
        this.bedit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptManipulator.this.bootScriptEditor();
            }
        });
        beditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptWrapper scripts = ScriptManipulator.this.scriptList.getSelectedScript();
                if (scripts != null) {
                    Utils.bootTextViewer(scripts.getPath());
                }
            }
        });
        this.bbootChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptManipulator.this.selectScript();
            }
        });
        this.bdelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptManipulator.this.deleteSelectedElement();
            }
        });
        this.bup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptManipulator.this.shiftUpSelectedElement();
            }
        });
        this.bdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptManipulator.this.shiftDownSelectedElement();
            }
        });
        this.scriptType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ScriptManipulator.this.scriptType.getSelectedItem() == null) {
                    return;
                }
                ScriptManipulator.this.scriptList.setScriptType(ScriptManipulator.this.scriptType.getSelectedItem().toString());
                ScriptManipulator.this.saveToDisk();
            }
        });
        return p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof HostSelector) {
            HostSelector selector = (HostSelector)e.getSource();
            HostInfo info = selector.getSelectedHost();
            Object selectedObject = this.scriptType.getSelectedItem();
            this.scriptType.removeAllItems();
            String[] selection = ScriptWrapper.getValidScriptType(info);
            int i = 0;
            while (i < selection.length) {
                this.scriptType.addItem(selection[i]);
                ++i;
            }
            this.scriptType.setSelectedItem(selectedObject);
        }
    }

    private void shiftDownSelectedElement() {
        this.scriptList.shiftDownSelectedElement();
        this.saveToDisk();
    }

    private void shiftUpSelectedElement() {
        this.scriptList.shiftUpSelectedElement();
        this.saveToDisk();
    }

    private void deleteSelectedElement() {
        this.scriptList.deleteSelectedElement();
        this.saveToDisk();
        this.revalidate();
    }

    private void selectScript() {
        ChaseFileChooser fdlg = new ChaseFileChooser("script");
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("choose");
        fdlg.setFileSelectionMode(0);
        if (fdlg.showDialog(this, "Select") != 0) {
            return;
        }
        String str = fdlg.getSelectedFile().getAbsolutePath();
        if (!new File(str).exists()) {
            this.logger.error((Object)"file doesn't exist!!");
            return;
        }
        String name = new File(str).getName();
        String foo = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + name;
        try {
            ExternalProgramExecuter.copy(str, foo);
        }
        catch (Exception exc) {
            this.logger.error((Object)"failed copy of template file... ");
            foo = str;
        }
        String type = ScriptWrapper.getTypeFromFile(foo);
        ScriptWrapper script = new ScriptWrapper(foo, type);
        this.scriptList.addScript(script);
        this.revalidate();
        this.saveToDisk();
    }

    private void saveToDisk() {
        if (this.document == null || !this.document.hasRootElement()) {
            return;
        }
        Element root = this.document.getRootElement().getChild(JobController.JOBCONTROL);
        if (root == null) {
            return;
        }
        Element type_ = root.getChild("script").getChild("script_type");
        if (type_ != null) {
            type_.setText(MyElement.encode(this.scriptType.getSelectedItem().toString()));
        }
        Element script_element_exec = root.getChild("script").getChild("exec");
        List exec = script_element_exec.getChildren("exec_script");
        int i = exec.size() - 1;
        while (i >= 0) {
            script_element_exec.removeContent((Content)((Element)exec.get(i)));
            --i;
        }
        ScriptWrapper[] scripts = this.scriptList.getAllScripts();
        if (scripts != null) {
            int i2 = 0;
            while (i2 < scripts.length) {
                ScriptWrapper script = scripts[i2];
                Element exec_element = new Element("exec_script");
                Element type = new Element("script_type");
                type.setText(MyElement.encode(script.getScriptType()));
                Element path = new Element("script_path");
                path.setText(MyElement.encode(script.toString()));
                exec_element.addContent((Content)type);
                exec_element.addContent((Content)path);
                script_element_exec.addContent((Content)exec_element);
                ++i2;
            }
        }
        JobController.saveJobControlFile(this.projectInfo.getProjectDirectory(), this.document);
    }

    private void bootScriptEditor() {
        this.scriptList.bootEditor();
    }

    @Override
    public boolean readJobControlDocument(Document doc) {
        Element root;
        Element script_element;
        DefaultScriptCreator creator = this.projectInfo.getDefaultScriptCreator();
        if (!creator.createDefaultScript()) {
            this.logger.error((Object)"failed creation of default script...");
        }
        if ((script_element = (root = doc.getRootElement().getChild(JobController.JOBCONTROL)).getChild("script")) == null) {
            return false;
        }
        Element type = script_element.getChild("script_type");
        if (type == null) {
            return false;
        }
        this.scriptType.setSelectedItem(MyElement.decode(type.getTextTrim()));
        Element exec_element = script_element.getChild("exec");
        if (exec_element == null) {
            return false;
        }
        Element bsh_elem = exec_element.getChild("bsh");
        if (bsh_elem == null) {
            return false;
        }
        Element ele = exec_element.getChild("bsh").getChild("script_exec_script");
        if (ele == null) {
            return false;
        }
        List list = exec_element.getChildren("exec_script");
        this.logger.debug((Object)("number of exec_script: " + list.size()));
        if (list == null || list.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < list.size()) {
            Element element = (Element)list.get(i);
            String scriptPath = MyElement.decode(element.getChildTextTrim("script_path"));
            if (!new File(scriptPath).isAbsolute()) {
                scriptPath = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + MyElement.decode(element.getChildTextTrim("script_path"));
            }
            String strtype = MyElement.decode(element.getChildTextTrim("script_type"));
            ScriptWrapper scriptWrapper = new ScriptWrapper(scriptPath, strtype);
            this.scriptList.addScript(scriptWrapper);
            this.logger.debug((Object)("added : " + scriptWrapper));
            ++i;
        }
        this.revalidate();
        return true;
    }

    private void createGUI() {
        JSplitPane split = new JSplitPane();
        split.setOrientation(0);
        this.scriptList = new ScriptList();
        this.scriptBrowser = new ScriptBrowser("jobcontrol", this.scriptList);
        split.setTopComponent(this.scriptList);
        split.setBottomComponent(this.scriptBrowser);
        split.setDividerLocation(0.5);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.scriptList);
        panel.add(this.createButtons());
        JPanel selector = new JPanel();
        selector.setLayout(new BoxLayout(selector, 1));
        JButton btn = new JButton(Resources.getIcon("/org/javalobby/icons/20x20/Up.gif"));
        selector.add(btn);
        selector.add(this.scriptBrowser);
        JSplitPane splitPane = new JSplitPane(0, true, panel, selector);
        splitPane.setResizeWeight(0.5);
        this.add(splitPane);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String[] paths = ScriptManipulator.this.scriptBrowser.getSelectedPaths();
                if (paths == null || paths.length == 0) {
                    ScriptManipulator.this.logger.debug((Object)"no file selected");
                    return;
                }
                int i = 0;
                while (i < paths.length) {
                    String name = new File(paths[i]).getName();
                    String foo = String.valueOf(ScriptManipulator.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + name;
                    try {
                        ExternalProgramExecuter.copy(paths[i], foo);
                    }
                    catch (Exception exc) {
                        ScriptManipulator.this.logger.error((Object)"failed copy of template file... ");
                        foo = paths[i];
                    }
                    ScriptManipulator.this.processScript(paths[i]);
                    ScriptManipulator.this.logger.debug((Object)("path: " + paths[i]));
                    ScriptManipulator.this.logger.debug((Object)("name: " + foo));
                    String type = ScriptWrapper.getTypeFromFile(foo);
                    ScriptManipulator.this.logger.debug((Object)("type: " + type));
                    ScriptWrapper script = new ScriptWrapper(foo, type);
                    ScriptManipulator.this.scriptList.addScript(script);
                    ++i;
                }
                ScriptManipulator.this.revalidate();
                ScriptManipulator.this.saveToDisk();
            }
        });
    }

    private void processScript(String scrfile) {
        ScriptUtils.copyNecessaryFiles(scrfile, this.projectInfo.getProjectDirectory());
        String sfile = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.scriptName;
        if (!new File(sfile).exists()) {
            return;
        }
        HashMap<String, ProjectInfo> ma = new HashMap<String, ProjectInfo>();
        ma.put("projectInfo", this.projectInfo);
        ScriptUtils.runScript(sfile, ma);
    }

    @Override
    public void initJobControlDocument(Document doc) {
        DefaultScriptCreator creator = this.projectInfo.getDefaultScriptCreator();
        if (!creator.createDefaultScript()) {
            this.logger.error((Object)"failed creation of default script...");
        }
        ScriptWrapper[] initScripts = creator.getDefaultScripts();
        Element script_element = new Element("script");
        doc.getRootElement().getChild(JobController.JOBCONTROL).addContent((Content)script_element);
        String foo = this.props.getProperty("jobcontrol_init_script_path");
        String init_script_path = String.valueOf(System.getProperty("pviewer.home")) + System.getProperty("file.separator") + foo.replace('/', File.separatorChar);
        Element init_script_element = new Element("init_script");
        init_script_element.setText(MyElement.encode(init_script_path));
        script_element.addContent((Content)init_script_element);
        Element script_type_element = new Element("script_type");
        script_type_element.setText(MyElement.encode("sh"));
        script_element.addContent((Content)script_type_element);
        Element exec_element = new Element("exec");
        String bar = this.props.getProperty("jobcontrol_bsh_script_exec_script");
        String script_exec_script_path = String.valueOf(System.getProperty("pviewer.home")) + System.getProperty("file.separator") + bar.replace('/', File.separatorChar);
        Element script_exec_script_element = new Element("script_exec_script");
        script_exec_script_element.setText(MyElement.encode(script_exec_script_path));
        Element bsh_element = new Element("bsh");
        bsh_element.addContent((Content)script_exec_script_element);
        exec_element.addContent((Content)bsh_element);
        script_element.addContent((Content)exec_element);
        if (initScripts != null && initScripts.length != 0) {
            int i = 0;
            while (i < initScripts.length) {
                Element exec_script_element = new Element("exec_script");
                Element type = new Element("script_type");
                type.setText(MyElement.encode(initScripts[i].getScriptType()));
                Element path = new Element("script_path");
                path.setText(MyElement.encode(initScripts[i].toString()));
                exec_script_element.addContent((Content)type);
                exec_script_element.addContent((Content)path);
                exec_element.addContent((Content)exec_script_element);
                ++i;
            }
        }
    }
}

