/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting;

import bsh.EvalError;
import bsh.Interpreter;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ScriptUtils {
    private static Logger logger = Logger.getLogger((String)ScriptUtils.class.getName());
    private static String BEGIN_DESCRIPTION = "BEGIN_DESCRIPTION";
    private static String END_DESCRIPTION = "END_DESCRIPTION";
    private static String BEGIN_INPUT = "BEGIN_INPUT";
    private static String END_INPUT = "END_INPUT";
    private static String BEGIN_NECESSARY_FILES = "BEGIN_NECESSARY_FILES";
    private static String END_NECESSARY_FILES = "END_NECESSARY_FILES";
    private static String BEGIN_BCOMMENT = "/*";
    private static String END_BCOMMENT = "*/";
    private static String FS = ConstParameters.FS;
    private static String scriptDir = String.valueOf(System.getProperty("user.dir")) + FS + ".phase-viewer" + FS + "scripts";

    private ScriptUtils() {
    }

    public static InputInterface getInputInterfaceFrom(String file) {
        BufferedReader reader = null;
        boolean inInput = false;
        String inputString = "";
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                String string = "";
                while ((string = reader.readLine()) != null) {
                    if (string.trim().equals(BEGIN_INPUT)) {
                        inInput = true;
                        continue;
                    }
                    if (string.trim().equals(END_INPUT)) {
                        break;
                    }
                    if (!inInput) continue;
                    inputString = String.valueOf(inputString) + string + System.getProperty("line.separator");
                }
            }
            catch (IOException ioe) {
                logger.error((Object)ioe);
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ioe2) {
                    logger.error((Object)ioe2);
                    return null;
                }
                return null;
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe2) {
                logger.error((Object)ioe2);
                return null;
            }
        }
        File tmpFile = ScriptUtils.getTmpFile();
        logger.debug((Object)("tmpfile name: " + tmpFile.getAbsolutePath()));
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(tmpFile));
                writer.write(inputString, 0, inputString.length() - 1);
            }
            catch (IOException ioe) {
                logger.error((Object)ioe);
                try {
                    writer.close();
                }
                catch (IOException ioe2) {
                    logger.error((Object)ioe2);
                    return null;
                }
                return null;
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ioe2) {
                logger.error((Object)ioe2);
                return null;
            }
        }
        DataManager dm = new DataManager(tmpFile.getAbsolutePath());
        dm.parse();
        InputInterface inputInterface = dm.getInputInterface();
        tmpFile.delete();
        if (inputInterface != null) {
            inputInterface.writeNullValue(true);
        }
        return inputInterface;
    }

    private static HashMap getNecessaryFiles(String file) {
        Vector<String> fromFile = new Vector<String>();
        Vector<String> toFile = new Vector<String>();
        BufferedReader reader = Utils.getReader(file);
        if (reader == null) {
            return null;
        }
        String delim = "\\-\\>";
        boolean inCopyNecessary = false;
        String line = "";
        try {
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith(BEGIN_NECESSARY_FILES)) {
                    inCopyNecessary = true;
                    continue;
                }
                if (!line.trim().startsWith(END_NECESSARY_FILES)) {
                    String[] ar;
                    if (!inCopyNecessary || (ar = line.split(delim)) == null || ar.length < 2) continue;
                    fromFile.add(ar[0]);
                    toFile.add(ar[1]);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (fromFile.size() == 0) {
            return null;
        }
        Object[] fromStr = new String[fromFile.size()];
        Object[] toStr = new String[toFile.size()];
        fromFile.copyInto(fromStr);
        toFile.copyInto(toStr);
        HashMap<String, Object[]> ret = new HashMap<String, Object[]>();
        ret.put("from", fromStr);
        ret.put("to", toStr);
        return ret;
    }

    public static boolean copyNecessaryFiles(String file, String targetDir) {
        File scriptDirFile = new File(scriptDir);
        if (!scriptDirFile.exists() || !scriptDirFile.isDirectory()) {
            logger.error((Object)("invalid script dir: " + scriptDir));
            return false;
        }
        HashMap nefile = ScriptUtils.getNecessaryFiles(file);
        if (nefile == null) {
            return false;
        }
        String[] fromFile = (String[])nefile.get("from");
        String[] toFile = (String[])nefile.get("to");
        boolean ret = true;
        int i = 0;
        while (i < fromFile.length) {
            String from = String.valueOf(scriptDir) + FS + fromFile[i];
            String to = String.valueOf(targetDir) + FS + toFile[i];
            logger.debug((Object)("from, to: " + from + ", " + to));
            try {
                ExternalProgramExecuter.copyBinary(from, to);
            }
            catch (IOException ioe) {
                ret = false;
            }
            ++i;
        }
        return ret;
    }

    public static boolean removeNecessaryFiles(String file, String targetDir) {
        HashMap nefile = ScriptUtils.getNecessaryFiles(file);
        if (nefile == null) {
            return false;
        }
        String[] to = (String[])nefile.get("to");
        boolean ret = false;
        int i = 0;
        while (i < to.length) {
            ret = new File(String.valueOf(targetDir) + FS + to[i]).delete();
            ++i;
        }
        return ret;
    }

    public static String getDescriptionFrom(String file) {
        if (new File(file).isDirectory()) {
            return "";
        }
        BufferedReader reader = null;
        boolean inDescription = false;
        String descriptionString = "";
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                String string = "";
                while ((string = reader.readLine()) != null) {
                    if (string.trim().equals(BEGIN_DESCRIPTION)) {
                        inDescription = true;
                        continue;
                    }
                    if (string.trim().equals(END_DESCRIPTION)) {
                        break;
                    }
                    if (!inDescription) continue;
                    descriptionString = String.valueOf(descriptionString) + string + System.getProperty("line.separator");
                }
            }
            catch (IOException ioe) {
                logger.error((Object)ioe);
                try {
                    reader.close();
                }
                catch (IOException ioe2) {
                    logger.error((Object)ioe2);
                    return "";
                }
                return "";
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe2) {
                logger.error((Object)ioe2);
                return "";
            }
        }
        return descriptionString;
    }

    public static String getScriptText(String file) {
        BufferedReader reader = null;
        String ret = "";
        try {
            try {
                String string = "";
                reader = new BufferedReader(new FileReader(file));
                boolean inBlock = false;
                while ((string = reader.readLine()) != null) {
                    if (string.trim().indexOf(BEGIN_BCOMMENT) != -1) {
                        inBlock = true;
                    }
                    if (!inBlock) {
                        ret = String.valueOf(ret) + string + System.getProperty("line.separator");
                    }
                    if (string.trim().indexOf(END_BCOMMENT) == -1) continue;
                    inBlock = false;
                }
            }
            catch (IOException ioe) {
                logger.error((Object)ioe);
                try {
                    reader.close();
                }
                catch (IOException ioe1) {
                    logger.error((Object)ioe1);
                }
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe1) {
                logger.error((Object)ioe1);
            }
        }
        return ret;
    }

    public static File getTmpFile() {
        String now = String.valueOf(Calendar.getInstance().getTimeInMillis());
        String tmpDir = System.getProperty("java.io.tmpdir");
        String tmpFile = String.valueOf(tmpDir) + System.getProperty("file.separator") + "tmp" + now;
        return new File(tmpFile);
    }

    private static String getNecessaryFilesStr(String file) {
        BufferedReader rd = Utils.getReader(file);
        String ret = "";
        try {
            boolean inNec = false;
            String line = "";
            while ((line = rd.readLine()) != null) {
                if (line.startsWith(BEGIN_NECESSARY_FILES)) {
                    inNec = true;
                }
                if (inNec) {
                    ret = String.valueOf(ret) + line + "\n";
                }
                if (!line.startsWith(END_NECESSARY_FILES)) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            rd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static boolean saveScript(String file, InputInterface inputInterface, String description) {
        BufferedWriter writer = null;
        File tmp = Utils.getTmpFile();
        String nefi = ScriptUtils.getNecessaryFilesStr(file);
        String script = ScriptUtils.getScriptText(file);
        inputInterface.writeValueDelimitedByColon(true);
        try {
            try {
                ExternalProgramExecuter.copyBinary(file, tmp.getAbsolutePath());
                new File(file).delete();
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(String.valueOf(BEGIN_BCOMMENT) + "\n", 0, BEGIN_BCOMMENT.length() + 1);
                writer.write(String.valueOf(BEGIN_DESCRIPTION) + "\n", 0, BEGIN_DESCRIPTION.length() + 1);
                writer.write(description);
                writer.write(String.valueOf(END_DESCRIPTION) + "\n", 0, END_DESCRIPTION.length() + 1);
                writer.write(String.valueOf(BEGIN_INPUT) + "\n", 0, BEGIN_INPUT.length() + 1);
                String input = inputInterface.toString();
                writer.write(input, 0, input.length());
                writer.write(String.valueOf(END_INPUT) + "\n", 0, END_INPUT.length() + 1);
                writer.write(nefi, 0, nefi.length());
                writer.write(String.valueOf(END_BCOMMENT) + "\n", 0, END_BCOMMENT.length() + 1);
                writer.write(script, 0, script.length());
            }
            catch (Exception exc) {
                try {
                    logger.error((Object)"write failed; restoring backup...");
                    ExternalProgramExecuter.copyBinary(tmp.getAbsolutePath(), file);
                }
                catch (IOException ioe) {
                    logger.error((Object)"failed to restore backup file.");
                    ioe.printStackTrace();
                }
                tmp.delete();
                try {
                    writer.close();
                }
                catch (IOException ioe2) {
                    logger.error((Object)ioe2);
                }
            }
        }
        finally {
            tmp.delete();
            try {
                writer.close();
            }
            catch (IOException ioe2) {
                logger.error((Object)ioe2);
            }
        }
        return true;
    }

    public static Object runScript(String[] scriptPath, HashMap properties) {
        Object obj = null;
        Interpreter interpreter = new Interpreter();
        try {
            int i;
            Set keySet = properties.keySet();
            Object[] keys = keySet.toArray();
            if (keys != null) {
                i = 0;
                while (i < keys.length) {
                    interpreter.set(keys[i].toString(), properties.get(keys[i]));
                    ++i;
                }
            }
            obj = interpreter.eval("importCommands(\"ciss.phase_viewer.scripting.commands\")");
            i = 0;
            while (i < scriptPath.length) {
                interpreter.source(scriptPath[i]);
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (EvalError e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static Object runScript(String scriptPath, HashMap properties) {
        return ScriptUtils.runScript(new String[]{scriptPath}, properties);
    }
}

