/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser.projectstatemanipulator;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.NewProjectCreator;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateChangeEvent;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateChangeListener;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateChanger;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateGUI;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class SubProjectCreatorPanel
extends JPanel
implements ProjectStateChanger {
    private Logger logger = Logger.getLogger((String)SubProjectCreatorPanel.class.getName());
    private ProjectDirBrowserNode parentNode;
    private Vector components = new Vector();
    private JComboBox cbtype;
    private JTextField name;
    private ProjectDirBrowser dirBrowser;
    private Vector listeners = new Vector();
    private ProjectStateGUI parentGUI;

    public SubProjectCreatorPanel(ProjectDirBrowserNode parentNode, ProjectDirBrowser dirBrowser) {
        this.parentNode = parentNode;
        this.dirBrowser = dirBrowser;
        this.init();
    }

    public SubProjectCreatorPanel(ProjectDirBrowserNode parentNode, ProjectDirBrowser dirBrowser, ProjectStateGUI parentGUI) {
        this.parentNode = parentNode;
        this.dirBrowser = dirBrowser;
        this.parentGUI = parentGUI;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.setBorder(new TitledBorder("sub project info"));
        JPanel pcb = new JPanel();
        pcb.setLayout(new GridLayout(1, 1));
        pcb.setBorder(new TitledBorder("sub project type"));
        this.cbtype = new JComboBox<String>(ProjectBrowserUtils.getSupportedSubProjectTypes());
        pcb.add(this.cbtype);
        p.add(pcb);
        JPanel pname = new JPanel();
        pname.setBorder(new TitledBorder("sub project name"));
        pname.setLayout(new GridLayout(1, 1));
        this.name = new JTextField(this.getDefaultName(), 10);
        pname.add(this.name);
        p.add(pname);
        this.components.addElement(this.cbtype);
        this.components.addElement(this.name);
        this.cbtype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SubProjectCreatorPanel.this.name.setText(SubProjectCreatorPanel.this.getDefaultName());
            }
        });
        this.name.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                File par = new File(SubProjectCreatorPanel.this.parentNode.getProjectInfo().getProjectDirectory());
                boolean ch = Utils.isCreatable(par, SubProjectCreatorPanel.this.name.getText());
                if (SubProjectCreatorPanel.this.parentGUI != null) {
                    SubProjectCreatorPanel.this.parentGUI.getOKButton().setEnabled(ch);
                }
            }
        });
        this.name.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SubProjectCreatorPanel.this.parentGUI != null && SubProjectCreatorPanel.this.parentGUI.getOKButton().isEnabled()) {
                    SubProjectCreatorPanel.this.parentGUI.getOKButton().doClick();
                }
            }
        });
        this.add(p);
        this.add(new JPanel());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int i = 0;
        while (i < this.components.size()) {
            JComponent comp = (JComponent)this.components.elementAt(i);
            comp.setEnabled(enabled);
            ++i;
        }
    }

    @Override
    public void manipulateProjectState() {
        this.createElement();
    }

    public void setParentNode(ProjectDirBrowserNode parentNode) {
        this.parentNode = parentNode;
    }

    protected void createElement() {
        String sname = this.name.getText();
        String type = this.cbtype.getSelectedItem().toString();
        this.logger.debug((Object)("name and type of sub project...: " + sname + " " + type));
        String dir = String.valueOf(this.parentNode.getProjectInfo().getProjectDirectory()) + System.getProperty("file.separator") + sname;
        Element elem = SubProjectCreatorPanel.createSubProjectElement(dir, sname, type);
        File f = new File(dir);
        if (!f.exists() && !f.mkdirs()) {
            this.logger.error((Object)("failed to create " + dir));
            return;
        }
        ProjectDirBrowserNode nd = new ProjectDirBrowserNode(elem, this.dirBrowser, true);
        nd.addProjectDirBrowserNodeChangeListener(this.dirBrowser);
        this.dirBrowser.addObject(this.parentNode, nd, true);
        ProjectManipulator component = ProjectManipulator.createProjectManipulator(nd.getProjectInfo());
        if (component == null) {
            return;
        }
        component.initializeProject(nd);
    }

    public static Element createSubProjectElement(String baseDir, String name, String type) {
        Element elem = new Element("subproject");
        elem.setAttribute(new Attribute("display", "true"));
        Element elemname = new Element("name");
        elemname.setText(MyElement.encode(name));
        elem.addContent((Content)elemname);
        Element elemdate = new Element("date");
        elemdate.setText(MyElement.encode(Calendar.getInstance().getTime().toString()));
        elem.addContent((Content)elemdate);
        Element elemtype = new Element("type");
        elemtype.setText(MyElement.encode(type));
        elem.addContent((Content)elemtype);
        Element elemdir = new Element("directory");
        elemdir.setText(MyElement.encode(baseDir));
        elem.addContent((Content)elemdir);
        return elem;
    }

    protected void notifyListeners() {
        int i = 0;
        while (i < this.listeners.size()) {
            ProjectStateChangeListener listener = (ProjectStateChangeListener)this.listeners.elementAt(i);
            listener.projectStateChanged(new ProjectStateChangeEvent(this, this.name.getText()));
            ++i;
        }
    }

    public void addProjectStateChangeListener(ProjectStateChangeListener listener) {
        this.listeners.addElement(listener);
    }

    private String getDefaultName() {
        Enumeration<TreeNode> enumeration = this.parentNode.children();
        String ret = String.valueOf(this.cbtype.getSelectedItem().toString()) + "-project";
        boolean proj = false;
        Vector<String> vec = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String name;
            ProjectDirBrowserNode node = (ProjectDirBrowserNode)enumeration.nextElement();
            ProjectInfo info = node.getProjectInfo();
            if (info.getInfoType() != 2 || !(name = info.getProjectName().toLowerCase()).startsWith(ret.toLowerCase())) continue;
            vec.addElement(name);
        }
        if (vec.size() == 0) {
            return ret;
        }
        return NewProjectCreator.getNonDupliString(ret, vec);
    }
}

