/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.prefs;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.ColorConfigGUI;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropConfigCheckBox;
import ciss.phase_viewer.settings.PropConfigCombo;
import ciss.phase_viewer.settings.PropConfigTextField;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class HbondConfigPanel
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)HbondConfigPanel.class.getName());
    private J3DPanel parent;
    private GlobalProperties props = PropertiesManager.getGlobalProperties(1);
    private PropConfigCheckBox drawHbond;
    private ColorConfigGUI color;
    private PropConfigTextField width;
    private PropConfigCombo pattern;
    private String[] linePattern = new String[]{"solid", "dashed", "dotted"};

    public HbondConfigPanel(J3DPanel parent) {
        super("Hydrogen bond config", new Dimension(400, 130));
        this.parent = parent;
        this.parent.addDisposeOnExit(this);
        this.init();
        this.setVisible(true);
    }

    private void init() {
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(this.createSettings());
        container.add(this.createButtons());
    }

    private JPanel createSettings() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 0));
        this.drawHbond = new PropConfigCheckBox("draw H bonds", "hbond_draw_hbonds", this.props);
        JPanel drawPanel = new JPanel();
        drawPanel.setBorder(new TitledBorder(" "));
        drawPanel.add(this.drawHbond);
        JPanel colorPanel = new JPanel();
        colorPanel.setBorder(new TitledBorder("color"));
        this.color = new ColorConfigGUI("choose", "hbond_color", this.props);
        colorPanel.add(this.color);
        this.width = new PropConfigTextField(7, PropConfigTextField.FLOAT, "hbond_width", this.props);
        JPanel widthPanel = new JPanel();
        widthPanel.setBorder(new TitledBorder("width"));
        widthPanel.add(this.width);
        this.pattern = new PropConfigCombo(this.linePattern, "hbond_type", this.props);
        JPanel patternPanel = new JPanel();
        patternPanel.setBorder(new TitledBorder("pattern"));
        patternPanel.add(this.pattern);
        ret.add(this.drawHbond);
        ret.add(colorPanel);
        ret.add(widthPanel);
        ret.add(patternPanel);
        this.drawHbond.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = HbondConfigPanel.this.drawHbond.isSelected();
                HbondConfigPanel.this.color.setEnabled(b);
                HbondConfigPanel.this.width.setEnabled(b);
                HbondConfigPanel.this.pattern.setEnabled(b);
            }
        });
        boolean b = this.drawHbond.isSelected();
        this.color.setEnabled(b);
        this.width.setEnabled(b);
        this.pattern.setEnabled(b);
        return ret;
    }

    private JPanel createButtons() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 0));
        JButton apply = new JButton("apply");
        JButton dismiss = new JButton("dismiss");
        ret.add(apply);
        ret.add(dismiss);
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HbondConfigPanel.this.doApply();
            }
        });
        dismiss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HbondConfigPanel.this.dispose();
            }
        });
        return ret;
    }

    private void doApply() {
        this.props.storeProperty();
        if (this.parent instanceof MainPanel) {
            ((CoordsViewerInterface)((Object)this.parent)).lightRedraw();
        }
    }
}

