/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.frame;

import ciss.phase_viewer.acviewer.Animater;
import ciss.phase_viewer.acviewer.ImageReciver;
import ciss.phase_viewer.acviewer.vrml.VRMLExporter;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.movie.JpegImagesToMovie;
import ciss.phase_viewer.movie.MovieUtils;
import java.awt.Image;
import java.io.File;
import java.util.Vector;
import javax.media.MediaLocator;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class MovieMaker
implements ImageReciver {
    private static Logger logger = Logger.getLogger((String)MovieMaker.class.getName());
    private Animater animater;
    protected boolean jpegs = false;
    protected boolean movs = true;
    private Vector images;
    private String baseDir = System.getProperty("user.dir");
    private String movieFileName = "frame.mov";
    private int fr = 10;

    protected MovieMaker(Animater animater) {
        this.animater = animater;
        this.animater.setImageReciever(this);
    }

    protected Animater getAssociatedAnimater() {
        return this.animater;
    }

    protected void setFrameRate(int fr) {
        this.fr = fr;
    }

    protected void setAnimMode(int animMode) {
        this.animater.setBatchImageMode(animMode);
    }

    protected void setImagePrefix(String prefix) {
        this.animater.setPrefix(prefix);
    }

    protected void setMovieFileName(String movieFileName) {
        this.movieFileName = movieFileName;
    }

    protected void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
        this.animater.setBaseDir(baseDir);
    }

    protected void createMovie() {
        new Thread(this.animater).start();
    }

    @Override
    public void setImages(Vector images) {
        if (!this.movs) {
            return;
        }
        this.images = images;
        if (this.animater.getBatchImageMode() == 2) {
            this.runJMF();
            if (this.jpegs) {
                String imageFileDir = String.valueOf(this.baseDir) + System.getProperty("file.separator") + "imagefiles";
                Utils.deleteDir(new File(imageFileDir));
            }
        } else if (this.animater.getBatchImageMode() == 3) {
            this.concatVRMLs();
        }
    }

    private void concatVRMLs() {
        String dir = String.valueOf(this.baseDir) + System.getProperty("file.separator") + "imagefiles";
        VRMLExporter exp = new VRMLExporter();
        exp.setGzip(true);
        exp.concatVRMLFiles(new File(dir), new File(String.valueOf(this.baseDir) + System.getProperty("file.separator") + this.movieFileName), this.fr);
        Utils.deleteDir(new File(dir));
    }

    protected String getMovieFileName() {
        return String.valueOf(this.baseDir) + System.getProperty("file.separator") + this.movieFileName;
    }

    private void runJMF() {
        String image0 = (String)this.images.get(0);
        Image im = new ImageIcon(image0).getImage();
        int height = im.getHeight(null);
        int width = im.getWidth(null);
        String outputURL = "file:" + this.baseDir + System.getProperty("file.separator") + this.movieFileName;
        MediaLocator oml = MovieUtils.createMediaLocator(outputURL);
        if (oml == null) {
            logger.error((Object)("failed to create media locator from:" + outputURL));
            return;
        }
        JpegImagesToMovie moviemaker = new JpegImagesToMovie();
        moviemaker.doIt(width, height, this.fr, this.images, oml);
    }

    protected String getBaseDir() {
        return this.baseDir;
    }
}

