/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.edit;

import ciss.phase_viewer.acviewer.ACVCaller;
import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.io.CIFImporter;
import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.CoordsViewerBooter;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

class FileSelector
extends JPanel
implements PropertyChangeListener,
ACVCaller {
    private JTextField tfpath;
    private JButton btnchooser;
    private JButton btnV;
    private String title;
    private int width = 20;
    private boolean btnView;

    FileSelector(String title) {
        this(title, true);
    }

    FileSelector(String title, boolean btnView) {
        this.title = title;
        this.btnView = btnView;
        this.init();
    }

    void addCaretListener(CaretListener cl) {
        this.tfpath.addCaretListener(cl);
    }

    private void init() {
        this.setBorder(new TitledBorder(this.title));
        this.setLayout(new BoxLayout(this, 0));
        if (this.tfpath == null) {
            this.tfpath = new JTextField(this.width);
        }
        this.add(this.tfpath);
        this.btnchooser = new JButton("choose...");
        this.add(this.btnchooser);
        if (this.btnView) {
            this.btnV = new JButton("viewer");
            this.btnV.setEnabled(false);
            this.btnV.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileSelector.this.bootViewer();
                }
            });
            this.add(this.btnV);
        }
        int x = this.btnchooser.getSize().width;
        int y = this.btnchooser.getSize().height;
        this.tfpath.setPreferredSize(new Dimension(x, y));
        this.btnchooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSelector.this.bootFileChooser();
            }
        });
        if (this.btnView) {
            this.tfpath.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    FileSelector.this.btnV.setEnabled(FileSelector.this.pathExists());
                }
            });
        }
    }

    private void bootViewer() {
        CIFImporter cifimp = new CIFImporter();
        cifimp.createOptionsPanel(false, this, this.getPath());
        AtomCoords[] c1 = cifimp.getAtomCoordsFrom(this.getPath());
        if (c1 == null) {
            JOptionPane.showInternalMessageDialog(Desk.getDesktop().getSelectedFrame(), "failed to import atomic coordinatews from " + this.getPath());
            return;
        }
        Vector<AtomCoords> cv = new Vector<AtomCoords>();
        AtomCoords[] atomCoordsArray = c1;
        int n = c1.length;
        int n2 = 0;
        while (n2 < n) {
            AtomCoords c = atomCoordsArray[n2];
            cv.add(c);
            ++n2;
        }
        DataManager dm = new DataManager("foo", PhaseConstants.TABLESPEC, false);
        ACVData acvdata = new ACVData((ACVCaller)this, cv, this.getPath(), dm.getInputInterface(), StringConstants.phase_atom_tag);
        CoordsViewerBooter cvb = new CoordsViewerBooter(acvdata);
        try {
            cvb.boot();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showInternalMessageDialog(Desk.getDesktop().getSelectedFrame(), "failed to boot viewer");
        }
    }

    private void bootFileChooser() {
        ChaseFileChooser fdlg = new ChaseFileChooser("atom", true);
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("choose");
        fdlg.setFileSelectionMode(0);
        if (fdlg.showDialog(this, "Select") != 0) {
            return;
        }
        this.tfpath.setText(fdlg.getSelectedFile().getAbsolutePath());
    }

    boolean pathExists() {
        return new File(this.tfpath.getText()).exists();
    }

    String getPath() {
        return this.tfpath.getText();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void save(AtomCoords coords) {
    }
}

