/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.edit;

import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.operations.EnlargeCell;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.common.ExcelAdapter;
import ciss.phase_viewer.common.InputPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;

public class CellPanel
extends JPanel
implements TableModelListener,
ConfigData {
    private Logger logger = Logger.getLogger((String)CellPanel.class.getName());
    private CoordsViewerInterface parent;
    private JTable tbl_cell;
    private JButton enlargeButton;
    private InputPanel ipenlargeA;
    private InputPanel ipenlargeB;
    private InputPanel ipenlargeC;
    private final String one = "1";
    private Atom[] origAtoms;
    private Cell origCell;
    private boolean updateCell = true;
    private EnlargeCell enlargeCell;
    private JCheckBox cbactonall;
    int prevA = 1;
    int prevB = 1;
    int prevC = 1;

    public CellPanel(CoordsViewerInterface parent) {
        this.parent = parent;
        this.enlargeCell = new EnlargeCell(parent.getFramesAC(), (MainPanel)parent);
        this.init();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.updateCell) {
            return;
        }
        Cell cell = this.getCell();
        if (cell == null) {
            return;
        }
        AtomCoords coords = this.parent.getCD().getAtomCoords();
        coords.setCell(cell);
        coords.getAtomList().setUndoCount(1);
        this.parent.getCD().setCoords(coords);
    }

    private Cell getCell() {
        String[] avec = new String[3];
        String[] bvec = new String[3];
        String[] cvec = new String[3];
        int i = 0;
        while (i < 3) {
            avec[i] = (String)this.tbl_cell.getValueAt(0, i + 1);
            bvec[i] = (String)this.tbl_cell.getValueAt(1, i + 1);
            cvec[i] = (String)this.tbl_cell.getValueAt(2, i + 1);
            try {
                Double.parseDouble(avec[i]);
                Double.parseDouble(bvec[i]);
                Double.parseDouble(cvec[i]);
            }
            catch (NumberFormatException nfe) {
                this.logger.error((Object)"cell parameter must be a double value.");
                return null;
            }
            catch (NullPointerException npe) {
                this.logger.error((Object)"one of the value for the cell parameters was invalid.");
                return null;
            }
            ++i;
        }
        return new Cell(avec, bvec, cvec);
    }

    private void init() {
        this.createOrig();
        this.parent.getCD().register(this);
        Object[] colname_cell = new String[]{"unit cell", "x", "y", "z"};
        Object[][] celldata = new String[][]{{"a-axis", "", "", ""}, {"b-axis", "", "", ""}, {"c-axis", "", "", ""}};
        this.tbl_cell = new JTable(celldata, colname_cell);
        this.tbl_cell.setColumnSelectionAllowed(true);
        this.tbl_cell.setRowSelectionAllowed(true);
        JScrollPane scrPaneCell = new JScrollPane();
        scrPaneCell.getViewport().setView(this.tbl_cell);
        scrPaneCell.setPreferredSize(new Dimension(350, 70));
        ExcelAdapter ea_cell = new ExcelAdapter(this.tbl_cell);
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        dtcr.setHorizontalAlignment(0);
        JTextField tf = new JTextField("");
        tf.setEditable(false);
        DefaultCellEditor dce = new DefaultCellEditor(tf);
        this.tbl_cell.getColumnModel().getColumn(0).setCellRenderer(dtcr);
        this.tbl_cell.getColumnModel().getColumn(0).setCellEditor(dce);
        Cell[] cell = this.parent.getCD().getAtomCoords().getCell();
        if (cell != null && cell.length != 0) {
            double[][] data = cell[0].getDouble();
            try {
                int i = 0;
                while (i < 3) {
                    int j = 0;
                    while (j < 3) {
                        this.tbl_cell.getModel().setValueAt(String.valueOf(data[i][j]), i, j + 1);
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception exc) {
                this.logger.error((Object)"unable to show cell data...");
                exc.printStackTrace();
            }
        }
        JPanel patconfig_cell = new JPanel();
        patconfig_cell.setBorder(new TitledBorder("cell"));
        patconfig_cell.add(scrPaneCell);
        JPanel patconfig_enlarge = new JPanel();
        patconfig_enlarge.setLayout(new BoxLayout(patconfig_enlarge, 0));
        this.enlargeButton = new JButton("apply");
        JButton setButton = new JButton("set current structure as base");
        this.cbactonall = new JCheckBox("act on all frames");
        this.cbactonall.setSelected(true);
        this.ipenlargeA = new InputPanel("a-axis", 0, 5);
        this.ipenlargeB = new InputPanel("b-axis", 0, 5);
        this.ipenlargeC = new InputPanel("c-axis\t", 0, 5);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 0));
        textPanel.add(this.ipenlargeA);
        textPanel.add(this.ipenlargeB);
        textPanel.add(this.ipenlargeC);
        patconfig_enlarge.add(this.cbactonall);
        patconfig_enlarge.add(this.enlargeButton);
        patconfig_enlarge.add(setButton);
        this.ipenlargeA.setValue("1");
        this.ipenlargeB.setValue("1");
        this.ipenlargeC.setValue("1");
        this.add(patconfig_cell);
        JPanel enlargePanel = new JPanel();
        enlargePanel.setLayout(new BoxLayout(enlargePanel, 1));
        enlargePanel.add(textPanel);
        enlargePanel.add(patconfig_enlarge);
        enlargePanel.setBorder(new TitledBorder("supercell"));
        this.add(enlargePanel);
        this.enlargeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CellPanel.this.doEnlarge();
            }
        });
        setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CellPanel.this.createOrig();
            }
        });
        this.cbactonall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CellPanel.this.enlargeCell.setDoAllFrames(CellPanel.this.cbactonall.isSelected());
            }
        });
        this.enlargeCell.setDoAllFrames(true);
        this.tbl_cell.getModel().addTableModelListener(this);
    }

    private void createOrig() {
        this.enlargeCell.recreateOrig();
    }

    private void doEnlarge() {
        int a = 1;
        int b = 1;
        int c = 1;
        double[][] dCell = new double[3][3];
        try {
            a = Integer.parseInt(this.ipenlargeA.getValue());
            b = Integer.parseInt(this.ipenlargeB.getValue());
            c = Integer.parseInt(this.ipenlargeC.getValue());
        }
        catch (NumberFormatException nfe) {
            this.logger.error((Object)"enter an integer value!");
            return;
        }
        if (this.prevA == 1 && this.prevB == 1 && this.prevC == 1) {
            this.enlargeCell.recreateOrig();
        }
        this.enlargeCell.doEnlarge(a, b, c);
        this.updateCell = false;
        double[][] newCell = this.parent.getCD().getCell();
        int i = 0;
        while (i < 3) {
            this.tbl_cell.getModel().setValueAt(String.valueOf(newCell[0][i]), 0, i + 1);
            this.tbl_cell.getModel().setValueAt(String.valueOf(newCell[1][i]), 1, i + 1);
            this.tbl_cell.getModel().setValueAt(String.valueOf(newCell[2][i]), 2, i + 1);
            ++i;
        }
        this.updateCell = true;
        this.prevA = a;
        this.prevB = b;
        this.prevC = c;
    }

    @Override
    public void configDataUpdate() {
        Cell cell = this.parent.getCD().getAtomCoords().getCell(0);
        if (cell != null) {
            this.updateCell = false;
            String[][] newCell = cell.getCell();
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 3) {
                    this.tbl_cell.getModel().setValueAt(newCell[i][j], i, j + 1);
                    ++j;
                }
                ++i;
            }
            this.updateCell = true;
        }
    }

    @Override
    public void configDataUpdate(boolean rescaleOnUpdate, ConfigDataUpdateEvent e) {
        this.configDataUpdate();
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }
}

