/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.chargedensity;

import ciss.phase_viewer.acviewer.BaseJ3DPanel;
import ciss.phase_viewer.acviewer.ChaseTransformGroup;
import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.colormap.BaseColorMap;
import ciss.phase_viewer.acviewer.colormap.ColorBar;
import ciss.phase_viewer.acviewer.colormap.ColorMap;
import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.acviewer.scenegraphelements.Isosurface;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.primitiveguis.TransparencySelector;
import ciss.phase_viewer.primitiveguis.ValueSlider;
import ciss.phase_viewer.primitiveguis.ValueSliderListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import org.apache.log4j.Logger;

public class IsosurfacePanel
extends InternalFrameChase
implements ConfigData {
    private Logger logger = Logger.getLogger((String)IsosurfacePanel.class.getName());
    private BaseJ3DPanel parent;
    private Color defaultColor = new Color(229, 229, 127);
    private JComboBox isosurfaces;
    private JButton colorChooser;
    private JTextField textTrans;
    private JComboBox normalSelector;
    private JComboBox colorMaps;
    private JComboBox colorScheme;
    private JTextField minText;
    private JTextField maxText;
    private float minval;
    private float maxval;
    private JCheckBox invert;
    private JToggleButton colorbar;
    private VolumetricData density;
    private TransformGroup transformGroup;
    private JComboBox dataSelector;
    private VolumetricData[] densities;
    private TitledBorder titledBorder;
    private JPanel pall;
    private TransparencySelector transparencySelector;
    private ValueSlider valueSlider;
    private JCheckBox ontheFly;
    private ColorBar bar;

    public IsosurfacePanel(BaseJ3DPanel parent) {
        super("Isosurface panel", new Dimension(550, 430));
        this.parent = parent;
        parent.addDisposeOnExit(this);
        if (parent instanceof MainPanel) {
            ((CoordsViewerInterface)((Object)parent)).getCD().register(this);
        }
        this.init();
        this.setVisible(true);
    }

    private void init() {
        this.densities = this.parent.getAssociatedVolumetricData();
        this.density = this.densities[0];
        this.transformGroup = this.parent.getRootTransform();
        Container container = this.getContentPane();
        String title = null;
        if (this.density != null) {
            title = this.density.toString();
        }
        container.setLayout(new BoxLayout(container, 1));
        this.pall = new JPanel();
        this.pall.setLayout(new BoxLayout(this.pall, 1));
        if (title != null) {
            this.titledBorder = new TitledBorder(title);
            this.pall.setBorder(this.titledBorder);
        }
        JPanel datapanel = new JPanel();
        datapanel.setLayout(new BoxLayout(datapanel, 0));
        JPanel selepanel = new JPanel();
        selepanel.setBorder(new TitledBorder("select data"));
        this.dataSelector = new JComboBox();
        selepanel.add(this.dataSelector);
        datapanel.add(selepanel);
        float mid = this.density.getMidVal();
        this.minval = this.density.getMinVal();
        this.maxval = this.density.getMaxVal();
        this.valueSlider = new ValueSlider(this.minval, this.maxval, this.density.getInterpolationScheme());
        if (this.parent instanceof FBZ) {
            this.valueSlider.setValue(((FBZ)this.parent).getFBZData().fermiEnergy);
        } else {
            this.valueSlider.setValue(this.density.getMidVal());
        }
        datapanel.add(this.valueSlider);
        this.ontheFly = new JCheckBox("render on the fly");
        JPanel props = new JPanel();
        props.setLayout(new BoxLayout(props, 0));
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.fill = 2;
        gc.anchor = 10;
        Node[] nds = ((ChaseTransformGroup)this.transformGroup).getChildren(Isosurface.class);
        this.isosurfaces = nds != null && nds.length != 0 ? new JComboBox<Node>(nds) : new JComboBox();
        JPanel psurfs = new JPanel();
        psurfs.setLayout(new GridBagLayout());
        psurfs.add((Component)this.isosurfaces, gc);
        psurfs.setBorder(new TitledBorder("select isosurface"));
        this.transparencySelector = new TransparencySelector();
        this.colorChooser = new JButton("color");
        this.colorChooser.setBackground(this.defaultColor);
        this.normalSelector = new JComboBox<String>(new String[]{"built-in", "Java3D"});
        JPanel pns = new JPanel();
        pns.setLayout(new GridBagLayout());
        pns.setBorder(new TitledBorder("normal generator"));
        pns.add((Component)this.normalSelector, gc);
        props.add(psurfs);
        props.add(this.transparencySelector);
        props.add(pns);
        JPanel pcolor = new JPanel();
        pcolor.setLayout(new BoxLayout(pcolor, 0));
        JPanel pcscheme = new JPanel();
        pcscheme.setLayout(new GridBagLayout());
        pcscheme.setBorder(new TitledBorder("coloring scheme"));
        this.colorScheme = new JComboBox<String>(new String[]{"by color", "by value"});
        pcscheme.add((Component)this.colorScheme, gc);
        ColorMap[] cmaps = BaseColorMap.getSupportedColorMaps();
        if (cmaps == null || cmaps.length == 0) {
            this.logger.error((Object)"corrupted colormap file!!!");
        }
        JPanel pcmapall = new JPanel();
        pcmapall.setLayout(new BoxLayout(pcmapall, 1));
        this.colorMaps = new JComboBox<ColorMap>(cmaps);
        JPanel pcmaps = new JPanel();
        pcmaps.setBorder(new TitledBorder("color map"));
        pcmaps.add(this.colorMaps);
        this.invert = new JCheckBox("invert");
        this.colorbar = new JToggleButton("colorbar");
        pcmaps.add(this.invert);
        pcmaps.add(this.colorbar);
        pcmapall.add(pcmaps);
        JPanel pcmaptext = new JPanel();
        pcmaptext.setLayout(new BoxLayout(pcmaptext, 0));
        JPanel minpanel = new JPanel();
        minpanel.setBorder(new TitledBorder("min"));
        JPanel maxpanel = new JPanel();
        maxpanel.setBorder(new TitledBorder("max"));
        float tmpmin = this.minval;
        float tmpmax = this.maxval;
        this.minText = new JTextField(7);
        this.minText.setText(String.valueOf(tmpmin));
        this.maxText = new JTextField(7);
        this.maxText.setText(String.valueOf(tmpmax));
        minpanel.add(this.minText);
        maxpanel.add(this.maxText);
        pcmaptext.add(minpanel);
        pcmaptext.add(maxpanel);
        pcmapall.add(pcmaptext);
        pcolor.add(pcscheme);
        pcolor.add(pcmapall);
        pcolor.add(this.colorChooser);
        this.pall.add(datapanel);
        this.pall.add(props);
        this.pall.add(pcolor);
        JButton apply = new JButton("apply");
        JButton add = new JButton("add");
        JButton remove = new JButton("remove");
        JButton close = new JButton("close");
        JPanel button = new JPanel();
        button.setLayout(new BoxLayout(button, 0));
        button.add(this.ontheFly);
        button.add(apply);
        button.add(add);
        button.add(remove);
        button.add(close);
        this.pall.add(button);
        container.add(this.pall);
        if (this.densities != null) {
            int i = 0;
            while (i < this.densities.length) {
                this.dataSelector.addItem(this.densities[i]);
                ++i;
            }
            this.dataSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean valchanged = true;
                    try {
                        if (IsosurfacePanel.this.density.getMidVal() == IsosurfacePanel.this.valueSlider.getValue()) {
                            valchanged = false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    IsosurfacePanel.this.density = (VolumetricData)IsosurfacePanel.this.dataSelector.getSelectedItem();
                    if (IsosurfacePanel.this.titledBorder != null) {
                        IsosurfacePanel.this.titledBorder.setTitle(IsosurfacePanel.this.density.toString());
                        IsosurfacePanel.this.pall.repaint();
                    }
                    IsosurfacePanel.this.valueSlider.setMinMax(IsosurfacePanel.this.density.getMinVal(), IsosurfacePanel.this.density.getMaxVal());
                    if (IsosurfacePanel.this.parent instanceof MainPanel && !valchanged) {
                        float mid = IsosurfacePanel.this.density.getMidVal();
                        IsosurfacePanel.this.valueSlider.setValue(mid);
                    }
                }
            });
        }
        this.isosurfaces.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = IsosurfacePanel.this.isosurfaces.getSelectedItem();
                if (obj != null) {
                    IsosurfacePanel.this.valueSlider.setValue(((Isosurface)obj).getValue());
                }
                IsosurfacePanel.this.updateGUI();
            }
        });
        this.valueSlider.addValueSliderListener(new ValueSliderListener(){

            @Override
            public void valueSliderValueChanged() {
                if (!IsosurfacePanel.this.ontheFly.isSelected()) {
                    return;
                }
                IsosurfacePanel.this.applyChanges(false);
                if (IsosurfacePanel.this.colorScheme.getSelectedIndex() == 1) {
                    IsosurfacePanel.this.updateAllIsoSurfaces();
                    IsosurfacePanel.this.updateColorBar();
                }
            }
        });
        this.ontheFly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!IsosurfacePanel.this.ontheFly.isSelected()) {
                    return;
                }
                IsosurfacePanel.this.applyChanges(false);
                if (IsosurfacePanel.this.colorScheme.getSelectedIndex() == 1) {
                    IsosurfacePanel.this.updateAllIsoSurfaces();
                    IsosurfacePanel.this.updateColorBar();
                }
            }
        });
        this.colorScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!IsosurfacePanel.this.ontheFly.isSelected()) {
                    return;
                }
                IsosurfacePanel.this.applyChanges(false);
                if (IsosurfacePanel.this.colorScheme.getSelectedIndex() == 1) {
                    IsosurfacePanel.this.updateAllIsoSurfaces();
                    IsosurfacePanel.this.updateColorBar();
                }
            }
        });
        this.transparencySelector.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (!IsosurfacePanel.this.ontheFly.isSelected()) {
                    return;
                }
                IsosurfacePanel.this.applyChanges(false);
                if (IsosurfacePanel.this.colorScheme.getSelectedIndex() == 1) {
                    IsosurfacePanel.this.updateAllIsoSurfaces();
                    IsosurfacePanel.this.updateColorBar();
                }
            }
        });
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IsosurfacePanel.this.applyChanges();
                if (IsosurfacePanel.this.colorScheme.getSelectedIndex() == 1) {
                    IsosurfacePanel.this.updateAllIsoSurfaces();
                    IsosurfacePanel.this.updateColorBar();
                }
            }
        });
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IsosurfacePanel.this.addIsosurface();
            }
        });
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IsosurfacePanel.this.removeIsosurface();
            }
        });
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IsosurfacePanel.this.dispose();
            }
        });
        this.colorChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JColorChooser colorchooser = new JColorChooser();
                Color col = IsosurfacePanel.this.colorChooser.getBackground();
                Color color = JColorChooser.showDialog(IsosurfacePanel.this.parent, "Choose", col);
                if (color != null) {
                    IsosurfacePanel.this.colorChooser.setBackground(color);
                }
            }
        });
        this.colorbar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (IsosurfacePanel.this.colorbar.isSelected()) {
                    IsosurfacePanel.this.drawColorBar();
                } else {
                    IsosurfacePanel.this.removeColorBar();
                }
            }
        });
        this.invert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IsosurfacePanel.this.updateColorBar();
                IsosurfacePanel.this.updateAllIsoSurfaces();
            }
        });
        this.colorMaps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IsosurfacePanel.this.updateColorBar();
                IsosurfacePanel.this.updateAllIsoSurfaces();
            }
        });
        this.colorScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (IsosurfacePanel.this.colorScheme.getSelectedIndex() == 0) {
                    IsosurfacePanel.this.colorMaps.setEnabled(false);
                    IsosurfacePanel.this.minText.setEnabled(false);
                    IsosurfacePanel.this.maxText.setEnabled(false);
                    IsosurfacePanel.this.colorbar.setSelected(false);
                    IsosurfacePanel.this.colorbar.setEnabled(false);
                    IsosurfacePanel.this.removeColorBar();
                    IsosurfacePanel.this.colorChooser.setEnabled(true);
                } else if (IsosurfacePanel.this.colorScheme.getSelectedIndex() == 1) {
                    IsosurfacePanel.this.colorMaps.setEnabled(true);
                    IsosurfacePanel.this.minText.setEnabled(true);
                    IsosurfacePanel.this.maxText.setEnabled(true);
                    IsosurfacePanel.this.colorbar.setEnabled(true);
                    IsosurfacePanel.this.colorChooser.setEnabled(false);
                }
            }
        });
        this.colorScheme.setSelectedIndex(0);
        if (this.density != null && this.density.getMode() == VolumetricData.MOLECULAR_ORBITAL) {
            this.colorScheme.setSelectedIndex(1);
        }
    }

    private float[] getMinMaxVal() {
        float tmpmin = this.minval;
        float tmpmax = this.maxval;
        try {
            tmpmin = Float.parseFloat(this.minText.getText().trim());
            tmpmax = Float.parseFloat(this.maxText.getText().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new float[]{tmpmin, tmpmax};
    }

    private void drawColorBar() {
        this.removeColorBar();
        ColorMap map = (ColorMap)this.colorMaps.getSelectedItem();
        boolean b = this.invert.isSelected();
        try {
            float[] minmax = this.getMinMaxVal();
            this.bar = new ColorBar(map, b, new Float(minmax[0]), new Float(minmax[1]), this.parent);
            this.bar.setInterpolationMode(this.parent.getAssociatedVolumetricData()[0].getInterpolationScheme());
            this.bar.create();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.parent.getRootBranch().addChild((Node)this.bar);
        this.logger.debug((Object)"colorbar added.");
    }

    private void updateColorBar() {
        if (this.bar != null) {
            ColorMap map = (ColorMap)this.colorMaps.getSelectedItem();
            boolean b = this.invert.isSelected();
            float[] minmax = this.getMinMaxVal();
            this.bar.recreate(map, b, new Float(minmax[0]), new Float(minmax[1]));
        }
    }

    private void removeColorBar() {
        if (this.bar != null) {
            this.bar.detach();
        }
    }

    private void updateAllIsoSurfaces() {
        int n = this.isosurfaces.getItemCount();
        int i = 0;
        while (i < n) {
            Isosurface surf = (Isosurface)this.isosurfaces.getItemAt(i);
            Color3f c3f = this.getColor(surf.getValue());
            surf.setColor(c3f);
            surf.createIsoSurface();
            ++i;
        }
        this.updateGUI();
    }

    private Color3f getColor(float value) {
        if (this.colorScheme.getSelectedIndex() == 0) {
            Color c = this.colorChooser.getBackground();
            return new Color3f((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
        }
        if (this.colorScheme.getSelectedIndex() == 1) {
            double tmpmin = this.minval;
            double tmpmax = this.maxval;
            try {
                tmpmin = Double.parseDouble(this.minText.getText().trim());
                tmpmax = Double.parseDouble(this.maxText.getText().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            double d = BaseColorMap.getLogScaledValue(tmpmin, tmpmax, value);
            ColorMap map = (ColorMap)this.colorMaps.getSelectedItem();
            boolean b = this.invert.isSelected();
            return map.getColor3f((float)d, b);
        }
        return null;
    }

    private void applyChanges() {
        this.applyChanges(true);
    }

    private void applyChanges(boolean gui_mo) {
        Object obj = this.isosurfaces.getSelectedItem();
        if (obj == null) {
            this.addIsosurface();
            return;
        }
        Isosurface surf = (Isosurface)obj;
        this.updateIsoSurface(surf);
        if (gui_mo) {
            this.updateGUI();
        }
    }

    private void updateIsoSurface(Isosurface surf) {
        float val = this.valueSlider.getValue();
        Color3f c3f = this.getColor(val);
        surf.setColor(c3f);
        float trans = this.transparencySelector.getTransparency();
        surf.setValue(val);
        surf.setTransparency(trans);
        surf.setNormalGenerator(this.normalSelector.getSelectedIndex());
        surf.createIsoSurface();
    }

    private void addIsosurface() {
        try {
            float val = this.valueSlider.getValue();
            if (this.density == null) {
                this.logger.info((Object)"no volumetric data allocated.");
                return;
            }
            Color3f c3f = this.getColor(val);
            float trans = this.transparencySelector.getTransparency();
            Isosurface surf = new Isosurface(this.parent, this.density, c3f, val, trans, this.isosurfaces.getItemCount());
            surf.setChargeID(this.dataSelector.getSelectedIndex());
            if (this.parent instanceof FBZ) {
                surf.setClippingPlane(((FBZ)this.parent).getFBZ().getPlanes());
            }
            surf.setNormalGenerator(this.normalSelector.getSelectedIndex());
            surf.createIsoSurface();
            this.isosurfaces.addItem(surf);
            this.isosurfaces.setSelectedItem(surf);
            this.transformGroup.addChild((Node)surf);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.updateGUI();
    }

    private void removeIsosurface() {
        Object obj = this.isosurfaces.getSelectedItem();
        if (obj == null) {
            this.logger.info((Object)"no isosurface selected");
            return;
        }
        try {
            Isosurface surf = (Isosurface)obj;
            surf.detach();
            this.isosurfaces.removeItem(surf);
            this.updateGUI();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void updateGUI() {
        int i = 0;
        while (i < this.isosurfaces.getItemCount()) {
            Isosurface surf = (Isosurface)this.isosurfaces.getItemAt(i);
            surf.setID(i);
            ++i;
        }
        Object o = this.isosurfaces.getSelectedItem();
        if (o != null) {
            Color3f c = ((Isosurface)o).getColor();
            this.colorChooser.setBackground(new Color(c.x, c.y, c.z));
            this.transparencySelector.setTransparency(((Isosurface)o).getTransparency());
            this.valueSlider.setValue(((Isosurface)o).getValue());
            this.normalSelector.setSelectedIndex(((Isosurface)o).getNormalGenerator());
        }
    }

    @Override
    public void configDataUpdate(boolean rescaleOnUpdate, ConfigDataUpdateEvent e) {
        this.transformGroup = this.parent.getRootTransform();
        this.densities = this.parent.getAssociatedVolumetricData();
        this.getContentPane().removeAll();
        this.init();
        this.updateGUI();
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }

    @Override
    public void configDataUpdate() {
    }
}

