/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.chargedensity;

import Jama.Matrix;
import ciss.phase_viewer.acviewer.ChaseTransformGroup;
import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.colormap.ColorMap;
import ciss.phase_viewer.acviewer.colormap.ColorMapChangeEvent;
import ciss.phase_viewer.acviewer.colormap.ColorMapChangeListener;
import ciss.phase_viewer.acviewer.colormap.ColorMapPanel;
import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.acviewer.geom.Plane;
import ciss.phase_viewer.acviewer.scenegraphelements.Contour;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.primitiveguis.TransparencySelector;
import ciss.phase_viewer.primitiveguis.ValueSlider;
import ciss.phase_viewer.primitiveguis.ValueSliderListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

public class ContourPanel
extends InternalFrameChase
implements ColorMapChangeListener,
ValueSliderListener,
ConfigData {
    private Logger logger = Logger.getLogger((String)ContourPanel.class.getName());
    private J3DPanel parent;
    private float[][] bounds;
    private double lenmax;
    private double[] jusin;
    private JTextField textNormalX;
    private JTextField textNormalY;
    private JTextField textNormalZ;
    private JTextField textRotX;
    private JTextField textRotY;
    private JTextField textRotZ;
    private ValueSlider vsliderRotX;
    private ValueSlider vsliderRotY;
    private JComboBox planeSelector;
    private String[] planes = new String[]{"xy", "xz", "yz"};
    private JButton initRot;
    private ValueSlider sliderCenterX;
    private ValueSlider sliderCenterY;
    private ValueSlider sliderCenterZ;
    private JPanel centerPanel;
    private JButton btnColorBar;
    private JComboBox dataCombo;
    private JComboBox comboContour;
    private MyComboBoxModel comboContourModel;
    private JTextField textMin;
    private JTextField textMax;
    private DecimalFormat formexp = new DecimalFormat("0.00E0");
    private GuidePlane guidePlane;
    private TransparencySelector transp;
    private JCheckBox ontheFly;
    private float[] origin;
    private ColorMapPanel colorBarPanel;
    private DecimalFormat decform = new DecimalFormat("0.000");
    private double prevx = 0.0;
    private double prevy = 0.0;
    private boolean dontShow = false;

    public ContourPanel(J3DPanel parent) {
        super("contour panel", new Dimension(450, 550));
        this.parent = parent;
        parent.addDisposeOnExit(this);
        if (parent instanceof MainPanel) {
            ((CoordsViewerInterface)((Object)parent)).getCD().register(this);
        }
        this.bounds = ((ChaseTransformGroup)parent.getRootTransform()).getEffectiveBounds();
        this.init();
        this.setVisible(true);
    }

    private void updateCenterPanel() {
        this.sliderCenterX.setMinMax(0.0f, (this.bounds[0][0] + this.bounds[0][1] + this.bounds[0][2]) * (float)this.lenmax);
        this.sliderCenterY.setMinMax(0.0f, (this.bounds[1][0] + this.bounds[1][1] + this.bounds[1][2]) * (float)this.lenmax);
        this.sliderCenterZ.setMinMax(0.0f, (this.bounds[2][0] + this.bounds[2][1] + this.bounds[2][2]) * (float)this.lenmax);
    }

    private void init() {
        VolumetricData[] vdata = this.parent.getAssociatedVolumetricData();
        this.origin = vdata[0].getOrigin();
        this.logger.debug((Object)("origin: " + this.origin[0] + ", " + this.origin[1] + ", " + this.origin[2]));
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel planepanel = this.createPlanePanel();
        JPanel apppanel = this.createAppearancePanel();
        JPanel pa = new JPanel();
        pa.setLayout(new BorderLayout());
        pa.add((Component)apppanel, "North");
        tabbedPane.addTab("plane", planepanel);
        tabbedPane.addTab("appearance", pa);
        this.dataCombo = new JComboBox();
        int i = 0;
        while (i < vdata.length) {
            this.dataCombo.addItem(vdata[i]);
            ++i;
        }
        JPanel pdataCombo = new JPanel();
        pdataCombo.setBorder(new TitledBorder("data"));
        pdataCombo.add(this.dataCombo);
        JPanel pcomboContour = new JPanel();
        pcomboContour.setBorder(new TitledBorder("plane"));
        this.comboContourModel = new MyComboBoxModel();
        this.comboContour = new JComboBox(this.comboContourModel);
        ChaseTransformGroup tgroup = (ChaseTransformGroup)this.parent.getRootTransform();
        Node[] cdc = tgroup.getChildren(Contour.class);
        if (cdc != null && cdc.length != 0) {
            int i2 = 0;
            while (i2 < cdc.length) {
                this.comboContour.addItem(cdc[i2]);
                ++i2;
            }
        }
        pcomboContour.add(this.comboContour);
        this.ontheFly = new JCheckBox("render on the fly");
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, 0));
        pp.add(pcomboContour);
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(pdataCombo);
        pane.add(pp);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel btnPanel = new JPanel();
        JButton apply = new JButton("apply");
        JButton add = new JButton("add");
        JButton remove = new JButton("remove");
        JButton close = new JButton("close");
        btnPanel.add(this.ontheFly);
        btnPanel.add(apply);
        btnPanel.add(add);
        btnPanel.add(remove);
        btnPanel.add(close);
        container.add((Component)pane, "North");
        container.add((Component)tabbedPane, "Center");
        container.add((Component)btnPanel, "South");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContourPanel.this.removeGuidePlane();
                ContourPanel.this.dispose();
            }
        });
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContourPanel.this.recreateContour();
                ContourPanel.this.removeGuidePlane();
            }
        });
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContourPanel.this.drawContour();
                ContourPanel.this.removeGuidePlane();
            }
        });
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContourPanel.this.removeContour();
                ContourPanel.this.removeGuidePlane();
            }
        });
        this.comboContour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContourPanel.this.updateGUI();
                ContourPanel.this.removeGuidePlane();
            }
        });
        this.ontheFly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ContourPanel.this.guidePlane != null) {
                    if (ContourPanel.this.ontheFly.isSelected()) {
                        ContourPanel.this.guidePlane.setTransparency(1.0f);
                        ContourPanel.this.recreateContour();
                    } else {
                        ContourPanel.this.guidePlane.resetTransparency();
                    }
                }
            }
        });
        this.updateGUI();
    }

    private void removeGuidePlane() {
        if (this.guidePlane != null) {
            this.guidePlane.removeGuidePlane();
        }
    }

    private void setCOMAndLenMax() {
        this.setCOMAndLenMax(true);
    }

    private void setCOMAndLenMax(boolean check) {
        this.lenmax = 1.0;
        if (this.jusin == null) {
            this.jusin = new double[3];
            int i = 0;
            while (i < 3) {
                this.jusin[i] = 0.0;
                ++i;
            }
        }
        if (this.parent instanceof MainPanel) {
            TGAtom tgatom = (TGAtom)this.parent.getRootTransform();
            double[] jusin_buff = tgatom.getJusin();
            this.lenmax = tgatom.getLenMax();
            boolean comChanged = false;
            int i = 0;
            while (i < 3) {
                if (jusin_buff[i] != this.jusin[i]) {
                    comChanged = true;
                }
                ++i;
            }
            if (!check) {
                this.jusin = jusin_buff;
                return;
            }
            this.logger.debug((Object)("jusin : " + this.jusin[0] + ", " + this.jusin[1] + ", " + this.jusin[2]));
            this.logger.debug((Object)("jusin_buff : " + jusin_buff[0] + ", " + jusin_buff[1] + ", " + jusin_buff[2]));
            if (comChanged) {
                double[] diff = new double[3];
                int i2 = 0;
                while (i2 < 3) {
                    diff[i2] = this.jusin[i2] - jusin_buff[i2];
                    this.jusin[i2] = jusin_buff[i2];
                    ++i2;
                }
                if (this.guidePlane != null) {
                    Point3f orig = this.guidePlane.getOrigin();
                    orig.x += (float)(diff[0] / this.lenmax);
                    orig.y += (float)(diff[1] / this.lenmax);
                    orig.z += (float)(diff[2] / this.lenmax);
                    this.guidePlane.setOrigin(orig);
                }
            }
            this.logger.debug((Object)("lenmax: " + this.lenmax));
            this.logger.debug((Object)("jusin: " + this.jusin[0] + " " + this.jusin[1] + " " + this.jusin[2]));
        } else {
            float[] tmp = new float[3];
            if (this.dataCombo != null && this.dataCombo.getSelectedIndex() >= 0) {
                tmp = ((VolumetricData)this.dataCombo.getSelectedItem()).getOrigin();
                int i = 0;
                while (i < tmp.length) {
                    this.jusin[i] = tmp[i];
                    ++i;
                }
            }
        }
    }

    private JPanel createPlanePanel() {
        this.setCOMAndLenMax(false);
        this.bounds = ((ChaseTransformGroup)this.parent.getRootTransform()).getEffectiveBounds();
        float sizex = (float)Math.sqrt(Math.pow(this.bounds[0][0], 2.0) + Math.pow(this.bounds[1][0], 2.0) + Math.pow(this.bounds[2][0], 2.0));
        float sizey = (float)Math.sqrt(Math.pow(this.bounds[0][1], 2.0) + Math.pow(this.bounds[1][1], 2.0) + Math.pow(this.bounds[2][1], 2.0));
        this.logger.debug((Object)("effective bounds: " + sizex + ", " + sizey));
        if (this.guidePlane == null) {
            this.guidePlane = new GuidePlane(this.parent.getRootTransform(), sizex, sizey);
        }
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 0));
        JPanel normalPanel = new JPanel();
        normalPanel.setLayout(new BoxLayout(normalPanel, 0));
        normalPanel.setBorder(new TitledBorder("normal vector of plane"));
        JPanel tnx = new JPanel();
        tnx.setBorder(new TitledBorder("x"));
        this.textNormalX = new JTextField(10);
        this.textNormalX.setText("0.0");
        tnx.add(this.textNormalX);
        JPanel tny = new JPanel();
        tny.setBorder(new TitledBorder("y"));
        this.textNormalY = new JTextField(10);
        this.textNormalY.setText("0.0");
        tny.add(this.textNormalY);
        JPanel tnz = new JPanel();
        tnz.setBorder(new TitledBorder("z"));
        this.textNormalZ = new JTextField(10);
        tnz.add(this.textNormalZ);
        this.textNormalZ.setText("1.0");
        normalPanel.add(tnx);
        normalPanel.add(tny);
        normalPanel.add(tnz);
        JPanel rotPanel = new JPanel();
        rotPanel.setLayout(new BoxLayout(rotPanel, 1));
        rotPanel.setBorder(new TitledBorder("rotation (degrees)"));
        RotListener rlistener = new RotListener();
        this.vsliderRotX = new ValueSlider(-180, 180);
        this.vsliderRotX.setTitleForBorder("around axis1");
        this.vsliderRotX.setOrientation(ValueSlider.HORIZONTAL);
        this.vsliderRotX.addValueSliderListener(rlistener);
        this.vsliderRotY = new ValueSlider(-180, 180);
        this.vsliderRotY.setTitleForBorder("around axis2");
        this.vsliderRotY.setOrientation(ValueSlider.HORIZONTAL);
        this.vsliderRotY.addValueSliderListener(rlistener);
        this.planeSelector = new JComboBox<String>(this.planes);
        this.initRot = new JButton("init rotation");
        JPanel pplane = new JPanel();
        pplane.setBorder(new TitledBorder(""));
        pplane.add(this.initRot);
        rotPanel.add(pplane);
        rotPanel.add(this.vsliderRotX);
        rotPanel.add(this.vsliderRotY);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.centerPanel.setBorder(new TitledBorder("origin"));
        int i = 0;
        while (i < 3) {
            this.logger.debug((Object)("cell : " + this.bounds[i][0] + " " + this.bounds[i][1] + " " + this.bounds[i][2]));
            ++i;
        }
        JPanel norpanel = new JPanel();
        norpanel.setLayout(new BorderLayout());
        norpanel.add((Component)normalPanel, "North");
        norpanel.add((Component)rotPanel, "Center");
        JTabbedPane tp = new JTabbedPane();
        tp.addTab("direction", norpanel);
        tp.addTab("origin", this.centerPanel);
        ret.add(tp);
        float boundmax1 = this.bounds[0][0] + this.bounds[0][1] + this.bounds[0][2] - this.origin[0];
        float boundmax2 = this.bounds[1][0] + this.bounds[1][1] + this.bounds[1][2] - this.origin[1];
        float boundmax3 = this.bounds[2][0] + this.bounds[2][1] + this.bounds[2][2] - this.origin[2];
        this.sliderCenterX = new ValueSlider(0.0f, boundmax1 * (float)this.lenmax);
        this.sliderCenterX.setTitleForBorder("axis 1");
        this.sliderCenterX.setOrientation(ValueSlider.HORIZONTAL);
        this.sliderCenterX.addValueSliderListener(this);
        this.sliderCenterY = new ValueSlider(0.0f, boundmax2 * (float)this.lenmax);
        this.sliderCenterY.setTitleForBorder("axis 2");
        this.sliderCenterY.setOrientation(ValueSlider.HORIZONTAL);
        this.sliderCenterY.addValueSliderListener(this);
        this.sliderCenterZ = new ValueSlider(0.0f, boundmax3 * (float)this.lenmax);
        this.sliderCenterZ.setOrientation(ValueSlider.HORIZONTAL);
        this.sliderCenterZ.setTitleForBorder("axis 3");
        this.sliderCenterZ.addValueSliderListener(this);
        JPanel xpanel = new JPanel();
        xpanel.add(this.sliderCenterX);
        JPanel ypanel = new JPanel();
        ypanel.add(this.sliderCenterY);
        JPanel zpanel = new JPanel();
        zpanel.add(this.sliderCenterZ);
        this.centerPanel.add(xpanel);
        this.centerPanel.add(ypanel);
        this.centerPanel.add(zpanel);
        CaretListener clist = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                ContourPanel.this.updateGuidePlaneFromNormal();
            }
        };
        this.textNormalX.addCaretListener(clist);
        this.textNormalY.addCaretListener(clist);
        this.textNormalZ.addCaretListener(clist);
        this.initRot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContourPanel.this.vsliderRotX.setValue(0.0f);
                ContourPanel.this.vsliderRotY.setValue(0.0f);
                ContourPanel.this.prevx = 0.0;
                ContourPanel.this.prevy = 0.0;
                ContourPanel.this.textNormalX.setText("0.0");
                ContourPanel.this.textNormalY.setText("0.0");
                ContourPanel.this.textNormalZ.setText("1.0");
                ContourPanel.this.updateGuidePlaneFromNormal();
                ContourPanel.this.recreateContour();
                ContourPanel.this.removeGuidePlane();
            }
        });
        return ret;
    }

    private JPanel createAppearancePanel() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 1));
        JPanel pminmax = new JPanel();
        pminmax.setLayout(new BoxLayout(pminmax, 0));
        this.textMin = new JTextField(10);
        this.textMax = new JTextField(10);
        float minv = this.parent.getAssociatedVolumetricData()[0].getMinVal();
        float maxv = this.parent.getAssociatedVolumetricData()[0].getMaxVal();
        this.setTitle(String.valueOf(this.getTitle()) + " min: " + this.formexp.format(minv) + ", max: " + this.formexp.format(maxv));
        this.textMin.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                try {
                    float min = Float.parseFloat(ContourPanel.this.textMin.getText().trim());
                    ContourPanel.this.colorBarPanel.setMinVal(min);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.textMax.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                try {
                    float max = Float.parseFloat(ContourPanel.this.textMax.getText().trim());
                    ContourPanel.this.colorBarPanel.setMaxVal(max);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JPanel pmin = new JPanel();
        pmin.setBorder(new TitledBorder("min"));
        pmin.add(this.textMin);
        JPanel pmax = new JPanel();
        pmax.setBorder(new TitledBorder("max"));
        pmax.add(this.textMax);
        pminmax.add(pmin);
        pminmax.add(pmax);
        JPanel ptrans = new JPanel();
        ptrans.setLayout(new BoxLayout(ptrans, 0));
        this.transp = new TransparencySelector();
        ptrans.add(this.transp);
        this.transp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (ContourPanel.this.ontheFly.isSelected()) {
                    ContourPanel.this.recreateContour();
                }
            }
        });
        this.colorBarPanel = new ColorMapPanel(this.parent);
        this.colorBarPanel.setLayout(new BoxLayout(this.colorBarPanel, 1));
        this.colorBarPanel.addColorBarChangeListener(this);
        ret.add(pminmax);
        ret.add(ptrans);
        ret.add(this.colorBarPanel);
        this.textMin.setText(String.valueOf(minv));
        this.textMax.setText(String.valueOf(maxv));
        this.textMin.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent arg0) {
                if (!ContourPanel.this.ontheFly.isSelected()) {
                    return;
                }
                ContourPanel.this.recreateContour();
            }
        });
        this.textMax.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent arg0) {
                if (!ContourPanel.this.ontheFly.isSelected()) {
                    return;
                }
                ContourPanel.this.recreateContour();
            }
        });
        return ret;
    }

    private Point3f getPos() {
        Point3f center = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f center_tmp = new Point3f();
        center_tmp.x = this.sliderCenterX.getValue() / (this.bounds[0][0] + this.bounds[0][1] + this.bounds[0][2]);
        center_tmp.y = this.sliderCenterY.getValue() / (this.bounds[1][0] + this.bounds[1][1] + this.bounds[1][2]);
        center_tmp.z = this.sliderCenterZ.getValue() / (this.bounds[2][0] + this.bounds[2][1] + this.bounds[2][2]);
        center.x = (center_tmp.x * this.bounds[0][0] + center_tmp.y * this.bounds[1][0] + center_tmp.z * this.bounds[2][0] - (float)this.jusin[0]) / (float)this.lenmax;
        center.y = (center_tmp.x * this.bounds[0][1] + center_tmp.y * this.bounds[1][1] + center_tmp.z * this.bounds[2][1] - (float)this.jusin[1]) / (float)this.lenmax;
        center.z = (center_tmp.x * this.bounds[0][2] + center_tmp.y * this.bounds[1][2] + center_tmp.z * this.bounds[2][2] - (float)this.jusin[2]) / (float)this.lenmax;
        return center;
    }

    private Point3f getPos(Point3f pos) {
        Point3f ret = new Point3f();
        Point3f tmppos = new Point3f(pos);
        tmppos.x /= this.bounds[0][0] + this.bounds[0][1] + this.bounds[0][2];
        tmppos.y /= this.bounds[1][0] + this.bounds[1][1] + this.bounds[1][2];
        tmppos.z /= this.bounds[2][0] + this.bounds[2][1] + this.bounds[2][2];
        ret.x = (tmppos.x * this.bounds[0][0] + tmppos.y * this.bounds[1][0] + tmppos.z * this.bounds[2][0] - (float)this.jusin[0]) / (float)this.lenmax;
        ret.y = (tmppos.x * this.bounds[0][1] + tmppos.y * this.bounds[1][1] + tmppos.z * this.bounds[2][1] - (float)this.jusin[1]) / (float)this.lenmax;
        ret.z = (tmppos.x * this.bounds[0][2] + tmppos.y * this.bounds[1][2] + tmppos.z * this.bounds[2][2] - (float)this.jusin[2]) / (float)this.lenmax;
        return ret;
    }

    private Point3f getPosRealCoords(Point3f j3dPos) {
        Point3f ret = new Point3f();
        double[][] tmpbound = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                tmpbound[i][j] = this.bounds[j][i];
                ++j;
            }
            ++i;
        }
        double[][] tmppos = new double[3][1];
        tmppos[0][0] = (double)j3dPos.x * this.lenmax + this.jusin[0];
        tmppos[1][0] = (double)j3dPos.y * this.lenmax + this.jusin[1];
        tmppos[2][0] = (double)j3dPos.z * this.lenmax + this.jusin[2];
        Matrix A = new Matrix(tmpbound);
        Matrix P = new Matrix(tmppos);
        Matrix B = A.solve(P);
        ret.x = (float)B.get(0, 0) * (this.bounds[0][0] + this.bounds[0][1] + this.bounds[0][2]);
        ret.y = (float)B.get(1, 0) * (this.bounds[1][0] + this.bounds[1][1] + this.bounds[1][2]);
        ret.z = (float)B.get(2, 0) * (this.bounds[2][0] + this.bounds[2][1] + this.bounds[2][2]);
        return ret;
    }

    private Point3f getNorm() {
        String x = this.textNormalX.getText();
        String y = this.textNormalY.getText();
        String z = this.textNormalZ.getText();
        try {
            return new Point3f(Float.parseFloat(x.trim()), Float.parseFloat(y.trim()), Float.parseFloat(z.trim()));
        }
        catch (Exception exc) {
            return null;
        }
    }

    private void setContourParameters(Contour contour) {
        Point3f center = this.guidePlane.getOrigin();
        Point3f normal = this.guidePlane.getNormalVector();
        Float min = null;
        Float max = null;
        try {
            min = new Float(this.textMin.getText().trim());
            max = new Float(this.textMax.getText().trim());
        }
        catch (NumberFormatException nfe) {
            return;
        }
        float trans = this.transp.getTransparency();
        int transmode = 2;
        ColorMap map = this.colorBarPanel.getSelectedColorMap();
        boolean b = this.colorBarPanel.isInvert();
        contour.setNormalVector(normal);
        contour.setMinMax(min, max);
        contour.setOrigin(center);
        contour.setTransparency(trans);
        contour.setTransparencyMode(transmode);
        contour.setColorMap(map);
        contour.setInvert(b);
    }

    private void recreateContour() {
        try {
            this.setCOMAndLenMax();
            if (this.comboContourModel.getSize() == 0) {
                this.drawContour();
                return;
            }
            Contour contour = (Contour)this.comboContourModel.getSelectedItem();
            if (contour == null) {
                this.logger.error((Object)"contour is null!!!!");
            }
            this.setContourParameters(contour);
            contour.recreateContour();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void drawContour() {
        this.setCOMAndLenMax();
        int count = this.comboContour.getItemCount();
        Contour contour = null;
        contour = new Contour(this.parent, (VolumetricData)this.dataCombo.getSelectedItem(), this.lenmax, this.jusin);
        if (this.parent instanceof FBZ) {
            contour.setClippingPlane(((FBZ)this.parent).getFBZ().getPlanes());
        }
        contour.setID(count + 1);
        contour.setChargeID(this.dataCombo.getSelectedIndex());
        this.setContourParameters(contour);
        this.setCOMAndLenMax();
        contour.createContour();
        TransformGroup tg = this.parent.getRootTransform();
        tg.addChild((Node)contour);
        this.comboContourModel.addElement(contour);
        this.updateGUI();
    }

    private void removeContour() {
        if (this.comboContour.getSelectedIndex() < 0) {
            return;
        }
        int oldind = this.comboContour.getSelectedIndex();
        try {
            Object obj = this.comboContour.getSelectedItem();
            this.comboContourModel.removeElementAt(oldind);
            if (obj != null) {
                ((BranchGroup)obj).detach();
            }
            int i = 0;
            while (i < this.comboContourModel.getSize()) {
                Object ob = this.comboContourModel.getElementAt(i);
                ((Contour)ob).setID(i + 1);
                ++i;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (oldind == 0) {
            this.comboContour.setSelectedIndex(0);
        } else {
            this.comboContour.setSelectedIndex(oldind - 1);
        }
    }

    private void updateGUI() {
        if (this.comboContourModel.getSize() <= 0) {
            return;
        }
        this.dontShow = true;
        this.setCOMAndLenMax();
        Contour contour = (Contour)this.comboContour.getSelectedItem();
        if (contour == null) {
            return;
        }
        Point3f origin = contour.getOrigin();
        Point3f normal = contour.getNormalVector();
        this.textNormalX.setText(this.decform.format(normal.x));
        this.textNormalY.setText(this.decform.format(normal.y));
        this.textNormalZ.setText(this.decform.format(normal.z));
        float trans = contour.getTransparency();
        this.transp.setTransparency(trans);
        this.textMin.setText(String.valueOf(contour.getMinVal()));
        this.textMax.setText(String.valueOf(contour.getMaxVal()));
        Point3f p = this.getPosRealCoords(contour.getOrigin());
        this.sliderCenterX.setValue(p.x);
        this.sliderCenterY.setValue(p.y);
        this.sliderCenterZ.setValue(p.z);
        this.dontShow = false;
    }

    @Override
    public void colorMapChanged(ColorMapChangeEvent event) {
        ColorMap colorMap = event.getColorMap();
        if (colorMap == null) {
            return;
        }
        boolean invert = event.invert();
        Object obj = this.comboContour.getSelectedItem();
        if (obj != null) {
            Contour cont = (Contour)obj;
            cont.setColorMap(colorMap);
            this.logger.debug((Object)("invert: " + invert));
            cont.setInvert(invert);
            cont.recreateContour();
        }
    }

    @Override
    public void valueSliderValueChanged() {
        this.updateGuidePlane();
        if (this.ontheFly.isSelected()) {
            this.recreateContour();
        }
    }

    private void updateGuidePlaneFromNormal() {
        Point3f no = this.getNorm();
        if (no == null) {
            return;
        }
        this.guidePlane.setNormalVector(no);
        this.guidePlane.setOrigin(this.getPos());
        this.guidePlane.updateGuidePlane();
    }

    private void updateGuidePlane() {
        if (this.guidePlane == null) {
            this.guidePlane = new GuidePlane(this.parent.getRootTransform());
        }
        this.logger.debug((Object)"updating guide plane...");
        this.guidePlane.setOrigin(this.getPos());
        this.guidePlane.setTransformRot(this.transRot());
    }

    private Transform3D transRot() {
        double rotx = 0.0;
        double roty = 0.0;
        rotx = ((double)this.vsliderRotX.getValue() - this.prevx) * (Math.PI / 180);
        roty = ((double)this.vsliderRotY.getValue() - this.prevy) * (Math.PI / 180);
        if (rotx == 0.0 && roty == 0.0) {
            return new Transform3D();
        }
        this.prevx = this.vsliderRotX.getValue();
        this.prevy = this.vsliderRotY.getValue();
        Transform3D tx = new Transform3D();
        Transform3D ty = new Transform3D();
        if (this.planeSelector.getSelectedIndex() == 0) {
            if (rotx != 0.0) {
                tx.rotX(rotx);
            }
            if (roty != 0.0) {
                ty.rotY(roty);
            }
        } else if (this.planeSelector.getSelectedIndex() == 1) {
            if (rotx != 0.0) {
                tx.rotX(rotx);
            }
            if (roty != 0.0) {
                ty.rotZ(roty);
            }
        } else if (this.planeSelector.getSelectedIndex() == 2) {
            if (rotx != 0.0) {
                tx.rotY(rotx);
            }
            if (roty != 0.0) {
                ty.rotZ(roty);
            }
        }
        tx.mul(ty);
        return tx;
    }

    @Override
    public void configDataUpdate(boolean rescaleOnUpdate, ConfigDataUpdateEvent e) {
        this.doSurfaces(e);
    }

    private void doSurfaces(ConfigDataUpdateEvent e) {
        TransformGroup tg = this.parent.getRootTransform();
        TransformGroup gtg = this.guidePlane.getTransform();
        Point3f origCenter = this.guidePlane.getOrigin();
        Vector rorigs = new Vector();
        Vector rnorms = new Vector();
        if (e.getType() == ConfigDataUpdateEvent.CELL_CHANGED) {
            this.bounds = ((ChaseTransformGroup)this.parent.getRootTransform()).getEffectiveBounds();
            this.logger.debug((Object)("bounds0: " + this.bounds[0][0] + ", " + this.bounds[0][1] + ", " + this.bounds[0][2]));
            this.logger.debug((Object)("bounds1: " + this.bounds[1][0] + ", " + this.bounds[1][1] + ", " + this.bounds[1][2]));
            this.logger.debug((Object)("bounds2: " + this.bounds[2][0] + ", " + this.bounds[2][1] + ", " + this.bounds[2][2]));
            this.setCOMAndLenMax();
            this.updateCenterPanel();
        }
        this.guidePlane.removeGuidePlane();
        float sizex = this.bounds[0][0] + this.bounds[1][0] + this.bounds[2][0];
        float sizey = this.bounds[0][1] + this.bounds[1][1] + this.bounds[2][1];
        this.guidePlane = new GuidePlane(this.parent.getRootTransform(), sizex, sizey);
        Transform3D currtrans = new Transform3D();
        gtg.getTransform(currtrans);
        this.guidePlane.setTransform(currtrans);
        this.guidePlane.setOrigin(origCenter);
        this.guidePlane.removeGuidePlane();
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }

    @Override
    public void configDataUpdate() {
    }

    class GuidePlane
    extends Plane {
        private TransformGroup transformGroup;
        private TransformGroup tg;
        private BranchGroup guidePlane;
        private float trans = 0.7f;
        private TransparencyAttributes tattr;
        private boolean visible = false;
        private Logger logger = Logger.getLogger((String)GuidePlane.class.getName());
        private Point3f axis1 = new Point3f(1.0f, 0.0f, 0.0f);
        private Point3f axis2 = new Point3f(0.0f, 1.0f, 0.0f);
        private Point3f[] initpoints = new Point3f[]{new Point3f(1.0f, 1.0f, 0.0f), new Point3f(1.0f, -1.0f, 0.0f), new Point3f(-1.0f, -1.0f, 0.0f), new Point3f(-1.0f, 1.0f, 0.0f)};
        private Color3f color = new Color3f(0.9f, 0.9f, 0.9f);
        private Point3f jusin = new Point3f();
        private Transform3D transform = new Transform3D();
        private Transform3D transformRotX = new Transform3D();
        private Transform3D transformRotY = new Transform3D();
        private Transform3D transformRotZ = new Transform3D();

        GuidePlane(TransformGroup transformGroup) {
            this.transformGroup = transformGroup;
            this.guidePlane = new BranchGroup();
            this.guidePlane.setCapability(17);
            this.init();
        }

        GuidePlane(TransformGroup transformGroup, float sizex, float sizey) {
            this.initpoints = new Point3f[]{new Point3f(sizex, sizey, 0.0f), new Point3f(sizex, -sizey, 0.0f), new Point3f(-sizex, -sizey, 0.0f), new Point3f(-sizex, sizey, 0.0f)};
            this.transformGroup = transformGroup;
            this.guidePlane = new BranchGroup();
            this.guidePlane.setCapability(17);
            this.init();
        }

        void setJusin(Point3f jusin) {
            this.jusin = jusin;
        }

        private void init() {
            int i = 0;
            while (i < this.initpoints.length) {
                this.logger.debug((Object)("initpoints: " + this.initpoints[i]));
                ++i;
            }
            QuadArray qarray = new QuadArray(this.initpoints.length, 5);
            qarray.setCoordinates(0, this.initpoints);
            qarray.setColors(0, new Color3f[]{this.color, this.color, this.color, this.color});
            Shape3D s3d = new Shape3D();
            try {
                qarray.setCapability(18);
            }
            catch (RestrictedAccessException restrictedAccessException) {
                // empty catch block
            }
            s3d.setGeometry((Geometry)qarray);
            Appearance app = new Appearance();
            this.tattr = new TransparencyAttributes();
            this.tattr.setCapability(3);
            this.tattr.setTransparency(this.trans);
            this.tattr.setTransparencyMode(2);
            app.setTransparencyAttributes(this.tattr);
            PolygonAttributes pattr = new PolygonAttributes();
            pattr.setCullFace(0);
            pattr.setPolygonMode(2);
            pattr.setBackFaceNormalFlip(true);
            app.setPolygonAttributes(pattr);
            s3d.setAppearance(app);
            this.tg = new TransformGroup();
            this.tg.setCapability(18);
            this.tg.setCapability(17);
            this.tg.addChild((Node)s3d);
            this.guidePlane.addChild((Node)this.tg);
        }

        void setTransparency(float tran) {
            this.tattr.setTransparency(tran);
        }

        void resetTransparency() {
            this.tattr.setTransparency(this.trans);
        }

        @Override
        public Point3f getNormalVector() {
            Transform3D currtrans = new Transform3D();
            this.tg.getTransform(currtrans);
            Vector3f vnormal = new Vector3f(0.0f, 0.0f, 1.0f);
            currtrans.transform(vnormal);
            this.normal = new Point3f((Tuple3f)vnormal);
            return this.normal;
        }

        void updateGuidePlane() {
            if (!this.visible && !ContourPanel.this.dontShow) {
                this.transformGroup.addChild((Node)this.guidePlane);
                this.visible = true;
            }
            this.logger.debug((Object)("axis1 & 2 before transformation: " + this.axis1 + " " + this.axis2));
            Vector3f unit = new Vector3f((Tuple3f)this.normal);
            Vector3f uX = new Vector3f();
            Vector3f uY = new Vector3f();
            Vector3f uZ = new Vector3f();
            Transform3D rotateFix = new Transform3D();
            uZ = new Vector3f(unit);
            uX.cross(new Vector3f(0.0f, 1.0f, 0.0f), unit);
            float magX = uX.length();
            Transform3D rotateMatrix = null;
            if (magX != 0.0f) {
                uX.z /= magX;
                uX.x /= magX;
                uX.y /= magX;
                uY.cross(uZ, uX);
                rotateMatrix = new Transform3D(new Matrix4d((double)uX.x, (double)uX.y, (double)uX.z, 0.0, (double)uY.x, (double)uY.y, (double)uY.z, 0.0, (double)uZ.x, (double)uZ.y, (double)uZ.z, 0.0, 0.0, 0.0, 0.0, 1.0));
                try {
                    rotateMatrix.invert();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            } else {
                rotateMatrix = new Transform3D();
                rotateMatrix.rotX(1.5707963267948966);
            }
            rotateMatrix.transform(this.axis1);
            rotateMatrix.transform(this.axis2);
            rotateMatrix.setTranslation(new Vector3f((Tuple3f)this.origin));
            this.tg.setTransform(rotateMatrix);
            this.logger.debug((Object)("axis1 & 2 after transformation: " + this.axis1 + " " + this.axis2));
        }

        Point3f getAxis1() {
            return this.axis1;
        }

        Point3f getAxis2() {
            return this.axis2;
        }

        TransformGroup getTransform() {
            return this.tg;
        }

        void setTransform(Transform3D t3d) {
            this.tg.setTransform(t3d);
        }

        void setTransformRot(Transform3D t3d) {
            if (!this.visible) {
                this.transformGroup.addChild((Node)this.guidePlane);
                this.visible = true;
            }
            Transform3D currtrans = new Transform3D();
            this.tg.getTransform(currtrans);
            Matrix4d mat = new Matrix4d();
            currtrans.get(mat);
            currtrans.setTranslation(new Vector3d(0.0, 0.0, 0.0));
            currtrans.mul(currtrans, t3d);
            Point3f point = new Point3f(this.jusin);
            point.add((Tuple3f)this.origin);
            currtrans.setTranslation(new Vector3d((Tuple3f)point));
            this.tg.setTransform(currtrans);
            currtrans.transform(this.normal);
        }

        void removeGuidePlane() {
            this.guidePlane.detach();
            this.visible = false;
        }

        boolean isVisible() {
            return this.visible;
        }
    }

    class MyComboBoxModel
    extends DefaultComboBoxModel {
        MyComboBoxModel() {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            ContourPanel.this.logger.debug((Object)("set selected item : " + anObject));
            super.setSelectedItem(anObject);
        }
    }

    class RotListener
    implements ValueSliderListener {
        private ValueSlider vslider;

        RotListener() {
        }

        @Override
        public void valueSliderValueChanged() {
            Transform3D tx = ContourPanel.this.transRot();
            if (ContourPanel.this.guidePlane == null) {
                ContourPanel.this.guidePlane = new GuidePlane(ContourPanel.this.parent.getRootTransform());
            }
            ContourPanel.this.guidePlane.setTransformRot(tx);
            Point3f foo = ContourPanel.this.guidePlane.getNormalVector();
            CaretListener[] clis = ContourPanel.this.textNormalX.getCaretListeners();
            int i = 0;
            while (i < clis.length) {
                ContourPanel.this.textNormalX.removeCaretListener(clis[i]);
                ContourPanel.this.textNormalY.removeCaretListener(clis[i]);
                ContourPanel.this.textNormalZ.removeCaretListener(clis[i]);
                ++i;
            }
            ContourPanel.this.textNormalX.setText(String.valueOf(foo.x));
            ContourPanel.this.textNormalY.setText(String.valueOf(foo.y));
            ContourPanel.this.textNormalZ.setText(String.valueOf(foo.z));
            i = 0;
            while (i < clis.length) {
                ContourPanel.this.textNormalX.addCaretListener(clis[i]);
                ContourPanel.this.textNormalY.addCaretListener(clis[i]);
                ContourPanel.this.textNormalZ.addCaretListener(clis[i]);
                ++i;
            }
            if (ContourPanel.this.ontheFly.isSelected()) {
                ContourPanel.this.recreateContour();
            }
        }
    }
}

