/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.tools;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.ExternalProgramPanel;
import ciss.phase_viewer.common.InputPanel;
import ciss.phase_viewer.common.Utils;
import java.awt.Dimension;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class FreqPlPanel
extends ExternalProgramPanel {
    private Logger logger = Logger.getLogger((String)FreqPlPanel.class.getName());
    private String dir;
    private String modeData;
    private InputPanel width;
    private InputPanel height;
    private InputPanel nrep;
    private JCheckBox solid;
    private JCheckBox mol;
    private InputPanel ignored_modes;

    public FreqPlPanel(String dir, String modeData) {
        super("run freq.pl", new Dimension(400, 200));
        this.dir = dir;
        this.modeData = modeData;
    }

    @Override
    public JPanel createMainPanel() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 1));
        this.width = new InputPanel("width", 0, 10);
        this.height = new InputPanel("height", 0, 10);
        this.nrep = new InputPanel("nrep", 0, 10);
        this.solid = new JCheckBox("solid");
        this.mol = new JCheckBox("mol");
        this.ignored_modes = new InputPanel("ignored_modes", 0, 10);
        JPanel row1 = new JPanel();
        row1.add(this.width);
        row1.add(this.height);
        row1.add(this.nrep);
        JPanel row2 = new JPanel();
        row2.add(this.solid);
        row2.add(this.mol);
        row2.add(this.ignored_modes);
        ret.add(row1);
        ret.add(row2);
        return ret;
    }

    @Override
    public boolean createExeString() {
        String curDir = System.getProperty("user.dir");
        if (!new File(curDir).canWrite()) {
            this.logger.error((Object)"can't create tmp file ... check permission.");
            return false;
        }
        String freqpl = this.getPerlScript("freq.pl");
        String opts = "";
        String strwidth = this.width.getValue();
        String strheight = this.height.getValue();
        String strnrep = this.nrep.getValue();
        boolean bsolid = this.solid.isSelected();
        boolean bmol = this.mol.isSelected();
        String strignored = this.ignored_modes.getValue();
        if (strwidth.trim().length() != 0) {
            opts = String.valueOf(opts) + " -width=" + strwidth;
        }
        if (strheight.trim().length() != 0) {
            opts = String.valueOf(opts) + " -height=" + strheight;
        }
        if (strnrep.trim().length() != 0) {
            opts = String.valueOf(opts) + " -nrep=" + strnrep;
        }
        if (strignored.trim().length() != 0) {
            opts = String.valueOf(opts) + " -ignored_modes=" + strignored;
        }
        if (bsolid) {
            opts = String.valueOf(opts) + " -solid";
        }
        if (bmol) {
            opts = String.valueOf(opts) + " -mol";
        }
        this.exeString = String.valueOf(freqpl) + " " + opts + " " + Utils.getPathDQ(String.valueOf(this.dir) + System.getProperty("file.separator") + this.modeData);
        this.logger.debug((Object)this.exeString);
        System.out.println("exeString: " + this.exeString);
        return true;
    }

    @Override
    public void bootPostProcess() {
        String moveToPath = String.valueOf(this.dir) + this.FS + "freq.eps";
        String epspath = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "freq.eps";
        if (!epspath.trim().equalsIgnoreCase(moveToPath.trim())) {
            ExternalProgramExecuter.remove(moveToPath);
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ExternalProgramExecuter.move(epspath, moveToPath);
    }
}

