/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.tools;

import ciss.phase_viewer.common.ExternalProgramPanel;
import ciss.phase_viewer.common.InputPanel;
import ciss.phase_viewer.common.MyMessageBox;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class DosPlPanel
extends ExternalProgramPanel {
    private Logger logger = Logger.getLogger((String)DosPlPanel.class.getName());
    private String projdir;
    private String dosData;
    private JComboBox cbMode;
    private InputPanel iperangemin;
    private InputPanel iperangemax;
    private InputPanel ipdosmin;
    private InputPanel ipdosmax;
    private InputPanel ipeinc;
    private InputPanel ipdosinc;
    private JCheckBox cbwithfermi;
    private JCheckBox cbcolor;
    private InputPanel ipfont;
    private InputPanel ipwidth;
    private InputPanel iptitle;
    private String FS = System.getProperty("file.separator");
    private MyMessageBox mbox = new MyMessageBox();

    public DosPlPanel(String title) {
        super(title, new Dimension(400, 300));
    }

    public void setProjDir(String projdir) {
        this.projdir = projdir;
        this.setCurrDir(projdir);
    }

    public void setDosData(String dosData) {
        this.dosData = dosData;
    }

    @Override
    public boolean createExeString() {
        GlobalProperties pm = PropertiesManager.getGlobalProperties(0);
        String curDir = System.getProperty("user.dir");
        if (!new File(curDir).canWrite()) {
            this.mbox.setText("can't create tmp file ... check permission.");
            return false;
        }
        String dospl = new String();
        dospl = String.valueOf(System.getProperty("pviewer.home")) + this.FS + pm.getProperty("phasetoolsdir") + this.FS + "dos.pl";
        this.logger.debug((Object)("dos.pl: " + dospl));
        if (!new File(dospl).exists()) {
            this.exeString = "dos.pl";
            this.mbox.setText("could not find dos.pl");
            return false;
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            dospl = "perl.exe " + Utils.getPathDQ(dospl);
        }
        this.exeString = String.valueOf(dospl) + " " + Utils.getPathDQ(String.valueOf(this.projdir) + this.dosData) + " ";
        String mode = (String)this.cbMode.getSelectedItem();
        String dosrangemin = this.ipdosmin.getValue();
        String dosrangemax = this.ipdosmax.getValue();
        String dosinc = this.ipdosinc.getValue();
        String font = this.ipfont.getValue();
        String title = this.iptitle.getValue();
        String erangemin = this.iperangemin.getValue();
        String erangemax = this.iperangemax.getValue();
        String einc = this.ipeinc.getValue();
        boolean fermi = this.cbwithfermi.isSelected();
        boolean color = this.cbcolor.isSelected();
        String width = this.ipwidth.getValue();
        if (mode.trim().length() != 0) {
            this.exeString = String.valueOf(this.exeString) + " -mode=" + mode;
        }
        if (erangemin.trim().length() != 0 && erangemax.trim().length() != 0) {
            this.exeString = String.valueOf(this.exeString) + " -erange=" + erangemin + "," + erangemax;
        }
        if (dosrangemin.trim().length() != 0 && dosrangemax.trim().length() != 0) {
            this.exeString = String.valueOf(this.exeString) + " -dosrange=" + dosrangemin + "," + dosrangemax;
        }
        if (einc.trim().length() != 0) {
            this.exeString = String.valueOf(this.exeString) + " -einc=" + einc;
        }
        if (dosinc.trim().length() != 0) {
            this.exeString = String.valueOf(this.exeString) + " -dosinc=" + dosinc;
        }
        if (font.trim().length() != 0) {
            this.exeString = String.valueOf(this.exeString) + " -font=" + font;
        }
        if (title.trim().length() != 0) {
            this.exeString = String.valueOf(this.exeString) + " -title=" + title;
        }
        if (fermi) {
            this.exeString = String.valueOf(this.exeString) + " -with_fermi";
        }
        if (width.trim().length() != 0) {
            this.exeString = String.valueOf(this.exeString) + " -width=" + width;
        }
        if (color) {
            this.exeString = String.valueOf(this.exeString) + " -color";
        }
        this.logger.debug((Object)this.exeString);
        return true;
    }

    @Override
    public void bootPostProcess() {
    }

    @Override
    public JPanel createMainPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(3, 4));
        p.setBorder(new TitledBorder("options"));
        String[] modeString = new String[]{"total", "atom", "layer", "projected"};
        JPanel modePanel = new JPanel();
        modePanel.setBorder(new TitledBorder("mode"));
        this.cbMode = new JComboBox<String>(modeString);
        modePanel.add(this.cbMode);
        this.iperangemin = new InputPanel("erange(min)", 0, 7, true);
        this.iperangemax = new InputPanel("erange(max)", 0, 7, true);
        this.ipdosmin = new InputPanel("dosrange(min)", 0, 7, true);
        this.ipdosmax = new InputPanel("dosrange(max)", 0, 7, true);
        this.ipeinc = new InputPanel("einc", 0, 7, true);
        this.ipdosinc = new InputPanel("dosinc", 0, 7, true);
        this.cbwithfermi = new JCheckBox("with_fermi");
        this.cbcolor = new JCheckBox("color");
        this.ipwidth = new InputPanel("width", 0, 7, true);
        this.ipfont = new InputPanel("font", 0, 7, true);
        this.iptitle = new InputPanel("title", 0, 7, true);
        p.add(modePanel);
        p.add(this.ipwidth);
        p.add(this.cbwithfermi);
        p.add(this.cbcolor);
        p.add(this.iperangemin);
        p.add(this.iperangemax);
        p.add(this.ipdosmin);
        p.add(this.ipdosmax);
        p.add(this.ipeinc);
        p.add(this.ipdosinc);
        p.add(this.ipfont);
        p.add(this.iptitle);
        return p;
    }
}

