/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.parsers;

import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class NfEnfParser
extends OutputParser {
    private Logger logger = Logger.getLogger((String)NfEnfParser.class.getName());
    private final String START = "iter_ion";
    private final String START_U = "iter_unitcell";
    private String[] idents;
    private Vector dataVector = new Vector();

    public NfEnfParser(String fileName) {
        super(fileName);
    }

    @Override
    protected boolean parse() {
        String line = "";
        if (this.readers != null) {
            int i = 0;
            while (i < this.readers.length) {
                this.dataVector = new Vector();
                try {
                    this.logger.debug((Object)("at file:" + this.fileNames.get(i).toString()));
                    while ((line = this.readers[i].readLine()) != null) {
                        this.logger.debug((Object)line);
                        this.parseLine(line.trim());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.readers[i].close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String[][] d2d = new String[this.dataVector.size()][this.idents.length];
                try {
                    this.dataVector.copyInto((Object[])d2d);
                }
                catch (ArrayIndexOutOfBoundsException aiob) {
                    this.logger.error((Object)("corrupted F_ENF file: " + this.fileNames.get(i).toString()));
                    return false;
                }
                String[] id = this.fileNames.get(i).toString().split("\\.");
                if (id[id.length - 1].trim().equals("converged")) {
                    this.idents = new String[]{"reac_coord", "iter_ion", "hartree", "eV", "kcal/mol", "kJ/mol"};
                }
                OutputData outputData = new OutputData(id[id.length - 1], "energy at each ionic loop", this.idents, d2d, "");
                outputData.setFileName(this.fileNames.get(i).toString());
                this.addOutputData(outputData);
                ++i;
            }
            if (this.readers.length != 0) {
                this.isDone = true;
            }
        }
        if (this.reader == null) {
            return false;
        }
        this.dataVector = new Vector();
        try {
            try {
                while ((line = this.reader.readLine()) != null) {
                    this.parseLine(line.trim());
                }
            }
            catch (IOException ioe) {
                this.logger.error((Object)("failed parse of file: " + this.fileName));
                this.isDone = true;
                try {
                    this.reader.close();
                }
                catch (IOException ioe2) {
                    this.logger.error((Object)("failed to close file: " + this.fileName));
                }
                return false;
            }
        }
        finally {
            this.isDone = true;
            try {
                this.reader.close();
            }
            catch (IOException ioe) {
                this.logger.error((Object)("failed to close file: " + this.fileName));
            }
        }
        if (this.idents == null || this.dataVector.size() == 0) {
            return false;
        }
        String[][] data2d = new String[this.dataVector.size()][this.idents.length];
        try {
            this.dataVector.copyInto((Object[])data2d);
        }
        catch (ArrayIndexOutOfBoundsException aiob) {
            this.logger.error((Object)"corrupted F_ENF file");
            return false;
        }
        OutputData outputData = new OutputData("energy", "energy at each ionic loop", this.idents, data2d, "");
        outputData.setFileName(this.fileName);
        this.addOutputData(outputData);
        return true;
    }

    private void parseLine(String line) {
        if (line.startsWith("iter_ion") || line.startsWith("#step") || line.startsWith("iter_unitcell") || line.startsWith("reaction coordinate")) {
            this.idents = line.split("\\s+");
            if (this.idents != null) {
                int i = 0;
                while (i < this.idents.length) {
                    String[] foo = this.idents[i].split(",");
                    if (foo != null) {
                        this.idents[i] = foo[0];
                    }
                    ++i;
                }
            }
            return;
        }
        String[] data = line.split("\\s+");
        this.dataVector.addElement(data);
    }

    @Override
    public String getCurrentMessage() {
        return null;
    }
}

