/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel;

import ciss.phase_viewer.common.InputPanel;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.primitiveguis.ComboButton;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.ChoosableOption;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.ONOFFOption;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlExecPanel;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlScript;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlScriptOption;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.RangeOption;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.TextOption;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.LoadingFilePanel;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class DosPanel
extends ProjectManipulator
implements OutputParserListener {
    private Logger logger = Logger.getLogger((String)DosPanel.class.getName());
    private OutputParser parser;
    private String dosfile;

    public DosPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        this.setLayout(new BoxLayout(this, 1));
    }

    @Override
    public void recreate() {
        this.projectInfo.getOutputInterface().initCache();
        this.init();
        this.revalidate();
    }

    @Override
    public void init() {
        String fname;
        this.removeAll();
        this.dosfile = fname = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.projectInfo.getChaseFileManager().getFile("F_DOS").getFileName();
        if (!new File(fname).exists()) {
            this.add(new NoFilePanel("F_DOS"));
            return;
        }
        this.add(new LoadingFilePanel("F_DOS"));
        if (this.parser == null) {
            this.parser = this.projectInfo.getOutputInterface().getParser("F_DOS", this);
        }
        this.parser.setParsed(false);
        this.parser.doParse();
    }

    @Override
    public void initializeProject() {
    }

    private void bootDosPlPanel() {
        PerlScript script = new PerlScript("dos.pl", new File(this.projectInfo.getProjectDirectory()));
        script.setCommand(new String[]{this.projectInfo.getChaseFileManager().getFile("F_DOS").getFileName(), PerlScriptOption.OPTION});
        ChoosableOption mode = new ChoosableOption("mode", new String[]{"total", "atom", "layer", "projected"});
        RangeOption erange = new RangeOption("erange");
        TextOption einc = new TextOption("einc");
        RangeOption dosrange = new RangeOption("dosrange");
        TextOption dosinc = new TextOption("dosinc");
        ONOFFOption with_fermi = new ONOFFOption("with_fermi");
        ONOFFOption color = new ONOFFOption("color");
        TextOption title = new TextOption("title");
        TextOption width = new TextOption("width");
        TextOption font = new TextOption("font");
        script.addOptions(mode);
        script.addOptions(erange);
        script.addOptions(einc);
        script.addOptions(dosrange);
        script.addOptions(dosinc);
        script.addOptions(with_fermi);
        script.addOptions(color);
        script.addOptions(title);
        script.addOptions(width);
        script.addOptions(font);
        PerlExecPanel panel = new PerlExecPanel("run dos.pl", new Dimension(400, 250), script);
        panel.closeAfterOK(false);
    }

    private JPanel createDosPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel panelmode = new JPanel();
        panelmode.setLayout(new BoxLayout(panelmode, 0));
        String[] modes = new String[]{"total", "atom", "layer"};
        JComboBox<String> checkMode = new JComboBox<String>(modes);
        InputPanel width = new InputPanel("width", 0, 5);
        JCheckBox checkFermi = new JCheckBox("with_fermi");
        JCheckBox checkColor = new JCheckBox("");
        return panel;
    }

    @Override
    public void parseFinished() {
        this.removeAll();
        JPanel button = new JPanel();
        button.setBorder(new TitledBorder("dos.pl"));
        button.setLayout(new FlowLayout());
        JButton btndospl = new JButton("run dos.pl");
        button.add(btndospl);
        ComboButton cbdos = new ComboButton(this.projectInfo.getProjectDirectory(), new String[]{"density_of_states.eps", "dos_a\\d+.eps", "dos_l\\d+.eps", "dos_a\\d+l\\d+m\\d+t\\d+.eps"});
        button.add(cbdos);
        this.add(button);
        JPanel dataPanel = this.projectInfo.getOutputInterface().getDataPanel("F_DOS");
        this.add(dataPanel);
        this.revalidate();
        btndospl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DosPanel.this.bootDosPlPanel();
            }
        });
    }
}

