/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig;

import ciss.phase_viewer.common.ElementInfo;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceBlockChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceBlockChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.PseudoPotentialPanel;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

class EPP
extends PhaseInputItems
implements InputInterfaceEntryChangeListener,
InputInterfaceBlockChangeListener {
    private Logger logger = Logger.getLogger((String)EPP.class.getName());
    private TableForInputInterface tbl_elm;
    private JComboBox combo_elm;
    private JComboBox combo_num;
    private PseudoPotentialPanel pppanel;
    private boolean init = false;
    private ElementInfo eI;
    private boolean dontCheck = false;

    protected EPP(ProjectInfo projectInfo) {
        super(projectInfo);
        this.updateMe();
        projectInfo.getInputInterface().addInputInterfaceEntryChangeListener(this);
        projectInfo.getInputInterface().addInputInterfaceBlockChangeListener(this);
    }

    @Override
    public void createGUI() {
        if (this.tbl_elm != null) {
            this.inputInterface.removeInputInterfaceEntryChangeListener((InputInterfaceEntryChangeListener)((Object)this.tbl_elm.getModel()));
        }
        this.removeAll();
        JPanel p = new JPanel();
        p.setBorder(new TitledBorder("element info"));
        p.setLayout(new GridLayout());
        String[] elmSpec = new String[]{"structure.element_list"};
        this.tbl_elm = new TableForInputInterface(elmSpec, this.inputInterface, this);
        this.tbl_elm.setColumnSelectionAllowed(true);
        this.tbl_elm.setRowSelectionAllowed(true);
        this.setEditorForElementTable();
        this.pppanel = new PseudoPotentialPanel(this.projectInfo, this.tbl_elm.getRowCount());
        this.setLayout(new BoxLayout(this, 1));
        TMLPP tlistener = new TMLPP(this.pppanel);
        this.tbl_elm.getModel().addTableModelListener(tlistener);
        JScrollPane elempane = new JScrollPane(this.tbl_elm.getPanel());
        p.add(elempane);
        tlistener.tableChanged(null);
        p.setPreferredSize(new Dimension(this.getPreferredSize().width, 150));
        this.pppanel.setPreferredSize(new Dimension(this.getPreferredSize().width, 150));
        JScrollPane pppane = new JScrollPane(this.pppanel);
        this.add(p);
        this.add(pppane);
        this.revalidate();
    }

    @Override
    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
        if (this.init || e.getSource() == this.tbl_elm.getModel() || this.pppanel.updating()) {
            this.logger.debug((Object)"source == this");
            return;
        }
        if (e.getTag().equalsIgnoreCase("structure.atom_list.atoms") || e.getTag().equalsIgnoreCase("structure.element_list")) {
            this.updateMe();
        }
    }

    private void updateMe() {
        InputInterface inpint = this.projectInfo.getInputInterface();
        ElementInfo.updateElement(inpint);
        this.createGUI();
    }

    @Override
    public void inputInterfaceInitializing() {
        this.init = true;
    }

    @Override
    public void inputInterfaceInitialized() {
        this.init = false;
        this.dontCheck = true;
        this.updateMe();
        this.dontCheck = false;
    }

    private void setEditorForElementTable() {
        this.eI = ElementInfo.getElementInfo();
        int num_elements = this.eI.num_elements;
        String[] elements_list = new String[num_elements];
        String[] atomic_num_list = new String[num_elements];
        elements_list[0] = "";
        atomic_num_list[0] = "";
        int i = 1;
        while (i < num_elements) {
            elements_list[i] = this.eI.getSymbolFromNumber(i);
            atomic_num_list[i] = Integer.toString(i);
            if (this.eI == null || this.eI.getSymbolFromNumber(i) == null) {
                this.logger.error((Object)"element info is null!!!");
            }
            ++i;
        }
        TableColumn column_elm = this.tbl_elm.getColumnModel().getColumn(1);
        this.combo_elm = new JComboBox<String>(elements_list);
        column_elm.setCellEditor(new DefaultCellEditor(this.combo_elm));
        TableColumn column_num = this.tbl_elm.getColumnModel().getColumn(2);
        this.combo_num = new JComboBox<String>(atomic_num_list);
        column_num.setCellEditor(new DefaultCellEditor(this.combo_num));
        this.combo_elm.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean valid;
                String symbolSelected = (String)EPP.this.combo_elm.getSelectedItem();
                int row = EPP.this.tbl_elm.getSelectedRow();
                int col = EPP.this.tbl_elm.getColumnCount();
                boolean bl = valid = symbolSelected != null && symbolSelected.trim().length() != 0;
                if (row >= 0 && EPP.this.combo_elm.isPopupVisible()) {
                    EPP.this.inputInterface.setUpdateUndoStack(false);
                    if (valid) {
                        EPP.this.tbl_elm.setValueAt("", row, 2);
                        EPP.this.tbl_elm.setValueAt("", row, 3);
                        try {
                            int atn = EPP.this.eI.getNumberFromSymbol(symbolSelected);
                            EPP.this.tbl_elm.setValueAt(EPP.this.eI.getMassFromSymbol(symbolSelected), row, 3);
                            EPP.this.tbl_elm.setValueAt(String.valueOf(EPP.this.eI.getNumberFromSymbol(symbolSelected)), row, 2);
                        }
                        catch (Exception ee) {
                            EPP.this.tbl_elm.setValueAt("", row, 2);
                            EPP.this.tbl_elm.setValueAt("", row, 3);
                            ee.printStackTrace();
                        }
                    } else {
                        int i = 0;
                        while (i < col) {
                            EPP.this.tbl_elm.setValueAt("", row, i);
                            ++i;
                        }
                    }
                    EPP.this.inputInterface.setUpdateUndoStack(true);
                }
            }
        });
        this.combo_num.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean valid;
                String numberSelected = (String)EPP.this.combo_num.getSelectedItem();
                int row = EPP.this.tbl_elm.getSelectedRow();
                int col = EPP.this.tbl_elm.getColumnCount();
                boolean bl = valid = numberSelected != null && numberSelected.trim().length() != 0;
                if (row >= 0 && EPP.this.combo_num.isPopupVisible()) {
                    EPP.this.inputInterface.setUpdateUndoStack(false);
                    if (valid) {
                        EPP.this.tbl_elm.setValueAt(" ", row, 1);
                        EPP.this.tbl_elm.setValueAt(" ", row, 3);
                        try {
                            EPP.this.tbl_elm.setValueAt(EPP.this.eI.getSymbolFromNumber(Integer.parseInt(numberSelected)), row, 1);
                            EPP.this.tbl_elm.setValueAt(EPP.this.eI.getMassFromNumber(Integer.parseInt(numberSelected)), row, 3);
                        }
                        catch (Exception ee) {
                            EPP.this.logger.debug((Object)"failed to obtain symbol and mass from atomic number");
                            EPP.this.tbl_elm.setValueAt("", row, 1);
                            EPP.this.tbl_elm.setValueAt("", row, 3);
                        }
                    } else {
                        int i = 0;
                        while (i < col) {
                            EPP.this.tbl_elm.setValueAt("", row, i);
                            ++i;
                        }
                    }
                    EPP.this.inputInterface.setUpdateUndoStack(true);
                }
            }
        });
    }

    private void updateTable() {
        this.tbl_elm.update(this.tbl_elm.getGraphics());
    }

    @Override
    public void inputInterfaceBlockChanged(InputInterfaceBlockChangeEvent e) {
        if (e.getSource() == this || !e.getTag().equalsIgnoreCase("structure")) {
            return;
        }
        this.dontCheck = true;
        this.updateMe();
        this.dontCheck = false;
    }

    class TMLPP
    implements TableModelListener {
        private Logger logger = Logger.getLogger((String)this.getClass().getName());
        private PseudoPotentialPanel pppanel;

        protected TMLPP(PseudoPotentialPanel pppanel) {
            this.pppanel = pppanel;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.pppanel.updating(true);
            int nrow = EPP.this.tbl_elm.getRowCount();
            int ncol = EPP.this.tbl_elm.getColumnCount();
            Vector<String> elems = new Vector<String>();
            boolean nvalid = false;
            int i = 0;
            while (i < nrow) {
                String elem = (String)EPP.this.tbl_elm.getModel().getValueAt(i, 1);
                elems.addElement(elem);
                ++i;
            }
            try {
                this.pppanel.updatePPPanel(elems);
            }
            catch (NullPointerException npe) {
                this.logger.debug((Object)"failed to update pseudopotential panel!");
            }
            this.pppanel.updating(false);
        }
    }
}

