/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.inputcheck;

import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.input.PhaseInputChecker;
import org.apache.log4j.Logger;

public class NumBandsChecker
extends PhaseInputChecker {
    private Logger logger = Logger.getLogger((String)NumBandsChecker.class.getName());
    private boolean metallic = false;
    private boolean spin = false;
    private int def;

    @Override
    public boolean isFixable() {
        return true;
    }

    @Override
    public String getName() {
        return "number of bands";
    }

    @Override
    public String getDescription() {
        return "check the number of bands";
    }

    @Override
    public String getCandidate() {
        String ret = "";
        if (this.state != 0) {
            ret = "will fix num_bands to\nthe recommended value : " + String.valueOf(this.def);
        }
        return ret;
    }

    @Override
    public boolean fixInput() {
        int def = PhaseUtils.getDefaultNumBands(this.inputInterface, this.metallic, this.spin);
        this.fixPrimitiveEntry("accuracy", "num_bands", String.valueOf(def), "");
        return true;
    }

    @Override
    public int doCheck() {
        this.logger.debug((Object)this.inputInterface);
        String mag = this.inputInterface.getInputInterfacePrimitiveEntry("structure.magnetic_state").getValue();
        if (mag.length() != 0 && !mag.equalsIgnoreCase("para")) {
            this.spin = true;
        }
        this.state = 0;
        this.def = PhaseUtils.getDefaultNumBands(this.inputInterface, this.metallic, this.spin);
        int min = PhaseUtils.getNumBands(this.inputInterface, this.metallic, this.spin, 1.0);
        int numbands = -1;
        try {
            numbands = Integer.parseInt(this.inputInterface.getInputInterfacePrimitiveEntry("accuracy.num_bands").getValue());
        }
        catch (NumberFormatException e) {
            this.state = -2;
        }
        this.message = "current num. bands: " + String.valueOf(numbands) + this.LS;
        this.message = String.valueOf(this.message) + "minimum num. bands: " + String.valueOf(min) + this.LS;
        this.message = String.valueOf(this.message) + "recommended num. bands: " + String.valueOf(this.def);
        if (numbands < min) {
            this.state = -2;
        }
        if (numbands < this.def) {
            this.state = -1;
        }
        return this.state;
    }
}

