/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.file;

import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.SimpleMonitor;
import ciss.phase_viewer.graph.GraphPanel;
import ciss.phase_viewer.graph.SimpleChart;
import ciss.phase_viewer.graph.XYData;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import java.awt.Dimension;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jfree.chart.axis.AxisLocation;

public class NfEnfMonitor
extends SimpleMonitor {
    private Logger logger = Logger.getLogger((String)NfEnfMonitor.class.getName());
    private String chartTitle = "";

    public NfEnfMonitor(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    protected String getFileToMonitor() {
        return this.getChaseFile().getFileName();
    }

    @Override
    public ChaseFile getChaseFile() {
        ChaseFile cf = this.projectInfo.getChaseFileManager().getFile("F_ENF");
        return cf;
    }

    @Override
    protected void doGraph(String[] lines) {
        double[][] inidata;
        if (lines == null || lines.length == 0) {
            return;
        }
        boolean md = false;
        Vector<double[]> dataVector = new Vector<double[]>();
        int i = 0;
        while (i < lines.length) {
            block24: {
                this.logger.debug((Object)lines[i]);
                String line = lines[i].trim();
                String[] ar = line.split("\\s+");
                try {
                    Integer.parseInt(ar[0]);
                }
                catch (NumberFormatException e) {
                    break block24;
                }
                if (ar.length >= 4) {
                    double[] tmp;
                    if (ar.length > 4) {
                        md = true;
                    }
                    if (!md) {
                        try {
                            tmp = new double[]{Double.parseDouble(ar[0]), Double.parseDouble(ar[2]), Double.parseDouble(ar[3])};
                            dataVector.add(tmp);
                        }
                        catch (NumberFormatException nfe) {}
                    } else {
                        try {
                            tmp = new double[]{Double.parseDouble(ar[0]), Double.parseDouble(ar[2]), Double.parseDouble(ar[3]), Double.parseDouble(ar[4])};
                            dataVector.add(tmp);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
        if (dataVector.size() == 0 && !this.isGraphCreatable(this.textArea)) {
            return;
        }
        if (!md) {
            if (this.xyData == null) {
                this.xyData = new XYData[2];
                this.xyData[0] = new XYData("energy");
                this.xyData[0].collectionIndex = 0;
                this.xyData[0].xAxisName = "iteration";
                this.xyData[0].xValType = XYData.INTEGER;
                this.xyData[0].yAxisName = "energy (hartree)";
                this.xyData[1] = new XYData("force");
                this.xyData[1].collectionIndex = 1;
                this.xyData[1].xAxisName = "iteration";
                this.xyData[1].xValType = XYData.INTEGER;
                this.xyData[1].yAxisName = "max. force (hartree/bohr)";
                this.xyData[1].yAxisLocation = AxisLocation.BOTTOM_OR_RIGHT;
                this.chartTitle = "structural optimization";
            }
            inidata = new double[dataVector.size()][];
            dataVector.copyInto((Object[])inidata);
            int i2 = 0;
            while (i2 < inidata.length) {
                this.xyData[0].add(inidata[i2][0], inidata[i2][1]);
                this.xyData[1].add(inidata[i2][0], inidata[i2][2]);
                ++i2;
            }
        } else {
            if (this.xyData == null) {
                this.xyData = new XYData[3];
                this.xyData[0] = new XYData("tot. energy");
                this.xyData[0].collectionIndex = 0;
                this.xyData[0].xAxisName = "iteration";
                this.xyData[0].yAxisName = "internal and total energy (hartree)";
                this.xyData[0].xValType = XYData.INTEGER;
                this.xyData[1] = new XYData("constant of motion");
                this.xyData[1].xValType = XYData.INTEGER;
                this.xyData[1].collectionIndex = 0;
                this.xyData[1].yAxisName = "internal and total energy (hartree)";
                this.xyData[2] = new XYData("kinetic energy");
                this.xyData[2].xValType = XYData.INTEGER;
                this.xyData[2].collectionIndex = 1;
                this.xyData[2].yAxisName = "kinetic energy (hartree)";
                this.xyData[2].yAxisLocation = AxisLocation.BOTTOM_OR_RIGHT;
                this.chartTitle = "molecular dynamics";
            }
            inidata = new double[dataVector.size()][];
            dataVector.copyInto((Object[])inidata);
            try {
                int i3 = 0;
                while (i3 < inidata.length) {
                    this.xyData[0].add(inidata[i3][0], inidata[i3][1]);
                    this.xyData[1].add(inidata[i3][0], inidata[i3][3]);
                    this.xyData[2].add(inidata[i3][0], inidata[i3][2]);
                    ++i3;
                }
            }
            catch (ArrayIndexOutOfBoundsException aiob) {
                aiob.printStackTrace();
            }
        }
        if (!this.graph) {
            return;
        }
        if (this.graphPanel == null) {
            SimpleChart simpleChart = new SimpleChart(this.xyData);
            simpleChart.setSize(new Dimension(512, 400));
            simpleChart.setTitle("monitoring " + this.fileName);
            simpleChart.setChartTitle(this.chartTitle);
            simpleChart.setChartProgressListener(this);
            this.graphPanel = new GraphPanel(simpleChart);
            this.graphPanel.addInternalFrameListener(this);
        }
        if (!this.graphPanel.isVisible()) {
            this.graphPanel.setVisible(true);
        }
    }
}

