/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.ekcal.file;

import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.SimpleMonitor;
import ciss.phase_viewer.graph.GraphPanel;
import ciss.phase_viewer.graph.SimpleChart;
import ciss.phase_viewer.graph.XYData;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FENERGMonitor
extends SimpleMonitor {
    private Logger logger = Logger.getLogger((String)FENERGMonitor.class.getName());
    private double[][] reclat;
    private double[] prevk = new double[]{0.0, 0.0, 0.0};
    private double dk = 0.0;
    private int numBands = -1;
    private int spin = 1;
    private boolean readingEig = false;
    private final String startTag = "===";
    private double[] eigs;
    private int eigCount = 0;
    private Vector dataVector = new Vector();
    private Vector dkVector = new Vector();
    private boolean readK = false;
    private double hartree2eV = 27.2114;

    public FENERGMonitor(ProjectInfo projectInfo) {
        super(projectInfo);
        this.init();
    }

    private void init() {
        String finp = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.projectInfo.getChaseFileManager().getFile("F_INP").getFileName();
        DataManager dm = new DataManager(finp);
        if (!dm.parse()) {
            this.logger.error((Object)"invalid input file");
            return;
        }
        InputInterface inputInterface = dm.getInputInterface();
        try {
            this.numBands = Integer.parseInt(inputInterface.getInputInterfacePrimitiveEntry("accuracy.num_bands").getValue());
        }
        catch (NumberFormatException npe) {
            this.logger.error((Object)"invalid num_bands");
        }
        Cell cell = Cell.createFrom(inputInterface);
        if (cell == null) {
            this.logger.error((Object)"invalid cell");
            return;
        }
        this.logger.debug((Object)"cell");
        this.logger.debug((Object)cell);
        this.reclat = cell.getReciprocalLattice();
        this.logger.debug((Object)("num_bands: " + this.numBands));
        if (this.reclat != null) {
            this.logger.debug((Object)("reclat1: " + this.reclat[0][0] + " " + this.reclat[0][1] + " " + this.reclat[0][2]));
            this.logger.debug((Object)("reclat2: " + this.reclat[1][0] + " " + this.reclat[1][1] + " " + this.reclat[1][2]));
            this.logger.debug((Object)("reclat3: " + this.reclat[2][0] + " " + this.reclat[2][1] + " " + this.reclat[2][2]));
        } else {
            this.logger.debug((Object)"failed to obtain reciprocal lattice...");
        }
        String mag = inputInterface.getInputInterfacePrimitiveEntry("structure.magnetic_state").getValue().trim();
        if (mag.equalsIgnoreCase("af") || mag.equalsIgnoreCase("antiferro") || mag.equalsIgnoreCase("ferro")) {
            this.spin = 2;
        }
        this.eigs = new double[this.numBands * this.spin];
    }

    @Override
    protected String getFileToMonitor() {
        return this.getChaseFile().getFileName();
    }

    @Override
    public ChaseFile getChaseFile() {
        return this.projectInfo.getChaseFileManager().getFile("F_ENERG");
    }

    @Override
    protected void doGraph(String[] lines) {
        if (this.eigs == null || this.numBands <= 0 || this.reclat == null || this.drawingChart) {
            return;
        }
        int i = 0;
        while (i < lines.length) {
            block26: {
                this.logger.debug((Object)("parsing line: " + lines[i]));
                if (lines[i].trim().startsWith("===")) {
                    this.logger.debug((Object)"readingEig=true");
                    this.readingEig = true;
                }
                if (this.readingEig) {
                    String[] ar = lines[i].trim().split("\\s+");
                    double[] kv = new double[3];
                    if (!this.readK && ar[0].startsWith("ik") && ar.length >= 7) {
                        kv[0] = Double.parseDouble(ar[4]);
                        kv[1] = Double.parseDouble(ar[5]);
                        kv[2] = Double.parseDouble(ar[6].replaceAll("\\)", ""));
                        double[] kvec = new double[3];
                        int j2 = 0;
                        while (j2 < 3) {
                            int k = 0;
                            while (k < 3) {
                                int n = j2;
                                kvec[n] = kvec[n] + kv[k] * this.reclat[j2][k];
                                ++k;
                            }
                            ++j2;
                        }
                        this.dk += Math.sqrt(Math.pow(kvec[0] - this.prevk[0], 2.0) + Math.pow(kvec[1] - this.prevk[1], 2.0) + Math.pow(kvec[2] - this.prevk[2], 2.0));
                        this.dkVector.addElement(new Double(this.dk));
                        this.prevk = kvec;
                        this.logger.debug((Object)("kv: " + kv[0] + ", " + kv[1] + ", " + kv[2]));
                        this.readK = true;
                    } else {
                        try {
                            Double.parseDouble(ar[0]);
                        }
                        catch (NumberFormatException nfe) {
                            break block26;
                        }
                        int j = 0;
                        while (j < ar.length) {
                            try {
                                this.eigs[this.eigCount] = Double.parseDouble(ar[j]) * this.hartree2eV;
                                ++this.eigCount;
                            }
                            catch (NumberFormatException j2) {
                                // empty catch block
                            }
                            ++j;
                        }
                        if (this.eigCount >= this.numBands * this.spin) {
                            int ii = 0;
                            while (ii < this.eigs.length) {
                                this.logger.debug((Object)("eigen value no. " + ii + ": " + this.eigs[ii]));
                                ++ii;
                            }
                            this.readingEig = false;
                            this.readK = false;
                            this.eigCount = 0;
                            this.dataVector.add(this.eigs);
                        }
                    }
                }
            }
            ++i;
        }
        if (this.dataVector.size() == 0 && this.xyData == null) {
            return;
        }
        if (this.xyData == null) {
            this.xyData = new XYData[this.numBands * this.spin];
            int ispin = 0;
            while (ispin < this.spin) {
                Color color = Color.red;
                boolean seriesIndex = false;
                String yname = "eigenvalue (eV)";
                if (ispin == 1) {
                    color = Color.blue;
                    yname = "";
                    seriesIndex = true;
                }
                int i2 = 0;
                while (i2 < this.numBands) {
                    int ind = i2 + ispin * this.numBands;
                    this.logger.debug((Object)("at index: " + ind));
                    this.xyData[ind] = new XYData("band no. " + String.valueOf(i2));
                    this.xyData[ind].xAxisName = "|k|";
                    this.xyData[ind].seriesIndex = ind;
                    this.xyData[ind].seriesColor = color;
                    this.xyData[ind].yAxisName = yname;
                    ++i2;
                }
                ++ispin;
            }
            this.logger.debug((Object)"instanciated XYData[]");
        }
        if (this.drawingChart) {
            this.dataVector = new Vector();
            this.dkVector = new Vector();
            return;
        }
        i = 0;
        while (i < this.dkVector.size()) {
            double kv = (Double)this.dkVector.get(i);
            double[] ei = (double[])this.dataVector.get(i);
            int j = 0;
            while (j < ei.length) {
                this.xyData[j].add(kv, ei[j]);
                ++j;
            }
            ++i;
        }
        this.dataVector = new Vector();
        this.dkVector = new Vector();
        if (!this.graph) {
            return;
        }
        this.logger.debug((Object)"creating graph");
        if (this.graphPanel == null) {
            SimpleChart simpleChart = new SimpleChart(this.xyData);
            simpleChart.setSize(new Dimension(400, 600));
            simpleChart.setTitle("monitoring " + this.fileName);
            simpleChart.setChartTitle("eigenvalue");
            simpleChart.createLegend(false);
            simpleChart.setChartProgressListener(this);
            this.graphPanel = new GraphPanel(simpleChart);
            this.graphPanel.addInternalFrameListener(this);
        }
        if (!this.graphPanel.isVisible()) {
            this.graphPanel.setVisible(true);
        }
    }
}

