/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.mainpanel;

import ciss.phase_viewer.mainpanel.AbstractInternalFrameChase;
import ciss.phase_viewer.mainpanel.ChaseDesktop;
import ciss.phase_viewer.mainpanel.ChaseGUI;
import ciss.phase_viewer.mainpanel.ChaseJMenuItems;
import ciss.phase_viewer.mainpanel.InternalFrameKeyListener;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class Desk
extends JDesktopPane
implements ChaseDesktop {
    private static Logger logger = Logger.getLogger((String)Desk.class.getName());
    private static Desk desktop;
    private int widthCount = 0;
    private int heightCount = 0;
    private JScrollPane scrollpane;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
    private ChaseGUI parent;

    private Desk() {
        String outline = this.gp.getProperty("outline_only");
        if (outline == null || !outline.trim().equals("false")) {
            this.setDragMode(1);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                if (e.getButton() == 3) {
                    JPopupMenu popup = new JPopupMenu();
                    ChaseJMenuItems items = new ChaseJMenuItems();
                    JMenuItem[] ite = items.getMenuItems();
                    int i = 0;
                    while (i < ite.length) {
                        if (ite[i] != null) {
                            popup.add(ite[i]);
                        } else {
                            popup.addSeparator();
                        }
                        ++i;
                    }
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public static JDesktopPane getDesktop() {
        if (desktop == null) {
            desktop = new Desk();
        }
        return desktop;
    }

    public int getMaxLayer() {
        int layer = 0;
        JInternalFrame[] frames = this.getAllFrames();
        if (frames == null) {
            return layer;
        }
        int i = 0;
        while (i < frames.length) {
            int foo = frames[i].getLayer();
            if (foo > layer) {
                layer = foo;
            }
            ++i;
        }
        return layer;
    }

    @Override
    public Component add(Component component) {
        if (component instanceof AbstractInternalFrameChase) {
            Component[] comps = ((JInternalFrame)component).getComponents();
            int i = 0;
            while (i < comps.length) {
                comps[i].addKeyListener(new InternalFrameKeyListener());
                ++i;
            }
        }
        return super.add(component);
    }

    public void setScrollPane(JScrollPane scrollpane_) {
        this.scrollpane = scrollpane_;
        this.scrollpane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (Desk.this.scrollpane.getHorizontalScrollBar().getValueIsAdjusting()) {
                    Desk.this.deactivateHeavy();
                }
            }
        });
        this.scrollpane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (Desk.this.scrollpane.getVerticalScrollBar().getValueIsAdjusting()) {
                    Desk.this.deactivateHeavy();
                }
            }
        });
    }

    protected void setParentFrame(ChaseGUI parent) {
        this.parent = parent;
    }

    public ChaseGUI getParentFrame() {
        return this.parent;
    }

    public JScrollPane getScrollPane() {
        return this.scrollpane;
    }

    private void deactivateHeavy() {
        JInternalFrame[] frames = this.getAllFrames();
        if (frames != null && frames.length > 0) {
            int i = 0;
            while (i < frames.length) {
                if (((AbstractInternalFrameChase)frames[i]).isHeavyWeight()) {
                    try {
                        frames[i].setSelected(false);
                        frames[i].setLayer(0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void componentShown() {
        this.scrollBarUpdate();
    }

    @Override
    public void componentResized() {
        this.scrollBarUpdate();
    }

    @Override
    public void componentMoved() {
        this.scrollBarUpdate();
    }

    @Override
    public void componentHidden() {
        this.scrollBarUpdate();
    }

    @Override
    public void initialLocation(Component frameNow) {
        this.initialLocation(frameNow, 0);
    }

    public void selectLast() {
        JInternalFrame[] components = super.getAllFrames();
        if (components == null || components.length <= 1) {
            return;
        }
        int visibles = 0;
        int i = 0;
        while (i < components.length) {
            if (components[i].isVisible()) {
                ++visibles;
            }
            ++i;
        }
        if (visibles == 0) {
            return;
        }
        int numFrames = components.length;
        int i2 = numFrames - 1;
        while (i2 >= 0) {
            JInternalFrame frame = components[i2];
            if (frame.isVisible() && !frame.isIcon()) {
                try {
                    frame.setSelected(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            --i2;
        }
    }

    @Override
    public void initialLocation(Component frameNow, int location) {
        JInternalFrame[] components = super.getAllFrames();
        if (components == null || components.length <= 1) {
            return;
        }
        int visibles = 0;
        int i = 0;
        while (i < components.length) {
            if (components[i].isVisible()) {
                ++visibles;
            }
            ++i;
        }
        if (visibles == 0) {
            return;
        }
        if (this.getSelectedFrame() == null || !this.getSelectedFrame().isVisible()) {
            return;
        }
        String initial_position = this.gp.getProperty("initial_position");
        if (initial_position != null && initial_position.trim().equals("tile")) {
            this.tile(location, frameNow);
        } else {
            this.cascade(location, frameNow);
        }
    }

    private void tile(int location, Component frameNow) {
        logger.debug((Object)"setting initial location ...");
        int widthThis = this.getWidth();
        int heightThis = this.getHeight();
        JInternalFrame framePre = this.getSelectedFrame();
        if (framePre == null && (framePre = super.getAllFrames()[0]) == null) {
            frameNow.setLocation(0, 0);
            return;
        }
        int hidari = framePre.getLocation().x;
        int migi = hidari + framePre.getSize().width;
        int ue = framePre.getLocation().y;
        int sita = ue + framePre.getSize().height;
        logger.debug((Object)("hidari, migi, ue, sita: " + hidari + " " + migi + " " + ue + " " + sita));
        if (location == 0) {
            float d;
            float a = (float)hidari / (float)widthThis;
            float b = (float)ue / (float)heightThis;
            float c = (float)(widthThis - migi) / (float)widthThis;
            if (c < 0.0f) {
                c = 0.0f;
            }
            if ((d = (float)(heightThis - sita) / (float)heightThis) < 0.0f) {
                d = 0.0f;
            }
            float comp = 0.0f;
            int index = 1;
            if (a > comp) {
                comp = a;
                index = 1;
                ++this.widthCount;
            }
            if (b > comp) {
                comp = b;
                index = 2;
                ++this.heightCount;
            }
            if (c > comp) {
                comp = c;
                index = 3;
                ++this.widthCount;
            }
            if (d > comp) {
                comp = d;
                index = 4;
                ++this.heightCount;
            }
            if (this.widthCount == 2) {
                index = 4;
                this.widthCount = 0;
            }
            if (this.heightCount == 2) {
                index = 3;
                this.heightCount = 0;
            }
            logger.debug((Object)("a,b,c,d,index: " + index + " " + a + " " + b + " " + c + " " + d));
            if (index == 1) {
                frameNow.setLocation(hidari - frameNow.getSize().width, ue);
            } else if (index == 2) {
                frameNow.setLocation(hidari, ue - frameNow.getSize().height);
            } else if (index == 3) {
                frameNow.setLocation(migi, ue);
            } else if (index == 4) {
                frameNow.setLocation(hidari, sita);
            }
        } else if (location == 2) {
            frameNow.setLocation(hidari - frameNow.getSize().width, ue);
        } else if (location == 3) {
            frameNow.setLocation(migi, ue);
        } else if (location == 1) {
            this.center(frameNow);
        }
    }

    private void center(Component frameNow) {
        JInternalFrame framePre = this.getSelectedFrame();
        if (framePre == null && (framePre = super.getAllFrames()[0]) == null) {
            frameNow.setLocation(0, 0);
            return;
        }
        int centerx = framePre.getLocation().x + ((Component)framePre).getWidth() / 2;
        int centery = framePre.getLocation().y + ((Component)framePre).getHeight() / 2;
        int locx = centerx - frameNow.getWidth() / 2;
        int locy = centery - frameNow.getHeight() / 2;
        frameNow.setLocation(locx, locy);
    }

    private void cascade(int location, Component frameNow) {
        logger.debug((Object)"setting initial location ...");
        int widthThis = this.getWidth();
        int heightThis = this.getHeight();
        JInternalFrame framePre = this.getSelectedFrame();
        if (framePre == null && (framePre = super.getAllFrames()[0]) == null) {
            frameNow.setLocation(0, 0);
            return;
        }
        int hidari = framePre.getLocation().x;
        int migi = hidari + framePre.getSize().width;
        int ue = framePre.getLocation().y;
        int sita = ue + framePre.getSize().height;
        logger.debug((Object)("hidari, migi, ue, sita: " + hidari + " " + migi + " " + ue + " " + sita));
        if (location == 0) {
            int overlap_x = 20;
            int overlap_y = 20;
            String ox = this.gp.getProperty("overlap_x");
            String oy = this.gp.getProperty("overlap_y");
            if (ox != null) {
                try {
                    overlap_x = Integer.parseInt(ox);
                }
                catch (NumberFormatException nfe) {
                    overlap_x = 20;
                }
            }
            if (oy != null) {
                try {
                    overlap_y = Integer.parseInt(oy);
                }
                catch (NumberFormatException nfe) {
                    overlap_y = 20;
                }
            }
            int prex = framePre.getLocation().x;
            int prey = framePre.getLocation().y;
            int locx = prex + overlap_x;
            int locy = prey + overlap_y;
            frameNow.setLocation(locx, locy);
        } else if (location == 2) {
            frameNow.setLocation(hidari - frameNow.getSize().width, ue);
        } else if (location == 3) {
            frameNow.setLocation(migi, ue);
        } else if (location == 1) {
            this.center(frameNow);
        }
    }

    protected void scrollBarUpdate() {
        JInternalFrame[] frames = null;
        try {
            frames = super.getAllFrames();
        }
        catch (Exception ex) {
            return;
        }
        int numFrames = frames.length;
        int migi = 0;
        int imigi = 0;
        int sita = 0;
        int isita = 0;
        int i = 0;
        while (i < numFrames) {
            JInternalFrame frame = frames[i];
            int migi_ = frame.getLocation().x + frame.getSize().width;
            int sita_ = frame.getLocation().y + frame.getSize().height;
            if (migi_ > migi) {
                migi = migi_;
                imigi = i;
            }
            if (sita_ > sita) {
                sita = sita_;
                isita = i;
            }
            int hidari_ = frame.getLocation().x;
            int ue_ = frame.getLocation().y;
            int hidari = 0;
            int ue = 0;
            hidari = hidari_;
            ue = ue_;
            if (hidari_ < 0) {
                hidari = 0;
            }
            if (ue_ < 0) {
                ue = 0;
            }
            if (hidari != hidari_ || ue != ue_) {
                frame.setLocation(hidari, ue);
                frame.revalidate();
            }
            ++i;
        }
        logger.debug((Object)("migi: " + migi));
        logger.debug((Object)("sita: " + sita));
        this.setPreferredSize(new Dimension(migi, sita));
        this.revalidate();
    }
}

