/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.mainpanel;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.MyMessageBox;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.logger.JTextAreaAppender;
import ciss.phase_viewer.main.PhaseViewerMain;
import ciss.phase_viewer.mainpanel.ChaseFrame;
import ciss.phase_viewer.mainpanel.ChaseInitializer;
import ciss.phase_viewer.mainpanel.ChaseMenu;
import ciss.phase_viewer.mainpanel.ChaseProgressMonitor;
import ciss.phase_viewer.mainpanel.ChaseSplitPane;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.mainpanel.Desktop4Frame;
import ciss.phase_viewer.mainpanel.FrameChase;
import ciss.phase_viewer.mainpanel.GlobalHotkeyManager;
import ciss.phase_viewer.mainpanel.LogoBooter;
import ciss.phase_viewer.mainpanel.LookandFeel;
import ciss.phase_viewer.projectbrowser.ProjectBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;
import ciss.phase_viewer.textviewer.HelpViewer;
import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class ChaseGUI
extends FrameChase {
    private static Logger logger = Logger.getLogger((String)ChaseGUI.class.getName());
    private final String FS;
    private MyMessageBox mbox;
    private Container cont;
    public JDesktopPane desktop;
    private int fontsize;
    private String fonttype;
    private int fontstyle;
    private boolean chaseiniExists;
    private ChaseMenu chaseMenu;
    private static ProjectDirBrowser dirBrowser;
    private Vector components;
    private ChaseProgressMonitor monitor;
    private final String toggleWindowString = "TOGGLE_WINDOW";
    private final KeyStroke toggleWindowKey;
    private final Action toggleWindowAction;
    private final String toggleWindowRevString = "TOGGLE_WINDOW_REVERSE";
    private final KeyStroke toggleWindowRevKey;
    private final Action toggleWindowRevAction;
    private final String closeWindowString = "CLOSE_WINDOW";
    private final KeyStroke closeWindowKey;
    private final KeyStroke closeWindowKey2;
    private final Action closeWindowAction;
    private final String closeAppString = "CLOSE_APPLICATION";
    private final KeyStroke closeAppKey;
    private final Action closeAppAction;
    private final String toggleDirString = "TOGGLE_DIR_BROWSER";
    private final KeyStroke toggleDirKey;
    private final Action toggleDirAction;
    private final String bootHelpString = "BOOT_HELP";
    private final KeyStroke bootHelpKey;
    private final Action bootHelpAction;
    private final String selectFromProj = "SELECT_FROM_PROJECTS";
    private final KeyStroke selectFromProjKey;
    private final Action selectFromProjAction;
    private boolean loadSample;
    private LogoBooter lb;
    private ChaseInitializer ini;
    private String oldHosts;
    private String currHosts;
    private JInternalFrame[] frameMap;

    void setLoadSample(boolean loadSample) {
        this.loadSample = loadSample;
    }

    void init() {
        logger.info((Object)"Welcome to PHASE-Viewer!");
        String ver = "Copyright (C)  Corporation.";
        try {
            ver = PhaseViewerMain.getDefaultPropertiesDocument().getRootElement().getChildTextTrim("copyright");
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info((Object)ver);
        GlobalProperties props = PropertiesManager.getGlobalProperties(0);
        this.desktop = Desk.getDesktop();
        JScrollPane scrpanedesk = new JScrollPane(this.desktop);
        scrpanedesk.setPreferredSize(new Dimension(this.desktop.getWidth(), this.desktop.getHeight()));
        ((Desk)this.desktop).setScrollPane(scrpanedesk);
        ((Desk)this.desktop).setParentFrame(this);
        dirBrowser = new ProjectDirBrowser("projects");
        if (this.loadSample) {
            dirBrowser.loadSample();
        }
        this.mbox = new MyMessageBox();
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        String unit_increment = props.getProperty("desktop_scrollbar_increment");
        int unitincre = 30;
        try {
            unitincre = Integer.parseInt(unit_increment);
        }
        catch (NumberFormatException nfe) {
            unitincre = 30;
        }
        int hunit = unitincre;
        int vunit = unitincre;
        scrpanedesk.getHorizontalScrollBar().setUnitIncrement(hunit);
        scrpanedesk.getVerticalScrollBar().setUnitIncrement(vunit);
        scrpanedesk.getViewport().setScrollMode(0);
        JTextArea textarea = JTextAreaAppender.getTextArea();
        textarea.setLineWrap(true);
        textarea.setWrapStyleWord(true);
        JScrollPane scrpane = new JScrollPane(textarea);
        scrpane.setVerticalScrollBarPolicy(22);
        scrpane.setPreferredSize(new Dimension(250, 250));
        JPanel logview = new JPanel();
        logview.setLayout(new BoxLayout(logview, 0));
        JButton clearLogButton = new JButton("clear log");
        JButton logsaveButton = new JButton("save log");
        logview.add(scrpane);
        JPanel logbuttons = new JPanel();
        logbuttons.setLayout(new BoxLayout(logbuttons, 1));
        logbuttons.add(clearLogButton);
        logbuttons.add(logsaveButton);
        logview.add(logbuttons);
        JScrollPane scrDir = new JScrollPane();
        JPanel panel = new JPanel();
        scrDir.getViewport().setView(dirBrowser);
        ChaseSplitPane splitpaneDir = new ChaseSplitPane("dirselector", 1, (Component)this);
        this.components.addElement(splitpaneDir);
        splitpaneDir.setOneTouchExpandable(true);
        splitpaneDir.setLeftComponent(dirBrowser);
        splitpaneDir.setRightComponent(scrpanedesk);
        splitpaneDir.init();
        ChaseSplitPane splitpane = new ChaseSplitPane("logviewer", 0, (Component)this);
        splitpane.setTopComponent(splitpaneDir);
        splitpane.setBottomComponent(logview);
        splitpane.setContinuousLayout(true);
        splitpane.setOneTouchExpandable(true);
        splitpane.setResizeWeight(1.0);
        splitpane.init();
        JPanel foo = new JPanel();
        foo.setLayout(new BoxLayout(foo, 0));
        foo.add(splitpane);
        panel1.add(foo);
        JPanel foo1 = new JPanel();
        foo1.setLayout(new BorderLayout());
        this.monitor = ChaseProgressMonitor.getMonitor();
        foo1.add((Component)this.monitor, "West");
        panel1.add(this.monitor);
        this.cont.add(panel1);
        this.components.addElement(splitpane);
        logsaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChaseGUI.this.exportLog();
            }
        });
        clearLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChaseGUI.this.clearLog();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ChaseGUI.this.endApplication();
            }
        });
        GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
        String me = gp.getProperty("dont_show_menu");
        if (!new Boolean(me).booleanValue()) {
            this.chaseMenu = new ChaseMenu(this);
            this.setJMenuBar(this.chaseMenu);
        }
        GlobalHotkeyManager hkmanager = GlobalHotkeyManager.getInstance();
        hkmanager.getInputMap().put(this.toggleWindowKey, "TOGGLE_WINDOW");
        hkmanager.getActionMap().put("TOGGLE_WINDOW", this.toggleWindowAction);
        hkmanager.getInputMap().put(this.toggleWindowRevKey, "TOGGLE_WINDOW_REVERSE");
        hkmanager.getActionMap().put("TOGGLE_WINDOW_REVERSE", this.toggleWindowRevAction);
        hkmanager.getInputMap().put(this.closeWindowKey, "CLOSE_WINDOW");
        hkmanager.getActionMap().put("CLOSE_WINDOW", this.closeWindowAction);
        hkmanager.getInputMap().put(this.closeAppKey, "CLOSE_APPLICATION");
        hkmanager.getActionMap().put("CLOSE_APPLICATION", this.closeAppAction);
        hkmanager.getInputMap().put(this.toggleDirKey, "TOGGLE_DIR_BROWSER");
        hkmanager.getActionMap().put("TOGGLE_DIR_BROWSER", this.toggleDirAction);
        hkmanager.getInputMap().put(this.bootHelpKey, "BOOT_HELP");
        hkmanager.getActionMap().put("BOOT_HELP", this.bootHelpAction);
        hkmanager.getInputMap().put(this.selectFromProjKey, "SELECT_FROM_PROJECTS");
        hkmanager.getActionMap().put("SELECT_FROM_PROJECTS", this.selectFromProjAction);
        if (this.lb != null) {
            this.lb.stop();
        }
        if (this.ini != null) {
            this.ini.setVisible(false);
            this.ini.dispose();
        }
        this.display(true);
    }

    private void convertHostsFile() {
        HostInfo hinfo = HostList.getHostList().getHostInfo("localhost");
        DataManager dm = new DataManager(this.oldHosts);
        dm.setWSisDelimiter(false);
        dm.parse();
        InputInterface inputInterface = dm.getInputInterface();
        inputInterface.selectRoot();
        String oldbdir = inputInterface.getInputInterfacePrimitiveEntry("localhost.basedir").getValue();
        if (oldbdir != null && oldbdir.trim().length() != 0) {
            hinfo.setProperty("basedir", oldbdir);
        }
        HostList.getHostList().save();
    }

    /*
     * Loose catch block
     */
    public ChaseGUI(boolean splash) {
        double locversion;
        boolean verfileExists;
        String version;
        boolean chaseiniExists;
        block34: {
            super("PHASE-Viewer:", new Dimension(1024, 768), false);
            this.FS = System.getProperty("file.separator");
            this.fontsize = 12;
            this.fonttype = "SansSerif";
            this.fontstyle = 0;
            this.chaseiniExists = true;
            this.components = new Vector();
            this.toggleWindowString = "TOGGLE_WINDOW";
            this.toggleWindowKey = KeyStroke.getKeyStroke(9, 128, false);
            this.toggleWindowAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setEnabled(false);
                    ChaseGUI.this.toggleWindow(false);
                    this.setEnabled(true);
                }
            };
            this.toggleWindowRevString = "TOGGLE_WINDOW_REVERSE";
            this.toggleWindowRevKey = KeyStroke.getKeyStroke(9, 192, false);
            this.toggleWindowRevAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setEnabled(false);
                    ChaseGUI.this.toggleWindow(true);
                    this.setEnabled(true);
                }
            };
            this.closeWindowString = "CLOSE_WINDOW";
            this.closeWindowKey = KeyStroke.getKeyStroke(87, 2, false);
            this.closeWindowKey2 = KeyStroke.getKeyStroke(27, 0, false);
            this.closeWindowAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setEnabled(false);
                    ChaseGUI.this.closeActiveWindow();
                    this.setEnabled(true);
                }
            };
            this.closeAppString = "CLOSE_APPLICATION";
            this.closeAppKey = KeyStroke.getKeyStroke(81, 2, false);
            this.closeAppAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setEnabled(false);
                    ChaseGUI.this.endApplication();
                    this.setEnabled(true);
                }
            };
            this.toggleDirString = "TOGGLE_DIR_BROWSER";
            this.toggleDirKey = KeyStroke.getKeyStroke(84, 3, false);
            this.toggleDirAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setEnabled(false);
                    dirBrowser.requestFocus();
                    this.setEnabled(true);
                }
            };
            this.bootHelpString = "BOOT_HELP";
            this.bootHelpKey = KeyStroke.getKeyStroke(112, 0, false);
            this.bootHelpAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setEnabled(false);
                    HelpViewer vie = new HelpViewer();
                    this.setEnabled(true);
                }
            };
            this.selectFromProj = "SELECT_FROM_PROJECTS";
            this.selectFromProjKey = KeyStroke.getKeyStroke(49, 3, false);
            this.selectFromProjAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChaseGUI.selectFromProjects();
                }
            };
            this.loadSample = false;
            this.oldHosts = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".phase-viewer" + System.getProperty("file.separator") + "hosts";
            this.currHosts = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".phase-viewer" + System.getProperty("file.separator") + "hosts.xml";
            String chaseini = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + System.getProperty("file.separator") + ".phase-viewer" + System.getProperty("file.separator") + "phase-viewer.ini";
            chaseiniExists = new File(chaseini).exists();
            version = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".phase-viewer" + System.getProperty("file.separator") + "VERSION";
            verfileExists = new File(version).exists();
            locversion = -1.0;
            if (verfileExists) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(version));
                    locversion = Double.parseDouble(reader.readLine().split(":")[1].trim());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                    break block34;
                }
                catch (NumberFormatException ioe) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                    break block34;
                }
                catch (NullPointerException ioe) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                    break block34;
                    {
                        catch (Throwable throwable) {
                            try {
                                reader.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        logger.debug((Object)("version file: " + version + " does it exsist? " + verfileExists));
        String versionno = PhaseViewerMain.getDefaultPropertiesDocument().getRootElement().getChildTextTrim("version");
        double currversion = Double.parseDouble(versionno);
        logger.debug((Object)("version: " + versionno));
        boolean currhostsexi = new File(this.currHosts).exists();
        boolean oldhostsexi = new File(this.oldHosts).exists();
        logger.debug((Object)("currhost exists? " + currhostsexi));
        logger.debug((Object)("oldhost exists? " + oldhostsexi));
        if (new File(this.oldHosts).exists() && !new File(this.currHosts).exists()) {
            this.convertHostsFile();
        }
        if (splash) {
            this.lb = new LogoBooter(this);
        }
        this.setInitialLookandFeel();
        if (chaseiniExists && currversion <= locversion) {
            this.init();
        } else {
            block36: {
                if (this.lb != null) {
                    this.lb.stop();
                }
                PrintWriter verwriter = null;
                try {
                    try {
                        verwriter = new PrintWriter(new BufferedWriter(new FileWriter(version)));
                        verwriter.println("version: " + versionno);
                        verwriter.flush();
                    }
                    catch (Exception exc) {
                        logger.error((Object)("failed write to: " + version));
                        try {
                            verwriter.close();
                        }
                        catch (Exception exception) {}
                        break block36;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        verwriter.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    verwriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.ini = new ChaseInitializer(this);
        }
    }

    public ChaseMenu getMenuBarChase() {
        return this.chaseMenu;
    }

    private void toggleWindow(boolean reverse) {
        if (this.isActive()) {
            this.toggleInternalFrame(reverse);
        } else {
            Desktop4Frame.toggleFrame(reverse);
        }
    }

    private void closeActiveWindow() {
        Frame frameHeavy = Desktop4Frame.getActiveComponent();
        if (frameHeavy != null && frameHeavy != this) {
            frameHeavy.dispose();
            return;
        }
        JInternalFrame frame = this.desktop.getSelectedFrame();
        if (frame != null) {
            frame.dispose();
        }
    }

    public void display(boolean disp) {
        if (this.monitor != null) {
            this.monitor.init();
        }
        this.setVisible(disp);
        JInternalFrame[] frames = this.desktop.getAllFrames();
        if (frames != null && frames.length != 0) {
            try {
                frames[frames.length - 1].setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void endApplication() {
        this.exiting();
        this.dispose();
        System.exit(0);
    }

    public void exiting() {
        dirBrowser.saveMyProjects();
        int i = 0;
        while (i < this.components.size()) {
            ((ChaseFrame)this.components.elementAt(i)).saveState();
            ++i;
        }
    }

    public static int getScreenHeight() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        DisplayMode mode = device.getDisplayMode();
        if (mode == null) {
            return 0;
        }
        return mode.getHeight();
    }

    public static int getScreenWidth() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        DisplayMode mode = device.getDisplayMode();
        if (mode == null) {
            return 0;
        }
        return mode.getWidth();
    }

    public void setUI(String str) {
        try {
            UIManager.setLookAndFeel(str);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exc) {
            logger.error((Object)("Error loading L&F: " + str));
            exc.printStackTrace();
        }
        catch (Error er) {
            this.setUI(LookandFeel.landf_metal);
        }
    }

    static ProjectDirBrowser getProjectDirBrowser() {
        return dirBrowser;
    }

    private void updateInternalFrameMap(JInternalFrame[] frames, JInternalFrame currentFrame) {
        block5: {
            block4: {
                if (this.frameMap != null && this.frameMap.length == frames.length) break block4;
                this.frameMap = new JInternalFrame[frames.length];
                int i = 0;
                while (i < this.frameMap.length) {
                    this.frameMap[i] = frames[i];
                    ++i;
                }
                break block5;
            }
            boolean found = false;
            int i = 0;
            while (i < this.frameMap.length) {
                if (this.frameMap[i] == currentFrame) {
                    found = true;
                }
                ++i;
            }
            if (found) break block5;
            this.frameMap = new JInternalFrame[frames.length];
            i = 0;
            while (i < this.frameMap.length) {
                this.frameMap[i] = frames[i];
                ++i;
            }
        }
    }

    static void selectFromProjects() {
        JInternalFrame currFrame = Desk.getDesktop().getSelectedFrame();
        if (currFrame instanceof ProjectBrowser) {
            ((ProjectBrowser)currFrame).selectFromProjects();
        }
    }

    private void toggleInternalFrame(boolean reverse) {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        if (frames == null || frames.length == 0) {
            return;
        }
        JInternalFrame currentFrame = this.desktop.getSelectedFrame();
        if (currentFrame == null) {
            currentFrame = frames[frames.length - 1];
        }
        JInternalFrame nextFrame = null;
        this.updateInternalFrameMap(frames, currentFrame);
        if (this.frameMap.length == 1) {
            nextFrame = currentFrame;
        } else if (!reverse) {
            int i = 0;
            while (i < this.frameMap.length) {
                if (this.frameMap[i] == currentFrame) {
                    nextFrame = i == this.frameMap.length - 1 ? this.frameMap[0] : this.frameMap[i + 1];
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.frameMap.length) {
                if (this.frameMap[i] == currentFrame) {
                    nextFrame = i == 0 ? this.frameMap[this.frameMap.length - 1] : this.frameMap[i - 1];
                }
                ++i;
            }
        }
        try {
            nextFrame.setSelected(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearLog() {
        JTextArea textArea = JTextAreaAppender.getTextArea();
        textArea.setText("");
    }

    private void exportLog() {
        JTextArea textArea = JTextAreaAppender.getTextArea();
        ChaseFileChooser filechooser = new ChaseFileChooser("log");
        filechooser.setFileSelectionMode(0);
        if (filechooser.showDialog(this, "open") != 0) {
            return;
        }
        String selectedFile = filechooser.getSelectedFile().getAbsolutePath();
        logger.info((Object)("exported log file to " + selectedFile));
        try {
            FileWriter writer = new FileWriter(new File(selectedFile));
            writer.write(textArea.getText());
            writer.flush();
            writer.close();
        }
        catch (IOException ioe) {
            logger.error((Object)("failed to export log to file : " + selectedFile));
        }
    }

    protected void setInitialLookandFeel() {
        GlobalProperties props = PropertiesManager.getGlobalProperties(0);
        try {
            int default_font_style = 1;
            String default_font_name = "Helvetica";
            int default_font_size = 11;
            default_font_name = props.getProperty("default_font_name");
            default_font_style = Integer.parseInt(props.getProperty("default_font_style"));
            default_font_size = Integer.parseInt(props.getProperty("default_font_size"));
            LookandFeel.setUIFont(default_font_name, default_font_style, default_font_size);
        }
        catch (Exception default_font_style) {
            // empty catch block
        }
        String lf = props.getProperty("look_and_feel");
        if (lf != null && lf.length() != 0) {
            boolean failed_skin_load = false;
            if (lf.equals(LookandFeel.landf_skin)) {
                String skin = props.getProperty("look_and_feel_skin");
                String defaultSkin = "defaultthemepack.zip";
                if (skin != null && skin.trim().length() != 0) {
                    try {
                        SkinLookAndFeel.setSkin((Skin)SkinLookAndFeel.loadThemePack((String)(String.valueOf(System.getProperty("pviewer.home")) + this.FS + "lib" + this.FS + "skinlf" + this.FS + skin)));
                    }
                    catch (Exception ee) {
                        failed_skin_load = true;
                        logger.error((Object)("failed to load: " + skin));
                    }
                } else {
                    try {
                        SkinLookAndFeel.setSkin((Skin)SkinLookAndFeel.loadThemePack((String)(String.valueOf(System.getProperty("pviewer.home")) + this.FS + "lib" + this.FS + "skinlf" + this.FS + defaultSkin)));
                    }
                    catch (Exception ex) {
                        failed_skin_load = true;
                        logger.error((Object)("failed to load: " + defaultSkin));
                    }
                }
            }
            boolean sup = false;
            int i = 0;
            while (i < LookandFeel.supported_lf.length) {
                if (LookandFeel.supported_lf[i].equals(lf)) {
                    this.setUI(lf);
                    sup = true;
                    break;
                }
                ++i;
            }
            if (!sup) {
                logger.error((Object)("unsupported look and feel: " + lf));
                logger.error((Object)("using default: " + LookandFeel.landf_metal));
                this.setUI(LookandFeel.landf_metal);
            } else if (failed_skin_load) {
                logger.error((Object)"unsupported skin.");
                this.setUI(LookandFeel.landf_metal);
            }
        } else if (Utils.isWindows()) {
            this.setUI(LookandFeel.landf_win);
        } else {
            this.setUI(LookandFeel.landf_metal);
        }
    }
}

