/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.jobcontrol;

import ciss.phase_viewer.common.Resources;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.Monitorable;
import ciss.phase_viewer.jobcontrol.MonitorPanelInterface;
import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import com.jcraft.jsch.Session;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.apache.log4j.Logger;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;

public class MonitorPanel
extends InternalFrameChase
implements ChartProgressListener,
MonitorPanelInterface {
    private boolean drawingChart = false;
    private Logger logger = Logger.getLogger((String)MonitorPanel.class.getName());
    private ProjectInfo projectInfo;
    private ChaseFile[] chaseFile;
    private Session session;
    private JComboBox fileSelector;
    private JTextArea monitorTextArea;
    private Monitorable monitorable;
    private JToggleButton monitorButton;
    private JToggleButton graphButton;
    private HashMap monitorCache = new HashMap();

    public void chartProgress(ChartProgressEvent arg0) {
        if (arg0.getType() == 1) {
            this.drawingChart = true;
        } else if (arg0.getType() == 2) {
            this.drawingChart = false;
        }
    }

    public MonitorPanel(ProjectInfo projectInfo, Session session) {
        super("host: " + projectInfo.getHostInfo().getName() + " dir: " + projectInfo.getTargetDirectory(), true, true, true, true, new Dimension(640, 500));
        this.projectInfo = projectInfo;
        this.session = session;
        this.init();
    }

    private void init() {
        ChaseFile[] cfs = this.projectInfo.getChaseFileManager().getFiles();
        if (cfs == null || cfs.length == 0) {
            this.logger.error((Object)"invalid files!");
            this.dispose();
            return;
        }
        Vector<ChaseFile> validFiles = new Vector<ChaseFile>();
        int i = 0;
        while (i < cfs.length) {
            this.logger.debug((Object)("cfs: " + cfs[i]));
            if (cfs[i].isMonitorable()) {
                validFiles.addElement(cfs[i]);
            }
            ++i;
        }
        if (validFiles.size() == 0) {
            this.logger.error((Object)"no monitorable files.");
            this.dispose();
            return;
        }
        this.chaseFile = new ChaseFile[validFiles.size()];
        validFiles.copyInto(this.chaseFile);
        JPanel fileMonitor = this.getFileMonitorPanel();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                MonitorPanel.this.stopAll();
                if (MonitorPanel.this.session != null) {
                    MonitorPanel.this.session.disconnect();
                }
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                MonitorPanel.this.stopAll();
                if (MonitorPanel.this.session != null) {
                    MonitorPanel.this.session.disconnect();
                }
            }
        });
        JButton btnclose = new JButton("close");
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(fileMonitor);
        container.add(btnclose);
        btnclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MonitorPanel.this.dispose();
            }
        });
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                if (MonitorPanel.this.session != null) {
                    MonitorPanel.this.session.disconnect();
                }
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
            }
        });
    }

    @Override
    public void setGraphButtonSelected(boolean sel) {
        if (this.graphButton != null) {
            int i;
            this.logger.debug((Object)("calling graphButton.setSelected(" + sel + ")"));
            ActionListener[] al = this.graphButton.getActionListeners();
            if (al != null) {
                i = 0;
                while (i < al.length) {
                    this.graphButton.removeActionListener(al[i]);
                    ++i;
                }
            }
            this.graphButton.setSelected(sel);
            if (al != null) {
                i = 0;
                while (i < al.length) {
                    this.graphButton.addActionListener(al[i]);
                    ++i;
                }
            }
        }
    }

    private JPanel getFileMonitorPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JPanel pbtns = new JPanel();
        pbtns.setLayout(new BoxLayout(pbtns, 0));
        String[] idents = new String[this.chaseFile.length];
        int i = 0;
        while (i < idents.length) {
            idents[i] = this.chaseFile[i].getIdentifier().getValue();
            ++i;
        }
        this.fileSelector = new JComboBox<String>(idents);
        this.monitorButton = new JToggleButton(Resources.getIcon("/org/javalobby/icons/20x20/VCRPlay.gif"));
        this.monitorButton.setToolTipText("toggle monitor");
        this.graphButton = new JToggleButton(Resources.getIcon("/org/javalobby/icons/20x20/LineGraph.gif"));
        this.graphButton.setEnabled(false);
        JPanel psele = new JPanel();
        psele.setBorder(new TitledBorder("select file to monitor"));
        psele.setLayout(new BoxLayout(psele, 0));
        psele.add(this.fileSelector);
        pbtns.add(psele);
        pbtns.add(this.monitorButton);
        pbtns.add(this.graphButton);
        p.add((Component)pbtns, "North");
        this.monitorTextArea = new JTextArea();
        this.monitorTextArea.setEditable(false);
        JScrollPane scrpane = new JScrollPane(this.monitorTextArea);
        p.add((Component)scrpane, "Center");
        this.fileSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MonitorPanel.this.fileSelected();
            }
        });
        this.monitorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (MonitorPanel.this.monitorable != null && MonitorPanel.this.monitorButton.isSelected()) {
                    MonitorPanel.this.monitorable.monitor(MonitorPanel.this.session, MonitorPanel.this.monitorTextArea);
                    MonitorPanel.this.graphButton.setEnabled(MonitorPanel.this.monitorable.isGraphCreatable(MonitorPanel.this.monitorTextArea));
                } else if (MonitorPanel.this.monitorable != null && !MonitorPanel.this.monitorButton.isSelected()) {
                    MonitorPanel.this.monitorable.stopMonitor();
                    MonitorPanel.this.graphButton.setEnabled(false);
                    MonitorPanel.this.graphButton.setSelected(false);
                    MonitorPanel.this.monitorable.destroyGraph();
                    try {
                        MonitorPanel.this.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        });
        this.graphButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (MonitorPanel.this.monitorable != null) {
                    if (MonitorPanel.this.graphButton.isSelected()) {
                        MonitorPanel.this.monitorable.createGraphFrom(MonitorPanel.this.monitorTextArea);
                    } else {
                        MonitorPanel.this.logger.debug((Object)"destroying graph");
                        MonitorPanel.this.monitorable.destroyGraph();
                        try {
                            MonitorPanel.this.setSelected(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.monitorTextArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                if (MonitorPanel.this.monitorable != null) {
                    MonitorPanel.this.graphButton.setEnabled(MonitorPanel.this.monitorable.isGraphCreatable(MonitorPanel.this.monitorTextArea));
                } else {
                    MonitorPanel.this.graphButton.setEnabled(false);
                }
            }
        });
        this.fileSelector.setSelectedIndex(0);
        return p;
    }

    private void fileSelected() {
        this.monitorButton.setSelected(false);
        this.setGraphButtonSelected(false);
        this.graphButton.setEnabled(false);
        if (this.monitorable != null) {
            this.monitorable.stopMonitor();
            this.monitorable.destroyGraph();
        }
        this.monitorTextArea.setText("");
        ChaseFile selectedFile = this.chaseFile[this.fileSelector.getSelectedIndex()];
        Object obj = this.monitorCache.get(selectedFile.getIdentifier().getValue());
        if (obj == null) {
            String path = selectedFile.getMonitorPath();
            this.monitorable = (Monitorable)PluginLoader.instantiate(path, new Object[]{this.projectInfo});
            this.monitorable.setMonitorPanel(this);
            this.monitorCache.put(selectedFile.getIdentifier().getValue(), this.monitorable);
        } else {
            this.monitorable = (Monitorable)obj;
        }
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void stopAll() {
        Set keySet = this.monitorCache.keySet();
        if (keySet == null) {
            return;
        }
        Object[] foo = keySet.toArray();
        if (foo == null || foo.length == 0) {
            return;
        }
        int i = 0;
        while (i < foo.length) {
            Monitorable mon = (Monitorable)this.monitorCache.get(foo[i]);
            if (mon != null) {
                mon.stopMonitor();
            }
            ++i;
        }
    }

    protected void finalize() throws Throwable {
        this.stopAll();
        if (this.session != null) {
            this.session.disconnect();
        }
    }
}

