/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface;

import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import java.util.HashMap;

public class InputInterfaceUnits
extends InputInterfaceEntry {
    private String[] units;
    public static String LENGTH = "length";
    public static String ENERGY = "energy";
    private static HashMap unitMap;

    public InputInterfaceUnits() {
    }

    public InputInterfaceUnits(String name, String[] units) {
        super(name);
        this.units = units;
    }

    public String[] getUnits() {
        return this.units;
    }

    public void setUnits(String[] units) {
        this.units = units;
    }

    public String[] getUnitTypes() {
        if (this.units == null) {
            return null;
        }
        HashMap map = InputInterfaceUnits.getUnitMap();
        String[] types = new String[this.units.length];
        int i = 0;
        while (i < this.units.length) {
            Object obj = map.get(this.units[i].toLowerCase());
            types[i] = obj != null ? obj.toString() : null;
            ++i;
        }
        return types;
    }

    @Override
    public int getEntryType() {
        return 3;
    }

    public InputInterfaceEntry getCopy() {
        return this;
    }

    @Override
    public boolean equals(InputInterfaceEntry entry) {
        return entry instanceof InputInterfaceUnits;
    }

    @Override
    public void saveState() {
    }

    @Override
    public void undo() {
    }

    @Override
    public void redo() {
    }

    public static HashMap getUnitMap() {
        if (unitMap == null) {
            unitMap = new HashMap();
            unitMap.put("angstrom", LENGTH);
            unitMap.put("bohr", LENGTH);
            unitMap.put("nm", LENGTH);
            unitMap.put("ev", ENERGY);
            unitMap.put("hartree", ENERGY);
            unitMap.put("rydberg", ENERGY);
        }
        return unitMap;
    }
}

