/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface;

import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.inputinterface.InputInterfaceBlock;
import ciss.phase_viewer.inputinterface.InputInterfaceBlockChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceBlockChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfaceData;
import ciss.phase_viewer.inputinterface.InputInterfaceDefaults;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceUnits;
import ciss.phase_viewer.inputinterface.UndoRedo;
import ciss.phase_viewer.inputinterface.UndoRedoListener;
import ciss.phase_viewer.inputinterface.Utils;
import ciss.phase_viewer.inputinterface.filestate.FileStateObserver;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpec;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpecManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InputInterface
implements Serializable,
Input {
    public static String __ROOT__ = "rootBlock";
    private InputInterfaceBlock list = new InputInterfaceBlock();
    private static Logger logger = Logger.getLogger((String)InputInterface.class.getName());
    private int blockDepth;
    private PrintWriter writer;
    private String indent = "    ";
    private int restartAt = 1;
    private Stack restartAts;
    private String[] defaultName;
    private String[] defaultValue;
    private String fileName;
    private InputInterfaceTableSpec[] specs;
    private InputInterfaceTableSpecManager manager;
    private Vector changeListeners = new Vector();
    private Vector blockChangeListeners = new Vector();
    private UndoRedo undoRedo;
    private boolean updateUndoStack = true;
    private boolean stateChanged = false;
    private boolean writeNullValue = false;
    private boolean genLockFileOnSave = false;
    private String string;
    protected boolean block = false;
    private boolean writeDelimitedByColon = false;
    protected boolean iSavedIt = false;

    public InputInterface() {
        this.list.add(null);
        this.list.setName("root block");
        this.undoRedo = new UndoRedo(this);
    }

    public void setGenerateLockFileOnSave(boolean genLockFileOnSave) {
        this.genLockFileOnSave = genLockFileOnSave;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setUpdateUndoStack(boolean updateUndoStack) {
        this.updateUndoStack = updateUndoStack;
    }

    public void undo() {
        this.undoRedo.undo();
    }

    public void redo() {
        this.undoRedo.redo();
    }

    protected void clearUndoRedo() {
        this.undoRedo.clear();
    }

    public void addUndoRedoListener(UndoRedoListener listener) {
        this.undoRedo.addUndoRedoListener(listener);
    }

    private void blockChanged(String tag, InputInterfaceBlock block, InputInterfaceBlockChangeListener source) {
        InputInterfaceBlockChangeEvent event = new InputInterfaceBlockChangeEvent(tag, block, source, this);
        int i = 0;
        while (i < this.blockChangeListeners.size()) {
            InputInterfaceBlockChangeListener listener = (InputInterfaceBlockChangeListener)this.blockChangeListeners.elementAt(i);
            listener.inputInterfaceBlockChanged(event);
            ++i;
        }
    }

    private void entryChanged(String tag, InputInterfaceEntry entry, InputInterfaceEntryChangeListener source) {
        InputInterfaceEntryChangeEvent event = new InputInterfaceEntryChangeEvent(tag, entry, source, this);
        if (this.updateUndoStack) {
            this.undoRedo.addEntry(tag, entry);
            this.stateChanged = true;
        }
        int i = 0;
        while (i < this.changeListeners.size()) {
            InputInterfaceEntryChangeListener listener = (InputInterfaceEntryChangeListener)this.changeListeners.elementAt(i);
            logger.debug((Object)(" foobar " + i + " called from " + this.changeListeners.elementAt(i).getClass()));
            listener.inputInterfaceEntryChanged(event);
            ++i;
        }
    }

    protected void initialize() {
        this.selectRoot();
        InputInterfaceBlock root = this.getCurrentBlock();
        root.init("root block");
        this.undoRedo.clear();
        int i = 0;
        while (i < this.changeListeners.size()) {
            InputInterfaceEntryChangeListener listener = (InputInterfaceEntryChangeListener)this.changeListeners.elementAt(i);
            listener.inputInterfaceInitializing();
            ++i;
        }
    }

    protected void intialized() {
        int i = 0;
        while (i < this.changeListeners.size()) {
            InputInterfaceEntryChangeListener listener = (InputInterfaceEntryChangeListener)this.changeListeners.elementAt(i);
            listener.inputInterfaceInitialized();
            ++i;
        }
    }

    public void addInputInterfaceEntryChangeListener(InputInterfaceEntryChangeListener listener) {
        int i = 0;
        while (i < this.changeListeners.size()) {
            if (this.changeListeners.get(i) == listener) {
                return;
            }
            ++i;
        }
        logger.debug((Object)("adding listener: " + listener.getClass()));
        this.changeListeners.addElement(listener);
    }

    public void addInputInterfaceBlockChangeListener(InputInterfaceBlockChangeListener listener) {
        int i = 0;
        while (i < this.blockChangeListeners.size()) {
            if (this.blockChangeListeners.get(i) == listener) {
                return;
            }
            ++i;
        }
        this.blockChangeListeners.addElement(listener);
    }

    public void removeInputInterfaceEntryChangeListener(InputInterfaceEntryChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void removeInputInterfaceBlockChangeListener(InputInterfaceBlockChangeListener listener) {
        this.blockChangeListeners.remove(listener);
    }

    public void selectAndCreateBlock(String blockName) {
        String[] array = blockName.split("\\.");
        if (array != null) {
            this.selectAndCreateBlock(array, array.length);
        }
    }

    public void selectAndCreateBlock(String[] blockNames, int depth) {
        int bdepth = depth;
        if (depth > blockNames.length) {
            bdepth = blockNames.length;
        }
        String blName = "";
        int i = 0;
        while (i < bdepth) {
            String ident = blockNames[i];
            blName = blName.trim().length() == 0 ? ident : String.valueOf(blName) + "." + ident;
            if (!this.selectBlock(ident)) {
                logger.debug((Object)("creating block: " + blName));
                this.addBlock(new InputInterfaceBlock(ident, blName));
            }
            ++i;
        }
    }

    public InputInterfaceTable getInputInterfaceTable(String blockName) {
        this.selectRoot();
        String[] fullName = blockName.split("\\.");
        this.selectAndCreateBlock(fullName, fullName.length);
        return this.getTable();
    }

    public InputInterfacePrimitiveEntry getInputInterfacePrimitiveEntry(String entryName) {
        this.selectRoot();
        String[] fullName = entryName.split("\\.");
        this.selectAndCreateBlock(fullName, fullName.length - 1);
        return this.getPrimitiveEntry(fullName[fullName.length - 1]);
    }

    private String getParentTag(String[] tag) {
        String ret = "";
        int i = 0;
        while (i < tag.length - 1) {
            ret = String.valueOf(ret) + tag[i];
            ++i;
        }
        return ret;
    }

    public InputInterfaceUnits getInputInterfaceUnits(String unitName) {
        this.selectRoot();
        String[] fullName = unitName.split("\\.");
        this.selectAndCreateBlock(fullName, fullName.length - 1);
        return this.getUnits();
    }

    public void addBlock(InputInterfaceBlock block, boolean select) {
        if (block.size() == 0) {
            block.addFirst(this.list);
        } else {
            block.set(0, this.list);
        }
        this.list.addLast(block);
        if (select) {
            this.selectBlock(block.getName(), null);
        }
    }

    public void addBlock(InputInterfaceBlock block) {
        if (block.size() == 0) {
            block.addFirst(this.list);
        } else {
            block.set(0, this.list);
        }
        this.list.addLast(block);
        this.selectBlock(block.getName(), null);
    }

    private void addEntry(InputInterfaceEntry entry) {
        this.list.addLast(entry);
        int type = entry.getEntryType();
        if (type == 1) {
            this.list.setHasTable(true);
        }
        if (type == 2) {
            this.list.setHasDefaults(true);
        }
        if (type == 3) {
            this.list.setHasUnits(true);
        }
    }

    public void replaceBlock(InputInterfaceBlock block, InputInterfaceBlockChangeListener caller) {
        boolean found = false;
        this.replaceBlock(block);
        this.blockChanged(block.getFullName(), block, caller);
    }

    public void replaceBlock(InputInterfaceBlock block) {
        boolean found = false;
        int i = 1;
        while (i < this.list.size()) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data.isBlock() && data.getName().trim().equalsIgnoreCase(block.getName())) {
                logger.debug((Object)("replacing block: " + data));
                this.list.remove(i);
                this.list.add(i, block);
                if (block.size() != 0) {
                    block.set(0, this.list);
                } else {
                    block.add(this.list);
                }
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.addBlock(block, false);
        }
    }

    public void replaceEntry(InputInterfaceEntry entry, InputInterfaceEntryChangeListener source, boolean callListener) {
        int type = entry.getEntryType();
        String name = entry.getName();
        int i = 0;
        while (i < this.list.size()) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data != null && !data.isBlock()) {
                InputInterfaceEntry en = (InputInterfaceEntry)data;
                if (data.getName().trim().equalsIgnoreCase(name) && type == en.getEntryType()) {
                    this.list.remove(i);
                    boolean badd = true;
                    if (type == 0) {
                        InputInterfacePrimitiveEntry pentry = (InputInterfacePrimitiveEntry)entry;
                        badd = pentry.getValue() != null && pentry.getValue().trim().length() != 0;
                    } else if (type == 1) {
                        InputInterfaceTable tentry = (InputInterfaceTable)entry;
                        boolean bl = badd = tentry.getTableData() != null && tentry.getTableData().size() != 0;
                    }
                    if (badd) {
                        if (type == 3 || type == 2) {
                            logger.debug((Object)"adding entry at top of list for units & defaults.");
                            this.list.add(1, entry);
                        } else {
                            logger.debug((Object)"adding entry at bottom of list for primitive entries & tables.");
                            this.list.addLast(entry);
                        }
                        logger.debug((Object)("replacing entry..." + this.list.getFullName() + "." + entry.getName()));
                        if (callListener && source != null) {
                            this.entryChanged(this.list.getFullName(), entry, source);
                        }
                    }
                    return;
                }
            }
            ++i;
        }
        logger.debug((Object)("adding entry..." + this.list.getFullName() + "." + entry.getName()));
        this.addEntry(entry);
        if (callListener && source != null) {
            this.entryChanged(this.list.getFullName(), entry, source);
        }
    }

    public void replaceEntry(InputInterfaceEntry entry) {
        this.replaceEntry(entry, null, true);
    }

    public void replaceEntry(InputInterfaceEntry entry, InputInterfaceEntryChangeListener source) {
        this.replaceEntry(entry, source, true);
    }

    public void removeEntry(InputInterfaceEntry entry, InputInterfaceEntryChangeListener source) {
        this.removeEntry(entry, source, true);
    }

    public void removeEntry(InputInterfaceEntry entry) {
        this.removeEntry(entry, null, true);
    }

    public void removeEntry(InputInterfaceEntry entry, InputInterfaceEntryChangeListener source, boolean callListener) {
        int type = entry.getEntryType();
        String name = entry.getName();
        int i = 0;
        while (i < this.list.size()) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data != null && !data.isBlock()) {
                InputInterfaceEntry en = (InputInterfaceEntry)data;
                if (data.getName().trim().equalsIgnoreCase(name) && type == en.getEntryType()) {
                    this.list.remove(i);
                    if (callListener) {
                        this.entryChanged(this.list.getFullName(), entry, source);
                    }
                    return;
                }
            }
            ++i;
        }
    }

    public void removeBlock(InputInterfaceBlock block) {
        this.list.remove(block);
    }

    public void removeBlock(String name) {
        int i = 0;
        while (i < this.list.size()) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data != null && data.isBlock() && data.getName().equals(name)) {
                ((InputInterfaceBlock)data).remove(0);
                this.list.remove(data);
            }
            ++i;
        }
    }

    public boolean selectParentBlock() {
        if (this.list.get(0) != null) {
            this.list = (InputInterfaceBlock)this.list.get(0);
            return true;
        }
        return false;
    }

    public boolean selectBlock(String blockName) {
        return this.selectBlock(blockName, "\\.");
    }

    public boolean selectBlock(String blockName, String delimiter) {
        if (blockName == __ROOT__) {
            this.selectRoot();
            return true;
        }
        String[] decomp = null;
        if (delimiter == null || delimiter.trim().length() == 0) {
            decomp = new String[]{blockName};
        } else {
            decomp = blockName.split(delimiter);
            if (decomp == null) {
                return false;
            }
        }
        if (decomp.length > 1) {
            this.selectRoot();
        }
        int i = 0;
        while (i < decomp.length) {
            String ident = decomp[i];
            if (!this.selectBlockSub(ident)) {
                logger.debug((Object)("couldn't select block: " + ident));
                return false;
            }
            logger.debug((Object)("selected block: " + ident));
            ++i;
        }
        return true;
    }

    private boolean selectBlockSub(String blockName) {
        int i = 1;
        while (i < this.list.size()) {
            String name;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            logger.debug((Object)("name of data .... " + data.getName()));
            if (data.isBlock() && (name = data.getName()).trim().equalsIgnoreCase(blockName)) {
                this.list = (InputInterfaceBlock)data;
                return true;
            }
            ++i;
        }
        return false;
    }

    public InputInterfaceBlock getCurrentBlock() {
        return this.list;
    }

    public InputInterfacePrimitiveEntry getPrimitiveEntry(String name) {
        int i = 1;
        while (i < this.list.size()) {
            InputInterfaceEntry entry;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            logger.debug((Object)("at getPrimitiveEntry: got data: " + data.getName()));
            if (data.getName().trim().equalsIgnoreCase(name) && !data.isBlock() && (entry = (InputInterfaceEntry)data).getEntryType() == 0) {
                return (InputInterfacePrimitiveEntry)entry;
            }
            ++i;
        }
        InputInterfacePrimitiveEntry ent = new InputInterfacePrimitiveEntry();
        ent.setName(name);
        this.addEntry(ent);
        return ent;
    }

    public InputInterfacePrimitiveEntry[] getAllPrimitiveEntries() {
        Vector<InputInterfacePrimitiveEntry> entries = new Vector<InputInterfacePrimitiveEntry>();
        int i = 1;
        while (i < this.list.size()) {
            InputInterfaceEntry entry;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (!data.isBlock() && (entry = (InputInterfaceEntry)data).getEntryType() == 0) {
                entries.addElement((InputInterfacePrimitiveEntry)entry);
            }
            ++i;
        }
        if (entries.size() == 0) {
            return null;
        }
        InputInterfacePrimitiveEntry[] ret = new InputInterfacePrimitiveEntry[entries.size()];
        i = 0;
        while (i < entries.size()) {
            ret[i] = (InputInterfacePrimitiveEntry)entries.get(i);
            ++i;
        }
        return ret;
    }

    public InputInterfaceTable getTable() {
        int i = 1;
        while (i < this.list.size()) {
            InputInterfaceEntry entry;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (!data.isBlock() && (entry = (InputInterfaceEntry)data).getEntryType() == 1) {
                return (InputInterfaceTable)entry;
            }
            ++i;
        }
        logger.debug((Object)("getCurrentBlock().getFullName(): " + this.getCurrentBlock().getFullName()));
        InputInterfaceTableColumns[] cols = null;
        if (this.manager != null) {
            logger.debug((Object)"obtaining table spec...");
            InputInterfaceTableSpec tspec = this.manager.getTableSpec(this.list.getFullName());
            if (tspec != null) {
                logger.debug((Object)"obtaining columns");
                cols = tspec.getTableColumns();
            }
        }
        InputInterfaceTable ta = new InputInterfaceTable(this.getCurrentBlock().getName(), null, cols, new Vector());
        this.replaceEntry(ta);
        return ta;
    }

    public InputInterfaceDefaults getDefaults() {
        if (!this.list.hasDefaults()) {
            return null;
        }
        int i = 1;
        while (i < this.list.size()) {
            InputInterfaceEntry entry;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (!data.isBlock() && (entry = (InputInterfaceEntry)data).getEntryType() == 2) {
                return (InputInterfaceDefaults)entry;
            }
            ++i;
        }
        return null;
    }

    public InputInterfaceDefaults getDefaults(String name) {
        int i = 1;
        while (i < this.list.size()) {
            InputInterfaceEntry entry;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data.getName().trim().equalsIgnoreCase(name) && !data.isBlock() && (entry = (InputInterfaceEntry)data).getEntryType() == 2) {
                return (InputInterfaceDefaults)entry;
            }
            ++i;
        }
        return new InputInterfaceDefaults();
    }

    public InputInterfaceUnits getUnits() {
        int i = 1;
        while (i < this.list.size()) {
            InputInterfaceEntry entry;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (!data.isBlock() && (entry = (InputInterfaceEntry)data).getEntryType() == 3) {
                return (InputInterfaceUnits)entry;
            }
            ++i;
        }
        return new InputInterfaceUnits();
    }

    public void selectRoot() {
        if (this.selectParentBlock()) {
            this.selectRoot();
        }
    }

    public InputInterfaceBlock getRootList() {
        this.selectRoot();
        return this.list;
    }

    public boolean stateChanged() {
        return this.stateChanged;
    }

    public void setState(boolean stateChanged) {
        this.stateChanged = stateChanged;
    }

    public String toString() {
        logger.debug((Object)"obtaining string representation of 'inputinterface'...");
        this.blockDepth = 0;
        this.selectRoot();
        this.restartAts = new Stack();
        this.restartAt = 1;
        this.writer = null;
        this.string = "";
        this.saveSub();
        return this.string;
    }

    @Override
    public void save() {
        this.saveTo(new File(this.fileName));
    }

    public void save(boolean recreate) {
        this.saveTo(new File(this.fileName), recreate);
    }

    public void saveTo(File file) {
        this.saveTo(file, false);
    }

    private void deb(InputInterfaceBlock block) {
        if (!this.hasData(block)) {
            return;
        }
        ++this.blockDepth;
        String ws = this.getWhiteSpace(this.blockDepth);
        logger.debug((Object)(String.valueOf(ws) + block.getName() + "{"));
        if (this.writer != null) {
            this.writer.println(String.valueOf(ws) + block.getName() + "{");
        } else {
            this.string = String.valueOf(this.string) + ws + block.getName() + "{" + System.getProperty("line.separator");
        }
        if (block.hasUnits()) {
            this.writeUnits(block, this.blockDepth);
        }
        if (block.hasDefaults()) {
            this.writeDefaults(block, this.blockDepth);
        }
        int i = 1;
        while (i < block.size()) {
            String foo;
            InputInterfaceData dat = (InputInterfaceData)block.get(i);
            if (dat.isBlock()) {
                this.deb((InputInterfaceBlock)dat);
            } else if (dat instanceof InputInterfaceEntry && (foo = this.toString((InputInterfaceEntry)dat)) != null) {
                logger.debug((Object)foo);
                if (this.writer != null) {
                    this.writer.println(foo);
                } else {
                    this.string = String.valueOf(this.string) + foo + System.getProperty("line.separator");
                }
            }
            ++i;
        }
        --this.blockDepth;
        logger.debug((Object)(String.valueOf(ws) + "}"));
        if (this.writer != null) {
            this.writer.println(String.valueOf(ws) + "}");
        } else {
            this.string = String.valueOf(this.string) + ws + "}" + System.getProperty("line.separator");
        }
    }

    private boolean hasData(InputInterfaceBlock block) {
        int i = 1;
        while (i < block.size()) {
            block9: {
                InputInterfaceData data;
                block6: {
                    block8: {
                        InputInterfacePrimitiveEntry pent;
                        InputInterfaceEntry entry;
                        block7: {
                            data = (InputInterfaceData)block.get(i);
                            if (data.isBlock()) break block6;
                            entry = (InputInterfaceEntry)data;
                            if (entry.getEntryType() != 1) break block7;
                            boolean[] val = ((InputInterfaceTable)entry).getValidColumns();
                            boolean bl = false;
                            int ii = 0;
                            while (ii < val.length) {
                                if (val[ii]) {
                                    bl = true;
                                }
                                ++ii;
                            }
                            if (bl) break block8;
                            break block9;
                        }
                        if (entry.getEntryType() == 0 ? (pent = (InputInterfacePrimitiveEntry)entry).getValue() == null || pent.getValue().trim().length() == 0 : entry.getEntryType() == 3) break block9;
                    }
                    return true;
                }
                boolean bl = this.hasData((InputInterfaceBlock)data);
                if (bl) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void saveTo(File file, boolean recreate) {
        block9: {
            FileStateObserver.generateLockFile(file.getParentFile());
            this.block = true;
            this.blockDepth = 0;
            this.selectRoot();
            this.restartAts = new Stack();
            this.restartAt = 1;
            logger.info((Object)("saving input to: " + file));
            try {
                try {
                    this.writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                    int i = 1;
                    while (i < this.list.size()) {
                        InputInterfaceData data = (InputInterfaceData)this.list.get(i);
                        if (data.isBlock()) {
                            this.deb((InputInterfaceBlock)data);
                        }
                        ++i;
                    }
                    logger.info((Object)"input saved.");
                }
                catch (Exception exc) {
                    logger.warn((Object)"file in use?");
                    exc.printStackTrace();
                    this.writer.close();
                    this.iSavedIt = !recreate;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.writer.close();
                this.iSavedIt = !recreate;
                throw throwable;
            }
            this.writer.close();
            this.iSavedIt = !recreate;
        }
        this.selectRoot();
        this.block = false;
        this.stateChanged = false;
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileStateObserver.removeLockFile(file.getParentFile());
    }

    private boolean currBlockHasData() {
        int i = 1;
        while (i < this.list.size()) {
            block9: {
                InputInterfaceData data;
                block6: {
                    block8: {
                        InputInterfacePrimitiveEntry pent;
                        InputInterfaceEntry entry;
                        block7: {
                            data = (InputInterfaceData)this.list.get(i);
                            if (data.isBlock()) break block6;
                            entry = (InputInterfaceEntry)data;
                            if (entry.getEntryType() != 1) break block7;
                            boolean[] val = ((InputInterfaceTable)entry).getValidColumns();
                            boolean bl = false;
                            int ii = 0;
                            while (ii < val.length) {
                                if (val[ii]) {
                                    bl = true;
                                }
                                ++ii;
                            }
                            if (bl) break block8;
                            break block9;
                        }
                        if (entry.getEntryType() == 0 ? (pent = (InputInterfacePrimitiveEntry)entry).getValue() == null || pent.getValue().trim().length() == 0 : entry.getEntryType() == 3) break block9;
                    }
                    return true;
                }
                this.selectBlock(data.getName());
                if (this.currBlockHasData()) {
                    this.selectParentBlock();
                    return true;
                }
                this.selectParentBlock();
            }
            ++i;
        }
        return false;
    }

    private void saveSub() {
        try {
            int i = this.restartAt;
            while (i < this.list.size()) {
                InputInterfaceData data = (InputInterfaceData)this.list.get(i);
                String name = data.getName();
                if (data.isBlock()) {
                    ++this.blockDepth;
                    this.selectBlock(name, null);
                    Integer ii = new Integer(i + 1);
                    this.restartAts.push(ii);
                    logger.debug((Object)("entering block: " + name));
                    logger.debug((Object)("pushed: " + ii));
                    boolean bool = this.currBlockHasData();
                    if (!bool) {
                        this.endBlockWrite();
                        this.saveSub();
                    } else {
                        this.writeBlock((InputInterfaceBlock)data);
                        if (((InputInterfaceBlock)data).hasUnits()) {
                            this.writeUnits();
                        }
                        if (((InputInterfaceBlock)data).hasDefaults()) {
                            this.writeDefaults();
                        }
                        this.restartAt = 1;
                        this.saveSub();
                    }
                    break;
                }
                InputInterfaceEntry entry = (InputInterfaceEntry)data;
                if (this.blockDepth == 0 && data.getName().trim().length() == 0) {
                    logger.debug((Object)"something is wrong....");
                    break;
                }
                this.writeEntry(entry);
                if (i == this.list.size() - 1) {
                    this.endBlockWrite();
                    this.saveSub();
                    break;
                }
                ++i;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void endBlockWrite() {
        logger.debug((Object)("exiting block: " + this.list.getName()));
        if (this.currBlockHasData()) {
            this.writeBlockEnd();
        }
        if (!this.selectParentBlock()) {
            return;
        }
        logger.debug((Object)("re-entering block: " + this.list.getName()));
        --this.blockDepth;
        logger.debug((Object)("blockDepth at this point: " + this.blockDepth));
        this.restartAt = (Integer)this.restartAts.pop();
        logger.debug((Object)("poped: " + this.restartAt));
        if (this.restartAt == this.list.size()) {
            this.endBlockWrite();
        }
    }

    private void writeBlock(InputInterfaceBlock block) {
        String whiteSpace = this.getWhiteSpace();
        if (block.getName().equals("wavefunction_solver")) {
            logger.debug((Object)"getTags(): ");
            String[] tgs = this.getTags();
            logger.debug((Object)("num tags: " + tgs.length));
            int i = 0;
            while (i < tgs.length) {
                logger.debug((Object)("tag: " + tgs[i]));
                ++i;
            }
        }
        if (this.writer != null) {
            this.writer.println(String.valueOf(whiteSpace) + block.getName() + "{");
        } else {
            this.string = String.valueOf(this.string) + whiteSpace + block.getName() + "{" + System.getProperty("line.separator");
        }
    }

    private String toString(InputInterfaceEntry entry) {
        String whiteSpace = this.getWhiteSpace(this.blockDepth);
        int type = entry.getEntryType();
        if (entry.ignoreMe()) {
            return null;
        }
        if (type == 0) {
            InputInterfacePrimitiveEntry primitive = (InputInterfacePrimitiveEntry)entry;
            String name = primitive.getName();
            String value = primitive.getValueDelimitedBy();
            if (this.writeDelimitedByColon) {
                value = primitive.getValue();
            }
            if (primitive.isDoubleQuoted()) {
                value = "\"" + value + "\"";
            }
            boolean writeThis = false;
            if (this.writeNullValue) {
                writeThis = name != null && name.trim().length() != 0 && value != null;
            } else {
                boolean bl = writeThis = name != null && name.trim().length() != 0 && value != null && value.trim().length() != 0;
            }
            if (writeThis) {
                return String.valueOf(whiteSpace) + this.indent + name + " = " + value + " " + primitive.getUnit();
            }
        } else if (type == 1) {
            InputInterfaceTable table = (InputInterfaceTable)entry;
            String[] idents = table.getColumnIdentifiers();
            String identString = String.valueOf(whiteSpace) + this.indent + "#tag";
            boolean[] bcols = table.getValidColumns();
            if (idents != null) {
                int i = 0;
                while (i < idents.length) {
                    if (bcols[i]) {
                        identString = String.valueOf(identString) + " " + idents[i];
                    }
                    ++i;
                }
                Vector tableData = table.getTableData();
                String dataString = String.valueOf(whiteSpace) + this.indent;
                InputInterfaceTableSpec spec = null;
                try {
                    spec = this.manager.getTableSpec(this.list.getFullName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int i2 = 0;
                while (i2 < tableData.size()) {
                    String[] row = (String[])tableData.get(i2);
                    if (InputInterfaceTable.isValidRow(row)) {
                        int j = 0;
                        while (j < row.length) {
                            if (bcols[j]) {
                                String dat = row[j];
                                if (spec != null && spec.getTableColumn(idents[j]).isFirstLetterCaps()) {
                                    dat = Utils.firstLetterCaps(dat);
                                }
                                dataString = row[j] != null && row[j].length() != 0 ? String.valueOf(dataString) + " " + dat : String.valueOf(dataString) + " *";
                            }
                            ++j;
                        }
                        if (i2 < tableData.size() - 1) {
                            dataString = String.valueOf(dataString) + System.getProperty("line.separator") + whiteSpace + this.indent;
                        }
                    }
                    ++i2;
                }
                return String.valueOf(identString) + System.getProperty("line.separator") + dataString;
            }
        }
        return null;
    }

    private void writeEntry(InputInterfaceEntry entry) {
        String whiteSpace = this.getWhiteSpace();
        int type = entry.getEntryType();
        if (entry.ignoreMe()) {
            return;
        }
        if (type == 0) {
            InputInterfacePrimitiveEntry primitive = (InputInterfacePrimitiveEntry)entry;
            String name = primitive.getName();
            String value = primitive.getValueDelimitedBy();
            if (this.writeDelimitedByColon) {
                value = primitive.getValue();
            }
            if (primitive.isDoubleQuoted()) {
                value = "\"" + value + "\"";
            }
            boolean writeThis = false;
            if (this.writeNullValue) {
                writeThis = name != null && name.trim().length() != 0 && value != null;
            } else {
                boolean bl = writeThis = name != null && name.trim().length() != 0 && value != null && value.trim().length() != 0;
            }
            if (writeThis) {
                if (this.writer != null) {
                    this.writer.println(String.valueOf(whiteSpace) + this.indent + name + " = " + value + " " + primitive.getUnit());
                } else {
                    this.string = String.valueOf(this.string) + whiteSpace + this.indent + name + " = " + value + " " + primitive.getUnit() + System.getProperty("line.separator");
                }
            }
        } else if (type == 1) {
            InputInterfaceTable table = (InputInterfaceTable)entry;
            String[] idents = table.getColumnIdentifiers();
            String identString = String.valueOf(whiteSpace) + this.indent + "#tag";
            boolean[] bcols = table.getValidColumns();
            if (idents != null) {
                int i = 0;
                while (i < idents.length) {
                    if (bcols[i]) {
                        identString = String.valueOf(identString) + " " + idents[i];
                    }
                    ++i;
                }
                Vector tableData = table.getTableData();
                String dataString = String.valueOf(whiteSpace) + this.indent;
                InputInterfaceTableSpec spec = null;
                try {
                    spec = this.manager.getTableSpec(this.list.getFullName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int i2 = 0;
                while (i2 < tableData.size()) {
                    String[] row = (String[])tableData.get(i2);
                    if (InputInterfaceTable.isValidRow(row)) {
                        int j = 0;
                        while (j < row.length) {
                            if (bcols[j]) {
                                String dat = row[j];
                                if (spec != null && spec.getTableColumn(idents[j]).isFirstLetterCaps()) {
                                    dat = Utils.firstLetterCaps(dat);
                                }
                                dataString = row[j] != null && row[j].length() != 0 ? String.valueOf(dataString) + " " + dat : String.valueOf(dataString) + " *";
                            }
                            ++j;
                        }
                        if (i2 < tableData.size() - 1) {
                            dataString = String.valueOf(dataString) + System.getProperty("line.separator") + whiteSpace + this.indent;
                        }
                    }
                    ++i2;
                }
                if (this.writer != null) {
                    this.writer.println(String.valueOf(identString) + System.getProperty("line.separator") + dataString);
                } else {
                    this.string = String.valueOf(this.string) + identString + System.getProperty("line.separator") + dataString + System.getProperty("line.separator");
                }
            }
        }
    }

    private void writeUnits(InputInterfaceBlock block, int bld) {
        String whiteSpace = this.getWhiteSpace(bld);
        int i = 1;
        while (i < block.size()) {
            InputInterfaceEntry entry;
            int type;
            InputInterfaceData data = (InputInterfaceData)block.get(i);
            if (!data.isBlock() && (type = (entry = (InputInterfaceEntry)data).getEntryType()) == 3) {
                InputInterfaceUnits units = (InputInterfaceUnits)entry;
                String[] un = units.getUnits();
                String unitString = String.valueOf(whiteSpace) + this.indent + "#units";
                int j = 0;
                while (j < un.length) {
                    unitString = String.valueOf(unitString) + " " + un[j];
                    ++j;
                }
                if (this.writer != null) {
                    this.writer.println(unitString);
                } else {
                    this.string = String.valueOf(this.string) + unitString + System.getProperty("line.separator");
                }
            }
            ++i;
        }
    }

    private void writeDefaults(InputInterfaceBlock block, int bld) {
        String whiteSpace = this.getWhiteSpace(bld);
        int i = 1;
        while (i < block.size()) {
            InputInterfaceEntry entry;
            int type;
            InputInterfaceData data = (InputInterfaceData)block.get(i);
            if (!data.isBlock() && (type = (entry = (InputInterfaceEntry)data).getEntryType()) == 2) {
                InputInterfaceDefaults defs = (InputInterfaceDefaults)entry;
                String[] de = defs.getDefaults();
                String defString = String.valueOf(whiteSpace) + this.indent + "#default";
                int j = 0;
                while (j < de.length) {
                    defString = String.valueOf(defString) + " " + de[j];
                    if (j < de.length - 1) {
                        defString = String.valueOf(defString) + ",";
                    }
                    ++j;
                }
                if (this.writer != null) {
                    this.writer.println(defString);
                } else {
                    this.string = String.valueOf(this.string) + defString + System.getProperty("line.separator");
                }
            }
            ++i;
        }
    }

    private void writeUnits() {
        String whiteSpace = this.getWhiteSpace();
        int i = 1;
        while (i < this.list.size()) {
            InputInterfaceEntry entry;
            int type;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (!data.isBlock() && (type = (entry = (InputInterfaceEntry)data).getEntryType()) == 3) {
                InputInterfaceUnits units = (InputInterfaceUnits)entry;
                String[] un = units.getUnits();
                String unitString = String.valueOf(whiteSpace) + this.indent + "#units";
                int j = 0;
                while (j < un.length) {
                    unitString = String.valueOf(unitString) + " " + un[j];
                    ++j;
                }
                if (this.writer != null) {
                    this.writer.println(unitString);
                } else {
                    this.string = String.valueOf(this.string) + unitString + System.getProperty("line.separator");
                }
            }
            ++i;
        }
    }

    private void writeDefaults() {
        String whiteSpace = this.getWhiteSpace();
        int i = 1;
        while (i < this.list.size()) {
            InputInterfaceEntry entry;
            int type;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (!data.isBlock() && (type = (entry = (InputInterfaceEntry)data).getEntryType()) == 2) {
                InputInterfaceDefaults defs = (InputInterfaceDefaults)entry;
                String[] de = defs.getDefaults();
                String defString = String.valueOf(whiteSpace) + this.indent + "#default";
                int j = 0;
                while (j < de.length) {
                    defString = String.valueOf(defString) + " " + de[j];
                    if (j < de.length - 1) {
                        defString = String.valueOf(defString) + ",";
                    }
                    ++j;
                }
                if (this.writer != null) {
                    this.writer.println(defString);
                } else {
                    this.string = String.valueOf(this.string) + defString + System.getProperty("line.separator");
                }
            }
            ++i;
        }
    }

    private void writeBlockEnd() {
        if (this.list.get(0) != null) {
            if (this.writer != null) {
                this.writer.println(String.valueOf(this.getWhiteSpace()) + "}");
            } else {
                this.string = String.valueOf(this.string) + this.getWhiteSpace() + "}" + System.getProperty("line.separator");
            }
        }
    }

    private String getWhiteSpace(int depth) {
        String ret = "";
        int i = 0;
        while (i < depth - 1) {
            ret = String.valueOf(ret) + this.indent;
            ++i;
        }
        return ret;
    }

    private String getWhiteSpace() {
        String string = new String();
        int i = 0;
        while (i < this.blockDepth - 1) {
            string = String.valueOf(string) + this.indent;
            ++i;
        }
        return string;
    }

    public void scanList() {
        this.selectRoot();
        this.restartAts = new Stack();
        this.restartAt = 1;
        logger.debug((Object)"scanning list ...");
        this.scan();
    }

    public String[] getTags() {
        String[] ret = null;
        Vector<String> names = new Vector<String>();
        int i = 1;
        while (i < this.list.size()) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            names.addElement(data.getName());
            ++i;
        }
        if (names.size() > 0) {
            ret = new String[names.size()];
            i = 0;
            while (i < names.size()) {
                ret[i] = (String)names.get(i);
                ++i;
            }
        }
        return ret;
    }

    public InputInterfaceData[] getAllEntries() {
        InputInterfaceData[] ret = new InputInterfaceData[this.list.size() - 1];
        int i = 1;
        while (i < this.list.size()) {
            ret[i - 1] = (InputInterfaceData)this.list.get(i);
            ++i;
        }
        return ret;
    }

    public String[] getBlockTags() {
        String[] ret = null;
        Vector<String> names = new Vector<String>();
        int i = 1;
        while (i < this.list.size()) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data.isBlock()) {
                names.addElement(data.getName());
            }
            ++i;
        }
        if (names.size() > 0) {
            ret = new String[names.size()];
            i = 0;
            while (i < names.size()) {
                ret[i] = (String)names.get(i);
                ++i;
            }
        }
        return ret;
    }

    public InputInterfaceBlock getBlock(String name) {
        int i = 1;
        while (i < this.list.size()) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data.isBlock() && data.getName().trim().equalsIgnoreCase(name)) {
                return (InputInterfaceBlock)data;
            }
            ++i;
        }
        return null;
    }

    public int getBlockCount() {
        String[] blocks = this.getBlockTags();
        if (blocks == null) {
            return 0;
        }
        return blocks.length;
    }

    public int getPrimitiveEntryCount() {
        InputInterfacePrimitiveEntry[] pes = this.getAllPrimitiveEntries();
        if (pes == null) {
            return 0;
        }
        return pes.length;
    }

    public String[] getEntryTags() {
        String[] ret = null;
        Vector<String> names = new Vector<String>();
        int i = 1;
        while (i < this.list.size()) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (!data.isBlock()) {
                names.addElement(data.getName());
            }
            ++i;
        }
        if (names.size() > 0) {
            ret = new String[names.size()];
            i = 0;
            while (i < names.size()) {
                ret[i] = (String)names.get(i);
                ++i;
            }
        }
        return ret;
    }

    private void scan() {
        this.scan(false);
    }

    private void scan(InputInterfaceBlock block, boolean replace) {
        String blname = block.getFullName();
        int i = 1;
        while (i < block.size()) {
            InputInterfaceData data = (InputInterfaceData)block.get(i);
            String name = data.getName();
            if (data.isBlock()) {
                this.scan((InputInterfaceBlock)data, replace);
            } else {
                InputInterfaceEntry entry = (InputInterfaceEntry)data;
                int type = entry.getEntryType();
                if (type == 0) {
                    InputInterfacePrimitiveEntry primitive = (InputInterfacePrimitiveEntry)entry;
                    logger.debug((Object)"    token: ");
                    logger.debug((Object)("        name: " + primitive.getName()));
                    logger.debug((Object)("        value: " + primitive.getValue()));
                    logger.debug((Object)("        unit: " + primitive.getUnit()));
                } else if (type == 1) {
                    InputInterfaceTable table = (InputInterfaceTable)entry;
                    String[] tableIdentifiers = table.getTableIdentifiers();
                    Vector tableData = table.getTableData();
                    if (replace && block.hasDefaults()) {
                        tableIdentifiers = this.getUniqueIdentifiers(this.defaultName, tableIdentifiers);
                        table.setTableIdentifiers(tableIdentifiers);
                        this.expandTableData(tableData, tableIdentifiers.length);
                        Vector<String[]> replaceVector = new Vector<String[]>();
                        int j = 0;
                        while (j < tableIdentifiers.length) {
                            int jj = 0;
                            while (jj < this.defaultName.length) {
                                if (tableIdentifiers[j].trim().equalsIgnoreCase(this.defaultName[jj].trim())) {
                                    replaceVector.addElement(new String[]{Integer.toString(j), this.defaultValue[jj]});
                                }
                                ++jj;
                            }
                            ++j;
                        }
                        int ii = 0;
                        while (ii < tableData.size()) {
                            String[] cols = (String[])tableData.get(ii);
                            int j2 = 0;
                            while (j2 < replaceVector.size()) {
                                String[] rep = (String[])replaceVector.get(j2);
                                int irep = Integer.parseInt(rep[0]);
                                if (cols[irep].trim().equals("*")) {
                                    cols[irep] = rep[1];
                                }
                                ++j2;
                            }
                            ++ii;
                        }
                    }
                    logger.debug((Object)"    table: ");
                    logger.debug((Object)"        ident: ");
                    logger.debug((Object)"            ");
                    int ii = 0;
                    while (ii < tableIdentifiers.length) {
                        logger.debug((Object)("    " + tableIdentifiers[ii]));
                        ++ii;
                    }
                    logger.debug((Object)"        value:");
                    ii = 0;
                    while (ii < tableData.size()) {
                        String[] cols = (String[])tableData.get(ii);
                        int j = 0;
                        while (j < cols.length) {
                            logger.debug((Object)("    " + cols[j]));
                            ++j;
                        }
                        ++ii;
                    }
                    if (this.manager != null) {
                        logger.debug((Object)"obtaining table spec...");
                        InputInterfaceTableSpec tspec = this.manager.getTableSpec(block.getFullName());
                        if (tspec != null) {
                            logger.debug((Object)"obtaining columns");
                            InputInterfaceTableColumns[] cols = tspec.getTableColumns();
                            if (cols != null) {
                                logger.debug((Object)"adding columns...");
                                ((InputInterfaceTable)entry).setInputInterfaceTableColumns(cols);
                            }
                        }
                    }
                } else if (type == 2) {
                    InputInterfaceDefaults defs = (InputInterfaceDefaults)entry;
                    logger.debug((Object)"    defaults:");
                    String[] de = defs.getDefaults();
                    if (replace) {
                        this.defaultName = new String[de.length];
                        this.defaultValue = new String[de.length];
                    }
                    int ii = 0;
                    while (ii < de.length) {
                        logger.debug((Object)("            default no." + ii + ": " + de[ii]));
                        if (replace) {
                            String[] tmp = de[ii].split("=");
                            this.defaultName[ii] = tmp[0] != null ? tmp[0].trim() : "";
                            this.defaultValue[ii] = tmp[1] != null ? tmp[1].trim() : "";
                        }
                        ++ii;
                    }
                } else if (type == 3) {
                    InputInterfaceUnits units = (InputInterfaceUnits)entry;
                    logger.debug((Object)"    units:");
                    String[] un = units.getUnits();
                    int ii = 0;
                    while (ii < un.length) {
                        logger.debug((Object)("            unit no." + ii + ": " + un[ii]));
                        ++ii;
                    }
                }
                this.entryChanged(blname, entry, null);
            }
            ++i;
        }
    }

    private void scan(boolean replace) {
        int i = this.restartAt;
        while (i < this.list.size()) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            String name = data.getName();
            if (data.isBlock()) {
                this.selectBlock(name, null);
                logger.debug((Object)("entering block: " + name));
                logger.debug((Object)("full name of this block: " + ((InputInterfaceBlock)data).getFullName()));
                Integer ii = new Integer(i + 1);
                this.restartAts.push(ii);
                if (((InputInterfaceBlock)data).hasTable()) {
                    logger.debug((Object)"this block has a table...");
                }
                if (((InputInterfaceBlock)data).hasDefaults()) {
                    logger.debug((Object)"this block has default values ...");
                }
                if (((InputInterfaceBlock)data).hasUnits()) {
                    logger.debug((Object)"this block has units ...");
                }
                if (this.list.size() == 1) {
                    this.endBlockScan();
                    this.scan(replace);
                    break;
                }
                this.restartAt = 1;
                this.scan(replace);
                break;
            }
            InputInterfaceEntry entry = (InputInterfaceEntry)data;
            int type = entry.getEntryType();
            if (type == 0) {
                InputInterfacePrimitiveEntry primitive = (InputInterfacePrimitiveEntry)entry;
                logger.debug((Object)"    token: ");
                logger.debug((Object)("        name: " + primitive.getName()));
                logger.debug((Object)("        value: " + primitive.getValue()));
                logger.debug((Object)("        unit: " + primitive.getUnit()));
            } else if (type == 1) {
                InputInterfaceTable table = (InputInterfaceTable)entry;
                String[] tableIdentifiers = table.getTableIdentifiers();
                Vector tableData = table.getTableData();
                if (replace && this.list.hasDefaults()) {
                    tableIdentifiers = this.getUniqueIdentifiers(this.defaultName, tableIdentifiers);
                    table.setTableIdentifiers(tableIdentifiers);
                    this.expandTableData(tableData, tableIdentifiers.length);
                    Vector<String[]> replaceVector = new Vector<String[]>();
                    int j = 0;
                    while (j < tableIdentifiers.length) {
                        int jj = 0;
                        while (jj < this.defaultName.length) {
                            if (tableIdentifiers[j].trim().equalsIgnoreCase(this.defaultName[jj].trim())) {
                                replaceVector.addElement(new String[]{Integer.toString(j), this.defaultValue[jj]});
                            }
                            ++jj;
                        }
                        ++j;
                    }
                    int ii = 0;
                    while (ii < tableData.size()) {
                        String[] cols = (String[])tableData.get(ii);
                        int j2 = 0;
                        while (j2 < replaceVector.size()) {
                            String[] rep = (String[])replaceVector.get(j2);
                            int irep = Integer.parseInt(rep[0]);
                            if (cols[irep].trim().equals("*")) {
                                cols[irep] = rep[1];
                            }
                            ++j2;
                        }
                        ++ii;
                    }
                }
                logger.debug((Object)"    table: ");
                logger.debug((Object)"        ident: ");
                logger.debug((Object)"            ");
                int ii = 0;
                while (ii < tableIdentifiers.length) {
                    logger.debug((Object)("    " + tableIdentifiers[ii]));
                    ++ii;
                }
                logger.debug((Object)"        value:");
                ii = 0;
                while (ii < tableData.size()) {
                    String[] cols = (String[])tableData.get(ii);
                    int j = 0;
                    while (j < cols.length) {
                        logger.debug((Object)("    " + cols[j]));
                        ++j;
                    }
                    ++ii;
                }
                if (this.manager != null) {
                    logger.debug((Object)"obtaining table spec...");
                    InputInterfaceTableSpec tspec = this.manager.getTableSpec(this.list.getFullName());
                    if (tspec != null) {
                        logger.debug((Object)"obtaining columns");
                        InputInterfaceTableColumns[] cols = tspec.getTableColumns();
                        if (cols != null) {
                            logger.debug((Object)"adding columns...");
                            ((InputInterfaceTable)entry).setInputInterfaceTableColumns(cols);
                        }
                    }
                }
            } else if (type == 2) {
                InputInterfaceDefaults defs = (InputInterfaceDefaults)entry;
                logger.debug((Object)"    defaults:");
                String[] de = defs.getDefaults();
                if (replace) {
                    this.defaultName = new String[de.length];
                    this.defaultValue = new String[de.length];
                }
                int ii = 0;
                while (ii < de.length) {
                    logger.debug((Object)("            default no." + ii + ": " + de[ii]));
                    if (replace) {
                        String[] tmp = de[ii].split("=");
                        this.defaultName[ii] = tmp[0] != null ? tmp[0].trim() : "";
                        this.defaultValue[ii] = tmp[1] != null ? tmp[1].trim() : "";
                    }
                    ++ii;
                }
            } else if (type == 3) {
                InputInterfaceUnits units = (InputInterfaceUnits)entry;
                logger.debug((Object)"    units:");
                String[] un = units.getUnits();
                int ii = 0;
                while (ii < un.length) {
                    logger.debug((Object)("            unit no." + ii + ": " + un[ii]));
                    ++ii;
                }
            }
            this.entryChanged(this.list.getFullName(), entry, null);
            if (i == this.list.size() - 1) {
                this.endBlockScan();
                this.scan(replace);
                break;
            }
            ++i;
        }
    }

    private void endBlockScan() {
        logger.debug((Object)("exiting block: " + this.list.getName()));
        if (!this.selectParentBlock()) {
            return;
        }
        logger.debug((Object)("re-entering block: " + this.list.getName()));
        this.restartAt = (Integer)this.restartAts.pop();
        logger.debug((Object)("popped: " + this.restartAt));
        if (this.restartAt == this.list.size()) {
            this.endBlockScan();
        }
    }

    private String[] getUniqueIdentifiers(String[] ident1, String[] ident2) {
        if (ident1 == null || ident1.length == 0) {
            return ident2;
        }
        Vector<String> foo = new Vector<String>();
        int i = 0;
        while (i < ident1.length) {
            boolean dupli = false;
            int j = 0;
            while (j < ident2.length) {
                if (ident1[i].trim().equalsIgnoreCase(ident2[j].trim())) {
                    dupli = true;
                }
                ++j;
            }
            if (!dupli) {
                foo.addElement(ident1[i]);
            }
            ++i;
        }
        String[] ret = new String[ident2.length + foo.size()];
        int i2 = 0;
        while (i2 < ident2.length) {
            ret[i2] = ident2[i2];
            logger.debug((Object)("at getUniqueIdentifiers: i, ret " + i2 + " " + ret[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < foo.size()) {
            ret[ident2.length + i2] = (String)foo.elementAt(i2);
            logger.debug((Object)("at getUniqueIdentifiers: i, ret " + new Integer(i2 + ident2.length) + " " + ret[ident2.length + i2]));
            ++i2;
        }
        return ret;
    }

    private void expandTableData(Vector tableData, int newSize) {
        if (tableData == null) {
            return;
        }
        int i = 0;
        while (i < tableData.size()) {
            String[] tmp = (String[])tableData.elementAt(i);
            if (tmp.length >= newSize) {
                return;
            }
            String[] newCol = new String[newSize];
            int j = 0;
            while (j < tmp.length) {
                newCol[j] = tmp[j];
                ++j;
            }
            j = tmp.length;
            while (j < newSize) {
                newCol[j] = "*";
                ++j;
            }
            tableData.set(i, newCol);
            ++i;
        }
    }

    protected void replaceAst() {
        this.selectRoot();
        this.restartAts = new Stack();
        this.restartAt = 1;
        logger.debug((Object)"scanning list & replacing * with defaults ...");
        InputInterfaceBlock rootBlock = this.getRootList();
        int i = 1;
        while (i < rootBlock.size()) {
            InputInterfaceData data = (InputInterfaceData)rootBlock.get(i);
            if (data.isBlock()) {
                this.scan((InputInterfaceBlock)data, true);
            }
            ++i;
        }
    }

    public void setInputInterfaceTableSpecManager(InputInterfaceTableSpecManager manager) {
        this.manager = manager;
    }

    public InputInterfaceTableSpecManager getInputInterfaceTableSpecManager() {
        return this.manager;
    }

    public void setInputInterfaceTableSpecs(InputInterfaceTableSpec[] specs) {
        this.specs = specs;
    }

    public InputInterfaceTableSpec[] getInputInterfaceTableSpecs() {
        return this.specs;
    }

    public void writeValueDelimitedByColon(boolean writeDelimitedByColon) {
        this.writeDelimitedByColon = writeDelimitedByColon;
    }

    public void writeNullValue(boolean writeNullValue) {
        this.writeNullValue = writeNullValue;
    }

    public void overWriteBlock(String blockName, String tagName, InputInterface from) {
        from.selectBlock(blockName);
        InputInterfaceBlock block = from.getBlock(tagName);
        if (block == null) {
            logger.error((Object)("could not find block: " + blockName));
            return;
        }
        logger.debug((Object)("got block: " + block));
        this.selectAndCreateBlock(tagName);
        int i = 1;
        while (i < block.size()) {
            InputInterfaceData data = (InputInterfaceData)block.get(i);
            if (data.isBlock()) {
                this.overWriteBlock(block.getName(), data.getName(), from);
                from.selectParentBlock();
                this.selectParentBlock();
            } else {
                this.replaceEntry((InputInterfaceEntry)data);
            }
            ++i;
        }
    }

    public void swapBlock(String blockName, String tagName, InputInterface from) {
        from.selectBlock(blockName);
        InputInterfaceBlock block = from.getBlock(tagName);
        if (block == null) {
            logger.error((Object)("could not find block: " + blockName));
            return;
        }
        logger.debug((Object)("got block: " + block));
        this.selectAndCreateBlock(blockName);
        this.replaceBlock(block);
        this.selectRoot();
    }

    public void swapBlock(String blockName, String tagName, InputInterface from, InputInterfaceBlockChangeListener caller) {
        from.selectBlock(blockName);
        InputInterfaceBlock block = from.getBlock(tagName);
        if (block == null) {
            logger.error((Object)("could not find block: " + blockName));
            return;
        }
        logger.debug((Object)("got block: " + block));
        this.selectAndCreateBlock(blockName);
        this.replaceBlock(block, caller);
        this.selectRoot();
    }

    public static void main(String[] args) {
        InputInterface input = new InputInterface();
        InputInterfaceBlock block = new InputInterfaceBlock();
        block.setName("control");
        input.addBlock(block);
        input.selectBlock("control", null);
        InputInterfacePrimitiveEntry entry = new InputInterfacePrimitiveEntry();
        entry.setName("foo");
        entry.setValue("bar");
        entry.setUnit("hartree");
        input.addEntry(entry);
        input.selectRoot();
        input.scanList();
    }

    @Override
    public String getType() {
        return "PHASE input object";
    }

    public static boolean isTrue(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        String st = str.trim();
        return st.equalsIgnoreCase("1") || st.equalsIgnoreCase("on") || st.equalsIgnoreCase("yes");
    }
}

