/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface;

import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.Utils;
import java.io.Serializable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

class EntryTokenizer
implements Serializable {
    private static Logger logger = Logger.getLogger((String)EntryTokenizer.class.getName());
    private boolean table = false;
    private String token = new String();
    private int numCols;
    private boolean wid = true;
    private String tokenKind = DataManager.entry;

    public EntryTokenizer(String token, String tokenKind) {
        this.token = token;
        this.tokenKind = tokenKind;
    }

    public EntryTokenizer() {
    }

    public void setTokens(String token, String tokenKind) {
        this.token = token;
        this.tokenKind = tokenKind;
    }

    public void setWSisDelimiter(boolean wid) {
        this.wid = wid;
    }

    public Vector getResults() {
        Vector returnVector = new Vector();
        returnVector = this.tokenKind.equals(DataManager.tableStart) || this.tokenKind.equals(DataManager.tableEntry) ? this.tokenizeTable() : (this.tokenKind.equals(DataManager.entry) ? this.tokenizePrimitive() : (this.tokenKind.equals(DataManager.DEFAULT) ? this.tokenizeDefaults() : (this.tokenKind.equals(DataManager.UNITS) ? this.tokenizeUnits() : null)));
        return returnVector;
    }

    private Vector tokenizeTable() {
        Vector<String[]> tokens = new Vector<String[]>();
        if (this.tokenKind.equals(DataManager.tableStart)) {
            int hashStart = this.token.indexOf(DataManager.HASH);
            this.token = this.token.substring(hashStart + 4, this.token.length()).trim();
            Vector vec = EntryTokenizer.tokenizeSpaceOrDoubleQuote(this.token);
            String[] st = new String[vec.size()];
            int i = 0;
            while (i < vec.size()) {
                st[i] = (String)vec.get(i);
                ++i;
            }
            tokens.addElement(st);
            this.numCols = st.length;
        } else if (this.tokenKind.equals(DataManager.tableEntry)) {
            String[] ret = new String[this.numCols];
            Vector vec = EntryTokenizer.tokenizeSpaceOrDoubleQuote(this.token);
            String[] st = new String[vec.size()];
            int i = 0;
            while (i < vec.size()) {
                st[i] = (String)vec.get(i);
                ++i;
            }
            int count = this.numCols;
            if (st.length < this.numCols) {
                count = st.length;
            }
            int i2 = 0;
            while (i2 < count) {
                ret[i2] = st[i2].toString();
                ++i2;
            }
            i2 = count;
            while (i2 < this.numCols) {
                ret[i2] = DataManager.AST;
                ++i2;
            }
            tokens.addElement(ret);
        }
        return tokens;
    }

    private Vector tokenizePrimitive() {
        Vector<String[]> tokens = new Vector<String[]>();
        String[] first = this.token.split(",");
        int i = 0;
        while (i < first.length) {
            String[] tokenString = new String[3];
            String[] second = first[i].trim().split("=");
            boolean isCellVec = false;
            if (second.length >= 2) {
                tokenString[0] = second[0];
                int cell = 0;
                while (cell < DataManager.CELL_VECTORS.length) {
                    if (second[0].trim().equals(DataManager.CELL_VECTORS[cell])) {
                        isCellVec = true;
                    }
                    ++cell;
                }
                Vector vector = new Vector();
                if (isCellVec) {
                    vector.addElement(second[1]);
                } else if (!this.wid) {
                    vector.addElement(second[1]);
                } else {
                    vector = EntryTokenizer.tokenizeSpaceOrDoubleQuote(second[1]);
                }
                int ii = 0;
                while (ii < vector.size()) {
                    logger.debug((Object)("tokenized: " + vector.get(ii)));
                    ++ii;
                }
                if (vector.size() == 1) {
                    tokenString[1] = (String)vector.get(0);
                    tokenString[2] = "";
                } else if (vector.size() > 1) {
                    tokenString[1] = (String)vector.get(0);
                    tokenString[2] = (String)vector.get(1);
                } else {
                    tokenString[1] = "";
                    tokenString[2] = "";
                }
            } else if (second.length == 1) {
                tokenString[0] = second[0];
                tokenString[1] = "";
                tokenString[2] = "";
            } else {
                tokenString[0] = "";
                tokenString[1] = "";
                tokenString[2] = "";
            }
            tokens.addElement(tokenString);
            ++i;
        }
        return tokens;
    }

    private Vector tokenizeUnits() {
        Vector<String[]> tokens = new Vector<String[]>();
        int hashStart = this.token.indexOf(DataManager.HASH);
        this.token = this.token.substring(hashStart + 6, this.token.length()).trim();
        String[] st = this.token.split("\\s+");
        tokens.addElement(st);
        return tokens;
    }

    private Vector tokenizeDefaults() {
        Vector<String[]> tokens = new Vector<String[]>();
        int hashStart = this.token.indexOf(DataManager.HASH);
        this.token = this.token.substring(hashStart + 9, this.token.length()).trim();
        String[] st = this.token.split(",");
        String[] st2 = new String[st.length];
        int i = 0;
        while (i < st.length) {
            st2[i] = st[i].trim();
            ++i;
        }
        tokens.addElement(st2);
        return tokens;
    }

    static Vector tokenizeSpaceOrDoubleQuote(String string) {
        String substring;
        String[] indeces;
        string = string.trim();
        String SPACE = "[\\s]+";
        char QUOTE = '\"';
        String IN_QUOTE = "\".+\"";
        boolean inQuote = false;
        boolean inToken = true;
        String tokenString = "";
        Vector<String> tokenVector = new Vector<String>();
        if (Utils.isDoubleQuoted(string)) {
            tokenVector.addElement(new String(string));
            logger.debug((Object)"entry is double quoted.");
            return tokenVector;
        }
        String separator = SPACE;
        Vector<String[]> quoteVector = new Vector<String[]>();
        Vector<String[]> normalVector = new Vector<String[]>();
        Pattern pattern = Pattern.compile(IN_QUOTE);
        Matcher matcher = pattern.matcher(string);
        String quoteStart = "0";
        String normalStart = "0";
        String quoteEnd = "0";
        String normalEnd = "0";
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == QUOTE) {
                if (!inQuote) {
                    quoteStart = String.valueOf(i);
                    normalEnd = String.valueOf(i);
                    if (Integer.parseInt(normalEnd) - Integer.parseInt(normalStart) > 0) {
                        String[] normal = new String[]{normalStart, normalEnd};
                        normalVector.addElement(normal);
                    }
                } else {
                    quoteEnd = String.valueOf(i + 1);
                    normalStart = String.valueOf(i + 1);
                    String[] quote = new String[]{quoteStart, quoteEnd};
                    quoteVector.addElement(quote);
                }
                inQuote = !inQuote;
            }
            ++i;
        }
        normalEnd = String.valueOf(string.length());
        String[] normal = new String[]{normalStart, normalEnd};
        normalVector.addElement(normal);
        Vector<String> map = new Vector<String>();
        Vector<String> substringVector = new Vector<String>();
        Vector<Boolean> isQuote = new Vector<Boolean>();
        int i2 = 0;
        while (i2 < normalVector.size()) {
            indeces = (String[])normalVector.get(i2);
            substring = string.substring(Integer.parseInt(indeces[0]), Integer.parseInt(indeces[1])).trim();
            if (substring.length() > 0) {
                substringVector.addElement(substring);
                map.addElement(indeces[0]);
                isQuote.addElement(new Boolean(false));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < quoteVector.size()) {
            indeces = (String[])quoteVector.get(i2);
            substring = string.substring(Integer.parseInt(indeces[0]), Integer.parseInt(indeces[1])).trim();
            if (substring.length() > 0) {
                substringVector.addElement(substring);
                map.addElement(indeces[0]);
                isQuote.addElement(new Boolean(true));
            }
            ++i2;
        }
        String[] retString = new String[substringVector.size()];
        String[] mapString = new String[map.size()];
        Boolean[] isQuoteBoolean = new Boolean[isQuote.size()];
        int i3 = 0;
        while (i3 < retString.length) {
            retString[i3] = (String)substringVector.get(i3);
            mapString[i3] = (String)map.get(i3);
            isQuoteBoolean[i3] = (Boolean)isQuote.get(i3);
            ++i3;
        }
        i3 = 0;
        while (i3 < mapString.length - 1) {
            int j = i3 + 1;
            while (j < mapString.length) {
                int ii = Integer.parseInt(mapString[i3]);
                int jj = Integer.parseInt(mapString[j]);
                if (jj < ii) {
                    Boolean bj;
                    String tmpj;
                    String tmpi = mapString[i3];
                    mapString[i3] = tmpj = mapString[j];
                    mapString[j] = tmpi;
                    tmpi = retString[i3];
                    retString[i3] = tmpj = retString[j];
                    retString[j] = tmpi;
                    Boolean bi = isQuoteBoolean[i3];
                    isQuoteBoolean[i3] = bj = isQuoteBoolean[j];
                    isQuoteBoolean[j] = bi;
                }
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < retString.length) {
            if (isQuoteBoolean[i3].booleanValue()) {
                tokenVector.addElement(retString[i3]);
            } else {
                String[] split = retString[i3].split("\\s+");
                int j = 0;
                while (j < split.length) {
                    tokenVector.addElement(split[j]);
                    ++j;
                }
            }
            ++i3;
        }
        return tokenVector;
    }
}

