/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.input;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.input.InputWizard;
import ciss.phase_viewer.input.InputWizardController;
import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.scripting.ScriptUtils;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditorCaller;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditorPanel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public abstract class InputWizardScript
implements InputWizard,
ScriptEditorCaller {
    private Logger logger = Logger.getLogger((String)InputWizardScript.class.getName());
    private ScriptEditorPanel panel;
    protected String FS = System.getProperty("file.separator");
    protected String phaseJobControl = String.valueOf(System.getProperty("user.home")) + this.FS + ".phase-viewer" + this.FS + "scripts" + this.FS + "jobcontrol" + this.FS + "phase";
    protected String projDir;
    protected String chaseXML;
    protected Input input;
    protected InputWizardController parent;
    protected ProjectInfo projectInfo;

    @Override
    public JPanel getGUI() {
        this.panel = new ScriptEditorPanel(this, false, false);
        return this.panel;
    }

    protected abstract String[] getScripts();

    protected abstract String getScriptDir();

    @Override
    public String process() {
        String[] scrs = this.getScripts();
        int i = 0;
        while (i < scrs.length) {
            ScriptUtils.copyNecessaryFiles(String.valueOf(this.projDir) + System.getProperty("file.separator") + scrs[i], this.projDir);
            ++i;
        }
        this.panel.save();
        this.doChaseXML();
        return "done initialization of " + this.getScriptPath();
    }

    @Override
    public String getName() {
        return "script input";
    }

    @Override
    public String getDescription() {
        return "configure script input";
    }

    @Override
    public void setInput(Input input) {
        this.input = input;
        this.projDir = new File(input.getFileName()).getParent();
        this.chaseXML = String.valueOf(this.projDir) + this.FS + "phase-viewer.xml";
        String[] scripts = this.getScripts();
        String scriptDir = this.getScriptDir();
        try {
            int i = 0;
            while (i < scripts.length) {
                ExternalProgramExecuter.copyBinary(String.valueOf(scriptDir) + this.FS + scripts[i], String.valueOf(this.projDir) + this.FS + scripts[i]);
                ++i;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public void setParent(InputWizardController parent) {
        this.parent = parent;
        this.projectInfo = parent.getProjectInfo();
    }

    @Override
    public void setProperties(HashMap properties) {
    }

    protected void doChaseXML() {
        Element script;
        Document document = this.projectInfo.getProjectPropertyDocument();
        Element rootElement = document.getRootElement();
        Element jobcontrol = rootElement.getChild("jobcontrol");
        if (jobcontrol == null) {
            jobcontrol = new Element("jobcontrol");
            rootElement.addContent((Content)jobcontrol);
        }
        if ((script = jobcontrol.getChild("script")) == null) {
            script = new Element("script");
            jobcontrol.addContent((Content)script);
        }
        Element scrtype = new Element("script_type");
        scrtype.setText("bsh");
        Element exec = new Element("exec");
        script.addContent((Content)scrtype);
        script.addContent((Content)exec);
        String execpath = MyElement.encode(String.valueOf(this.projDir) + this.FS + "script_exec.bsh");
        exec.addContent((Content)new Element("bsh").addContent((Content)new Element("script_exec_script").setText(execpath)));
        String[] scripts = this.getScripts();
        int i = 0;
        while (i < scripts.length) {
            Element exec_script = new Element("exec_script").addContent((Content)new Element("script_type").setText("bsh"));
            exec_script.addContent((Content)new Element("script_path").setText(scripts[i]));
            exec.addContent((Content)exec_script);
            ++i;
        }
        this.parent.getProjectInfo().saveProjectPropertyDocument();
    }

    @Override
    public boolean hasFinished() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public boolean hasPrevious() {
        return true;
    }

    @Override
    public HashMap getObjects() {
        return null;
    }
}

