/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.imageviewer;

import ciss.phase_viewer.common.MyMessageBox;
import ciss.phase_viewer.imageviewer.GraphicsPanel;
import ciss.phase_viewer.imageviewer.ImageLoader;
import ciss.phase_viewer.imageviewer.ImagePrinter;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MainPanel
extends InternalFrameChase
implements ComponentListener {
    private Container cont;
    private JDesktopPane desktop;
    private String infile;
    private int iwidth;
    private int iheight;
    private int getaw = 0;
    private int getah = 105;
    private double scale = 1.0;
    private double rotscale = 0.0;
    private double rot = 0.0;
    private MyMessageBox mbox = new MyMessageBox();
    private boolean status = true;
    private int pageNum = -1;
    private int page = 0;
    private String[] pageArray;
    private ImageLoader loader;
    private String originalName;
    private JButton btnnextPage;
    private JButton btnprevPage;
    private BufferedImage biSave;
    private double prevWidth = -1.0;
    private double prevHeight = -1.0;
    private JPanel panelImage;
    private int buttonWidth;
    private GraphicsPanel graphicsPanel;
    private BufferedImage bi;

    public MainPanel(String infile, String originalName) {
        super(originalName, true, true, true, true, new Dimension(0, 0), 0, false);
        this.infile = infile;
        this.originalName = originalName;
        this.setResizable(true);
        this.createMainPanel();
        this.redraw(true);
        this.addComponentListener(this);
        this.revalidate();
        this.setVisible(true);
    }

    public MainPanel(String infile) {
        this(infile, infile);
    }

    public void setInfile(String infile) {
        this.infile = infile;
    }

    public void redraw(boolean from_the_begining) {
        if (from_the_begining) {
            this.cont.removeAll();
            this.createMainPanel();
        }
        if (this.panelImage == null) {
            this.panelImage = new JPanel();
        }
        this.panelImage.removeAll();
        JPanel pi = this.createImagePanel();
        if (pi == null) {
            this.mbox.setText("unsupported file type!");
            this.status = false;
            return;
        }
        this.panelImage.add(pi);
        if (this.pageNum == 1) {
            this.btnnextPage.setEnabled(false);
            this.btnprevPage.setEnabled(false);
        }
    }

    public boolean getStatus() {
        return this.status;
    }

    public void redraw() {
        this.redraw(false);
    }

    public void setLoader(ImageLoader loader) {
        this.loader = loader;
    }

    public void display() {
        this.setVisible(true);
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
        if (pageNum <= 1) {
            this.btnnextPage.setEnabled(false);
            this.btnprevPage.setEnabled(false);
        } else {
            this.setTitleWithPage();
        }
    }

    public void setPageArray(String[] pageArray) {
        this.pageArray = pageArray;
    }

    private void createMainPanel() {
        if (this.panelImage == null) {
            this.panelImage = new JPanel();
        }
        JPanel panel = new JPanel();
        this.cont = this.getContentPane();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel btnpanel = this.createButtonPanel();
        this.buttonWidth = btnpanel.getSize().width;
        panel.add(btnpanel);
        JPanel pi = this.createImagePanel();
        if (pi == null) {
            this.mbox.setText("unsupported file type!");
            this.status = false;
            return;
        }
        this.panelImage.add(pi);
        panel.add(this.panelImage);
        panel.revalidate();
        if (panel.getSize().width < this.buttonWidth) {
            panel.setSize(new Dimension(this.buttonWidth, panel.getSize().height));
        }
        this.cont.add(panel);
        this.revalidate();
        this.pack();
    }

    private void resizeImage() {
        AffineTransform transform = new AffineTransform();
        transform.scale(this.scale, this.scale);
        AffineTransformOp transformOp = new AffineTransformOp(transform, 2);
        BufferedImage bit = transformOp.filter(this.biSave, null);
        this.graphicsPanel.setImage(bit);
    }

    private JPanel createImagePanel() {
        JPanel pimage = new JPanel();
        pimage.setLayout(new FlowLayout(1));
        try {
            BufferedImage bi = ImageIO.read(new File(this.infile));
            int width = bi.getWidth();
            int height = bi.getHeight();
            int irotscale = Math.abs((int)(this.rotscale / 90.0));
            AffineTransform transform = new AffineTransform();
            transform.scale(this.scale, this.scale);
            transform.rotate(Math.PI * this.rotscale / 180.0, width / 2, height / 2);
            AffineTransformOp transformOp = new AffineTransformOp(transform, 2);
            Rectangle2D rectangle = transformOp.getBounds2D(bi);
            int x = (int)rectangle.getX();
            int y = (int)rectangle.getY();
            width = (int)rectangle.getWidth();
            height = (int)rectangle.getHeight();
            transform = new AffineTransform();
            transform.rotate(Math.PI * this.rotscale / 180.0, width / 2, height / 2);
            transform.translate(-x, -y);
            transform.scale(this.scale, this.scale);
            transformOp = new AffineTransformOp(transform, 2);
            BufferedImage bit = null;
            this.biSave = bit = transformOp.filter(bi, null);
            this.graphicsPanel = new GraphicsPanel(bit);
            pimage.add(this.graphicsPanel);
            this.setMinimumSize(new Dimension(120, 350));
            int sizex = width + this.getaw < 120 ? 120 : width + this.getaw;
            int sizey = height + this.getah < 350 ? 350 : height + this.getah;
            this.setPreferredSize(new Dimension(sizex, sizey));
            this.setSize(sizex, sizey);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return pimage;
    }

    private JPanel createButtonPanel() {
        JPanel pbtn1 = new JPanel();
        pbtn1.setLayout(new BoxLayout(pbtn1, 0));
        JPanel pbtn2 = new JPanel();
        pbtn2.setLayout(new BoxLayout(pbtn2, 0));
        JPanel pbtn = new JPanel();
        int x = 70;
        int y = 50;
        ImageIcon home2 = new ImageIcon(this.getClass().getResource("/org/javalobby/icons/20x20/Home.gif"));
        JButton btninitial = new JButton(home2);
        btninitial.setToolTipText("restore original size and orientation");
        ImageIcon mag = new ImageIcon(this.getClass().getResource("/org/javalobby/icons/20x20/MagnifyPlus.gif"));
        JButton btnresizep = new JButton(mag);
        btnresizep.setToolTipText("magnify");
        ImageIcon magminus = new ImageIcon(this.getClass().getResource("/org/javalobby/icons/20x20/MagnifyMinus.gif"));
        JButton btnresizem = new JButton(magminus);
        btnresizem.setToolTipText("shrink");
        ImageIcon rotcw = new ImageIcon(this.getClass().getResource("/org/javalobby/icons/20x20/RotCWDown.gif"));
        JButton btnrotatep = new JButton(rotcw);
        btnrotatep.setToolTipText("rotate (counter clockwise)");
        ImageIcon rotcc = new ImageIcon(this.getClass().getResource("/org/javalobby/icons/20x20/RotCCDown.gif"));
        JButton btnrotatem = new JButton(rotcc);
        btnrotatem.setToolTipText("rotate (clockwise)");
        ImageIcon back = new ImageIcon(this.getClass().getResource("/org/javalobby/icons/20x20/VCRBack.gif"));
        this.btnprevPage = new JButton(back);
        this.btnprevPage.setToolTipText("previous page");
        ImageIcon forward = new ImageIcon(this.getClass().getResource("/org/javalobby/icons/20x20/VCRForward.gif"));
        this.btnnextPage = new JButton(forward);
        this.btnnextPage.setToolTipText("next page");
        ImageIcon fastforward = new ImageIcon(this.getClass().getResource("/org/javalobby/icons/20x20/VCRFastForward.gif"));
        JButton nextimage = new JButton(fastforward);
        nextimage.setToolTipText("next image");
        ImageIcon rewind = new ImageIcon(this.getClass().getResource("/org/javalobby/icons/20x20/VCRRewind.gif"));
        JButton previmage = new JButton(rewind);
        previmage.setToolTipText("previous image");
        pbtn.setLayout(new BoxLayout(pbtn, 0));
        pbtn1.add(btninitial);
        pbtn1.add(btnresizep);
        pbtn1.add(btnresizem);
        pbtn1.add(btnrotatem);
        pbtn1.add(btnrotatep);
        pbtn1.add(this.btnprevPage);
        pbtn1.add(this.btnnextPage);
        ImageIcon print = new ImageIcon(this.getClass().getResource("/org/javalobby/icons/20x20/Print.gif"));
        JButton btnprint = new JButton(print);
        btnprint.setToolTipText("print image");
        ImageIcon exit = new ImageIcon(this.getClass().getResource("/org/javalobby/icons/20x20/Exit.gif"));
        JButton btnclose = new JButton(exit);
        btnclose.setToolTipText("exit");
        pbtn1.add(btnprint);
        pbtn1.add(btnclose);
        JScrollPane scrpane = new JScrollPane(pbtn1);
        pbtn.setLayout(new BoxLayout(pbtn, 1));
        pbtn.setPreferredSize(new Dimension(pbtn.getPreferredSize().width, 60));
        pbtn.add(scrpane);
        btnprint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.printImage();
            }
        });
        btninitial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.initializeImage();
            }
        });
        btnresizep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.scaleImage(0);
            }
        });
        btnresizem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.scaleImage(1);
            }
        });
        btnrotatep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.rotateImage(0);
            }
        });
        btnrotatem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.rotateImage(1);
            }
        });
        this.btnnextPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel mainPanel = MainPanel.this;
                mainPanel.page = mainPanel.page + 1;
                if (MainPanel.this.page > MainPanel.this.pageNum - 1) {
                    MainPanel.this.page = 0;
                }
                try {
                    MainPanel.this.infile = MainPanel.this.pageArray[MainPanel.this.page];
                    MainPanel.this.setTitleWithPage();
                    MainPanel.this.redraw();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.btnprevPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel mainPanel = MainPanel.this;
                mainPanel.page = mainPanel.page - 1;
                if (MainPanel.this.page < 0) {
                    MainPanel.this.page = MainPanel.this.pageNum - 1;
                }
                try {
                    MainPanel.this.infile = MainPanel.this.pageArray[MainPanel.this.page];
                    MainPanel.this.setTitleWithPage();
                    MainPanel.this.redraw();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        btnclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.dispose();
            }
        });
        return pbtn;
    }

    private void printImage() {
        BufferedImage image = null;
        try {
            image = this.biSave;
            ImagePrinter ip = new ImagePrinter(image);
            ip.printImage();
        }
        catch (Exception exception) {
            this.mbox.setText("failed Print");
            exception.printStackTrace();
        }
    }

    private void scaleImage(int magormin) {
        this.scale = magormin == 0 ? (this.scale *= 1.1) : (this.scale /= 1.1);
        this.redraw();
    }

    private void rotateImage(int plusorminus) {
        this.rotscale = plusorminus == 0 ? (this.rotscale += 90.0) : (this.rotscale -= 90.0);
        if (this.rotscale >= 360.0) {
            this.rotscale -= 360.0;
        } else if (this.rotscale <= -360.0) {
            this.rotscale += 360.0;
        }
        this.redraw();
    }

    private void initializeImage() {
        this.scale = 1.0;
        this.rotscale = 0.0;
        this.redraw();
    }

    private void setTitleWithPage() {
        int pageDisplay = this.page + 1;
        super.setTitle(String.valueOf(this.originalName) + ", page " + pageDisplay + "/" + this.pageNum);
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private final class MyListener
    extends WindowAdapter {
        private MyListener() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            MainPanel.this.dispose();
        }
    }
}

