/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph.plotattributes;

import ciss.phase_viewer.graph.GraphPanel;
import ciss.phase_viewer.graph.dataset.PlotProperties;
import ciss.phase_viewer.graph.plotattributes.PlotAttributesSubEditor;
import ciss.phase_viewer.graph.utils.PlotUtils;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;

public class PlotAttributesEditor
extends InternalFrameChase {
    private static Logger logger = Logger.getLogger((String)PlotAttributesEditor.class.getName());
    private Vector editors = new Vector();
    private GraphPanel parent;
    private JTabbedPane tabbedPane;
    private static final String xmlpath = "/ciss/phase_viewer/graph/plotattributes/Editors.xml";
    private JComboBox plotSelector;

    public PlotAttributesEditor(GraphPanel parent) {
        super("edit plot attributes", true, true, true, true, new Dimension(512, 532));
        this.parent = parent;
        this.parent.addChildrenPanel(this);
        this.init();
    }

    public PlotAttributesSubEditor[] getPlotAttributesSubEditor(PlotAttributesEditor parent) {
        int plottype = this.getGraphPanel().getPlotProperties().getPlotType();
        URL url = PlotAttributesEditor.class.getResource(xmlpath);
        Document doc = XMLUtils.getDocumentFromURL(url);
        Element root = doc.getRootElement();
        List list = root.getChildren("editor");
        Vector<PlotAttributesSubEditor> subs = new Vector<PlotAttributesSubEditor>();
        int i = 0;
        while (i < list.size()) {
            Element editor = (Element)list.get(i);
            String name = editor.getChildTextTrim("name");
            String loadclass = editor.getChildTextTrim("loadclass");
            String strplottype = editor.getChildTextTrim("associated_plottype");
            String[] strplottypes = strplottype.split(",");
            int[] types = null;
            if (strplottypes != null && strplottypes.length != 0) {
                types = new int[strplottypes.length];
                int j = 0;
                while (j < strplottypes.length) {
                    if (strplottypes[j].equals("PIE")) {
                        types[j] = 1;
                    } else if (strplottypes[j].equals("XY")) {
                        types[j] = 0;
                    }
                    ++j;
                }
            }
            boolean enable_this = false;
            if (types != null && types.length != 0) {
                int j = 0;
                while (j < types.length) {
                    if (types[j] == plottype) {
                        enable_this = true;
                        break;
                    }
                    ++j;
                }
            }
            if (enable_this) {
                PlotAttributesSubEditor edit = (PlotAttributesSubEditor)PluginLoader.instantiate(loadclass, new Object[]{parent});
                edit.setAttributeName(name);
                subs.addElement(edit);
            }
            ++i;
        }
        if (subs.size() == 0) {
            return null;
        }
        Object[] editors = new PlotAttributesSubEditor[subs.size()];
        subs.copyInto(editors);
        return editors;
    }

    public Plot getSelectedPlot() {
        int index = this.plotSelector.getSelectedIndex();
        if (this.getGraphPanel().getPlotProperties().getPlotType() == 0) {
            XYPlot plot = this.parent.getChart().getXYPlot();
            logger.debug((Object)("xyplot: " + plot));
            return PlotUtils.getXYPlotFromCombinedXYPlot(plot, index);
        }
        if (this.getGraphPanel().getPlotProperties().getPlotType() == 1) {
            Plot plot = this.parent.getChart().getPlot();
            logger.debug((Object)("pieplot: " + plot));
            return plot;
        }
        return null;
    }

    private void choosePlot() {
        Plot plot = this.getSelectedPlot();
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            PlotAttributesSubEditor sub = (PlotAttributesSubEditor)this.tabbedPane.getComponentAt(i);
            sub.plotChanged(plot);
            ++i;
        }
    }

    private void init() {
        PlotProperties props = this.parent.getPlotProperties();
        int count = props.getSubPlotCount();
        String[] plots = new String[count];
        int i = 0;
        while (i < count) {
            plots[i] = props.getSubPlotPropertiesAt(i).getDataSetCollection().getName();
            ++i;
        }
        this.plotSelector = new JComboBox<String>(plots);
        this.plotSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotAttributesEditor.this.choosePlot();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        JPanel contents = new JPanel();
        contents.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        PlotAttributesSubEditor[] editors = this.getPlotAttributesSubEditor(this);
        int i2 = 0;
        while (i2 < editors.length) {
            editors[i2].init();
            editors[i2].initGUI();
            this.tabbedPane.addTab(editors[i2].getAttributeName(), editors[i2]);
            ++i2;
        }
        contents.add((Component)this.tabbedPane, constraints);
        constraints.weighty = 1.0;
        contents.add(new JPanel());
        constraints.weighty = 0.0;
        JPanel btnpanel = new JPanel();
        JButton btnupdate = new JButton("update");
        JButton btnclose = new JButton("close");
        JPanel pselector = new JPanel();
        pselector.setBorder(new TitledBorder("select plot"));
        pselector.add(this.plotSelector);
        btnpanel.add(pselector);
        btnpanel.add(btnupdate);
        btnpanel.add(btnclose);
        constraints.gridy = 2;
        constraints.anchor = 10;
        contents.add((Component)btnpanel, constraints);
        btnclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotAttributesEditor.this.dispose();
            }
        });
        btnupdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotAttributesEditor.this.doUpdate();
            }
        });
        this.getContentPane().add((Component)contents, "North");
    }

    public GraphPanel getGraphPanel() {
        return this.parent;
    }

    private void doUpdate() {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            PlotAttributesSubEditor sub = (PlotAttributesSubEditor)this.tabbedPane.getComponentAt(i);
            if (!sub.updateChart()) {
                logger.error((Object)("update from " + sub.getAttributeName() + " panel failed."));
            }
            ++i;
        }
    }
}

