/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph.export;

import ciss.phase_viewer.common.Drawable;
import java.awt.Component;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.freehep.util.export.ExportFileType;

public class EPSExportFileType
extends ExportFileType {
    private Logger logger = Logger.getLogger((String)EPSExportFileType.class.getName());
    private Drawable drawable;

    public EPSExportFileType(Drawable drawable) {
        this.drawable = drawable;
    }

    public String[] getMIMETypes() {
        return new String[]{""};
    }

    public String[] getExtensions() {
        return new String[]{".eps", ".EPS"};
    }

    public String getDescription() {
        return "encapsulated postscript format ";
    }

    public void exportToFile(OutputStream outputStream, Component[] component, Component component0, Properties properties, String string) throws IOException {
        if (component == null || component.length == 0) {
            return;
        }
        this.exportToFile(outputStream, component[0], component0, properties, string);
    }

    public void exportToFile(OutputStream outputStream, Component component, Component component0, Properties properties, String string) throws IOException {
        if (component == null) {
            return;
        }
        int width = component.getWidth();
        int height = component.getHeight();
        Graphics2D g2d = this.createG2D(width, height);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
        writer.write(g2d.toString());
    }

    public void exportToFile(File file, Component[] component, Component component0, Properties properties, String string) throws IOException {
        if (component == null || component.length == 0) {
            return;
        }
        this.exportToFile(file, component[0], component0, properties, string);
    }

    public void exportToFile(File file, Component component, Component component0, Properties properties, String string) throws IOException {
        if (component == null) {
            return;
        }
        int width = component.getWidth();
        int height = component.getHeight();
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
        Graphics2D g2d = this.createG2D(width, height);
        writer.write(g2d.toString());
    }

    private Graphics2D createG2D(int width, int height) {
        return null;
    }
}

