/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.filebrowser;

import ciss.phase_viewer.filebrowser.FileBrowserNode;
import ciss.phase_viewer.filebrowser.FileBrowserTree;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

class MouseListenerTree
extends MouseAdapter {
    private static Logger logger = Logger.getLogger((String)MouseListenerTree.class.getName());
    private FileBrowserTree parent;

    protected MouseListenerTree(FileBrowserTree parent) {
        this.parent = parent;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        JTree tree = (JTree)e.getSource();
        TreePath path = tree.getPathForLocation(x, y);
        if (path != null) {
            FileBrowserNode node = (FileBrowserNode)path.getLastPathComponent();
            node.mousePressed(e, this.parent);
            logger.debug((Object)("selected node: " + node));
        }
        int row = tree.getRowForLocation(x, y);
        logger.debug((Object)("selected row: " + row));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        JTree tree = (JTree)e.getSource();
        TreePath path = tree.getPathForLocation(x, y);
        if (path != null) {
            FileBrowserNode node = (FileBrowserNode)path.getLastPathComponent();
            node.mouseClicked(e, this.parent);
            logger.debug((Object)("selected node: " + node));
        }
    }
}

