/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.filebrowser;

import ciss.phase_viewer.acviewer.ACVCaller;
import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.io.ACIOUtils;
import ciss.phase_viewer.common.CoordsViewerBooter;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.imageviewer.ImageViewerBooter;
import java.io.File;
import org.apache.log4j.Logger;

public class FileBrowserUtils {
    private static Logger logger = Logger.getLogger((String)FileBrowserUtils.class.getName());

    private FileBrowserUtils() {
    }

    public static void bootProgram(boolean edi, String file) {
        if (edi && !new File(file).isDirectory()) {
            Utils.bootTextViewer(file);
            return;
        }
        if (!new File(file).isDirectory() && ImageViewerBooter.isImageFile(file) && !edi) {
            new Thread(new ImageViewerBooter(file)).start();
            return;
        }
        AtomCoords[] coords = null;
        try {
            coords = ACIOUtils.tryToGetInstance(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (coords != null) {
            logger.debug((Object)"coords not null...");
            String dir = new File(file).getParent();
            CoordsViewerBooter bt = new CoordsViewerBooter(new ACVData(new ACVCaller(){

                @Override
                public void save(AtomCoords coords) {
                }
            }, coords, dir, null, StringConstants.phase_atom_tag), CoordsViewerBooter.INTERNAL_VIEWER);
            bt.boot();
            return;
        }
        if (!new File(file).isDirectory()) {
            Utils.bootTextViewer(file);
        }
    }
}

