/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.filebrowser;

import ciss.phase_viewer.filebrowser.BtnUp;
import ciss.phase_viewer.filebrowser.ComboBoxFileBrowser;
import ciss.phase_viewer.filebrowser.FileBrowserEvent;
import ciss.phase_viewer.filebrowser.FileBrowserNode;
import ciss.phase_viewer.filebrowser.FileBrowserTreeListener;
import ciss.phase_viewer.filebrowser.FileBrowserUtils;
import ciss.phase_viewer.filebrowser.FilePropertyViewer;
import ciss.phase_viewer.filebrowser.FileTransfer;
import ciss.phase_viewer.filebrowser.KeyListenerTree;
import ciss.phase_viewer.filebrowser.MouseListenerTree;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;
import ciss.phase_viewer.ssh.sftp.SftpEvent;
import ciss.phase_viewer.ssh.sftp.SftpListener;
import com.jcraft.jsch.ChannelSftp;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class FileBrowserTree
extends JPanel
implements SftpListener {
    private static Logger logger = Logger.getLogger((String)FileBrowserTree.class.getName());
    public static final int WINDOWS = 0;
    public static final int UNIX = 1;
    private int type = 0;
    private int os = 0;
    private String initialDir;
    private String FS = System.getProperty("file.separator");
    private int curdir = 0;
    private RemoteFile[] templist;
    private RemoteFile[][] work = new RemoteFile[512][];
    private RemoteFile root;
    private JScrollPane scrollpane;
    protected JTree tree;
    private Vector listeners = new Vector();
    private boolean isremote = false;
    private ChannelSftp c;
    private boolean initExpand = true;
    private FileBrowserTreeListener parent;
    private String nodeClassString;
    private Vector mouseListeners = new Vector();
    private boolean useCombo = true;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
    private boolean bootingEditor = false;
    private boolean editor = true;
    private String[] tmpFiles;
    private FileTransfer transfer;

    public FileBrowserTree(int os, String initialDir, FileBrowserTreeListener parent, String nodeClassString, boolean init) {
        this.os = os;
        this.initialDir = initialDir;
        this.parent = parent;
        this.nodeClassString = nodeClassString;
        if (init) {
            this.init();
        }
    }

    public FileBrowserTree(int os, String initialDir, FileBrowserTreeListener parent, String nodeClassString, boolean init, boolean useCombo) {
        this.os = os;
        this.initialDir = initialDir;
        this.parent = parent;
        this.nodeClassString = nodeClassString;
        this.useCombo = useCombo;
        if (init) {
            this.init();
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setChannelSftp(ChannelSftp c) {
        this.c = c;
    }

    public void setParent(FileBrowserTreeListener parent) {
        this.parent = parent;
    }

    public RemoteFile[] getSelectedFiles() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            logger.info((Object)"no file selected!");
            return null;
        }
        RemoteFile[] ret = new RemoteFile[paths.length];
        int i = 0;
        while (i < paths.length) {
            ret[i] = this.getSubDirList(paths[i]);
            ++i;
        }
        return ret;
    }

    public RemoteFile getCurrentDir() {
        TreePath path = this.tree.getSelectionPath();
        RemoteFile f = this.getSubDirList(path);
        if (f == null) {
            return null;
        }
        logger.debug((Object)("file: " + f + ", isDir: " + f.isDirectory()));
        RemoteFile ret = f;
        if (!f.isDirectory()) {
            ret = (RemoteFile)f.getParentFile();
            logger.debug((Object)("dir at getcurrentdir: " + ret));
        }
        return ret;
    }

    public void setRemote(boolean isremote) {
        this.isremote = isremote;
    }

    public boolean isRemote() {
        return this.isremote;
    }

    public void addFileBrowserListener(FileBrowserTreeListener fbl) {
        this.listeners.addElement(fbl);
    }

    public void init(String initialDir) {
        this.initialDir = initialDir;
        this.init();
    }

    public void reload() {
        Vector<Enumeration<TreePath>> vector = new Vector<Enumeration<TreePath>>();
        int i = 0;
        while (i < this.tree.getRowCount()) {
            vector.addElement(this.tree.getExpandedDescendants(this.tree.getPathForRow(i)));
            ++i;
        }
        this.init();
        i = 0;
        while (i < vector.size()) {
            Enumeration enumeration = (Enumeration)vector.get(i);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    TreePath tp = (TreePath)enumeration.nextElement();
                    logger.debug((Object)("expanded path: " + tp.toString()));
                    this.tree.expandPath(tp);
                    this.tree.scrollPathToVisible(tp);
                }
            }
            ++i;
        }
    }

    public void init() {
        String exp;
        if (this.os == 1) {
            this.FS = "/";
        }
        if ((exp = PropertiesManager.getGlobalProperties(0).getProperty("file_browser_init_expand")) != null && exp.trim().equalsIgnoreCase("false")) {
            this.initExpand = false;
        }
        this.setLayout(new BoxLayout(this, 1));
        if (this.initialDir != null && this.initialDir.trim().length() != 0 && this.os != 0) {
            logger.debug((Object)("initialDir: " + this.initialDir));
            String[] array = this.initialDir.trim().split("/");
            String newinitdir = "";
            if (array != null && array.length != 0) {
                int i = 0;
                while (i < array.length) {
                    if (array[i].trim().length() != 0) {
                        newinitdir = String.valueOf(newinitdir) + "/" + array[i];
                    }
                    ++i;
                }
                this.initialDir = newinitdir;
                logger.debug((Object)("new initdir: " + this.initialDir));
            }
        }
        if (this.root == null) {
            if (this.initialDir == null || !new RemoteFile(this.initialDir, this.c).exists()) {
                logger.debug((Object)"initial dir doesn't exist / null");
                this.root = this.os == 0 ? new RemoteFile(System.getProperty("user.home")) : new RemoteFile("/", this.c);
            } else {
                logger.debug((Object)"initial dir exists.");
                this.root = new RemoteFile(String.valueOf(this.initialDir) + this.FS, this.c);
            }
        }
        this.root.isRoot(true);
        this.createTree();
    }

    public void setRoot(String newRoot) {
        RemoteFile test2 = new RemoteFile(newRoot, this.c);
        if (!test2.exists()) {
            return;
        }
        this.initialDir = newRoot;
        this.root = new RemoteFile(newRoot, this.c);
        this.root.isRoot(true);
        this.init();
    }

    public void bootFilePropertyViewer() {
        RemoteFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles != null) {
            FilePropertyViewer filePropertyViewer = new FilePropertyViewer(selectedFiles);
        }
    }

    public void createNewFile() {
        String message = "enter new file name";
        RemoteFile file = this.getSelectedFiles()[0];
        RemoteFile newfile = this.getNewFile(message, file);
        if (newfile == null) {
            logger.info((Object)"canceled.");
            return;
        }
        try {
            if (!newfile.createNewFile()) {
                logger.error((Object)("failed to create file " + file));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.init();
    }

    public void bootProgram(boolean editor) {
        this.editor = editor;
        RemoteFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles != null && !this.isRemote()) {
            int i = 0;
            while (i < selectedFiles.length) {
                FileBrowserUtils.bootProgram(editor, selectedFiles[i].getAbsolutePath());
                ++i;
            }
        } else if (selectedFiles != null && this.isRemote()) {
            Vector<String> tmpvec = new Vector<String>();
            int i = 0;
            while (i < selectedFiles.length) {
                if (!selectedFiles[i].isDirectory()) {
                    tmpvec.addElement(selectedFiles[i].getName());
                }
                ++i;
            }
            if (tmpvec.size() == 0) {
                return;
            }
            this.bootingEditor = true;
            this.tmpFiles = new String[tmpvec.size()];
            tmpvec.copyInto(this.tmpFiles);
            this.transfer.downloadToTmpFile();
        }
    }

    public void deleteSelectedFiles() {
        boolean warn = true;
        String ask = this.gp.getProperty("sftp_client_ask_delfile");
        if (ask != null) {
            logger.debug((Object)("ask: " + ask));
            if (ask.trim().equals("false")) {
                warn = false;
                logger.debug((Object)"deleteing file without warning");
            } else {
                logger.debug((Object)"warn");
            }
        } else {
            logger.debug((Object)"sftp_client_ask_deflfile not set, using default");
        }
        RemoteFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles != null) {
            int res = 0;
            if (warn) {
                String message = "deleting " + selectedFiles.length + " file(s) ... proceed?";
                res = JOptionPane.showInternalConfirmDialog(Desk.getDesktop(), message);
            }
            if (res == 0) {
                int i = 0;
                while (i < selectedFiles.length) {
                    logger.info((Object)("deleteing file: " + selectedFiles[i].getAbsolutePath()));
                    boolean b = selectedFiles[i].delete();
                    if (!b) {
                        logger.warn((Object)("failed to delete: " + selectedFiles[i].getAbsolutePath()));
                    }
                    ++i;
                }
            }
        }
        this.init();
    }

    public void mkdir() {
        logger.debug((Object)"running....");
        RemoteFile file = this.getSelectedFiles()[0];
        String message = "enter new directory name";
        RemoteFile newdir = this.getNewFile(message, file);
        if (newdir == null) {
            logger.info((Object)"canceled.");
            return;
        }
        new Thread(new DirMaker(newdir)).start();
    }

    public void rename() {
        String message = "enter new file name";
        RemoteFile file = this.getSelectedFiles()[0];
        RemoteFile renameTo = this.getNewFile(message, file);
        if (renameTo == null) {
            logger.info((Object)"canceled.");
            return;
        }
        new Thread(new Renamer(file, renameTo)).start();
    }

    public void setFileTransfer(FileTransfer transfer) {
        this.transfer = transfer;
    }

    public void uploadFiles() {
        if (this.transfer != null) {
            this.transfer.uploadFiles();
        }
    }

    public void downloadFiles() {
        if (this.transfer != null) {
            this.transfer.downloadFiles();
        }
    }

    public String[] getSelectedPaths() {
        RemoteFile[] files = this.getSelectedFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        String[] ret = new String[files.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = files[i].getAbsolutePath();
            ++i;
        }
        return ret;
    }

    public boolean isConnected() {
        if (this.transfer != null) {
            return this.transfer.isConnected();
        }
        return false;
    }

    private RemoteFile getNewFile(String message, RemoteFile file) {
        logger.debug((Object)"getting file name....");
        String name = JOptionPane.showInternalInputDialog(Desk.getDesktop(), message);
        logger.debug((Object)("got file name: " + name));
        if (name == null) {
            return null;
        }
        RemoteFile parent = null;
        parent = !file.isDirectory() ? (RemoteFile)file.getParentFile() : new RemoteFile(file.getAbsolutePath(), this.c);
        String newfile = "";
        String fs = file.getSeparator();
        if (parent != null) {
            newfile = String.valueOf(parent.getAbsolutePath()) + fs;
            newfile = String.valueOf(newfile) + name;
        }
        return new RemoteFile(newfile, this.c);
    }

    private void createTree() {
        FileBrowserNode treenode = FileBrowserNode.getInstance(this.nodeClassString, new Object[]{this.root});
        this.tree = new JTree(treenode);
        this.tree.setSelectionRow(0);
        FileBrowserNode treenode_tmp = FileBrowserNode.getInstance(this.nodeClassString, new Object[]{""});
        treenode.add(treenode_tmp);
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent e) {
                TreePath tp = e.getPath();
                RemoteFile file = FileBrowserTree.this.getSubDirList(tp);
                FileBrowserTree.this.addExpandTree(tp, file);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) {
                TreePath tp = e.getPath().getParentPath();
                RemoteFile file = FileBrowserTree.this.getSubDirList(tp);
                FileBrowserTree.this.showDirectory(tp, file);
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FileBrowserTree.this.notifyListeners();
            }
        });
        this.tree.addMouseListener(new MouseListenerTree(this));
        this.tree.addKeyListener(new KeyListenerTree(this));
        this.removeAll();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        if (this.useCombo) {
            ComboBoxFileBrowser combo = new ComboBoxFileBrowser(this, this.c);
            p.add(combo);
        } else {
            BtnUp up = new BtnUp(this, this.c);
            p.add(up);
        }
        JButton btnreload = new JButton("reload");
        p.add(btnreload);
        this.add(p);
        this.scrollpane = new JScrollPane(this.tree);
        this.add(this.scrollpane);
        if (this.initExpand) {
            this.tree.expandRow(0);
        }
        this.revalidate();
        btnreload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBrowserTree.this.reload();
            }
        });
    }

    private void notifyListeners() {
        FileBrowserEvent fbe = new FileBrowserEvent(this);
        int i = 0;
        while (i < this.listeners.size()) {
            ((FileBrowserTreeListener)this.listeners.elementAt(i)).directoryHasChanged(fbe);
            ++i;
        }
    }

    private void addExpandTree(TreePath tp, RemoteFile file) {
        if (file == null) {
            return;
        }
        FileBrowserNode node = (FileBrowserNode)tp.getLastPathComponent();
        logger.debug((Object)("at addExpandTree: " + node.toString()));
        if (node == null) {
            return;
        }
        if (file.isDirectory()) {
            this.templist = (RemoteFile[])file.listFiles();
            if (this.templist.length == 0) {
                return;
            }
            Arrays.sort(this.templist);
            Vector<RemoteFile> dirs = new Vector<RemoteFile>();
            Vector<RemoteFile> fil = new Vector<RemoteFile>();
            int i = 0;
            while (i < this.templist.length) {
                if (this.templist[i].isDirectory()) {
                    dirs.add(this.templist[i]);
                } else {
                    fil.add(this.templist[i]);
                }
                ++i;
            }
            int count = 0;
            int i2 = 0;
            while (i2 < dirs.size()) {
                this.templist[count] = (RemoteFile)dirs.get(i2);
                ++count;
                ++i2;
            }
            i2 = 0;
            while (i2 < fil.size()) {
                this.templist[count] = (RemoteFile)fil.get(i2);
                ++count;
                ++i2;
            }
            ++this.curdir;
            this.work[this.curdir] = this.templist;
            logger.debug((Object)"templist");
            i2 = 0;
            while (i2 < this.templist.length) {
                logger.debug((Object)("templist: " + this.templist[i2].getAbsolutePath()));
                ++i2;
            }
            node.removeAllChildren();
            i2 = 0;
            while (i2 < this.work[this.curdir].length) {
                Object[] files;
                FileBrowserNode temp = FileBrowserNode.getInstance(this.nodeClassString, new Object[]{this.work[this.curdir][i2]});
                logger.debug((Object)("at addExpandTree: " + temp.toString()));
                node.add(temp);
                if (this.work[this.curdir][i2].isDirectory() && (files = (RemoteFile[])this.work[this.curdir][i2].listFiles()) != null && files.length != 0) {
                    Arrays.sort(files);
                    int j = 0;
                    while (j < files.length) {
                        FileBrowserNode tempsub = FileBrowserNode.getInstance(this.nodeClassString, new Object[]{files[j]});
                        logger.debug((Object)("tempsub: " + tempsub.toString()));
                        temp.add(tempsub);
                        ++j;
                    }
                }
                ++i2;
            }
        }
    }

    private void showDirectory(TreePath tp, RemoteFile file) {
        if (file == null) {
            this.templist = new RemoteFile[1];
            ++this.curdir;
            this.work[this.curdir] = this.templist;
            return;
        }
        FileBrowserNode node = (FileBrowserNode)tp.getLastPathComponent();
        if (node == null) {
            return;
        }
        if (file.isDirectory()) {
            this.templist = (RemoteFile[])file.listFiles();
            if (this.templist.length == 0) {
                return;
            }
            ++this.curdir;
            Vector<RemoteFile> dirs = new Vector<RemoteFile>();
            Vector<RemoteFile> files = new Vector<RemoteFile>();
            int i = 0;
            while (i < this.templist.length) {
                if (this.templist[i].isDirectory()) {
                    dirs.add(this.templist[i]);
                } else {
                    files.add(this.templist[i]);
                }
                ++i;
            }
            int count = 0;
            int i2 = 0;
            while (i2 < dirs.size()) {
                this.templist[count] = (RemoteFile)dirs.get(i2);
                ++count;
                ++i2;
            }
            i2 = 0;
            while (i2 < files.size()) {
                this.templist[count] = (RemoteFile)files.get(i2);
                ++count;
                ++i2;
            }
            this.work[this.curdir] = this.templist;
        }
    }

    private RemoteFile getSubDirList(TreePath treepath) {
        if (treepath == null) {
            return null;
        }
        String string = treepath.getPathComponent(0).toString();
        if (!string.trim().endsWith(this.FS)) {
            string = String.valueOf(string) + this.FS;
        }
        int count = treepath.getPathCount();
        int i = 1;
        while (i < count) {
            string = String.valueOf(string) + treepath.getPathComponent(i).toString();
            if (i + 1 == count) break;
            string = String.valueOf(string) + this.FS;
            ++i;
        }
        logger.debug((Object)("subdirlist: " + string));
        return new RemoteFile(string, this.c);
    }

    protected RemoteFile getCurrentRoot() {
        return this.root;
    }

    protected void setNewRoot(RemoteFile newRoot) {
        this.root = newRoot;
        this.root.isRoot(true);
        this.createTree();
    }

    protected ChannelSftp getChannelSftp() {
        return this.c;
    }

    @Override
    public void uploadFinished(SftpEvent e) {
    }

    @Override
    public void downloadFinished(SftpEvent e) {
        if (this.bootingEditor && this.tmpFiles != null && this.tmpFiles.length != 0) {
            String dir = String.valueOf(System.getProperty("java.io.tmpdir")) + System.getProperty("file.separator");
            int i = 0;
            while (i < this.tmpFiles.length) {
                FileBrowserUtils.bootProgram(this.editor, String.valueOf(dir) + this.tmpFiles[i]);
                ++i;
            }
            this.bootingEditor = false;
        }
    }

    class DirMaker
    implements Runnable {
        private RemoteFile newdir;

        protected DirMaker(RemoteFile newdir) {
            this.newdir = newdir;
            logger.debug((Object)"instantiated DirMaker");
        }

        @Override
        public void run() {
            logger.info((Object)("creating new dir: " + this.newdir.getAbsolutePath()));
            this.newdir.mkdir();
            FileBrowserTree.this.init();
        }
    }

    class Renamer
    implements Runnable {
        private RemoteFile origfile;
        private RemoteFile newfile;

        protected Renamer(RemoteFile origfile, RemoteFile newfile) {
            this.origfile = origfile;
            this.newfile = newfile;
        }

        @Override
        public void run() {
            boolean res = this.origfile.renameTo(this.newfile);
            if (!res) {
                logger.warn((Object)"failed rename");
                return;
            }
            FileBrowserTree.this.init();
        }
    }
}

