/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.file;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.file.Monitorable;
import ciss.phase_viewer.jobcontrol.MonitorPanelInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.ssh.RemoteStdOut;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JTextArea;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public abstract class SimpleRefreshableMonitor
implements Monitorable {
    private Logger logger = Logger.getLogger((String)SimpleRefreshableMonitor.class.getName());
    protected ProjectInfo projectInfo;
    protected Session session;
    protected JTextArea textArea;
    protected RemoteStdOut remoteStdOut;
    private Timer timer;
    private File mostRescent;
    protected int REFRESH = 100;
    private long lastMod = -1L;
    private boolean firstTime = true;
    private MonitorPanelInterface monitorPanel;

    public SimpleRefreshableMonitor(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    @Override
    public void createGraphFrom(JTextArea textArea) {
    }

    @Override
    public void destroyGraph() {
    }

    @Override
    public boolean isGraphCreatable(JTextArea textArea) {
        return false;
    }

    @Override
    public boolean isMonitorable() {
        return true;
    }

    protected abstract String getFileToMonitor();

    @Override
    public void monitor(Session session, JTextArea textArea) {
        this.session = session;
        this.textArea = textArea;
        this.preProcess();
        this.timer = new Timer(this.REFRESH, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SimpleRefreshableMonitor.this.doIt();
            }
        });
        this.timer.start();
    }

    private void doIt() {
        if (this.firstTime || this.mostRescent.lastModified() > this.lastMod) {
            this.firstTime = false;
            this.remoteStdOut.doIt();
        }
    }

    private void preProcess() {
        String nam = this.getFileToMonitor();
        try {
            RemoteFile rf;
            File[] files;
            ChannelSftp c = null;
            if (this.session != null) {
                Channel channel = this.session.openChannel("sftp");
                channel.connect();
                c = (ChannelSftp)channel;
            }
            if ((files = (rf = new RemoteFile(this.projectInfo.getTargetDirectory(), c)).listFiles()) == null || files.length == 0) {
                return;
            }
            int i = 0;
            while (i < files.length) {
                if (files[i].getName().matches(nam) && this.lastMod < files[i].lastModified()) {
                    this.mostRescent = files[i];
                    this.lastMod = files[i].lastModified();
                }
                ++i;
            }
        }
        catch (Exception exc) {
            this.logger.error((Object)"failed to get remote-host info.");
            exc.printStackTrace();
            return;
        }
        String fs = "/";
        if (this.mostRescent == null) {
            this.logger.warn((Object)"no matching file.");
            return;
        }
        String cat = "cat ";
        String dir = this.projectInfo.getTargetDirectory();
        if (this.session == null) {
            fs = System.getProperty("file.separator");
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                cat = "cat.exe ";
            }
            dir = this.projectInfo.getProjectDirectory();
        }
        if (!dir.endsWith(fs)) {
            dir = String.valueOf(dir) + fs;
        }
        String fname = Utils.getPathDQ(String.valueOf(dir) + this.mostRescent.getName());
        String command = String.valueOf(cat) + fname;
        this.logger.debug((Object)("command: " + command));
        this.remoteStdOut = new RemoteStdOut(this.session, command, this.textArea);
        this.remoteStdOut.setMode(RemoteStdOut.REPLACE);
    }

    @Override
    public void stopMonitor() {
        if (this.remoteStdOut != null) {
            this.remoteStdOut.terminate();
        }
        this.timer.stop();
        this.firstTime = true;
    }

    @Override
    public void setMonitorPanel(MonitorPanelInterface monitorPanel) {
        this.monitorPanel = monitorPanel;
    }
}

