/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.file;

import ciss.phase_viewer.common.Tail;
import ciss.phase_viewer.common.TextAreaBufferedOutputStream;
import ciss.phase_viewer.common.TextAreaOutputStream;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.file.Monitorable;
import ciss.phase_viewer.graph.XYData;
import ciss.phase_viewer.jobcontrol.MonitorPanelInterface;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.ssh.RemoteStdOut;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.apache.log4j.Logger;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;

public abstract class SimpleMonitor
implements Monitorable,
CaretListener,
ChartProgressListener,
InternalFrameListener {
    private Logger logger = Logger.getLogger((String)SimpleMonitor.class.getName());
    protected ProjectInfo projectInfo;
    protected boolean drawingChart = false;
    protected Session session;
    protected JTextArea textArea;
    protected RemoteStdOut remoteStdOut;
    protected Tail localTail;
    protected boolean graph = false;
    protected String fileName = "";
    private MonitorMostRescent mmr;
    protected InternalFrameChase graphPanel;
    protected XYData[] xyData;
    private int prevTextIndex = 0;
    protected MonitorPanelInterface monitorPanel;

    @Override
    public void internalFrameActivated(InternalFrameEvent arg0) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent arg0) {
        this.monitorPanel.setGraphButtonSelected(false);
        this.destroyGraph();
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent arg0) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent arg0) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent arg0) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent arg0) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent arg0) {
    }

    public SimpleMonitor(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    public void chartProgress(ChartProgressEvent arg0) {
        this.drawingChart = arg0.getType() == 1;
    }

    @Override
    public boolean isMonitorable() {
        return true;
    }

    protected abstract String getFileToMonitor();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getMostRescent(String nam) {
        File mostRescent = null;
        ChannelSftp c = null;
        try {
            if (this.session != null) {
                if (!this.session.isConnected()) {
                    try {
                        this.session.connect();
                    }
                    catch (JSchException e1) {
                        return null;
                    }
                }
                Channel channel = this.session.openChannel("sftp");
                try {
                    channel.connect();
                }
                catch (JSchException e) {
                    return null;
                }
                c = (ChannelSftp)channel;
            }
            RemoteFile rf = new RemoteFile(this.projectInfo.getTargetDirectory(), c);
            File[] files = rf.listFiles();
            long date = -1L;
            if (files == null) return null;
            if (files.length == 0) {
                return null;
            }
            int i = 0;
            while (true) {
                if (i >= files.length) {
                    return mostRescent;
                }
                if (files[i].getName().matches(nam) && date < files[i].lastModified()) {
                    mostRescent = files[i];
                    date = files[i].lastModified();
                }
                ++i;
            }
        }
        catch (Exception exc) {
            this.logger.error((Object)"failed to get remote-host info.");
            exc.printStackTrace();
            return null;
        }
    }

    @Override
    public void monitor(Session session, JTextArea textArea) {
        this.session = session;
        this.textArea = textArea;
        this.textArea.addCaretListener(this);
        String nam = this.getFileToMonitor();
        File mostRescent = this.getMostRescent(nam);
        if (mostRescent == null) {
            if (this.mmr != null) {
                this.mmr.cancel();
            }
            this.mmr = new MonitorMostRescent(nam);
            return;
        }
        this.fileName = mostRescent.getAbsolutePath();
        if (session == null) {
            TextAreaOutputStream taos = new TextAreaOutputStream(textArea);
            TextAreaBufferedOutputStream tbos = new TextAreaBufferedOutputStream(taos);
            this.localTail = new Tail(mostRescent, tbos);
            this.localTail.doIt();
            if (this.mmr != null) {
                this.mmr.cancel();
            }
            this.mmr = new MonitorMostRescent(nam);
            return;
        }
        String fs = "/";
        String tail = "tail -f ";
        String fname = Utils.getPathDQ(String.valueOf(this.projectInfo.getTargetDirectory()) + fs + mostRescent.getName());
        String command = String.valueOf(tail) + fname;
        this.remoteStdOut = new RemoteStdOut(session, command, textArea);
        this.remoteStdOut.doIt();
        if (this.mmr != null) {
            this.mmr.cancel();
        }
        this.mmr = new MonitorMostRescent(nam);
    }

    @Override
    public void stopMonitor() {
        if (this.remoteStdOut != null) {
            this.remoteStdOut.terminate();
        }
        if (this.localTail != null) {
            this.localTail.cancel();
        }
        this.graph = false;
    }

    @Override
    public void createGraphFrom(JTextArea textArea) {
        this.graph = true;
        this.caretUpdate(null);
    }

    @Override
    public void caretUpdate(CaretEvent arg0) {
        int caretPosNow = this.textArea.getCaretPosition();
        if (caretPosNow < this.prevTextIndex) {
            return;
        }
        String text = "";
        this.logger.debug((Object)("prevTextInde, caretPosNow: " + this.prevTextIndex + ", " + caretPosNow));
        try {
            text = this.textArea.getText(this.prevTextIndex, caretPosNow - this.prevTextIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] lines = text.split(System.getProperty("line.separator"));
        this.doGraph(lines);
        this.prevTextIndex = caretPosNow;
    }

    protected abstract void doGraph(String[] var1);

    @Override
    public void destroyGraph() {
        if (this.graphPanel != null && this.graphPanel.isVisible()) {
            this.graphPanel.dispose();
        }
        this.graphPanel = null;
        this.xyData = null;
        this.graph = false;
        this.prevTextIndex = 0;
    }

    @Override
    public boolean isGraphCreatable(JTextArea textArea) {
        return this.xyData != null;
    }

    @Override
    public void setMonitorPanel(MonitorPanelInterface monitorPanel) {
        this.monitorPanel = monitorPanel;
    }

    class MonitorMostRescent
    extends TimerTask {
        private String nam;

        public MonitorMostRescent(String nam) {
            this.nam = nam;
            Timer timer = new Timer();
            timer.schedule((TimerTask)this, 0L, 1000L);
        }

        @Override
        public void run() {
            File mRescent = SimpleMonitor.this.getMostRescent(this.nam);
            if (mRescent == null) {
                return;
            }
            if (!SimpleMonitor.this.fileName.equals(mRescent.getAbsolutePath())) {
                SimpleMonitor.this.stopMonitor();
                this.cancel();
                SimpleMonitor.this.monitor(SimpleMonitor.this.session, SimpleMonitor.this.textArea);
            }
        }
    }
}

