/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.file;

import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.file.FileNameEditor;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class FileNameEditPanel
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)FileNameEditPanel.class.getName());
    private ChaseFileManager fileManager;
    private Vector editors = new Vector();

    public FileNameEditPanel(ChaseFileManager fileManager) {
        super("edit file names for " + fileManager.getName(), true, true, true, true, new Dimension(400, 600));
        this.fileManager = fileManager;
        this.init();
    }

    private void init() {
        Container cont = super.getContentPane();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JScrollPane scrollpane = new JScrollPane();
        scrollpane.getViewport().setView(this.createFileEditFrame());
        panel.add(scrollpane);
        panel.add(this.createButtons());
        cont.add(panel);
        this.revalidate();
    }

    private JPanel createFileEditFrame() {
        JPanel p = new JPanel();
        ChaseFile[] cfiles = this.fileManager.getFiles();
        if (cfiles == null || cfiles.length == 0) {
            this.logger.error((Object)"invalid file info.");
            return p;
        }
        p.setLayout(new BoxLayout(p, 1));
        int i = 0;
        while (i < cfiles.length) {
            if (cfiles[i].getFileNameEditLevel().equals(ChaseFile.ALWAYS)) {
                FileNameEditor editor = new FileNameEditor(cfiles[i]);
                p.add(editor);
                this.editors.addElement(editor);
            }
            ++i;
        }
        return p;
    }

    private JPanel createButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton def = new JButton("set default name");
        JButton save = new JButton("save");
        JButton saveclose = new JButton("save and close");
        JButton close = new JButton("close");
        p.add(def);
        p.add(save);
        p.add(saveclose);
        p.add(close);
        def.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileNameEditPanel.this.setDefaultName();
            }
        });
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileNameEditPanel.this.save();
            }
        });
        saveclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileNameEditPanel.this.save();
                FileNameEditPanel.this.dispose();
            }
        });
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileNameEditPanel.this.dispose();
            }
        });
        Dimension size = new Dimension(this.getSize().width, 50);
        p.setPreferredSize(size);
        p.setMinimumSize(size);
        return p;
    }

    private void setDefaultName() {
        int i = 0;
        while (i < this.editors.size()) {
            ((FileNameEditor)this.editors.elementAt(i)).setDefaultName();
            ++i;
        }
    }

    private void save() {
        int i = 0;
        while (i < this.editors.size()) {
            ((FileNameEditor)this.editors.elementAt(i)).save();
            ++i;
        }
        this.fileManager.save();
    }
}

